/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.searchengine;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.interfaces.Configurable;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.WebProfile;
import org.dbgl.model.conf.Settings;
import org.dbgl.swtdesigner.SWTImageManager;
import org.dbgl.util.FileUtils;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchEngineThread
extends Thread {
    private WebSearchEngine engine;
    private List<Configurable> profiles;
    private String title;
    private final Text log;
    private final ProgressBar progressBar;
    private final Label profileLabel;
    private final Display display;
    private final String lineDelimiter;

    public SearchEngineThread(WebSearchEngine webSearchEngine, List<Configurable> list, Text text, ProgressBar progressBar, Label label) {
        this.engine = webSearchEngine;
        this.profiles = list;
        this.log = text;
        this.lineDelimiter = text.getLineDelimiter();
        this.progressBar = progressBar;
        this.profileLabel = label;
        this.display = text.getShell().getDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Database database = Database.getInstance();
        Settings settings = Settings.getInstance();
        final StringBuffer stringBuffer = new StringBuffer();
        final StringBuffer stringBuffer2 = new StringBuffer();
        while (true) {
            block21: {
                try {
                    ExpProfile expProfile;
                    List<Object> list = this.profiles;
                    synchronized (list) {
                        expProfile = (ExpProfile)this.profiles.remove(0);
                    }
                    this.title = expProfile.getTitle();
                    try {
                        int n;
                        list = this.engine.getEntries(this.title, settings.getSettings().getValues(this.engine.getSimpleName(), "platform_filter"));
                        if (list.size() > 1 && (n = WebSearchEngine.getEntryFirstExactMatchIndex(this.title, list)) != -1) {
                            list = list.subList(n, n + 1);
                        }
                        if (list.size() == 1) {
                            String string;
                            Object object;
                            String string2;
                            SearchEngineImageInformation[] searchEngineImageInformationArray;
                            WebProfile webProfile = this.engine.getEntryDetailedInformation((WebProfile)list.get(0));
                            SearchEngineThread searchEngineThread = this;
                            synchronized (searchEngineThread) {
                                searchEngineImageInformationArray = settings.getSettings().getBooleanValue(this.engine.getSimpleName(), "set_title") ? webProfile.getTitle() : expProfile.getTitle();
                                String string3 = settings.getSettings().getBooleanValue(this.engine.getSimpleName(), "set_developer") ? webProfile.getDeveloperName() : expProfile.getDeveloperName();
                                string2 = settings.getSettings().getBooleanValue(this.engine.getSimpleName(), "set_publisher") ? webProfile.getPublisherName() : expProfile.getPublisherName();
                                object = settings.getSettings().getBooleanValue(this.engine.getSimpleName(), "set_year") ? webProfile.getYear() : expProfile.getYear();
                                string = settings.getSettings().getBooleanValue(this.engine.getSimpleName(), "set_genre") ? webProfile.getGenre() : expProfile.getGenre();
                                String string4 = settings.getSettings().getBooleanValue(this.engine.getSimpleName(), "set_link") ? webProfile.getUrl() : expProfile.getLink(0);
                                String[] stringArray = new String[]{string4, expProfile.getLink(1), expProfile.getLink(2), expProfile.getLink(3), expProfile.getLink(4), expProfile.getLink(5), expProfile.getLink(6), expProfile.getLink(7)};
                                String string5 = settings.getSettings().getBooleanValue(this.engine.getSimpleName(), "set_link") ? settings.msg("dialog.profile.searchengine.link.maininfo", new String[]{this.engine.getName()}) : expProfile.getLinkTitle(0);
                                String[] stringArray2 = new String[]{string5, expProfile.getLinkTitle(1), expProfile.getLinkTitle(2), expProfile.getLinkTitle(3), expProfile.getLinkTitle(4), expProfile.getLinkTitle(5), expProfile.getLinkTitle(6), expProfile.getLinkTitle(7)};
                                StringBuffer stringBuffer3 = new StringBuffer(expProfile.getNotes());
                                String string6 = webProfile.getNotes().replaceAll("\n", this.lineDelimiter);
                                if (settings.getSettings().getBooleanValue(this.engine.getSimpleName(), "set_description") && !expProfile.getNotes().endsWith(string6)) {
                                    if (stringBuffer3.length() > 0) {
                                        stringBuffer3.append(this.lineDelimiter + this.lineDelimiter);
                                    }
                                    stringBuffer3.append(string6);
                                }
                                int n2 = settings.getSettings().getBooleanValue(this.engine.getSimpleName(), "set_rank") ? webProfile.getRank() : expProfile.getCustomInt(0);
                                int[] nArray = new int[]{n2, expProfile.getCustomInt(1)};
                                database.addOrEditProfile((String)searchEngineImageInformationArray, string3, string2, string, (String)object, expProfile.getStatus(), stringBuffer3.toString(), expProfile.isDefault(), expProfile.getSetup(), expProfile.getSetupParameters(), expProfile.getDbversionId(), stringArray, stringArray2, expProfile.getCustomStrings(), nArray, expProfile.getId());
                            }
                            boolean bl = settings.getSettings().getBooleanValue(this.engine.getSimpleName(), "force_all_regions_coverart");
                            searchEngineImageInformationArray = this.engine.getEntryImages(webProfile, settings.getSettings().getIntValue(this.engine.getSimpleName(), "multi_max_coverart"), settings.getSettings().getIntValue(this.engine.getSimpleName(), "multi_max_screenshot"), bl);
                            for (int i = 0; i < searchEngineImageInformationArray.length; ++i) {
                                string2 = FileUtils.fileSystemSafeWebImages(searchEngineImageInformationArray[i].description);
                                if (searchEngineImageInformationArray[i].type == SearchEngineImageInformation.SearchEngineImageType.CoverArt) {
                                    string = settings.msg("dialog.profile.mobygames.coverartfilename", new Object[]{i, string2});
                                    object = new File(expProfile.getCanonicalCaptures(), string + ".jpg");
                                } else {
                                    string = settings.msg("dialog.profile.mobygames.screenshotfilename", new Object[]{i, string2});
                                    object = new File(expProfile.getCanonicalCaptures(), string + ".png");
                                }
                                if (!FileUtils.isExistingFile((File)object)) {
                                    SWTImageManager.save(webProfile.getWebImage(i), ((File)object).getPath());
                                    continue;
                                }
                                stringBuffer2.append(this.title).append(": ").append(settings.msg("dialog.profile.error.imagealreadyexists", new String[]{((File)object).getPath(), this.engine.getName()})).append('\n');
                            }
                            break block21;
                        }
                        if (list.size() == 0) {
                            stringBuffer2.append(this.title).append(": ").append(settings.msg("general.notice.searchenginenoresults", new String[]{this.engine.getName(), this.title})).append('\n');
                            break block21;
                        }
                        stringBuffer2.append(this.title).append(": ").append(settings.msg("dialog.multiprofile.notice.titlenotunique", new String[]{this.engine.getName(), this.title})).append('\n');
                    }
                    catch (SQLException sQLException) {
                        stringBuffer2.append(StringRelatedUtils.toString(sQLException)).append('\n');
                    }
                }
                catch (IOException iOException) {
                    stringBuffer2.append(this.title).append(": ").append(settings.msg("general.error.retrieveinfosearchengine", new String[]{this.engine.getName(), this.title, iOException.toString()})).append('\n');
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return;
                }
            }
            this.display.asyncExec(new Runnable(){

                public void run() {
                    if (SearchEngineThread.this.profileLabel.isDisposed() || SearchEngineThread.this.log.isDisposed() || SearchEngineThread.this.progressBar.isDisposed()) {
                        return;
                    }
                    SearchEngineThread.this.profileLabel.setText(Settings.getInstance().msg("dialog.multiprofile.updating", new Object[]{SearchEngineThread.this.title}));
                    SearchEngineThread.this.profileLabel.pack();
                    if (stringBuffer2.length() > stringBuffer.length()) {
                        String string = stringBuffer2.substring(stringBuffer.length());
                        SearchEngineThread.this.log.append(string);
                        stringBuffer.append(string);
                    }
                    SearchEngineThread.this.progressBar.setSelection(SearchEngineThread.this.progressBar.getSelection() + 1);
                }
            });
        }
    }
}

