/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

import java.io.IOException;
import org.dbgl.waldheinz.fs.fat.BlockDevice;
import org.dbgl.waldheinz.fs.fat.BootSector;
import org.dbgl.waldheinz.fs.fat.FatType;

final class Fat32BootSector
extends BootSector {
    public static final int ROOT_DIR_FIRST_CLUSTER_OFFSET = 44;
    public static final int SECTORS_PER_FAT_OFFSET = 36;
    public static final int FILE_SYSTEM_TYPE_OFFSET = 82;
    public static final int VERSION_OFFSET = 42;
    public static final int VERSION = 0;
    public static final int FS_INFO_SECTOR_OFFSET = 48;
    public static final int BOOT_SECTOR_COPY_OFFSET = 50;
    public static final int EXTENDED_BOOT_SIGNATURE_OFFSET = 66;

    Fat32BootSector(BlockDevice blockDevice, long l) throws IOException {
        super(blockDevice, l);
    }

    public long getRootDirFirstCluster() {
        return this.get32(44);
    }

    public int getBootSectorCopySector() {
        return this.get16(50);
    }

    public int getFsInfoSectorNr() {
        return this.get16(48);
    }

    public long getSectorsPerFat() {
        return this.get32(36);
    }

    public FatType getFatType() {
        return FatType.FAT32;
    }

    public long getSectorCount() {
        return super.getNrTotalSectors();
    }

    public int getRootDirEntryCount() {
        return 0;
    }

    public int getFileSystemId() {
        return (int)super.get32(67);
    }

    public int getFileSystemTypeLabelOffset() {
        return 82;
    }

    public int getExtendedBootSignatureOffset() {
        return 66;
    }
}

