/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.dbgl.waldheinz.fs.fat.AbstractDirectory;
import org.dbgl.waldheinz.fs.fat.ClusterChain;
import org.dbgl.waldheinz.fs.fat.ClusterChainDirectory;
import org.dbgl.waldheinz.fs.fat.Fat;
import org.dbgl.waldheinz.fs.fat.FatDirectoryEntry;
import org.dbgl.waldheinz.fs.fat.FatLfnDirectoryEntry;
import org.dbgl.waldheinz.fs.fat.ShortName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FatLfnDirectory {
    private final Set<String> usedNames;
    private final Fat fat;
    private final Map<ShortName, FatLfnDirectoryEntry> shortNameIndex;
    private final Map<String, FatLfnDirectoryEntry> longNameIndex;
    private final Map<FatDirectoryEntry, FatLfnDirectory> entryToDirectory;
    final AbstractDirectory dir;

    FatLfnDirectory(AbstractDirectory abstractDirectory, Fat fat) throws IOException {
        if (abstractDirectory == null || fat == null) {
            throw new NullPointerException();
        }
        this.fat = fat;
        this.dir = abstractDirectory;
        this.shortNameIndex = new LinkedHashMap<ShortName, FatLfnDirectoryEntry>();
        this.longNameIndex = new LinkedHashMap<String, FatLfnDirectoryEntry>();
        this.entryToDirectory = new LinkedHashMap<FatDirectoryEntry, FatLfnDirectory>();
        this.usedNames = new HashSet<String>();
        this.parseLfn();
    }

    FatLfnDirectory getDirectory(FatDirectoryEntry fatDirectoryEntry) throws IOException {
        FatLfnDirectory fatLfnDirectory = this.entryToDirectory.get(fatDirectoryEntry);
        if (fatLfnDirectory == null) {
            ClusterChainDirectory clusterChainDirectory = FatLfnDirectory.read(fatDirectoryEntry, this.fat);
            fatLfnDirectory = new FatLfnDirectory(clusterChainDirectory, this.fat);
            this.entryToDirectory.put(fatDirectoryEntry, fatLfnDirectory);
        }
        return fatLfnDirectory;
    }

    private void checkUniqueName(String string) throws IOException {
        String string2 = string.toLowerCase();
        if (!this.usedNames.add(string2)) {
            throw new IOException("an entry named " + string + " already exists");
        }
    }

    private void parseLfn() throws IOException {
        int n = 0;
        int n2 = this.dir.getEntryCount();
        while (n < n2) {
            while (n < n2 && this.dir.getEntry(n) == null) {
                ++n;
            }
            if (n >= n2) break;
            int n3 = n;
            while (this.dir.getEntry(n).isLfnEntry() && ++n < n2) {
            }
            if (n >= n2) break;
            FatLfnDirectoryEntry fatLfnDirectoryEntry = FatLfnDirectoryEntry.extract(this, n3, ++n - n3);
            if (fatLfnDirectoryEntry.realEntry.isDeleted()) continue;
            this.checkUniqueName(fatLfnDirectoryEntry.getName());
            this.shortNameIndex.put(fatLfnDirectoryEntry.realEntry.getShortName(), fatLfnDirectoryEntry);
            this.longNameIndex.put(fatLfnDirectoryEntry.getName().toLowerCase(), fatLfnDirectoryEntry);
        }
    }

    public Iterator<FatLfnDirectoryEntry> iterator() {
        return new Iterator<FatLfnDirectoryEntry>(){
            final Iterator<FatLfnDirectoryEntry> it;
            {
                this.it = FatLfnDirectory.this.shortNameIndex.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public FatLfnDirectoryEntry next() {
                return this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [size=" + this.shortNameIndex.size() + ", dir=" + this.dir + "]";
    }

    private static ClusterChainDirectory read(FatDirectoryEntry fatDirectoryEntry, Fat fat) throws IOException {
        if (!fatDirectoryEntry.isDirectory()) {
            throw new IllegalArgumentException(fatDirectoryEntry + " is no directory");
        }
        ClusterChain clusterChain = new ClusterChain(fat, fatDirectoryEntry.getStartCluster());
        ClusterChainDirectory clusterChainDirectory = new ClusterChainDirectory(clusterChain, false);
        clusterChainDirectory.read();
        return clusterChainDirectory;
    }
}

