/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FatType {
    FAT12(4080, 4095L, 1.5f){

        public long readEntry(byte[] byArray, int n) {
            int n2 = (int)((double)n * 1.5);
            int n3 = byArray[n2] & 0xFF;
            int n4 = byArray[n2 + 1] & 0xFF;
            int n5 = n4 << 8 | n3;
            if (n % 2 == 0) {
                return n5 & 0xFFF;
            }
            return n5 >> 4;
        }
    }
    ,
    FAT16(65520, 65535L, 2.0f){

        public long readEntry(byte[] byArray, int n) {
            int n2 = n << 1;
            int n3 = byArray[n2] & 0xFF;
            int n4 = byArray[n2 + 1] & 0xFF;
            return n4 << 8 | n3;
        }
    }
    ,
    FAT32(0xFFFFFF0, 0xFFFFFFFFL, 4.0f){

        public long readEntry(byte[] byArray, int n) {
            int n2 = n * 4;
            long l = byArray[n2] & 0xFF;
            long l2 = byArray[n2 + 1] & 0xFF;
            long l3 = byArray[n2 + 2] & 0xFF;
            long l4 = byArray[n2 + 3] & 0xFF;
            return l4 << 24 | l3 << 16 | l2 << 8 | l;
        }
    };

    private final long eofCluster;
    private final float entrySize;

    private FatType(int n2, long l, float f) {
        this.eofCluster = 0xFFFFFF8L & l;
        this.entrySize = f;
    }

    public boolean isEofCluster(long l) {
        return l >= this.eofCluster;
    }

    public float getEntrySize() {
        return this.entrySize;
    }

    public abstract long readEntry(byte[] var1, int var2);
}

