/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.util.List;
import org.dbgl.model.KeyValuePair;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public final class AutoSelectCombo {
    private final Combo combo;
    private int currentLength;
    private boolean mutex;

    public AutoSelectCombo(Composite composite, int n, List<KeyValuePair> list, Object object) {
        this.combo = new Combo(composite, n);
        this.combo.setLayoutData(object);
        this.combo.setVisibleItemCount(15);
        for (KeyValuePair keyValuePair : list) {
            this.combo.add(keyValuePair.getValue());
        }
        this.combo.pack();
        this.currentLength = 0;
        this.mutex = false;
        this.combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (!AutoSelectCombo.this.mutex) {
                    int n = AutoSelectCombo.this.indexOfClosestMatch(AutoSelectCombo.this.combo.getText());
                    int n2 = AutoSelectCombo.this.combo.getText().length();
                    if (n2 > AutoSelectCombo.this.currentLength && n != -1) {
                        AutoSelectCombo.this.mutex = true;
                        AutoSelectCombo.this.combo.setText(AutoSelectCombo.this.combo.getText() + AutoSelectCombo.this.combo.getItem(n).substring(n2));
                        AutoSelectCombo.this.combo.setSelection(new Point(n2, AutoSelectCombo.this.combo.getText().length()));
                        AutoSelectCombo.this.mutex = false;
                    }
                    AutoSelectCombo.this.currentLength = n2;
                }
            }
        });
    }

    public String getText() {
        return this.combo.getText();
    }

    public void setText(String string) {
        this.combo.setText(string);
        this.currentLength = this.combo.getText().length();
    }

    private int indexOfClosestMatch(String string) {
        for (int i = 0; i < this.combo.getItemCount(); ++i) {
            if (!this.combo.getItem(i).toLowerCase().startsWith(string.toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    public Object getData() {
        return this.combo.getData();
    }

    public void setData(Object object) {
        this.combo.setData(object);
    }

    public Display getDisplay() {
        return this.combo.getDisplay();
    }

    public void setBackground(Color color) {
        this.combo.setBackground(color);
    }

    public Control getControl() {
        return this.combo;
    }
}

