/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dbgl.db.Database;
import org.dbgl.gui.AutoSelectCombo;
import org.dbgl.gui.EditMixerDialog;
import org.dbgl.gui.EditMountDialog;
import org.dbgl.gui.EditNativeCommandDialog;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SettingsDialog;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.interfaces.Configurable;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpTemplate;
import org.dbgl.model.Mount;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.Template;
import org.dbgl.model.conf.Autoexec;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.StringRelatedUtils;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ExpandAdapter;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import swing2swt.layout.BorderLayout;

public class EditTemplateDialog
extends Dialog {
    protected Text title;
    protected Button defaultButton;
    protected Combo dbversion;
    protected Button setButton;
    protected Button switchButton;
    protected Button reloadButton;
    protected Combo priority_active;
    protected Combo priority_inactive;
    protected Button waitonerror;
    protected Button exit;
    protected Text language;
    protected Text captures;
    protected Text config_file;
    protected Combo output;
    protected Combo frameskip;
    protected Combo scaler;
    protected Combo pixelshader;
    protected Button fulldouble;
    protected Button fullscreen;
    protected Combo fullresolution;
    protected Combo windowresolution;
    protected Button aspect;
    protected Combo overscan;
    protected Combo videoram;
    protected Combo vsyncmode;
    protected Text vsyncrate;
    protected Text forcerate;
    protected Button scaler_forced;
    protected Button linewise;
    protected Button char9;
    protected Button multiscan;
    protected Button autofit;
    protected Button cgasnow;
    protected Button splash3dfx;
    protected Text glideport;
    protected Text memsizeKB;
    protected Combo glide;
    protected Combo lfbGlide;
    protected Combo dacMT32;
    protected Combo reverbmodeMT32;
    protected Combo reverbtimeMT32;
    protected Combo reverblevelMT32;
    protected Combo machine;
    protected Combo cpu_type;
    protected Combo core;
    protected Combo cycles;
    protected Combo cycles_up;
    protected Combo cycles_down;
    protected Combo memsize;
    protected Button xms;
    protected Combo ems;
    protected Combo umb;
    protected Combo memalias;
    protected Button nosound;
    protected Combo rate;
    protected Combo blocksize;
    protected Combo prebuffer;
    protected Combo mpu401;
    protected Combo midi_device;
    protected Text midi_config;
    protected Text mixer_config;
    protected Combo sbtype;
    protected Combo oplrate;
    protected Combo oplmode;
    protected Combo oplemu;
    protected Combo sbbase;
    protected Combo irq;
    protected Combo dma;
    protected Combo hdma;
    protected Combo hardwareaddresssbbase;
    protected Button sbmixer;
    protected Button goldplay;
    protected Button gus;
    protected Button ps1;
    protected Button innova;
    protected Combo gusrate;
    protected Combo gusbase;
    protected Combo gusdma1;
    protected Combo gusdma2;
    protected Combo gusirq1;
    protected Combo gusirq2;
    protected Combo ps1rate;
    protected Combo innovarate;
    protected Combo innovabase;
    protected Combo innovaquality;
    protected Text ultradir;
    protected Button pcspeaker;
    protected Combo pcrate;
    protected Combo tandy;
    protected Combo tandyrate;
    protected Button disney;
    protected Button swapstereo;
    protected Button swapstereoMT32;
    protected Button loggingMT32;
    protected Button multithreadMT32;
    protected Button int33;
    protected Button biosps2;
    protected Button aux;
    protected Button isapnpbios;
    protected Button ide1;
    protected Button ide2;
    protected Button ide3;
    protected Button ide4;
    protected Button automount;
    protected Spinner partialsMT32;
    protected Spinner files;
    protected Spinner printerdpi;
    protected Spinner printerwidth;
    protected Spinner printerheight;
    protected Spinner printertimeout;
    protected Button usescancodes;
    protected Button dongle;
    protected Button ne2000;
    protected Text mapperfile;
    protected Combo keyboard_layout;
    protected Combo auxdevice;
    protected Combo printeroutput;
    protected Text keyb;
    protected Text printerdocpath;
    protected Text ne2000base;
    protected Text ne2000irq;
    protected Text ne2000macaddress;
    protected Text ne2000realnic;
    protected Button autolock;
    protected Combo sensitivity;
    protected Combo joysticktype;
    protected Button timed;
    protected Button autofire;
    protected Button swap34;
    protected Button buttonwrap;
    protected Text serial1;
    protected Text serial2;
    protected Text serial3;
    protected Text serial4;
    protected Text parallel1;
    protected Text parallel2;
    protected Text parallel3;
    protected Button ipx;
    protected Button printer;
    protected Button printermultipage;
    protected Text ipxnet;
    protected Text[] customCommands;
    protected org.eclipse.swt.widgets.List mountingpoints;
    protected ExpandItem booterExpandItem;
    protected ExpandItem dosExpandItem;
    protected Group memoryGroup;
    protected Group associationGroup;
    protected Group miscGroup;
    protected Group executeGroup;
    protected TabItem infoTabItem;
    protected TabItem generalTabItem;
    protected TabItem mountingTabItem;
    protected Button okButton;
    protected Button cancelButton;
    protected int dbversionIndex = -1;
    protected Shell shell;
    protected List<DosboxVersion> dbversionsList;
    protected Database dbase;
    protected List<Configurable> multiProfileList = new ArrayList<Configurable>();
    protected org.eclipse.swt.widgets.List nativeCommands;
    protected Settings settings;
    protected Object result;

    public EditTemplateDialog(Shell shell) {
        super(shell, 0);
    }

    public void setTemplate(Template template) {
        this.result = template;
    }

    public Object open() {
        this.settings = Settings.getInstance();
        this.dbase = Database.getInstance();
        if (this.init()) {
            this.createContents();
            this.shell.open();
            this.shell.layout();
            Display display = this.getParent().getDisplay();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        return this.result;
    }

    protected boolean init() {
        try {
            this.dbversionsList = this.dbase.readDosboxVersionsList();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            if (this.result == null) {
                this.dbversionIndex = DosboxVersion.indexOfDefault(this.dbversionsList);
                List<NativeCommand> list = this.dbase.readNativeCommandsList(-1, -1);
                this.multiProfileList.add(new ExpTemplate(new Conf((Template)null, this.dbversionsList.get(this.dbversionIndex), printStream), list));
            } else {
                this.dbversionIndex = DosboxVersion.findIndexById(this.dbversionsList, ((Template)this.result).getDbversionId());
                List<NativeCommand> list = this.dbase.readNativeCommandsList(-1, ((Template)this.result).getId());
                this.multiProfileList.add(new ExpTemplate(new Conf((Template)this.result, this.dbversionsList.get(this.dbversionIndex), printStream), list));
            }
            if (byteArrayOutputStream.size() > 0) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), byteArrayOutputStream.toString());
                byteArrayOutputStream.reset();
            }
            return true;
        }
        catch (Exception exception) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), exception);
            return false;
        }
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "templatedialog"));
        if (this.result == null) {
            this.shell.setText(this.settings.msg("dialog.template.title.add"));
        } else {
            this.shell.setText(this.settings.msg("dialog.template.title.edit", new Object[]{((Template)this.result).getTitle(), ((Template)this.result).getId()}));
        }
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        this.createInfoTab(tabFolder);
        this.createGeneralTab(tabFolder);
        this.createDisplayTab(tabFolder);
        this.createMachineTab(tabFolder);
        this.createAudioTab(tabFolder);
        this.createIOTab(tabFolder);
        this.createCustomCommandsTab(tabFolder);
        this.createMountingTab(tabFolder);
        this.createOkCancelButtons();
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!EditTemplateDialog.this.isValid()) {
                    return;
                }
                try {
                    Conf conf = EditTemplateDialog.this.multiProfileList.get(0).getConf();
                    int n = EditTemplateDialog.this.dbase.addOrEditTemplate(EditTemplateDialog.this.title.getText(), conf.getDbversion().getId(), EditTemplateDialog.this.defaultButton.getSelection(), EditTemplateDialog.this.result == null ? -1 : ((Template)EditTemplateDialog.this.result).getId());
                    EditTemplateDialog.this.dbase.saveNativeCommands(EditTemplateDialog.this.multiProfileList.get(0).getNativeCommandsList(), -1, n);
                    EditTemplateDialog.this.updateConfigurationBySettings(conf);
                    EditTemplateDialog.this.result = new Template(n, EditTemplateDialog.this.title.getText(), conf.getDbversion().getId(), EditTemplateDialog.this.defaultButton.getSelection());
                    conf.injectOrUpdateTemplate((Template)EditTemplateDialog.this.result);
                    conf.save();
                }
                catch (Exception exception) {
                    GeneralPurposeDialogs.warningMessage(EditTemplateDialog.this.shell, exception);
                }
                EditTemplateDialog.this.shell.close();
            }
        });
        for (DosboxVersion dosboxVersion : this.dbversionsList) {
            this.dbversion.add(dosboxVersion.getTitle());
        }
        this.dbversion.select(this.dbversionIndex);
        if (this.result == null) {
            this.title.setFocus();
        } else {
            this.title.setText(((Template)this.result).getTitle());
            this.defaultButton.setSelection(((Template)this.result).isDefault().booleanValue());
        }
        this.enableSettingsByConfiguration(this.multiProfileList.get(0).getConf().getDosboxSettings());
        this.selectSettingsByConfiguration(this.multiProfileList.get(0).getConf());
    }

    protected void createOkCancelButtons() {
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        composite.setLayoutData((Object)"South");
        this.okButton = new Button(composite, 0);
        this.shell.setDefaultButton(this.okButton);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 80;
        this.okButton.setLayoutData((Object)gridData);
        this.okButton.setText(this.settings.msg("button.ok"));
        this.cancelButton = new Button(composite, 0);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        this.cancelButton.setLayoutData((Object)gridData2);
        this.cancelButton.setText(this.settings.msg("button.cancel"));
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (EditTemplateDialog.this.cancelButton.getText().equals(EditTemplateDialog.this.settings.msg("button.cancel"))) {
                    EditTemplateDialog.this.result = null;
                }
                EditTemplateDialog.this.shell.close();
            }
        });
    }

    protected void createMountingTab(TabFolder tabFolder) {
        this.mountingTabItem = new TabItem(tabFolder, 0);
        this.mountingTabItem.setText(this.settings.msg("dialog.template.tab.mounting"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout());
        this.mountingTabItem.setControl((Control)composite);
        this.createMountingGroup(composite);
        this.createExecuteGroup(composite);
    }

    protected void createExecuteGroup(final Composite composite) {
        this.executeGroup = new Group(composite, 0);
        this.executeGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.executeGroup.setText(this.settings.msg("dialog.template.execute"));
        this.executeGroup.setLayout((Layout)new FillLayout());
        final ExpandBar expandBar = new ExpandBar((Composite)this.executeGroup, 512);
        Composite composite2 = new Composite((Composite)expandBar, 0);
        Composite composite3 = new Composite((Composite)expandBar, 0);
        this.createBooterComposite(composite2);
        this.createDosComposite(composite3);
        this.booterExpandItem = new ExpandItem(expandBar, 0, 0);
        this.booterExpandItem.setText(this.settings.msg("dialog.template.booter"));
        this.booterExpandItem.setHeight(composite2.computeSize((int)-1, (int)-1).y);
        this.booterExpandItem.setControl((Control)composite2);
        this.dosExpandItem = new ExpandItem(expandBar, 0, 1);
        this.dosExpandItem.setText(this.settings.msg("dialog.template.dos"));
        this.dosExpandItem.setHeight(composite3.computeSize((int)-1, (int)-1).y);
        this.dosExpandItem.setControl((Control)composite3);
        expandBar.addExpandListener((ExpandListener)new ExpandAdapter(){

            public void itemCollapsed(ExpandEvent expandEvent) {
                expandBar.getItem(((ExpandItem)expandEvent.item).getText().equals(EditTemplateDialog.this.settings.msg("dialog.template.dos")) ? 0 : 1).setExpanded(true);
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        composite.layout();
                    }
                });
            }

            public void itemExpanded(ExpandEvent expandEvent) {
                expandBar.getItem(((ExpandItem)expandEvent.item).getText().equals(EditTemplateDialog.this.settings.msg("dialog.template.dos")) ? 0 : 1).setExpanded(false);
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        composite.layout();
                    }
                });
            }
        });
        if (this.isMultiEdit()) {
            expandBar.setEnabled(false);
        }
    }

    protected void createBooterComposite(Composite composite) {
        composite.setLayout((Layout)new GridLayout());
        Label label = new Label(composite, 0);
        label.setText(this.settings.msg("dialog.profile.booterimage1"));
    }

    protected void createDosComposite(Composite composite) {
        composite.setLayout((Layout)new GridLayout());
        Label label = new Label(composite, 0);
        label.setText(this.settings.msg("dialog.profile.mainexe"));
    }

    protected void createMountingGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setText(this.settings.msg("dialog.template.mountingoverview"));
        group.setLayout((Layout)new GridLayout(2, false));
        this.mountingpoints = new org.eclipse.swt.widgets.List((Composite)group, 2560);
        this.mountingpoints.setLayoutData((Object)new GridData(4, 4, true, false, 1, 3));
        this.mountingpoints.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                if (EditTemplateDialog.this.mountingpoints.getSelectionIndex() == -1) {
                    EditTemplateDialog.this.doAddMount();
                } else {
                    EditTemplateDialog.this.doEditMount();
                }
            }
        });
        Button button = new Button((Composite)group, 0);
        button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button.setText(this.settings.msg("dialog.template.mount.add"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditTemplateDialog.this.doAddMount();
            }
        });
        Button button2 = new Button((Composite)group, 0);
        button2.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button2.setText(this.settings.msg("dialog.template.mount.edit"));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditTemplateDialog.this.doEditMount();
            }
        });
        Button button3 = new Button((Composite)group, 0);
        button3.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button3.setText(this.settings.msg("dialog.template.mount.remove"));
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditTemplateDialog.this.doRemoveMount();
            }
        });
        if (this.isMultiEdit()) {
            this.mountingpoints.setEnabled(false);
            button.setEnabled(false);
            button2.setEnabled(false);
            button3.setEnabled(false);
        }
    }

    protected void createCustomCommandsTab(TabFolder tabFolder) {
        Label label;
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(this.settings.msg("dialog.template.tab.customcommands"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new FillLayout());
        tabItem.setControl((Control)composite);
        TabFolder tabFolder2 = new TabFolder(composite, 0);
        TabItem tabItem2 = new TabItem(tabFolder2, 0);
        tabItem2.setText(this.settings.msg("dialog.template.tab.dosboxautoexec"));
        Composite composite2 = new Composite((Composite)tabFolder2, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        tabItem2.setControl((Control)composite2);
        this.customCommands = new Text[Autoexec.SECTIONS];
        for (int i = 0; i < Autoexec.SECTIONS; ++i) {
            label = new Label(composite2, 0);
            label.setText(this.settings.msg("dialog.template.customcommand" + (i + 1)));
            this.customCommands[i] = new Text(composite2, 2818);
            this.customCommands[i].setLayoutData((Object)new GridData(4, 4, true, true));
        }
        TabItem tabItem3 = new TabItem(tabFolder2, 0);
        tabItem3.setText(this.settings.msg("dialog.template.tab.native"));
        label = new Composite((Composite)tabFolder2, 0);
        label.setLayout((Layout)new GridLayout(2, false));
        tabItem3.setControl((Control)label);
        this.nativeCommands = new org.eclipse.swt.widgets.List((Composite)label, 2816);
        this.nativeCommands.setLayoutData((Object)new GridData(4, 4, true, true, 1, 6));
        this.nativeCommands.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                if (EditTemplateDialog.this.nativeCommands.getSelectionIndex() == -1) {
                    EditTemplateDialog.this.doAddNativeCommand();
                } else {
                    EditTemplateDialog.this.doEditNativeCommand();
                }
            }
        });
        Button button = new Button((Composite)label, 0);
        button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button.setText(this.settings.msg("dialog.template.mount.add"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditTemplateDialog.this.doAddNativeCommand();
            }
        });
        Button button2 = new Button((Composite)label, 0);
        button2.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button2.setText(this.settings.msg("dialog.template.mount.edit"));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditTemplateDialog.this.doEditNativeCommand();
            }
        });
        Button button3 = new Button((Composite)label, 0);
        button3.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button3.setText(this.settings.msg("dialog.template.mount.remove"));
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditTemplateDialog.this.doRemoveNativeCommand();
            }
        });
        Button button4 = new Button((Composite)label, 132);
        button4.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = EditTemplateDialog.this.nativeCommands.getSelectionIndex();
                if (n > 0) {
                    Collections.swap(EditTemplateDialog.this.multiProfileList.get(0).getNativeCommandsList(), n, n - 1);
                    EditTemplateDialog.this.updateNativeCommands(n - 1);
                }
            }
        });
        Button button5 = new Button((Composite)label, 1028);
        button5.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = EditTemplateDialog.this.nativeCommands.getSelectionIndex();
                if (n >= 0 && n < EditTemplateDialog.this.nativeCommands.getItemCount() - 1) {
                    Collections.swap(EditTemplateDialog.this.multiProfileList.get(0).getNativeCommandsList(), n, n + 1);
                    EditTemplateDialog.this.updateNativeCommands(n + 1);
                }
            }
        });
        new Label((Composite)label, 0);
        if (this.isMultiEdit()) {
            this.nativeCommands.setEnabled(false);
            button.setEnabled(false);
            button2.setEnabled(false);
            button3.setEnabled(false);
            button4.setEnabled(false);
            button5.setEnabled(false);
        } else {
            this.updateNativeCommands(-1);
        }
    }

    protected void updateNativeCommands(int n) {
        this.nativeCommands.removeAll();
        for (NativeCommand nativeCommand : this.multiProfileList.get(0).getNativeCommandsList()) {
            this.nativeCommands.add(nativeCommand.toString());
        }
        this.nativeCommands.select(n);
    }

    protected void createIOTab(TabFolder tabFolder) {
        TabFolder tabFolder2 = this.createRelExpTabs(tabFolder, "dialog.template.tab.io", 3, 3);
        Composite composite = (Composite)tabFolder2.getChildren()[0];
        Composite composite2 = (Composite)tabFolder2.getChildren()[1];
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(4, 4, false, false));
        group.setText(this.settings.msg("dialog.template.mouse"));
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)group, 0);
        label.setText(this.settings.msg("dialog.template.autolock"));
        this.autolock = new Button((Composite)group, 32);
        this.autolock.setToolTipText(this.settings.msg("dialog.template.autolock.tooltip"));
        Label label2 = new Label((Composite)group, 0);
        label2.setText(this.settings.msg("dialog.template.sensitivity"));
        this.sensitivity = new Combo((Composite)group, 8);
        this.sensitivity.setItems(this.settings.getSettings().getValues("profile", "sensitivity"));
        this.sensitivity.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.sensitivity.setVisibleItemCount(20);
        this.sensitivity.setToolTipText(this.settings.msg("dialog.template.sensitivity.tooltip"));
        Group group2 = new Group(composite, 0);
        group2.setLayoutData((Object)new GridData(4, 4, true, false));
        group2.setText(this.settings.msg("dialog.template.keyboard"));
        group2.setLayout((Layout)new GridLayout(2, false));
        Label label3 = new Label((Composite)group2, 0);
        label3.setText(this.settings.msg("dialog.template.usescancodes"));
        this.usescancodes = new Button((Composite)group2, 32);
        this.usescancodes.setToolTipText(this.settings.msg("dialog.template.usescancodes.tooltip"));
        Label label4 = new Label((Composite)group2, 0);
        label4.setText(this.settings.msg("dialog.template.mapperfile"));
        this.mapperfile = new Text((Composite)group2, 2048);
        this.mapperfile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mapperfile.setToolTipText(this.settings.msg("dialog.template.mapperfile.tooltip"));
        Label label5 = new Label((Composite)group2, 0);
        label5.setText(this.settings.msg("dialog.template.keyboardlayout"));
        this.keyboard_layout = new Combo((Composite)group2, 0);
        this.keyboard_layout.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.keyboard_layout.setVisibleItemCount(15);
        this.keyboard_layout.setItems(this.settings.getSettings().getValues("profile", "keyboardlayout"));
        this.keyboard_layout.setToolTipText(this.settings.msg("dialog.template.keyboardlayout.tooltip"));
        Label label6 = new Label((Composite)group2, 0);
        label6.setText(this.settings.msg("dialog.template.keybcommand"));
        this.keyb = new Text((Composite)group2, 2048);
        this.keyb.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group group3 = new Group(composite, 0);
        group3.setLayoutData((Object)new GridData(4, 4, false, false));
        group3.setText(this.settings.msg("dialog.template.joystick"));
        group3.setLayout((Layout)new GridLayout(2, false));
        Label label7 = new Label((Composite)group3, 0);
        label7.setText(this.settings.msg("dialog.template.joysticktype"));
        this.joysticktype = new Combo((Composite)group3, 8);
        this.joysticktype.setItems(this.settings.getSettings().getValues("profile", "joysticktype"));
        this.joysticktype.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.joysticktype.setToolTipText(this.settings.msg("dialog.template.joysticktype.tooltip"));
        Label label8 = new Label((Composite)group3, 0);
        label8.setText(this.settings.msg("dialog.template.timedemulation"));
        this.timed = new Button((Composite)group3, 32);
        this.timed.setToolTipText(this.settings.msg("dialog.template.timedemulation.tooltip"));
        Label label9 = new Label((Composite)group3, 0);
        label9.setText(this.settings.msg("dialog.template.autofire"));
        this.autofire = new Button((Composite)group3, 32);
        this.autofire.setToolTipText(this.settings.msg("dialog.template.autofire.tooltip"));
        Label label10 = new Label((Composite)group3, 0);
        label10.setText(this.settings.msg("dialog.template.swap34"));
        this.swap34 = new Button((Composite)group3, 32);
        this.swap34.setToolTipText(this.settings.msg("dialog.template.swap34.tooltip"));
        Label label11 = new Label((Composite)group3, 0);
        label11.setText(this.settings.msg("dialog.template.buttonwrapping"));
        this.buttonwrap = new Button((Composite)group3, 32);
        this.buttonwrap.setToolTipText(this.settings.msg("dialog.template.buttonwrapping.tooltip"));
        Group group4 = new Group(composite, 0);
        group4.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        group4.setText(this.settings.msg("dialog.template.modem"));
        group4.setLayout((Layout)new GridLayout(2, false));
        Label label12 = new Label((Composite)group4, 0);
        label12.setText(this.settings.msg("dialog.template.serial1"));
        this.serial1 = new Text((Composite)group4, 2048);
        this.serial1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.serial1.setToolTipText(this.settings.msg("dialog.template.serial.tooltip"));
        Label label13 = new Label((Composite)group4, 0);
        label13.setText(this.settings.msg("dialog.template.serial2"));
        this.serial2 = new Text((Composite)group4, 2048);
        this.serial2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.serial2.setToolTipText(this.settings.msg("dialog.template.serial.tooltip"));
        Label label14 = new Label((Composite)group4, 0);
        label14.setText(this.settings.msg("dialog.template.serial3"));
        this.serial3 = new Text((Composite)group4, 2048);
        this.serial3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.serial3.setToolTipText(this.settings.msg("dialog.template.serial.tooltip"));
        Label label15 = new Label((Composite)group4, 0);
        label15.setText(this.settings.msg("dialog.template.serial4"));
        this.serial4 = new Text((Composite)group4, 2048);
        this.serial4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.serial4.setToolTipText(this.settings.msg("dialog.template.serial.tooltip"));
        Group group5 = new Group(composite, 0);
        group5.setLayoutData((Object)new GridData(4, 4, false, false));
        group5.setText(this.settings.msg("dialog.template.network"));
        group5.setLayout((Layout)new GridLayout(2, false));
        Label label16 = new Label((Composite)group5, 0);
        label16.setText(this.settings.msg("dialog.template.enableipx"));
        this.ipx = new Button((Composite)group5, 32);
        this.ipx.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditTemplateDialog.this.ipxnet.setEnabled(EditTemplateDialog.this.ipx.getSelection());
            }
        });
        this.ipx.setToolTipText(this.settings.msg("dialog.template.enableipx.tooltip"));
        Label label17 = new Label((Composite)group5, 0);
        label17.setText(this.settings.msg("dialog.template.ipxnetcommand"));
        label17.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.ipxnet = new Text((Composite)group5, 2048);
        this.ipxnet.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Group group6 = new Group(composite2, 0);
        group6.setLayoutData((Object)new GridData(4, 4, false, false));
        group6.setText(this.settings.msg("dialog.template.mouse"));
        group6.setLayout((Layout)new GridLayout(2, false));
        Label label18 = new Label((Composite)group6, 0);
        label18.setText(this.settings.msg("dialog.template.int33"));
        this.int33 = new Button((Composite)group6, 32);
        Label label19 = new Label((Composite)group6, 0);
        label19.setText(this.settings.msg("dialog.template.biosps2"));
        this.biosps2 = new Button((Composite)group6, 32);
        Label label20 = new Label((Composite)group6, 0);
        label20.setText(this.settings.msg("dialog.template.aux"));
        this.aux = new Button((Composite)group6, 32);
        Label label21 = new Label((Composite)group6, 0);
        label21.setText(this.settings.msg("dialog.template.auxdevice"));
        this.auxdevice = new Combo((Composite)group6, 8);
        this.auxdevice.setItems(this.settings.getSettings().getValues("profile", "auxdevice"));
        Group group7 = new Group(composite2, 0);
        group7.setLayoutData((Object)new GridData(4, 4, false, false));
        group7.setText(this.settings.msg("dialog.template.miscellaneous"));
        group7.setLayout((Layout)new GridLayout(2, false));
        Label label22 = new Label((Composite)group7, 0);
        label22.setText(this.settings.msg("dialog.template.files"));
        this.files = new Spinner((Composite)group7, 2048);
        this.files.setMinimum(8);
        this.files.setMaximum(255);
        Label label23 = new Label((Composite)group7, 0);
        label23.setText(this.settings.msg("dialog.template.isapnpbios"));
        this.isapnpbios = new Button((Composite)group7, 32);
        Label label24 = new Label((Composite)group7, 0);
        label24.setText(this.settings.msg("dialog.template.ide1"));
        this.ide1 = new Button((Composite)group7, 32);
        Label label25 = new Label((Composite)group7, 0);
        label25.setText(this.settings.msg("dialog.template.ide2"));
        this.ide2 = new Button((Composite)group7, 32);
        Label label26 = new Label((Composite)group7, 0);
        label26.setText(this.settings.msg("dialog.template.ide3"));
        this.ide3 = new Button((Composite)group7, 32);
        Label label27 = new Label((Composite)group7, 0);
        label27.setText(this.settings.msg("dialog.template.ide4"));
        this.ide4 = new Button((Composite)group7, 32);
        Label label28 = new Label((Composite)group7, 0);
        label28.setText(this.settings.msg("dialog.template.automount"));
        this.automount = new Button((Composite)group7, 32);
        Group group8 = new Group(composite2, 0);
        group8.setLayoutData((Object)new GridData(4, 4, false, false));
        group8.setText(this.settings.msg("dialog.template.printer"));
        group8.setLayout((Layout)new GridLayout(2, false));
        Label label29 = new Label((Composite)group8, 0);
        label29.setText(this.settings.msg("dialog.template.printerenable"));
        this.printer = new Button((Composite)group8, 32);
        Label label30 = new Label((Composite)group8, 0);
        label30.setText(this.settings.msg("dialog.template.printerdpi"));
        this.printerdpi = new Spinner((Composite)group8, 2048);
        this.printerdpi.setMinimum(0);
        this.printerdpi.setMaximum(Short.MAX_VALUE);
        Label label31 = new Label((Composite)group8, 0);
        label31.setText(this.settings.msg("dialog.template.printerwidth"));
        this.printerwidth = new Spinner((Composite)group8, 2048);
        this.printerwidth.setMinimum(0);
        this.printerwidth.setMaximum(Short.MAX_VALUE);
        Label label32 = new Label((Composite)group8, 0);
        label32.setText(this.settings.msg("dialog.template.printerheight"));
        this.printerheight = new Spinner((Composite)group8, 2048);
        this.printerheight.setMinimum(0);
        this.printerheight.setMaximum(Short.MAX_VALUE);
        Label label33 = new Label((Composite)group8, 0);
        label33.setText(this.settings.msg("dialog.template.printeroutput"));
        this.printeroutput = new Combo((Composite)group8, 8);
        this.printeroutput.setItems(this.settings.getSettings().getValues("profile", "printeroutput"));
        Label label34 = new Label((Composite)group8, 0);
        label34.setText(this.settings.msg("dialog.template.printermultipage"));
        this.printermultipage = new Button((Composite)group8, 32);
        Label label35 = new Label((Composite)group8, 0);
        label35.setText(this.settings.msg("dialog.template.printerdocpath"));
        this.printerdocpath = new Text((Composite)group8, 2048);
        this.printerdocpath.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label36 = new Label((Composite)group8, 0);
        label36.setText(this.settings.msg("dialog.template.printertimeout"));
        this.printertimeout = new Spinner((Composite)group8, 2048);
        this.printertimeout.setMinimum(0);
        this.printertimeout.setMaximum(Short.MAX_VALUE);
        Group group9 = new Group(composite2, 0);
        group9.setText(this.settings.msg("dialog.template.parallel"));
        group9.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        group9.setLayout((Layout)new GridLayout(2, false));
        Label label37 = new Label((Composite)group9, 0);
        label37.setText(this.settings.msg("dialog.template.parallel1"));
        this.parallel1 = new Text((Composite)group9, 2048);
        this.parallel1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label38 = new Label((Composite)group9, 0);
        label38.setText(this.settings.msg("dialog.template.parallel2"));
        this.parallel2 = new Text((Composite)group9, 2048);
        this.parallel2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label39 = new Label((Composite)group9, 0);
        label39.setText(this.settings.msg("dialog.template.parallel3"));
        this.parallel3 = new Text((Composite)group9, 2048);
        this.parallel3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label40 = new Label((Composite)group9, 0);
        label40.setText(this.settings.msg("dialog.template.dongle"));
        this.dongle = new Button((Composite)group9, 32);
        Group group10 = new Group(composite2, 0);
        group10.setLayoutData((Object)new GridData(4, 4, false, false));
        group10.setText(this.settings.msg("dialog.template.ne2000"));
        group10.setLayout((Layout)new GridLayout(2, false));
        Label label41 = new Label((Composite)group10, 0);
        label41.setText(this.settings.msg("dialog.template.ne2000enable"));
        this.ne2000 = new Button((Composite)group10, 32);
        Label label42 = new Label((Composite)group10, 0);
        label42.setText(this.settings.msg("dialog.template.ne2000base"));
        this.ne2000base = new Text((Composite)group10, 2048);
        this.ne2000base.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label43 = new Label((Composite)group10, 0);
        label43.setText(this.settings.msg("dialog.template.ne2000irq"));
        this.ne2000irq = new Text((Composite)group10, 2048);
        this.ne2000irq.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label44 = new Label((Composite)group10, 0);
        label44.setText(this.settings.msg("dialog.template.ne2000macaddress"));
        this.ne2000macaddress = new Text((Composite)group10, 2048);
        this.ne2000macaddress.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label45 = new Label((Composite)group10, 0);
        label45.setText(this.settings.msg("dialog.template.ne2000realnic"));
        this.ne2000realnic = new Text((Composite)group10, 2048);
        this.ne2000realnic.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    protected void createAudioTab(TabFolder tabFolder) {
        TabFolder tabFolder2 = this.createRelExpTabs(tabFolder, "dialog.template.tab.audio", 3, 3);
        Composite composite = (Composite)tabFolder2.getChildren()[0];
        Composite composite2 = (Composite)tabFolder2.getChildren()[1];
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText(this.settings.msg("dialog.template.general"));
        Label label = new Label((Composite)group, 0);
        label.setText(this.settings.msg("dialog.template.silentmode"));
        this.nosound = new Button((Composite)group, 32);
        this.nosound.setToolTipText(this.settings.msg("dialog.template.silentmode.tooltip"));
        Label label2 = new Label((Composite)group, 0);
        label2.setText(this.settings.msg("dialog.template.samplerate"));
        this.rate = new Combo((Composite)group, 8);
        this.rate.setVisibleItemCount(10);
        this.rate.setItems(this.settings.getSettings().getValues("profile", "rate"));
        this.rate.setLayoutData((Object)new GridData());
        this.rate.setToolTipText(this.settings.msg("dialog.template.samplerate.tooltip"));
        Label label3 = new Label((Composite)group, 0);
        label3.setText(this.settings.msg("dialog.template.blocksize"));
        this.blocksize = new Combo((Composite)group, 8);
        this.blocksize.setItems(this.settings.getSettings().getValues("profile", "blocksize"));
        this.blocksize.setLayoutData((Object)new GridData());
        this.blocksize.setToolTipText(this.settings.msg("dialog.template.blocksize.tooltip"));
        Label label4 = new Label((Composite)group, 0);
        label4.setText(this.settings.msg("dialog.template.prebuffer"));
        this.prebuffer = new Combo((Composite)group, 0);
        this.prebuffer.setItems(this.settings.getSettings().getValues("profile", "prebuffer"));
        this.prebuffer.setLayoutData((Object)new GridData(70, -1));
        this.prebuffer.setToolTipText(this.settings.msg("dialog.template.prebuffer.tooltip"));
        Label label5 = new Label((Composite)group, 0);
        label5.setText(this.settings.msg("dialog.template.mpu401"));
        this.mpu401 = new Combo((Composite)group, 8);
        this.mpu401.setItems(this.settings.getSettings().getValues("profile", "mpu401"));
        this.mpu401.setLayoutData((Object)new GridData());
        this.mpu401.setToolTipText(this.settings.msg("dialog.template.mpu401.tooltip"));
        Label label6 = new Label((Composite)group, 0);
        label6.setText(this.settings.msg("dialog.template.mididevice"));
        this.midi_device = new Combo((Composite)group, 8);
        this.midi_device.setVisibleItemCount(10);
        this.midi_device.setItems(this.settings.getSettings().getValues("profile", "device"));
        this.midi_device.setLayoutData((Object)new GridData());
        this.midi_device.setToolTipText(this.settings.msg("dialog.template.mididevice.tooltip"));
        Label label7 = new Label((Composite)group, 0);
        label7.setText(this.settings.msg("dialog.template.midiconfig"));
        this.midi_config = new Text((Composite)group, 2048);
        this.midi_config.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.midi_config.setToolTipText(this.settings.msg("dialog.template.midiconfig.tooltip"));
        Label label8 = new Label((Composite)group, 0);
        label8.setText(this.settings.msg("dialog.template.mixercommand"));
        Composite composite3 = new Composite((Composite)group, 0);
        composite3.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 2;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        this.mixer_config = new Text(composite3, 18436);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 66;
        this.mixer_config.setLayoutData((Object)gridData);
        Button button = new Button(composite3, 0);
        button.setText("...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditMixerDialog editMixerDialog = new EditMixerDialog(EditTemplateDialog.this.shell);
                editMixerDialog.setMixerCommand(EditTemplateDialog.this.mixer_config.getText());
                String string = (String)editMixerDialog.open();
                if (string != null) {
                    EditTemplateDialog.this.mixer_config.setText(string);
                }
            }
        });
        Group group2 = new Group(composite, 0);
        group2.setLayoutData((Object)new GridData(4, 4, false, false));
        group2.setText(this.settings.msg("dialog.template.soundblaster"));
        group2.setLayout((Layout)new GridLayout(2, false));
        Label label9 = new Label((Composite)group2, 0);
        label9.setText(this.settings.msg("dialog.template.sbtype"));
        this.sbtype = new Combo((Composite)group2, 8);
        this.sbtype.setVisibleItemCount(10);
        this.sbtype.setItems(this.settings.getSettings().getValues("profile", "sbtype"));
        this.sbtype.setLayoutData((Object)new GridData());
        this.sbtype.setToolTipText(this.settings.msg("dialog.template.sbtype.tooltip"));
        Label label10 = new Label((Composite)group2, 0);
        label10.setText(this.settings.msg("dialog.template.sboplrate"));
        this.oplrate = new Combo((Composite)group2, 8);
        this.oplrate.setVisibleItemCount(10);
        this.oplrate.setItems(this.settings.getSettings().getValues("profile", "oplrate"));
        this.oplrate.setLayoutData((Object)new GridData());
        this.oplrate.setToolTipText(this.settings.msg("dialog.template.sboplrate.tooltip"));
        Label label11 = new Label((Composite)group2, 0);
        label11.setLayoutData((Object)new GridData());
        label11.setText(this.settings.msg("dialog.template.sboplmode"));
        this.oplmode = new Combo((Composite)group2, 8);
        this.oplmode.setItems(this.settings.getSettings().getValues("profile", "oplmode"));
        this.oplmode.setLayoutData((Object)new GridData());
        this.oplmode.setToolTipText(this.settings.msg("dialog.template.sboplmode.tooltip"));
        Label label12 = new Label((Composite)group2, 0);
        label12.setLayoutData((Object)new GridData());
        label12.setText(this.settings.msg("dialog.template.sboplemu"));
        this.oplemu = new Combo((Composite)group2, 8);
        this.oplemu.setItems(this.settings.getSettings().getValues("profile", "oplemu"));
        this.oplemu.setLayoutData((Object)new GridData());
        this.oplemu.setToolTipText(this.settings.msg("dialog.template.sboplemu.tooltip"));
        Label label13 = new Label((Composite)group2, 0);
        label13.setText(this.settings.msg("dialog.template.sbaddress"));
        this.sbbase = new Combo((Composite)group2, 8);
        this.sbbase.setItems(this.settings.getSettings().getValues("profile", "sbbase"));
        this.sbbase.setLayoutData((Object)new GridData());
        this.sbbase.setToolTipText(this.settings.msg("dialog.template.sbaddress.tooltip"));
        Label label14 = new Label((Composite)group2, 0);
        label14.setText(this.settings.msg("dialog.template.sbirq"));
        this.irq = new Combo((Composite)group2, 8);
        this.irq.setItems(this.settings.getSettings().getValues("profile", "irq"));
        this.irq.setLayoutData((Object)new GridData());
        this.irq.setToolTipText(this.settings.msg("dialog.template.sbirq.tooltip"));
        Label label15 = new Label((Composite)group2, 0);
        label15.setText(this.settings.msg("dialog.template.sbdma"));
        this.dma = new Combo((Composite)group2, 8);
        this.dma.setItems(this.settings.getSettings().getValues("profile", "dma"));
        this.dma.setLayoutData((Object)new GridData());
        this.dma.setToolTipText(this.settings.msg("dialog.template.sbdma.tooltip"));
        Label label16 = new Label((Composite)group2, 0);
        label16.setLayoutData((Object)new GridData());
        label16.setText(this.settings.msg("dialog.template.sbhdma"));
        this.hdma = new Combo((Composite)group2, 8);
        this.hdma.setItems(this.settings.getSettings().getValues("profile", "hdma"));
        this.hdma.setLayoutData((Object)new GridData());
        this.hdma.setToolTipText(this.settings.msg("dialog.template.sbhdma.tooltip"));
        Label label17 = new Label((Composite)group2, 0);
        label17.setText(this.settings.msg("dialog.template.mixer"));
        this.sbmixer = new Button((Composite)group2, 32);
        this.sbmixer.setToolTipText(this.settings.msg("dialog.template.mixer.tooltip"));
        Group group3 = new Group(composite, 0);
        group3.setLayoutData((Object)new GridData(4, 4, true, false));
        group3.setText(this.settings.msg("dialog.template.gravisultrasound"));
        group3.setLayout((Layout)new GridLayout(2, false));
        Label label18 = new Label((Composite)group3, 0);
        label18.setLayoutData((Object)new GridData());
        label18.setText(this.settings.msg("dialog.template.enablegus"));
        this.gus = new Button((Composite)group3, 32);
        this.gus.setLayoutData((Object)new GridData());
        this.gus.setToolTipText(this.settings.msg("dialog.template.enablegus.tooltip"));
        Label label19 = new Label((Composite)group3, 0);
        label19.setText(this.settings.msg("dialog.template.gusrate"));
        this.gusrate = new Combo((Composite)group3, 8);
        this.gusrate.setVisibleItemCount(10);
        this.gusrate.setItems(this.settings.getSettings().getValues("profile", "gusrate"));
        this.gusrate.setLayoutData((Object)new GridData());
        this.gusrate.setToolTipText(this.settings.msg("dialog.template.gusrate.tooltip"));
        Label label20 = new Label((Composite)group3, 0);
        label20.setText(this.settings.msg("dialog.template.gusaddress"));
        this.gusbase = new Combo((Composite)group3, 8);
        this.gusbase.setItems(this.settings.getSettings().getValues("profile", "gusbase"));
        this.gusbase.setLayoutData((Object)new GridData());
        this.gusbase.setToolTipText(this.settings.msg("dialog.template.gusaddress.tooltip"));
        Label label21 = new Label((Composite)group3, 0);
        label21.setText(this.settings.msg("dialog.template.gusirq1"));
        this.gusirq1 = new Combo((Composite)group3, 8);
        this.gusirq1.setItems(this.settings.getSettings().getValues("profile", "irq1"));
        this.gusirq1.setLayoutData((Object)new GridData());
        this.gusirq1.setToolTipText(this.settings.msg("dialog.template.gusirq1.tooltip"));
        Label label22 = new Label((Composite)group3, 0);
        label22.setText(this.settings.msg("dialog.template.gusirq2"));
        this.gusirq2 = new Combo((Composite)group3, 8);
        this.gusirq2.setItems(this.settings.getSettings().getValues("profile", "irq2"));
        this.gusirq2.setLayoutData((Object)new GridData());
        Label label23 = new Label((Composite)group3, 0);
        label23.setText(this.settings.msg("dialog.template.gusdma1"));
        this.gusdma1 = new Combo((Composite)group3, 8);
        this.gusdma1.setItems(this.settings.getSettings().getValues("profile", "dma1"));
        this.gusdma1.setLayoutData((Object)new GridData());
        this.gusdma1.setToolTipText(this.settings.msg("dialog.template.gusdma1.tooltip"));
        Label label24 = new Label((Composite)group3, 0);
        label24.setLayoutData((Object)new GridData());
        label24.setText(this.settings.msg("dialog.template.gusdma2"));
        this.gusdma2 = new Combo((Composite)group3, 8);
        this.gusdma2.setItems(this.settings.getSettings().getValues("profile", "dma2"));
        this.gusdma2.setLayoutData((Object)new GridData());
        Label label25 = new Label((Composite)group3, 0);
        label25.setText(this.settings.msg("dialog.template.ultradir"));
        this.ultradir = new Text((Composite)group3, 2048);
        this.ultradir.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.ultradir.setToolTipText(this.settings.msg("dialog.template.ultradir.tooltip"));
        Group group4 = new Group(composite, 0);
        group4.setLayoutData((Object)new GridData(4, 4, true, false));
        group4.setText(this.settings.msg("dialog.template.pcspeaker"));
        group4.setLayout((Layout)new GridLayout(2, false));
        Label label26 = new Label((Composite)group4, 0);
        label26.setText(this.settings.msg("dialog.template.enablepcspeaker"));
        this.pcspeaker = new Button((Composite)group4, 32);
        this.pcspeaker.setToolTipText(this.settings.msg("dialog.template.enablepcspeaker.tooltip"));
        Label label27 = new Label((Composite)group4, 0);
        label27.setText(this.settings.msg("dialog.template.pcrate"));
        this.pcrate = new Combo((Composite)group4, 8);
        this.pcrate.setVisibleItemCount(10);
        this.pcrate.setItems(this.settings.getSettings().getValues("profile", "pcrate"));
        this.pcrate.setLayoutData((Object)new GridData());
        this.pcrate.setToolTipText(this.settings.msg("dialog.template.pcrate.tooltip"));
        Group group5 = new Group(composite, 0);
        group5.setLayoutData((Object)new GridData(4, 4, false, false));
        group5.setText(this.settings.msg("dialog.template.tandy"));
        group5.setLayout((Layout)new GridLayout(2, false));
        Label label28 = new Label((Composite)group5, 0);
        label28.setText(this.settings.msg("dialog.template.enabletandy"));
        this.tandy = new Combo((Composite)group5, 8);
        this.tandy.setItems(this.settings.getSettings().getValues("profile", "tandy"));
        this.tandy.setLayoutData((Object)new GridData());
        this.tandy.setToolTipText(this.settings.msg("dialog.template.enabletandy.tooltip"));
        Label label29 = new Label((Composite)group5, 0);
        label29.setText(this.settings.msg("dialog.template.tandyrate"));
        this.tandyrate = new Combo((Composite)group5, 8);
        this.tandyrate.setVisibleItemCount(10);
        this.tandyrate.setItems(this.settings.getSettings().getValues("profile", "tandyrate"));
        this.tandyrate.setLayoutData((Object)new GridData());
        this.tandyrate.setToolTipText(this.settings.msg("dialog.template.tandyrate.tooltip"));
        Group group6 = new Group(composite, 0);
        group6.setLayoutData((Object)new GridData(4, 4, true, false));
        group6.setText(this.settings.msg("dialog.template.miscellaneous"));
        group6.setLayout((Layout)new GridLayout(2, false));
        Label label30 = new Label((Composite)group6, 0);
        label30.setText(this.settings.msg("dialog.template.enablesoundsource"));
        this.disney = new Button((Composite)group6, 32);
        this.disney.setToolTipText(this.settings.msg("dialog.template.enablesoundsource.tooltip"));
        Group group7 = new Group(composite2, 0);
        group7.setLayoutData((Object)new GridData(4, 4, true, false));
        group7.setLayout((Layout)new GridLayout(2, false));
        group7.setText(this.settings.msg("dialog.template.general"));
        Label label31 = new Label((Composite)group7, 0);
        label31.setText(this.settings.msg("dialog.template.swapstereo"));
        this.swapstereo = new Button((Composite)group7, 32);
        Group group8 = new Group(composite2, 0);
        group8.setLayoutData((Object)new GridData(4, 4, false, false));
        group8.setText(this.settings.msg("dialog.template.soundblaster"));
        group8.setLayout((Layout)new GridLayout(2, false));
        Label label32 = new Label((Composite)group8, 0);
        label32.setText(this.settings.msg("dialog.template.hardwaresbaddress"));
        this.hardwareaddresssbbase = new Combo((Composite)group8, 8);
        this.hardwareaddresssbbase.setItems(this.settings.getSettings().getValues("profile", "hardwaresbbase"));
        Label label33 = new Label((Composite)group8, 0);
        label33.setText(this.settings.msg("dialog.template.goldplay"));
        this.goldplay = new Button((Composite)group8, 32);
        Group group9 = new Group(composite2, 0);
        group9.setLayoutData((Object)new GridData(4, 4, false, false));
        group9.setText(this.settings.msg("dialog.template.mt32"));
        group9.setLayout((Layout)new GridLayout(2, false));
        Label label34 = new Label((Composite)group9, 0);
        label34.setText(this.settings.msg("dialog.template.swapstereo"));
        this.swapstereoMT32 = new Button((Composite)group9, 32);
        Label label35 = new Label((Composite)group9, 0);
        label35.setText(this.settings.msg("dialog.template.mt32.verboselogging"));
        this.loggingMT32 = new Button((Composite)group9, 32);
        Label label36 = new Label((Composite)group9, 0);
        label36.setText(this.settings.msg("dialog.template.mt32.multithread"));
        this.multithreadMT32 = new Button((Composite)group9, 32);
        Label label37 = new Label((Composite)group9, 0);
        label37.setText(this.settings.msg("dialog.template.mt32.dac"));
        this.dacMT32 = new Combo((Composite)group9, 8);
        this.dacMT32.setItems(this.settings.getSettings().getValues("profile", "mt32dac"));
        Label label38 = new Label((Composite)group9, 0);
        label38.setText(this.settings.msg("dialog.template.mt32.reverbmode"));
        this.reverbmodeMT32 = new Combo((Composite)group9, 8);
        this.reverbmodeMT32.setItems(this.settings.getSettings().getValues("profile", "mt32reverbmode"));
        Label label39 = new Label((Composite)group9, 0);
        label39.setText(this.settings.msg("dialog.template.mt32.reverbtime"));
        this.reverbtimeMT32 = new Combo((Composite)group9, 8);
        this.reverbtimeMT32.setItems(this.settings.getSettings().getValues("profile", "mt32reverbtime"));
        Label label40 = new Label((Composite)group9, 0);
        label40.setText(this.settings.msg("dialog.template.mt32.reverblevel"));
        this.reverblevelMT32 = new Combo((Composite)group9, 8);
        this.reverblevelMT32.setItems(this.settings.getSettings().getValues("profile", "mt32reverblevel"));
        Label label41 = new Label((Composite)group9, 0);
        label41.setText(this.settings.msg("dialog.template.mt32.partials"));
        this.partialsMT32 = new Spinner((Composite)group9, 2048);
        this.partialsMT32.setMinimum(0);
        this.partialsMT32.setMaximum(256);
        new Label(composite2, 0);
        Group group10 = new Group(composite2, 0);
        group10.setLayoutData((Object)new GridData(4, 4, true, false));
        group10.setText(this.settings.msg("dialog.template.ps1"));
        group10.setLayout((Layout)new GridLayout(2, false));
        Label label42 = new Label((Composite)group10, 0);
        label42.setText(this.settings.msg("dialog.template.ps1enable"));
        this.ps1 = new Button((Composite)group10, 32);
        Label label43 = new Label((Composite)group10, 0);
        label43.setText(this.settings.msg("dialog.template.ps1rate"));
        this.ps1rate = new Combo((Composite)group10, 8);
        this.ps1rate.setItems(this.settings.getSettings().getValues("profile", "ps1rate"));
        Group group11 = new Group(composite2, 0);
        group11.setLayoutData((Object)new GridData(4, 4, true, false));
        group11.setText(this.settings.msg("dialog.template.innova"));
        group11.setLayout((Layout)new GridLayout(2, false));
        Label label44 = new Label((Composite)group11, 0);
        label44.setText(this.settings.msg("dialog.template.innovaenable"));
        this.innova = new Button((Composite)group11, 32);
        Label label45 = new Label((Composite)group11, 0);
        label45.setText(this.settings.msg("dialog.template.innovarate"));
        this.innovarate = new Combo((Composite)group11, 8);
        this.innovarate.setItems(this.settings.getSettings().getValues("profile", "innovarate"));
        Label label46 = new Label((Composite)group11, 0);
        label46.setText(this.settings.msg("dialog.template.innovaaddress"));
        this.innovabase = new Combo((Composite)group11, 8);
        this.innovabase.setItems(this.settings.getSettings().getValues("profile", "innovabase"));
        Label label47 = new Label((Composite)group11, 0);
        label47.setText(this.settings.msg("dialog.template.innovaquality"));
        this.innovaquality = new Combo((Composite)group11, 8);
        this.innovaquality.setItems(this.settings.getSettings().getValues("profile", "innovaquality"));
    }

    protected void createMachineTab(TabFolder tabFolder) {
        TabFolder tabFolder2 = this.createRelExpTabs(tabFolder, "dialog.template.tab.machine", 1, 1);
        Composite composite = (Composite)tabFolder2.getChildren()[0];
        Composite composite2 = (Composite)tabFolder2.getChildren()[1];
        Group group = new Group(composite, 0);
        group.setText(this.settings.msg("dialog.template.cpu"));
        group.setLayout((Layout)new GridLayout(6, false));
        Label label = new Label((Composite)group, 0);
        label.setText(this.settings.msg("dialog.template.machine"));
        this.machine = new Combo((Composite)group, 8);
        this.machine.setLayoutData((Object)new GridData());
        this.machine.setVisibleItemCount(20);
        this.machine.setToolTipText(this.settings.msg("dialog.template.machine.tooltip"));
        Label label2 = new Label((Composite)group, 0);
        label2.setText(this.settings.msg("dialog.template.cputype"));
        this.cpu_type = new Combo((Composite)group, 8);
        this.cpu_type.setItems(this.settings.getSettings().getValues("profile", "cputype"));
        this.cpu_type.setLayoutData((Object)new GridData());
        this.cpu_type.setVisibleItemCount(10);
        this.cpu_type.setToolTipText(this.settings.msg("dialog.template.cputype.tooltip"));
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        Label label3 = new Label((Composite)group, 0);
        label3.setText(this.settings.msg("dialog.template.core"));
        this.core = new Combo((Composite)group, 8);
        this.core.setItems(this.settings.getSettings().getValues("profile", "core"));
        this.core.setLayoutData((Object)new GridData());
        this.core.setToolTipText(this.settings.msg("dialog.template.core.tooltip"));
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        Label label4 = new Label((Composite)group, 0);
        label4.setText(this.settings.msg("dialog.template.cycles"));
        this.cycles = new Combo((Composite)group, 0);
        this.cycles.setItems(this.settings.getSettings().getValues("profile", "cycles"));
        this.cycles.setLayoutData((Object)new GridData(100, -1));
        this.cycles.setVisibleItemCount(15);
        this.cycles.setToolTipText(this.settings.msg("dialog.template.cycles.tooltip"));
        Label label5 = new Label((Composite)group, 0);
        label5.setLayoutData((Object)new GridData());
        label5.setText(this.settings.msg("dialog.template.up"));
        this.cycles_up = new Combo((Composite)group, 0);
        this.cycles_up.setItems(this.settings.getSettings().getValues("profile", "cycles_up"));
        this.cycles_up.setLayoutData((Object)new GridData(75, -1));
        this.cycles_up.setToolTipText(this.settings.msg("dialog.template.up.tooltip"));
        Label label6 = new Label((Composite)group, 0);
        label6.setLayoutData((Object)new GridData());
        label6.setText(this.settings.msg("dialog.template.down"));
        this.cycles_down = new Combo((Composite)group, 0);
        this.cycles_down.setItems(this.settings.getSettings().getValues("profile", "cycles_down"));
        this.cycles_down.setLayoutData((Object)new GridData(75, -1));
        this.cycles_down.setToolTipText(this.settings.msg("dialog.template.down.tooltip"));
        this.memoryGroup = new Group(composite, 0);
        this.memoryGroup.setText(this.settings.msg("dialog.template.memory"));
        this.memoryGroup.setLayout((Layout)new GridLayout(4, false));
        Label label7 = new Label((Composite)this.memoryGroup, 0);
        label7.setText(this.settings.msg("dialog.template.memorysize"));
        this.memsize = new Combo((Composite)this.memoryGroup, 8);
        this.memsize.setItems(this.settings.getSettings().getValues("profile", "memsize"));
        this.memsize.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.memsize.setToolTipText(this.settings.msg("dialog.template.memorysize.tooltip"));
        new Label((Composite)this.memoryGroup, 0);
        new Label((Composite)this.memoryGroup, 0);
        Label label8 = new Label((Composite)this.memoryGroup, 0);
        label8.setText(this.settings.msg("dialog.template.xms"));
        this.xms = new Button((Composite)this.memoryGroup, 32);
        this.xms.setToolTipText(this.settings.msg("dialog.template.xms.tooltip"));
        new Label((Composite)this.memoryGroup, 0);
        new Label((Composite)this.memoryGroup, 0);
        Label label9 = new Label((Composite)this.memoryGroup, 0);
        label9.setText(this.settings.msg("dialog.template.ems"));
        this.ems = new Combo((Composite)this.memoryGroup, 8);
        this.ems.setItems(this.settings.getSettings().getValues("profile", "ems"));
        this.ems.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.ems.setToolTipText(this.settings.msg("dialog.template.ems.tooltip"));
        new Label((Composite)this.memoryGroup, 0);
        new Label((Composite)this.memoryGroup, 0);
        Label label10 = new Label((Composite)this.memoryGroup, 0);
        label10.setText(this.settings.msg("dialog.template.umb"));
        this.umb = new Combo((Composite)this.memoryGroup, 8);
        this.umb.setItems(this.settings.getSettings().getValues("profile", "umb"));
        this.umb.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.umb.setToolTipText(this.settings.msg("dialog.template.umb.tooltip"));
        new Label((Composite)this.memoryGroup, 0);
        new Label((Composite)this.memoryGroup, 0);
        Group group2 = new Group(composite2, 0);
        group2.setText(this.settings.msg("dialog.template.memory"));
        group2.setLayout((Layout)new GridLayout(2, false));
        Label label11 = new Label((Composite)group2, 0);
        label11.setText(this.settings.msg("dialog.template.memorysizekb"));
        this.memsizeKB = new Text((Composite)group2, 2048);
        this.memsizeKB.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label12 = new Label((Composite)group2, 0);
        label12.setText(this.settings.msg("dialog.template.memalias"));
        this.memalias = new Combo((Composite)group2, 0);
        this.memalias.setItems(this.settings.getSettings().getValues("profile", "memalias"));
        this.memalias.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    protected TabFolder createRelExpTabs(TabFolder tabFolder, String string, int n, int n2) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(this.settings.msg(string));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new FillLayout());
        tabItem.setControl((Control)composite);
        TabFolder tabFolder2 = new TabFolder(composite, 0);
        TabItem tabItem2 = new TabItem(tabFolder2, 0);
        tabItem2.setText(this.settings.msg("dialog.template.tab.releaseoptions"));
        TabItem tabItem3 = new TabItem(tabFolder2, 0);
        tabItem3.setText(this.settings.msg("dialog.template.tab.experimentaloptions"));
        Composite composite2 = new Composite((Composite)tabFolder2, 0);
        composite2.setLayout((Layout)new GridLayout(n, false));
        tabItem2.setControl((Control)composite2);
        Composite composite3 = new Composite((Composite)tabFolder2, 0);
        composite3.setLayout((Layout)new GridLayout(n2, false));
        tabItem3.setControl((Control)composite3);
        return tabFolder2;
    }

    protected void createDisplayTab(TabFolder tabFolder) {
        TabFolder tabFolder2 = this.createRelExpTabs(tabFolder, "dialog.template.tab.display", 1, 2);
        Composite composite = (Composite)tabFolder2.getChildren()[0];
        Composite composite2 = (Composite)tabFolder2.getChildren()[1];
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(1, 1, false, false));
        group.setLayout((Layout)new GridLayout(4, false));
        group.setText(this.settings.msg("dialog.template.general"));
        Label label = new Label((Composite)group, 0);
        label.setText(this.settings.msg("dialog.template.output"));
        this.output = new Combo((Composite)group, 8);
        this.output.setItems(this.settings.getSettings().getValues("profile", "output"));
        this.output.setVisibleItemCount(10);
        this.output.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.output.setToolTipText(this.settings.msg("dialog.template.output.tooltip"));
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        Label label2 = new Label((Composite)group, 0);
        label2.setText(this.settings.msg("dialog.template.frameskip"));
        this.frameskip = new Combo((Composite)group, 8);
        this.frameskip.setItems(this.settings.getSettings().getValues("profile", "frameskip"));
        this.frameskip.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.frameskip.setToolTipText(this.settings.msg("dialog.template.frameskip.tooltip"));
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        Label label3 = new Label((Composite)group, 0);
        label3.setText(this.settings.msg("dialog.template.scaler"));
        this.scaler = new Combo((Composite)group, 8);
        this.scaler.setItems(this.settings.getSettings().getValues("profile", "scaler"));
        this.scaler.setVisibleItemCount(15);
        this.scaler.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.scaler.setToolTipText(this.settings.msg("dialog.template.scaler.tooltip"));
        Label label4 = new Label((Composite)group, 0);
        label4.setText(this.settings.msg("dialog.template.scalerforced"));
        this.scaler_forced = new Button((Composite)group, 32);
        this.scaler_forced.setToolTipText(this.settings.msg("dialog.template.scalerforced.tooltip"));
        Label label5 = new Label((Composite)group, 0);
        label5.setText(this.settings.msg("dialog.template.fullscreenresolution"));
        this.fullresolution = new Combo((Composite)group, 8);
        this.fullresolution.setItems(this.settings.getSettings().getValues("profile", "fullresolution"));
        this.fullresolution.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fullresolution.setVisibleItemCount(10);
        this.fullresolution.setToolTipText(this.settings.msg("dialog.template.fullscreenresolution.tooltip"));
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        Label label6 = new Label((Composite)group, 0);
        label6.setText(this.settings.msg("dialog.template.windowresolution"));
        this.windowresolution = new Combo((Composite)group, 8);
        this.windowresolution.setItems(this.settings.getSettings().getValues("profile", "windowresolution"));
        this.windowresolution.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.windowresolution.setVisibleItemCount(10);
        this.windowresolution.setToolTipText(this.settings.msg("dialog.template.windowresolution.tooltip"));
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        Label label7 = new Label((Composite)group, 0);
        label7.setText(this.settings.msg("dialog.template.fullscreen"));
        this.fullscreen = new Button((Composite)group, 32);
        this.fullscreen.setToolTipText(this.settings.msg("dialog.template.fullscreen.tooltip"));
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        Label label8 = new Label((Composite)group, 0);
        label8.setText(this.settings.msg("dialog.template.doublebuffering"));
        this.fulldouble = new Button((Composite)group, 32);
        this.fulldouble.setToolTipText(this.settings.msg("dialog.template.doublebuffering.tooltip"));
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        Label label9 = new Label((Composite)group, 0);
        label9.setText(this.settings.msg("dialog.template.aspectcorrection"));
        this.aspect = new Button((Composite)group, 32);
        this.aspect.setToolTipText(this.settings.msg("dialog.template.aspectcorrection.tooltip"));
        new Label((Composite)group, 0);
        new Label((Composite)group, 0);
        Group group2 = new Group(composite2, 0);
        group2.setLayoutData((Object)new GridData(1, 1, false, false));
        group2.setLayout((Layout)new GridLayout(2, false));
        group2.setText(this.settings.msg("dialog.template.general"));
        Label label10 = new Label((Composite)group2, 0);
        label10.setText(this.settings.msg("dialog.template.autofit"));
        this.autofit = new Button((Composite)group2, 32);
        Label label11 = new Label((Composite)group2, 0);
        label11.setLayoutData((Object)new GridData());
        label11.setText(this.settings.msg("dialog.template.pixelshader"));
        this.pixelshader = new Combo((Composite)group2, 0);
        this.pixelshader.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pixelshader.setVisibleItemCount(20);
        String[] stringArray = FileUtils.getShaders();
        if (stringArray != null && stringArray.length > 0) {
            this.pixelshader.setItems(stringArray);
            this.pixelshader.add("none", 0);
        } else {
            this.pixelshader.setItems(this.settings.getSettings().getValues("profile", "pixelshader"));
        }
        Label label12 = new Label((Composite)group2, 0);
        label12.setText(this.settings.msg("dialog.template.linewise"));
        this.linewise = new Button((Composite)group2, 32);
        Label label13 = new Label((Composite)group2, 0);
        label13.setText(this.settings.msg("dialog.template.char9"));
        this.char9 = new Button((Composite)group2, 32);
        Label label14 = new Label((Composite)group2, 0);
        label14.setText(this.settings.msg("dialog.template.multiscan"));
        this.multiscan = new Button((Composite)group2, 32);
        Label label15 = new Label((Composite)group2, 0);
        label15.setText(this.settings.msg("dialog.template.cgasnow"));
        this.cgasnow = new Button((Composite)group2, 32);
        Label label16 = new Label((Composite)group2, 0);
        label16.setText(this.settings.msg("dialog.template.overscan"));
        this.overscan = new Combo((Composite)group2, 0);
        this.overscan.setItems(this.settings.getSettings().getValues("profile", "overscan"));
        this.overscan.setLayoutData((Object)new GridData(25, -1));
        Label label17 = new Label((Composite)group2, 0);
        label17.setText(this.settings.msg("dialog.template.vsyncmode"));
        this.vsyncmode = new Combo((Composite)group2, 8);
        this.vsyncmode.setItems(this.settings.getSettings().getValues("profile", "vsyncmode"));
        Label label18 = new Label((Composite)group2, 0);
        label18.setLayoutData((Object)new GridData());
        label18.setText(this.settings.msg("dialog.template.vsyncrate"));
        this.vsyncrate = new Text((Composite)group2, 2048);
        this.vsyncrate.setLayoutData((Object)new GridData(25, -1));
        Label label19 = new Label((Composite)group2, 0);
        label19.setLayoutData((Object)new GridData());
        label19.setText(this.settings.msg("dialog.template.forcerate"));
        this.forcerate = new Text((Composite)group2, 2048);
        this.forcerate.setLayoutData((Object)new GridData(25, -1));
        Label label20 = new Label((Composite)group2, 0);
        label20.setText(this.settings.msg("dialog.template.videoram"));
        this.videoram = new Combo((Composite)group2, 8);
        this.videoram.setItems(this.settings.getSettings().getValues("profile", "vmemsize"));
        this.videoram.setLayoutData((Object)new GridData(25, -1));
        Group group3 = new Group(composite2, 0);
        group3.setLayoutData((Object)new GridData(1, 1, false, false));
        group3.setLayout((Layout)new GridLayout(2, false));
        group3.setText(this.settings.msg("dialog.template.glide"));
        Label label21 = new Label((Composite)group3, 0);
        label21.setText(this.settings.msg("dialog.template.glide"));
        this.glide = new Combo((Composite)group3, 8);
        this.glide.setItems(this.settings.getSettings().getValues("profile", "glide"));
        this.glide.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        Label label22 = new Label((Composite)group3, 0);
        label22.setText(this.settings.msg("dialog.template.glideport"));
        this.glideport = new Text((Composite)group3, 2048);
        this.glideport.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label23 = new Label((Composite)group3, 0);
        label23.setText(this.settings.msg("dialog.template.lfbglide"));
        this.lfbGlide = new Combo((Composite)group3, 8);
        this.lfbGlide.setItems(this.settings.getSettings().getValues("profile", "lfbglide"));
        this.lfbGlide.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label24 = new Label((Composite)group3, 0);
        label24.setText(this.settings.msg("dialog.template.splash3dfx"));
        this.splash3dfx = new Button((Composite)group3, 32);
    }

    protected void createGeneralTab(TabFolder tabFolder) {
        this.generalTabItem = new TabItem(tabFolder, 0);
        this.generalTabItem.setText(this.settings.msg("dialog.template.tab.general"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout());
        this.generalTabItem.setControl((Control)composite);
        this.associationGroup = new Group(composite, 0);
        this.associationGroup.setText(this.settings.msg("dialog.template.association"));
        this.associationGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.associationGroup.setLayout((Layout)new GridLayout(5, false));
        Label label = new Label((Composite)this.associationGroup, 0);
        label.setText(this.settings.msg("dialog.template.dosboxversion"));
        this.dbversion = new Combo((Composite)this.associationGroup, 8);
        this.dbversion.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dbversion.setVisibleItemCount(20);
        this.setButton = new Button((Composite)this.associationGroup, 0);
        this.setButton.setText(this.settings.msg("dialog.template.set"));
        this.setButton.setToolTipText(this.settings.msg("dialog.template.set.tooltip"));
        this.setButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditTemplateDialog.this.doPerformDosboxConfAction(DosboxConfAction.SET);
            }
        });
        this.switchButton = new Button((Composite)this.associationGroup, 0);
        this.switchButton.setText(this.settings.msg("dialog.template.switch"));
        this.switchButton.setToolTipText(this.settings.msg("dialog.template.switch.tooltip"));
        this.switchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditTemplateDialog.this.doPerformDosboxConfAction(DosboxConfAction.SWITCH);
            }
        });
        this.dbversion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditTemplateDialog.this.setButton.setEnabled(true);
                EditTemplateDialog.this.switchButton.setEnabled(true);
            }
        });
        this.reloadButton = new Button((Composite)this.associationGroup, 0);
        this.reloadButton.setText(this.settings.msg("dialog.template.reloadsettings"));
        this.reloadButton.setToolTipText(this.settings.msg("dialog.template.reloadsettings.tooltip"));
        this.reloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditTemplateDialog.this.doPerformDosboxConfAction(DosboxConfAction.RELOAD);
            }
        });
        this.miscGroup = new Group(composite, 0);
        this.miscGroup.setText(this.settings.msg("dialog.template.miscellaneous"));
        this.miscGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.miscGroup.setLayout((Layout)new GridLayout(3, false));
        new Label((Composite)this.miscGroup, 0);
        Label label2 = new Label((Composite)this.miscGroup, 0);
        label2.setText(this.settings.msg("dialog.template.active"));
        Label label3 = new Label((Composite)this.miscGroup, 0);
        label3.setText(this.settings.msg("dialog.template.inactive"));
        Label label4 = new Label((Composite)this.miscGroup, 0);
        label4.setText(this.settings.msg("dialog.template.priority"));
        this.priority_active = new Combo((Composite)this.miscGroup, 8);
        this.priority_active.setItems(this.settings.getSettings().getValues("profile", "priority_active"));
        this.priority_active.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.priority_active.setToolTipText(this.settings.msg("dialog.template.priority.tooltip"));
        this.priority_inactive = new Combo((Composite)this.miscGroup, 8);
        this.priority_inactive.setItems(this.settings.getSettings().getValues("profile", "priority_inactive"));
        this.priority_inactive.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.priority_inactive.setToolTipText(this.settings.msg("dialog.template.priority.tooltip"));
        Label label5 = new Label((Composite)this.miscGroup, 0);
        label5.setText(this.settings.msg("dialog.template.waitonerror"));
        this.waitonerror = new Button((Composite)this.miscGroup, 32);
        this.waitonerror.setToolTipText(this.settings.msg("dialog.template.waitonerror.tooltip"));
        new Label((Composite)this.miscGroup, 0);
        Label label6 = new Label((Composite)this.miscGroup, 0);
        label6.setText(this.settings.msg("dialog.template.exitafterwards"));
        this.exit = new Button((Composite)this.miscGroup, 32);
        new Label((Composite)this.miscGroup, 0);
        Label label7 = new Label((Composite)this.miscGroup, 0);
        label7.setLayoutData((Object)new GridData());
        label7.setText(this.settings.msg("dialog.template.languagefile"));
        this.language = new Text((Composite)this.miscGroup, 2048);
        this.language.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.language.setToolTipText(this.settings.msg("dialog.template.languagefile.tooltip"));
        Label label8 = new Label((Composite)this.miscGroup, 0);
        label8.setLayoutData((Object)new GridData());
        label8.setText(this.settings.msg("dialog.template.captures"));
        this.captures = new Text((Composite)this.miscGroup, 2048);
        this.captures.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.captures.setEditable(false);
        this.captures.setToolTipText(this.settings.msg("dialog.template.captures.tooltip"));
        Label label9 = new Label((Composite)this.miscGroup, 0);
        label9.setText(this.settings.msg("dialog.profile.configfile"));
        this.config_file = new Text((Composite)this.miscGroup, 2048);
        this.config_file.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.config_file.setEditable(false);
        this.config_file.setText(this.result instanceof Template ? FileUtils.constructCanonicalTemplateFileLocation(((Template)this.result).getId()).getPath() : SettingsDialog.confFilenames[0]);
    }

    protected void createInfoTab(TabFolder tabFolder) {
        this.infoTabItem = new TabItem(tabFolder, 0);
        this.infoTabItem.setText(this.settings.msg("dialog.template.tab.info"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.infoTabItem.setControl((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(this.settings.msg("dialog.template.title"));
        this.title = new Text(composite, 2048);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label2 = new Label(composite, 0);
        label2.setText(this.settings.msg("dialog.template.default"));
        this.defaultButton = new Button(composite, 32);
    }

    protected void selectSettingsByConfiguration(Conf conf) {
        SectionsWrapper sectionsWrapper = conf.getSettings();
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sdl", "priority", (Control)this.priority_active, (Control)this.priority_inactive);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sdl", "waitonerror", (Control)this.waitonerror);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "dosbox", "language", (Control)this.language);
        EditTemplateDialog.setFieldIfEnabled(this.settings.msg("dialog.profile.automatic"), false, (Control)this.captures);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sdl", "output", (Control)this.output);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "render", "frameskip", (Control)this.frameskip);
        if (sectionsWrapper.isConflictingValue("render", "scaler")) {
            EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "render", "scaler", (Control)this.scaler);
            EditTemplateDialog.setFieldIfEnabled(null, true, (Control)this.scaler_forced);
        } else {
            String string = sectionsWrapper.getValue("render", "scaler");
            if (string.endsWith(" forced")) {
                EditTemplateDialog.setFieldIfEnabled(string.substring(0, string.length() - 7), false, (Control)this.scaler);
                EditTemplateDialog.setFieldIfEnabled(String.valueOf(true), false, (Control)this.scaler_forced);
            } else {
                EditTemplateDialog.setFieldIfEnabled(string, false, (Control)this.scaler);
                EditTemplateDialog.setFieldIfEnabled(String.valueOf(false), false, (Control)this.scaler_forced);
            }
        }
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sdl", "fullscreen", (Control)this.fullscreen);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sdl", "fulldouble", (Control)this.fulldouble);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sdl", "fullresolution", (Control)this.fullresolution);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sdl", "windowresolution", (Control)this.windowresolution);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "render", "aspect", (Control)this.aspect);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "dosbox", "machine", (Control)this.machine);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "cpu", "cputype", (Control)this.cpu_type);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "cpu", "core", (Control)this.core);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "cpu", "cycles", (Control)this.cycles);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "cpu", "cycleup", (Control)this.cycles_up);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "cpu", "cycledown", (Control)this.cycles_down);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "dosbox", "memsize", (Control)this.memsize);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "dos", "xms", (Control)this.xms);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "dos", "ems", (Control)this.ems);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "dos", "umb", (Control)this.umb);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "mixer", "nosound", (Control)this.nosound);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "mixer", "rate", (Control)this.rate);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "mixer", "blocksize", (Control)this.blocksize);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "mixer", "prebuffer", (Control)this.prebuffer);
        if (sectionsWrapper.hasValue("midi", "intelligent")) {
            if (sectionsWrapper.isConflictingValue("midi", "mpu401") || sectionsWrapper.isConflictingValue("midi", "intelligent")) {
                EditTemplateDialog.setFieldIfEnabled(null, true, (Control)this.mpu401);
            } else {
                EditTemplateDialog.setFieldIfEnabled(sectionsWrapper.getBooleanValue("midi", "mpu401") ? (sectionsWrapper.getBooleanValue("midi", "intelligent") ? "intelligent" : "uart") : "none", false, (Control)this.mpu401);
            }
        } else {
            EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "midi", "mpu401", (Control)this.mpu401);
        }
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "midi", "device", "mididevice", (Control)this.midi_device);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "midi", "config", "midiconfig", (Control)this.midi_config);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sblaster", "type", "sbtype", (Control)this.sbtype);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sblaster", "oplmode", (Control)this.oplmode);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sblaster", "oplrate", (Control)this.oplrate);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sblaster", "oplemu", (Control)this.oplemu);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sblaster", "base", "sbbase", (Control)this.sbbase);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sblaster", "irq", (Control)this.irq);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sblaster", "dma", (Control)this.dma);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sblaster", "hdma", (Control)this.hdma);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sblaster", "mixer", "sbmixer", (Control)this.sbmixer);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "gus", "gus", (Control)this.gus);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "gus", "rate", "gusrate", (Control)this.gusrate);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "gus", "base", "gusbase", (Control)this.gusbase);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "gus", "irq1", "gusirq", (Control)this.gusirq1);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "gus", "irq2", "gusirq", (Control)this.gusirq2);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "gus", "dma1", "gusdma", (Control)this.gusdma1);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "gus", "dma2", "gusdma", (Control)this.gusdma2);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "gus", "ultradir", (Control)this.ultradir);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "speaker", "pcspeaker", (Control)this.pcspeaker);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "speaker", "pcrate", (Control)this.pcrate);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "speaker", "tandy", (Control)this.tandy);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "speaker", "tandyrate", (Control)this.tandyrate);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "speaker", "disney", (Control)this.disney);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sdl", "autolock", (Control)this.autolock);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sdl", "sensitivity", (Control)this.sensitivity);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sdl", "usescancodes", (Control)this.usescancodes);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sdl", "mapperfile", (Control)this.mapperfile);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "dos", "keyboardlayout", (Control)this.keyboard_layout);
        if (sectionsWrapper.hasValue("joystick", "joysticktype")) {
            EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "joystick", "joysticktype", (Control)this.joysticktype);
            EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "joystick", "timed", (Control)this.timed);
            EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "joystick", "autofire", (Control)this.autofire);
            EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "joystick", "swap34", (Control)this.swap34);
            EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "joystick", "buttonwrap", (Control)this.buttonwrap);
        } else {
            EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "bios", "joysticktype", (Control)this.joysticktype);
        }
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "serial", "serial1", (Control)this.serial1);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "serial", "serial2", (Control)this.serial2);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "serial", "serial3", (Control)this.serial3);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "serial", "serial4", (Control)this.serial4);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "ipx", "ipx", (Control)this.ipx);
        this.ipxnet.setEnabled(this.ipx.getSelection());
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "render", "autofit", (Control)this.autofit);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sdl", "pixelshader", (Control)this.pixelshader);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "render", "linewise", (Control)this.linewise);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "render", "char9", (Control)this.char9);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "render", "multiscan", (Control)this.multiscan);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "cpu", "cgasnow", (Control)this.cgasnow);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sdl", "overscan", (Control)this.overscan);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "vsync", "vsyncmode", (Control)this.vsyncmode);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "vsync", "vsyncrate", (Control)this.vsyncrate);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "cpu", "forcerate", (Control)this.forcerate);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "dosbox", "vmemsize", (Control)this.videoram);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "glide", "glide", (Control)this.glide);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "glide", "port", "grport", (Control)this.glideport);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "glide", "lfb", (Control)this.lfbGlide);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "glide", "splash", (Control)this.splash3dfx);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "dosbox", "memsizekb", (Control)this.memsizeKB);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "dosbox", "memalias", (Control)this.memalias);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "mixer", "swapstereo", (Control)this.swapstereo);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sblaster", "hardwarebase", (Control)this.hardwareaddresssbbase);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "sblaster", "goldplay", (Control)this.goldplay);
        EditTemplateDialog.setOnOffFieldIfEnabled(sectionsWrapper, "midi", "mt32.reverse.stereo", (Control)this.swapstereoMT32);
        EditTemplateDialog.setOnOffFieldIfEnabled(sectionsWrapper, "midi", "mt32.verbose", (Control)this.loggingMT32);
        EditTemplateDialog.setOnOffFieldIfEnabled(sectionsWrapper, "midi", "mt32.thread", (Control)this.multithreadMT32);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "midi", "mt32.dac", (Control)this.dacMT32);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "midi", "mt32.reverb.mode", (Control)this.reverbmodeMT32);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "midi", "mt32.reverb.time", (Control)this.reverbtimeMT32);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "midi", "mt32.reverb.level", (Control)this.reverblevelMT32);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "midi", "mt32.partials", (Control)this.partialsMT32);
        EditTemplateDialog.setOnOffFieldIfEnabled(sectionsWrapper, "speaker", "ps1audio", (Control)this.ps1);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "speaker", "ps1audiorate", (Control)this.ps1rate);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "innova", "innova", (Control)this.innova);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "innova", "samplerate", (Control)this.innovarate);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "innova", "sidbase", (Control)this.innovabase);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "innova", "quality", (Control)this.innovaquality);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "dos", "int33", (Control)this.int33);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "dos", "biosps2", (Control)this.biosps2);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "keyboard", "aux", (Control)this.aux);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "keyboard", "auxdevice", (Control)this.auxdevice);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "dos", "files", (Control)this.files);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "cpu", "isapnpbios", (Control)this.isapnpbios);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "ide, primary", "enable", (Control)this.ide1);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "ide, secondary", "enable", (Control)this.ide2);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "ide, tertiary", "enable", (Control)this.ide3);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "ide, quaternary", "enable", (Control)this.ide4);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "dos", "automount", (Control)this.automount);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "printer", "printer", (Control)this.printer);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "printer", "dpi", (Control)this.printerdpi);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "printer", "width", (Control)this.printerwidth);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "printer", "height", (Control)this.printerheight);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "printer", "printoutput", (Control)this.printeroutput);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "printer", "multipage", (Control)this.printermultipage);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "printer", "docpath", (Control)this.printerdocpath);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "printer", "timeout", (Control)this.printertimeout);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "parallel", "parallel1", (Control)this.parallel1);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "parallel", "parallel2", (Control)this.parallel2);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "parallel", "parallel3", (Control)this.parallel3);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "parallel", "dongle", (Control)this.dongle);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "ne2000", "ne2000", (Control)this.ne2000);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "ne2000", "nicbase", (Control)this.ne2000base);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "ne2000", "nicirq", (Control)this.ne2000irq);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "ne2000", "macaddr", (Control)this.ne2000macaddress);
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, "ne2000", "realnic", (Control)this.ne2000realnic);
        EditTemplateDialog.setFieldIfEnabled(String.valueOf(conf.getAutoexec().isExit()), Conf.isConflictingValue(conf.getAutoexec().isExit()), (Control)this.exit);
        EditTemplateDialog.setFieldIfEnabled(conf.getAutoexec().getMixer(), Conf.isConflictingValue(conf.getAutoexec().getMixer()), (Control)this.mixer_config);
        EditTemplateDialog.setFieldIfEnabled(conf.getAutoexec().getKeyb(), Conf.isConflictingValue(conf.getAutoexec().getKeyb()), (Control)this.keyb);
        EditTemplateDialog.setFieldIfEnabled(conf.getAutoexec().getIpxnet(), Conf.isConflictingValue(conf.getAutoexec().getIpxnet()), (Control)this.ipxnet);
        for (int i = 0; i < Autoexec.SECTIONS; ++i) {
            EditTemplateDialog.setFieldIfEnabled(StringRelatedUtils.stringToTextArea(conf.getAutoexec().getCustomSection(i), this.customCommands[i].getLineDelimiter(), PlatformUtils.EOLN), Conf.isConflictingValue(conf.getAutoexec().getCustomSection(i)), (Control)this.customCommands[i]);
        }
        if (!this.isMultiEdit()) {
            this.mountingpoints.setItems(conf.getAutoexec().getMountingpoints());
            this.dosExpandItem.setExpanded(!conf.getAutoexec().isBooter());
            this.booterExpandItem.setExpanded(conf.getAutoexec().isBooter());
        }
    }

    protected void updateConfigurationBySettings(Conf conf) {
        boolean bl = !this.isMultiEdit();
        conf.updateValue("sdl", "priority", this.priority_active.getText() + "," + this.priority_inactive.getText(), bl || (Boolean)this.priority_active.getData() != false || (Boolean)this.priority_inactive.getData() != false);
        conf.updateValue("sdl", "waitonerror", String.valueOf(this.waitonerror.getSelection()), bl || (Boolean)this.waitonerror.getData() != false);
        conf.updateValue("dosbox", "language", this.language.getText(), bl || (Boolean)this.language.getData() != false);
        conf.updateValue("sdl", "output", this.output.getText(), bl || (Boolean)this.output.getData() != false);
        conf.updateValue("render", "frameskip", this.frameskip.getText(), bl || (Boolean)this.frameskip.getData() != false);
        conf.updateScalerValue(this.scaler.getText(), this.scaler_forced.getSelection(), bl || (Boolean)this.scaler.getData() != false || (Boolean)this.scaler_forced.getData() != false);
        conf.updateValue("sdl", "fullscreen", String.valueOf(this.fullscreen.getSelection()), bl || (Boolean)this.fullscreen.getData() != false);
        conf.updateValue("sdl", "fulldouble", String.valueOf(this.fulldouble.getSelection()), bl || (Boolean)this.fulldouble.getData() != false);
        conf.updateValue("sdl", "fullresolution", this.fullresolution.getText(), bl || (Boolean)this.fullresolution.getData() != false);
        conf.updateValue("sdl", "windowresolution", this.windowresolution.getText(), bl || (Boolean)this.windowresolution.getData() != false);
        conf.updateValue("render", "aspect", String.valueOf(this.aspect.getSelection()), bl || (Boolean)this.aspect.getData() != false);
        conf.updateValue("dosbox", "machine", this.machine.getText(), bl || (Boolean)this.machine.getData() != false);
        conf.updateValue("cpu", "cputype", this.cpu_type.getText(), bl || (Boolean)this.cpu_type.getData() != false);
        conf.updateValue("cpu", "core", this.core.getText(), bl || (Boolean)this.core.getData() != false);
        conf.updateValue("cpu", "cycles", this.cycles.getText(), bl || (Boolean)this.cycles.getData() != false);
        conf.updateValue("cpu", "cycleup", this.cycles_up.getText(), bl || (Boolean)this.cycles_up.getData() != false);
        conf.updateValue("cpu", "cycledown", this.cycles_down.getText(), bl || (Boolean)this.cycles_down.getData() != false);
        conf.updateValue("dosbox", "memsize", this.memsize.getText(), bl || (Boolean)this.memsize.getData() != false);
        conf.updateValue("dos", "xms", String.valueOf(this.xms.getSelection()), bl || (Boolean)this.xms.getData() != false);
        conf.updateValue("dos", "ems", this.ems.getText(), bl || (Boolean)this.ems.getData() != false);
        conf.updateValue("dos", "umb", this.umb.getText(), bl || (Boolean)this.umb.getData() != false);
        conf.updateValue("mixer", "nosound", String.valueOf(this.nosound.getSelection()), bl || (Boolean)this.nosound.getData() != false);
        conf.updateValue("mixer", "rate", this.rate.getText(), bl || (Boolean)this.rate.getData() != false);
        conf.updateValue("mixer", "blocksize", this.blocksize.getText(), bl || (Boolean)this.blocksize.getData() != false);
        conf.updateValue("mixer", "prebuffer", this.prebuffer.getText(), bl || (Boolean)this.prebuffer.getData() != false);
        conf.updateMidiValue(this.mpu401.getText(), bl || (Boolean)this.mpu401.getData() != false);
        conf.updateValue("midi", "device", "mididevice", this.midi_device.getText(), bl || (Boolean)this.midi_device.getData() != false);
        conf.updateValue("midi", "config", "midiconfig", this.midi_config.getText(), bl || (Boolean)this.midi_config.getData() != false);
        conf.updateValue("sblaster", "type", "sbtype", this.sbtype.getText(), bl || (Boolean)this.sbtype.getData() != false);
        conf.updateValue("sblaster", "oplmode", this.oplmode.getText(), bl || (Boolean)this.oplmode.getData() != false);
        conf.updateValue("sblaster", "oplrate", this.oplrate.getText(), bl || (Boolean)this.oplrate.getData() != false);
        conf.updateValue("sblaster", "oplemu", this.oplemu.getText(), bl || (Boolean)this.oplemu.getData() != false);
        conf.updateValue("sblaster", "base", "sbbase", this.sbbase.getText(), bl || (Boolean)this.sbbase.getData() != false);
        conf.updateValue("sblaster", "irq", this.irq.getText(), bl || (Boolean)this.irq.getData() != false);
        conf.updateValue("sblaster", "dma", this.dma.getText(), bl || (Boolean)this.dma.getData() != false);
        conf.updateValue("sblaster", "hdma", this.hdma.getText(), bl || (Boolean)this.hdma.getData() != false);
        conf.updateValue("sblaster", "mixer", "sbmixer", String.valueOf(this.sbmixer.getSelection()), bl || (Boolean)this.sbmixer.getData() != false);
        conf.updateValue("gus", "gus", String.valueOf(this.gus.getSelection()), bl || (Boolean)this.gus.getData() != false);
        conf.updateValue("gus", "rate", "gusrate", this.gusrate.getText(), bl || (Boolean)this.gusrate.getData() != false);
        conf.updateValue("gus", "base", "gusbase", this.gusbase.getText(), bl || (Boolean)this.gusbase.getData() != false);
        conf.updateValue("gus", "irq1", "gusirq", this.gusirq1.getText(), bl || (Boolean)this.gusirq1.getData() != false);
        conf.updateValue("gus", "irq2", this.gusirq2.getText(), bl || (Boolean)this.gusirq2.getData() != false);
        conf.updateValue("gus", "dma1", "gusdma", this.gusdma1.getText(), bl || (Boolean)this.gusdma1.getData() != false);
        conf.updateValue("gus", "dma2", this.gusdma2.getText(), bl || (Boolean)this.gusdma2.getData() != false);
        conf.updateValue("gus", "ultradir", this.ultradir.getText(), bl || (Boolean)this.ultradir.getData() != false);
        conf.updateValue("speaker", "pcspeaker", String.valueOf(this.pcspeaker.getSelection()), bl || (Boolean)this.pcspeaker.getData() != false);
        conf.updateValue("speaker", "pcrate", this.pcrate.getText(), bl || (Boolean)this.pcrate.getData() != false);
        conf.updateValue("speaker", "tandy", this.tandy.getText(), bl || (Boolean)this.tandy.getData() != false);
        conf.updateValue("speaker", "tandyrate", this.tandyrate.getText(), bl || (Boolean)this.tandyrate.getData() != false);
        conf.updateValue("speaker", "disney", String.valueOf(this.disney.getSelection()), bl || (Boolean)this.disney.getData() != false);
        conf.updateValue("sdl", "autolock", String.valueOf(this.autolock.getSelection()), bl || (Boolean)this.autolock.getData() != false);
        conf.updateValue("sdl", "sensitivity", this.sensitivity.getText(), bl || (Boolean)this.sensitivity.getData() != false);
        conf.updateValue("sdl", "usescancodes", String.valueOf(this.usescancodes.getSelection()), bl || (Boolean)this.usescancodes.getData() != false);
        conf.updateValue("sdl", "mapperfile", this.mapperfile.getText(), bl || (Boolean)this.mapperfile.getData() != false);
        conf.updateValue("dos", "keyboardlayout", this.keyboard_layout.getText(), bl || (Boolean)this.keyboard_layout.getData() != false);
        conf.updateJoystickValue(this.joysticktype.getText(), this.timed.getSelection(), this.autofire.getSelection(), this.swap34.getSelection(), this.buttonwrap.getSelection(), bl || (Boolean)this.joysticktype.getData() != false, bl || (Boolean)this.timed.getData() != false, bl || (Boolean)this.autofire.getData() != false, bl || (Boolean)this.swap34.getData() != false, bl || (Boolean)this.buttonwrap.getData() != false);
        conf.updateValue("serial", "serial1", this.serial1.getText(), bl || (Boolean)this.serial1.getData() != false);
        conf.updateValue("serial", "serial2", this.serial2.getText(), bl || (Boolean)this.serial2.getData() != false);
        conf.updateValue("serial", "serial3", this.serial3.getText(), bl || (Boolean)this.serial3.getData() != false);
        conf.updateValue("serial", "serial4", this.serial4.getText(), bl || (Boolean)this.serial4.getData() != false);
        conf.updateValue("ipx", "ipx", String.valueOf(this.ipx.getSelection()), bl || (Boolean)this.ipx.getData() != false);
        conf.updateValue("render", "autofit", String.valueOf(this.autofit.getSelection()), bl || (Boolean)this.autofit.getData() != false);
        conf.updateValue("sdl", "pixelshader", this.pixelshader.getText(), bl || (Boolean)this.pixelshader.getData() != false);
        conf.updateValue("render", "linewise", String.valueOf(this.linewise.getSelection()), bl || (Boolean)this.linewise.getData() != false);
        conf.updateValue("render", "char9", String.valueOf(this.char9.getSelection()), bl || (Boolean)this.char9.getData() != false);
        conf.updateValue("render", "multiscan", String.valueOf(this.multiscan.getSelection()), bl || (Boolean)this.multiscan.getData() != false);
        conf.updateValue("cpu", "cgasnow", String.valueOf(this.cgasnow.getSelection()), bl || (Boolean)this.cgasnow.getData() != false);
        conf.updateValue("sdl", "overscan", this.overscan.getText(), bl || (Boolean)this.overscan.getData() != false);
        conf.updateValue("vsync", "vsyncmode", this.vsyncmode.getText(), bl || (Boolean)this.vsyncmode.getData() != false);
        conf.updateValue("vsync", "vsyncrate", this.vsyncrate.getText(), bl || (Boolean)this.vsyncrate.getData() != false);
        conf.updateValue("cpu", "forcerate", this.forcerate.getText(), bl || (Boolean)this.forcerate.getData() != false);
        conf.updateValue("dosbox", "vmemsize", this.videoram.getText(), bl || (Boolean)this.videoram.getData() != false);
        conf.updateValue("glide", "glide", this.glide.getText(), bl || (Boolean)this.glide.getData() != false);
        conf.updateValue("glide", "port", "grport", this.glideport.getText(), bl || (Boolean)this.glideport.getData() != false);
        conf.updateValue("glide", "lfb", this.lfbGlide.getText(), bl || (Boolean)this.lfbGlide.getData() != false);
        conf.updateValue("glide", "splash", String.valueOf(this.splash3dfx.getSelection()), bl || (Boolean)this.splash3dfx.getData() != false);
        conf.updateValue("dosbox", "memsizekb", this.memsizeKB.getText(), bl || (Boolean)this.memsizeKB.getData() != false);
        conf.updateValue("dosbox", "memalias", this.memalias.getText(), bl || (Boolean)this.memalias.getData() != false);
        conf.updateValue("mixer", "swapstereo", String.valueOf(this.swapstereo.getSelection()), bl || (Boolean)this.swapstereo.getData() != false);
        conf.updateValue("sblaster", "hardwarebase", this.hardwareaddresssbbase.getText(), bl || (Boolean)this.hardwareaddresssbbase.getData() != false);
        conf.updateValue("sblaster", "goldplay", String.valueOf(this.goldplay.getSelection()), bl || (Boolean)this.goldplay.getData() != false);
        conf.updateValue("midi", "mt32.reverse.stereo", StringRelatedUtils.onOffValue(this.swapstereoMT32.getSelection()), bl || (Boolean)this.swapstereoMT32.getData() != false);
        conf.updateValue("midi", "mt32.verbose", StringRelatedUtils.onOffValue(this.loggingMT32.getSelection()), bl || (Boolean)this.loggingMT32.getData() != false);
        conf.updateValue("midi", "mt32.thread", StringRelatedUtils.onOffValue(this.multithreadMT32.getSelection()), bl || (Boolean)this.multithreadMT32.getData() != false);
        conf.updateValue("midi", "mt32.dac", this.dacMT32.getText(), bl || (Boolean)this.dacMT32.getData() != false);
        conf.updateValue("midi", "mt32.reverb.mode", this.reverbmodeMT32.getText(), bl || (Boolean)this.reverbmodeMT32.getData() != false);
        conf.updateValue("midi", "mt32.reverb.time", this.reverbtimeMT32.getText(), bl || (Boolean)this.reverbtimeMT32.getData() != false);
        conf.updateValue("midi", "mt32.reverb.level", this.reverblevelMT32.getText(), bl || (Boolean)this.reverblevelMT32.getData() != false);
        conf.updateValue("midi", "mt32.partials", this.partialsMT32.getText(), bl || (Boolean)this.partialsMT32.getData() != false);
        conf.updateValue("speaker", "ps1audio", StringRelatedUtils.onOffValue(this.ps1.getSelection()), bl || (Boolean)this.ps1.getData() != false);
        conf.updateValue("speaker", "ps1audiorate", this.ps1rate.getText(), bl || (Boolean)this.ps1rate.getData() != false);
        conf.updateValue("innova", "innova", String.valueOf(this.innova.getSelection()), bl || (Boolean)this.innova.getData() != false);
        conf.updateValue("innova", "samplerate", this.innovarate.getText(), bl || (Boolean)this.innovarate.getData() != false);
        conf.updateValue("innova", "sidbase", this.innovabase.getText(), bl || (Boolean)this.innovabase.getData() != false);
        conf.updateValue("innova", "quality", this.innovaquality.getText(), bl || (Boolean)this.innovaquality.getData() != false);
        conf.updateValue("dos", "int33", String.valueOf(this.int33.getSelection()), bl || (Boolean)this.int33.getData() != false);
        conf.updateValue("dos", "biosps2", String.valueOf(this.biosps2.getSelection()), bl || (Boolean)this.biosps2.getData() != false);
        conf.updateValue("keyboard", "aux", String.valueOf(this.aux.getSelection()), bl || (Boolean)this.aux.getData() != false);
        conf.updateValue("keyboard", "auxdevice", this.auxdevice.getText(), bl || (Boolean)this.auxdevice.getData() != false);
        conf.updateValue("dos", "files", this.files.getText(), bl || (Boolean)this.files.getData() != false);
        conf.updateValue("cpu", "isapnpbios", String.valueOf(this.isapnpbios.getSelection()), bl || (Boolean)this.isapnpbios.getData() != false);
        conf.updateValue("ide, primary", "enable", String.valueOf(this.ide1.getSelection()), bl || (Boolean)this.ide1.getData() != false);
        conf.updateValue("ide, secondary", "enable", String.valueOf(this.ide2.getSelection()), bl || (Boolean)this.ide2.getData() != false);
        conf.updateValue("ide, tertiary", "enable", String.valueOf(this.ide3.getSelection()), bl || (Boolean)this.ide3.getData() != false);
        conf.updateValue("ide, quaternary", "enable", String.valueOf(this.ide4.getSelection()), bl || (Boolean)this.ide4.getData() != false);
        conf.updateValue("dos", "automount", String.valueOf(this.automount.getSelection()), bl || (Boolean)this.automount.getData() != false);
        conf.updateValue("printer", "printer", String.valueOf(this.printer.getSelection()), bl || (Boolean)this.printer.getData() != false);
        conf.updateValue("printer", "dpi", this.printerdpi.getText(), bl || (Boolean)this.printerdpi.getData() != false);
        conf.updateValue("printer", "width", this.printerwidth.getText(), bl || (Boolean)this.printerwidth.getData() != false);
        conf.updateValue("printer", "height", this.printerheight.getText(), bl || (Boolean)this.printerheight.getData() != false);
        conf.updateValue("printer", "printoutput", this.printeroutput.getText(), bl || (Boolean)this.printeroutput.getData() != false);
        conf.updateValue("printer", "multipage", String.valueOf(this.printermultipage.getSelection()), bl || (Boolean)this.printermultipage.getData() != false);
        conf.updateValue("printer", "docpath", this.printerdocpath.getText(), bl || (Boolean)this.printerdocpath.getData() != false);
        conf.updateValue("printer", "timeout", this.printertimeout.getText(), bl || (Boolean)this.printertimeout.getData() != false);
        conf.updateValue("parallel", "parallel1", this.parallel1.getText(), bl || (Boolean)this.parallel1.getData() != false);
        conf.updateValue("parallel", "parallel2", this.parallel2.getText(), bl || (Boolean)this.parallel2.getData() != false);
        conf.updateValue("parallel", "parallel3", this.parallel3.getText(), bl || (Boolean)this.parallel3.getData() != false);
        conf.updateValue("parallel", "dongle", String.valueOf(this.dongle.getSelection()), bl || (Boolean)this.dongle.getData() != false);
        conf.updateValue("ne2000", "ne2000", String.valueOf(this.ne2000.getSelection()), bl || (Boolean)this.ne2000.getData() != false);
        conf.updateValue("ne2000", "nicbase", this.ne2000base.getText(), bl || (Boolean)this.ne2000base.getData() != false);
        conf.updateValue("ne2000", "nicirq", this.ne2000irq.getText(), bl || (Boolean)this.ne2000irq.getData() != false);
        conf.updateValue("ne2000", "macaddr", this.ne2000macaddress.getText(), bl || (Boolean)this.ne2000macaddress.getData() != false);
        conf.updateValue("ne2000", "realnic", this.ne2000realnic.getText(), bl || (Boolean)this.ne2000realnic.getData() != false);
        if (bl) {
            String[] stringArray = new String[this.customCommands.length];
            for (int i = 0; i < this.customCommands.length; ++i) {
                stringArray[i] = StringRelatedUtils.textAreaToString(this.customCommands[i].getText(), this.customCommands[i].getLineDelimiter(), PlatformUtils.EOLN);
            }
            conf.setAutoexecSettingsForTemplate(this.exit.getSelection(), this.mixer_config.getText(), this.keyb.getText(), this.ipx.getSelection() ? this.ipxnet.getText() : "", this.booterExpandItem.getExpanded(), stringArray);
        }
    }

    protected void doAddNativeCommand() {
        EditNativeCommandDialog editNativeCommandDialog = new EditNativeCommandDialog(this.shell);
        NativeCommand nativeCommand = (NativeCommand)editNativeCommandDialog.open();
        if (nativeCommand != null) {
            int n = this.nativeCommands.getSelectionIndex() + 1;
            this.multiProfileList.get(0).getNativeCommandsList().add(n, nativeCommand);
            this.updateNativeCommands(n);
        }
    }

    protected void doEditNativeCommand() {
        NativeCommand nativeCommand;
        int n = this.nativeCommands.getSelectionIndex();
        if (n != -1 && (nativeCommand = this.multiProfileList.get(0).getNativeCommandsList().get(n)).getCommand() != null) {
            EditNativeCommandDialog editNativeCommandDialog = new EditNativeCommandDialog(this.shell);
            editNativeCommandDialog.setCommand(nativeCommand);
            nativeCommand = (NativeCommand)editNativeCommandDialog.open();
            if (nativeCommand != null) {
                this.multiProfileList.get(0).getNativeCommandsList().set(n, nativeCommand);
                this.updateNativeCommands(n);
            }
        }
    }

    protected void doRemoveNativeCommand() {
        NativeCommand nativeCommand;
        int n = this.nativeCommands.getSelectionIndex();
        if (n != -1 && (nativeCommand = this.multiProfileList.get(0).getNativeCommandsList().get(n)).getCommand() != null) {
            this.multiProfileList.get(0).getNativeCommandsList().remove(n);
            this.updateNativeCommands(Math.min(n, this.nativeCommands.getItemCount() - 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Template duplicateTemplate(Template template, List<DosboxVersion> list, Database database, Shell shell) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        try {
            database.startTransaction();
            DosboxVersion dosboxVersion = DosboxVersion.findById(list, template.getDbversionId());
            Conf conf = new Conf(template, dosboxVersion, printStream);
            int n = database.duplicateTemplate(template.getId());
            database.saveNativeCommands(database.readNativeCommandsList(-1, template.getId()), -1, n);
            Template template2 = new Template(n, template);
            conf.injectOrUpdateTemplate(template2);
            conf.save();
            database.commitTransaction();
            if (byteArrayOutputStream.size() > 0) {
                GeneralPurposeDialogs.warningMessage(shell, byteArrayOutputStream.toString());
                byteArrayOutputStream.reset();
            }
            Template template3 = template2;
            return template3;
        }
        catch (Exception exception) {
            GeneralPurposeDialogs.warningMessage(shell, exception);
            try {
                database.rollbackTransaction();
            }
            catch (SQLException sQLException) {
                GeneralPurposeDialogs.warningMessage(shell, sQLException);
            }
            Template template4 = null;
            return template4;
        }
        finally {
            database.finishTransaction();
        }
    }

    protected void doAddMount() {
        EditMountDialog editMountDialog = new EditMountDialog(this.shell);
        try {
            editMountDialog.setDefaultDriveletter(Mount.getFreeDriveletter(this.booterExpandItem.getExpanded(), this.multiProfileList.get(0).getConf().nettoMountedDriveLetters()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = (String)editMountDialog.open();
        if (string != null) {
            this.mountingpoints.setItems(this.multiProfileList.get(0).getConf().addMount(string));
            this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
        }
    }

    protected void doEditMount() {
        int n = this.mountingpoints.getItemCount();
        int n2 = this.mountingpoints.getSelectionIndex();
        if (n2 != -1) {
            EditMountDialog editMountDialog = new EditMountDialog(this.shell);
            editMountDialog.setMount(this.mountingpoints.getItem(n2));
            String string = (String)editMountDialog.open();
            if (string != null) {
                this.mountingpoints.setItems(this.multiProfileList.get(0).getConf().editMount(n2, string));
                if (this.mountingpoints.getItemCount() == n) {
                    this.mountingpoints.select(n2);
                } else {
                    this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
                }
            }
        }
    }

    protected void doRemoveMount() {
        int n = this.mountingpoints.getItemCount();
        int n2 = this.mountingpoints.getSelectionIndex();
        if (n2 == -1 && n == 1) {
            n2 = 0;
            this.mountingpoints.select(n2);
        }
        if (n2 != -1) {
            this.mountingpoints.setItems(this.multiProfileList.get(0).getConf().removeMount(n2));
            if (this.mountingpoints.getItemCount() == n) {
                this.mountingpoints.select(n2);
            } else if (this.mountingpoints.getItemCount() > 0) {
                this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
            }
        }
    }

    protected void updateItems(String[] stringArray, boolean bl, Combo combo) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(combo.getItems()));
        boolean bl2 = false;
        if (bl) {
            for (String string : stringArray) {
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
                bl2 = true;
            }
        } else {
            for (String string : stringArray) {
                if (!arrayList.contains(string)) continue;
                arrayList.remove(string);
                bl2 = true;
            }
        }
        if (bl2) {
            combo.setItems(arrayList.toArray(new String[0]));
        }
    }

    protected void enableSettingsByConfiguration(SectionsWrapper sectionsWrapper) {
        this.setButton.setEnabled(false);
        this.switchButton.setEnabled(false);
        Object[] objectArray = null;
        if (sectionsWrapper != null) {
            objectArray = sectionsWrapper.hasValue("cpu", "cputype") ? this.settings.getSettings().getValues("profile", "machine073") : this.settings.getSettings().getValues("profile", "machine");
            this.updateItems(new String[]{"desktop"}, sectionsWrapper.hasFullResolutionDesktopSupport(), this.fullresolution);
            this.updateItems(new String[]{"openglhq", "direct3d"}, sectionsWrapper.hasOutputDirect3DSupport(), this.output);
            this.updateItems(new String[]{"cga_mono", "svga_s3_full", "amstrad"}, sectionsWrapper.hasAmstradSupport(), this.machine);
            this.updateItems(new String[]{"hardware2x", "hardware3x"}, sectionsWrapper.hasHardwareScalerSupport(), this.scaler);
            this.updateItems(new String[]{"mt32", "synth", "timidity"}, sectionsWrapper.hasMT32Support(), this.midi_device);
            this.updateItems(new String[]{"sb16vibra"}, sectionsWrapper.hasSoundBlaster16VibraSupport(), this.sbtype);
            this.updateItems(new String[]{"hardware", "hardwaregb"}, sectionsWrapper.hasHardwareOPLSupport(), this.oplmode);
            this.updateItems(new String[]{"486", "pentium", "pentium_mmx"}, sectionsWrapper.hasAdditionalCPUTypesSupport(), this.cpu_type);
        } else {
            objectArray = this.settings.getSettings().getCommonValues("profile", "machine073", "machine");
        }
        if (!Arrays.equals(this.machine.getItems(), objectArray)) {
            Object object = this.machine.getData();
            this.machine.setItems((String[])objectArray);
            this.machine.setData(object);
        }
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "cpu", "cputype", (Control)this.cpu_type);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "dos", "umb", (Control)this.umb);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "sdl", "windowresolution", (Control)this.windowresolution);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "sdl", "usescancodes", (Control)this.usescancodes);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "sblaster", "oplemu", (Control)this.oplemu);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "gus", "irq2", (Control)this.gusirq2);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "gus", "dma2", (Control)this.gusdma2);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "speaker", "tandy", (Control)this.tandy);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "bios", "joysticktype", "joystick", "joysticktype", (Control)this.joysticktype);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "joystick", "timed", (Control)this.timed);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "joystick", "autofire", (Control)this.autofire);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "joystick", "swap34", (Control)this.swap34);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "joystick", "buttonwrap", (Control)this.buttonwrap);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "dos", "keyboardlayout", (Control)this.keyboard_layout);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "serial", "serial1", (Control)this.serial1);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "serial", "serial2", (Control)this.serial2);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "serial", "serial3", (Control)this.serial3);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "serial", "serial4", (Control)this.serial4);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "render", "autofit", (Control)this.autofit);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "sdl", "pixelshader", (Control)this.pixelshader);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "render", "linewise", (Control)this.linewise);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "render", "char9", (Control)this.char9);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "render", "multiscan", (Control)this.multiscan);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "cpu", "cgasnow", (Control)this.cgasnow);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "sdl", "overscan", (Control)this.overscan);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "vsync", "vsyncmode", (Control)this.vsyncmode);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "vsync", "vsyncrate", (Control)this.vsyncrate);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "cpu", "forcerate", (Control)this.forcerate);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "dosbox", "vmemsize", (Control)this.videoram);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "glide", "glide", (Control)this.glide);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "glide", "port", "grport", (Control)this.glideport);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "glide", "lfb", (Control)this.lfbGlide);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "glide", "splash", (Control)this.splash3dfx);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "dosbox", "memsizekb", (Control)this.memsizeKB);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "dosbox", "memalias", (Control)this.memalias);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "mixer", "swapstereo", (Control)this.swapstereo);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "sblaster", "hardwarebase", (Control)this.hardwareaddresssbbase);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "sblaster", "goldplay", (Control)this.goldplay);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "midi", "mt32.reverse.stereo", (Control)this.swapstereoMT32);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "midi", "mt32.verbose", (Control)this.loggingMT32);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "midi", "mt32.thread", (Control)this.multithreadMT32);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "midi", "mt32.dac", (Control)this.dacMT32);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "midi", "mt32.reverb.mode", (Control)this.reverbmodeMT32);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "midi", "mt32.reverb.time", (Control)this.reverbtimeMT32);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "midi", "mt32.reverb.level", (Control)this.reverblevelMT32);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "midi", "mt32.partials", (Control)this.partialsMT32);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "speaker", "ps1audio", (Control)this.ps1);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "speaker", "ps1audiorate", (Control)this.ps1rate);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "innova", "innova", (Control)this.innova);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "innova", "samplerate", (Control)this.innovarate);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "innova", "sidbase", (Control)this.innovabase);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "innova", "quality", (Control)this.innovaquality);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "dos", "int33", (Control)this.int33);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "dos", "biosps2", (Control)this.biosps2);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "keyboard", "aux", (Control)this.aux);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "keyboard", "auxdevice", (Control)this.auxdevice);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "dos", "files", (Control)this.files);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "cpu", "isapnpbios", (Control)this.isapnpbios);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "ide, primary", "enable", (Control)this.ide1);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "ide, secondary", "enable", (Control)this.ide2);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "ide, tertiary", "enable", (Control)this.ide3);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "ide, quaternary", "enable", (Control)this.ide4);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "dos", "automount", (Control)this.automount);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "printer", "printer", (Control)this.printer);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "printer", "dpi", (Control)this.printerdpi);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "printer", "width", (Control)this.printerwidth);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "printer", "height", (Control)this.printerheight);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "printer", "printoutput", (Control)this.printeroutput);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "printer", "multipage", (Control)this.printermultipage);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "printer", "docpath", (Control)this.printerdocpath);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "printer", "timeout", (Control)this.printertimeout);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "parallel", "parallel1", (Control)this.parallel1);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "parallel", "parallel2", (Control)this.parallel2);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "parallel", "parallel3", (Control)this.parallel3);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "parallel", "dongle", (Control)this.dongle);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "ne2000", "ne2000", (Control)this.ne2000);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "ne2000", "nicbase", (Control)this.ne2000base);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "ne2000", "nicirq", (Control)this.ne2000irq);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "ne2000", "macaddr", (Control)this.ne2000macaddress);
        EditTemplateDialog.enableDisableControl(sectionsWrapper, "ne2000", "realnic", (Control)this.ne2000realnic);
    }

    protected void doPerformDosboxConfAction(DosboxConfAction dosboxConfAction) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            this.updateConfigurationBySettings(this.multiProfileList.get(0).getConf());
            Conf conf = new Conf(this.dbversionsList.get(this.dbversion.getSelectionIndex()), printStream);
            if (dosboxConfAction == DosboxConfAction.SET) {
                this.multiProfileList.get(0).getConf().setToDosboxVersion(conf);
            } else if (dosboxConfAction == DosboxConfAction.SWITCH) {
                this.multiProfileList.get(0).getConf().switchToDosboxVersion(conf);
            } else if (dosboxConfAction == DosboxConfAction.RELOAD) {
                this.multiProfileList.get(0).getConf().reloadDosboxVersion(conf);
            }
            this.enableSettingsByConfiguration(this.multiProfileList.get(0).getConf().getDosboxSettings());
            this.selectSettingsByConfiguration(this.multiProfileList.get(0).getConf());
            if (byteArrayOutputStream.size() > 0) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), byteArrayOutputStream.toString());
                byteArrayOutputStream.reset();
            }
        }
        catch (IOException iOException) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), iOException);
        }
    }

    protected static void enableDisableControl(SectionsWrapper sectionsWrapper, String string, String string2, String string3, String string4, Control control) {
        control.setEnabled(sectionsWrapper != null && (sectionsWrapper.hasValue(string3, string4) || sectionsWrapper.hasValue(string, string2)));
    }

    protected static void enableDisableControl(SectionsWrapper sectionsWrapper, String string, String string2, String string3, Control control) {
        control.setEnabled(sectionsWrapper != null && (sectionsWrapper.hasValue(string, string3) || sectionsWrapper.hasValue(string, string2)));
    }

    protected static void enableDisableControl(SectionsWrapper sectionsWrapper, String string, String string2, Control control) {
        control.setEnabled(sectionsWrapper != null && sectionsWrapper.hasValue(string, string2));
    }

    protected static void highlight(Control control, int n) {
        Control[] controlArray = control.getParent().getChildren();
        for (int i = 0; i < controlArray.length; ++i) {
            if (controlArray[i] != control) continue;
            if (i > 0) {
                Control control2 = null;
                if (controlArray[i - 1] instanceof Label) {
                    control2 = controlArray[i - 1];
                } else if (i + 1 == controlArray.length - 1) {
                    control2 = controlArray[i + 1];
                } else if (i - 1 > 0 && controlArray[i - 2] instanceof Label) {
                    control2 = controlArray[i - 2];
                }
                if (control2 == null) continue;
                control2.setForeground(control.getDisplay().getSystemColor(n));
                continue;
            }
            EditTemplateDialog.highlight((Control)control.getParent(), n);
        }
    }

    protected static void setFieldIfEnabled(String string, boolean bl, AutoSelectCombo autoSelectCombo) {
        if (bl) {
            EditTemplateDialog.highlight(autoSelectCombo.getControl(), 4);
        } else if (!autoSelectCombo.getText().equals(string)) {
            autoSelectCombo.setText(string);
        }
    }

    protected static void setFieldIfEnabled(String string, boolean bl, Control control) {
        EditTemplateDialog.setFieldIfEnabled(string, bl, control, false);
    }

    protected static void setFieldIfEnabled(String string, boolean bl, Control control, boolean bl2) {
        if (control.isEnabled()) {
            if (control instanceof Text) {
                if (bl) {
                    EditTemplateDialog.highlight(control, 4);
                } else if (!((Text)control).getText().equals(string)) {
                    ((Text)control).setText(string);
                }
            } else if (control instanceof Combo) {
                if (bl) {
                    EditTemplateDialog.highlight(control, 4);
                } else if (!((Combo)control).getText().equals(string)) {
                    ((Combo)control).setText(string);
                }
            } else if (control instanceof Button) {
                if (bl) {
                    ((Button)control).setSelection(true);
                    ((Button)control).setGrayed(true);
                    EditTemplateDialog.highlight(control, 4);
                } else {
                    boolean bl3;
                    boolean bl4 = bl3 = bl2 ? "on".equalsIgnoreCase(string) : Boolean.valueOf(string).booleanValue();
                    if (((Button)control).getSelection() != bl3 || ((Button)control).getGrayed()) {
                        ((Button)control).setSelection(bl3);
                        ((Button)control).notifyListeners(13, new Event());
                    }
                }
            } else if (control instanceof Scale) {
                if (bl) {
                    EditTemplateDialog.highlight(control, 4);
                } else {
                    Integer n = Integer.valueOf(string);
                    if (((Scale)control).getSelection() != n.intValue()) {
                        ((Scale)control).setSelection(n.intValue());
                    }
                }
            } else if (control instanceof Spinner) {
                if (bl) {
                    EditTemplateDialog.highlight(control, 4);
                } else {
                    Integer n = Integer.valueOf(string);
                    if (((Spinner)control).getSelection() != n.intValue()) {
                        ((Spinner)control).setSelection(n.intValue());
                    }
                }
            }
        }
    }

    protected static void setFieldIfEnabled(SectionsWrapper sectionsWrapper, String string, String string2, Control control) {
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper.getValue(string, string2), sectionsWrapper.isConflictingValue(string, string2), control);
    }

    protected static void setOnOffFieldIfEnabled(SectionsWrapper sectionsWrapper, String string, String string2, Control control) {
        EditTemplateDialog.setFieldIfEnabled(sectionsWrapper.getValue(string, string2), sectionsWrapper.isConflictingValue(string, string2), control, true);
    }

    protected static void setFieldIfEnabled(SectionsWrapper sectionsWrapper, String string, String string2, Control control, Control control2) {
        if (sectionsWrapper.isConflictingValue(string, string2)) {
            EditTemplateDialog.setFieldIfEnabled(sectionsWrapper.getValue(string, string2), sectionsWrapper.isConflictingValue(string, string2), control);
            EditTemplateDialog.setFieldIfEnabled(sectionsWrapper.getValue(string, string2), sectionsWrapper.isConflictingValue(string, string2), control2);
        } else {
            String string3 = sectionsWrapper.getValue(string, string2);
            String[] stringArray = string3.split(",");
            if (stringArray != null && stringArray.length >= 2) {
                EditTemplateDialog.setFieldIfEnabled(stringArray[0], false, control);
                EditTemplateDialog.setFieldIfEnabled(stringArray[1], false, control2);
            }
        }
    }

    protected static void setFieldIfEnabled(SectionsWrapper sectionsWrapper, String string, String string2, String string3, Control control) {
        if (sectionsWrapper.hasValue(string, string3)) {
            EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, string, string3, control);
        } else {
            EditTemplateDialog.setFieldIfEnabled(sectionsWrapper, string, string2, control);
        }
    }

    protected boolean isMultiEdit() {
        return this.multiProfileList.size() > 1;
    }

    protected String fetch(Text text) {
        return (Boolean)text.getData() != false ? text.getText() : null;
    }

    protected String fetch(Combo combo) {
        return (Boolean)combo.getData() != false ? combo.getText() : null;
    }

    protected String fetch(AutoSelectCombo autoSelectCombo) {
        return (Boolean)autoSelectCombo.getData() != false ? autoSelectCombo.getText() : null;
    }

    protected Boolean fetch(Button button) {
        return (Boolean)button.getData() != false ? Boolean.valueOf(button.getSelection()) : null;
    }

    protected int fetch(Scale scale) {
        return (Boolean)scale.getData() != false ? scale.getSelection() : -1;
    }

    protected int fetch(Spinner spinner) {
        return (Boolean)spinner.getData() != false ? spinner.getSelection() : -1;
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.title.getText().equals("")) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.template.required.title"), (Control)this.title, this.infoTabItem);
        }
        if (this.setButton.isEnabled()) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.template.required.dosboxassociation"), (Control)this.setButton, this.generalTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    protected static enum DosboxConfAction {
        SET,
        SWITCH,
        RELOAD,
        RELOAD_TEMPLATE;

    }
}

