/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.util.Collections;
import java.util.List;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.model.conf.Settings;
import org.dbgl.model.conf.SharedConf;
import org.dbgl.util.StringRelatedUtils;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public final class LoadSharedConfDialog
extends Dialog {
    private String title;
    private List<SharedConf> confs;
    private SharedConfLoading result;
    private Shell shell;
    private Settings settings;

    public LoadSharedConfDialog(Shell shell, String string, List<SharedConf> list) {
        super(shell, 0);
        this.title = string;
        this.confs = list;
        this.settings = Settings.getInstance();
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        TableColumn tableColumn;
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new GridLayout(2, false));
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "sharedconfbrowser"));
        this.shell.setText(this.settings.msg("dialog.loadsharedconf.title"));
        SashForm sashForm = new SashForm((Composite)this.shell, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        sashForm.setLayout((Layout)new FillLayout());
        final Table table = new Table((Composite)sashForm, 67584);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                int n = table.getSelectionIndex();
                SharedConf sharedConf = (SharedConf)LoadSharedConfDialog.this.confs.get(n);
                TableColumn tableColumn = (TableColumn)event.widget;
                int n2 = (Integer)tableColumn.getData();
                switch (n2) {
                    case 0: {
                        Collections.sort(LoadSharedConfDialog.this.confs, new SharedConf.byTitle());
                        break;
                    }
                    case 1: {
                        Collections.sort(LoadSharedConfDialog.this.confs, new SharedConf.byYear());
                        break;
                    }
                    case 2: {
                        Collections.sort(LoadSharedConfDialog.this.confs, new SharedConf.byVersion());
                        break;
                    }
                }
                table.removeAll();
                LoadSharedConfDialog.this.populate(table);
                table.setSortColumn(tableColumn);
                table.setSortDirection(128);
                for (int i = 0; i < LoadSharedConfDialog.this.confs.size(); ++i) {
                    if (sharedConf != LoadSharedConfDialog.this.confs.get(i)) continue;
                    table.setSelection(i);
                    break;
                }
            }
        };
        String[] stringArray = new String[]{this.settings.msg("dialog.profile.title"), this.settings.msg("dialog.profile.year"), this.settings.msg("dialog.confsharing.gameversion")};
        for (int i = 0; i < stringArray.length; ++i) {
            tableColumn = new TableColumn(table, 0);
            tableColumn.setText(stringArray[i]);
            tableColumn.setData((Object)i);
            tableColumn.addListener(13, listener);
            if (i == 0) {
                table.setSortColumn(tableColumn);
                table.setSortDirection(128);
            }
            Collections.sort(this.confs, new SharedConf.byTitle());
        }
        TabFolder tabFolder = new TabFolder((Composite)sashForm, 0);
        sashForm.setWeights(new int[]{40, 60});
        tableColumn = new TabItem(tabFolder, 0);
        tableColumn.setText(this.settings.msg("dialog.confsharing.tab.info"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        tableColumn.setControl((Control)composite);
        Label label = new Label(composite, 0);
        label.setText(this.settings.msg("dialog.confsharing.author"));
        final Text text = new Text(composite, 2048);
        text.setEditable(false);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label label2 = new Label(composite, 0);
        label2.setText(this.settings.msg("dialog.loadsharedconf.dosboxversion"));
        final Text text2 = new Text(composite, 2048);
        text2.setEditable(false);
        text2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label label3 = new Label(composite, 0);
        label3.setText(this.settings.msg("dialog.confsharing.explanation"));
        final Text text3 = new Text(composite, 2818);
        text3.setLayoutData((Object)new GridData(4, 4, true, true));
        text3.setEditable(false);
        final Text text4 = new Text(composite, 2626);
        text4.setEditable(false);
        text4.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label4 = new Label(composite, 0);
        label4.setText(this.settings.msg("dialog.confsharing.notes"));
        final Text text5 = new Text(composite, 2626);
        text5.setEditable(false);
        text5.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        final Button button = new Button(composite, 32);
        button.setText(this.settings.msg("dialog.loadsharedconf.reloaddefaults"));
        button.setLayoutData((Object)new GridData(16384, 128, false, false, 3, 1));
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LoadSharedConfDialog.this.displaySharedConfData(table, text, text2, text3, text4, text5);
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                LoadSharedConfDialog.this.result = new SharedConfLoading();
                ((LoadSharedConfDialog)LoadSharedConfDialog.this).result.conf = (SharedConf)LoadSharedConfDialog.this.confs.get(table.getSelectionIndex());
                ((LoadSharedConfDialog)LoadSharedConfDialog.this).result.reloadDosboxDefaults = button.getSelection();
                LoadSharedConfDialog.this.shell.close();
            }
        });
        Button button2 = new Button((Composite)this.shell, 0);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LoadSharedConfDialog.this.result = new SharedConfLoading();
                ((LoadSharedConfDialog)LoadSharedConfDialog.this).result.conf = (SharedConf)LoadSharedConfDialog.this.confs.get(table.getSelectionIndex());
                ((LoadSharedConfDialog)LoadSharedConfDialog.this).result.reloadDosboxDefaults = button.getSelection();
                LoadSharedConfDialog.this.shell.close();
            }
        });
        button2.setLayoutData((Object)new GridData(80, -1));
        this.shell.setDefaultButton(button2);
        button2.setText(this.settings.msg("button.ok"));
        Button button3 = new Button((Composite)this.shell, 0);
        button3.setLayoutData((Object)new GridData(80, -1));
        button3.setText(this.settings.msg("button.cancel"));
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LoadSharedConfDialog.this.result = null;
                LoadSharedConfDialog.this.shell.close();
            }
        });
        this.populate(table);
        for (int i = 0; i < stringArray.length; ++i) {
            table.getColumn(i).pack();
        }
        table.setSelection(LoadSharedConfDialog.getEntryBestMatchIndex(this.title, this.confs));
        table.showSelection();
        this.displaySharedConfData(table, text, text2, text3, text4, text5);
    }

    private void populate(Table table) {
        for (SharedConf sharedConf : this.confs) {
            TableItem tableItem = new TableItem(table, 0);
            tableItem.setText(0, sharedConf.getGameTitle());
            tableItem.setText(1, sharedConf.getGameYear());
            tableItem.setText(2, sharedConf.getGameVersion());
        }
    }

    public static int getEntryBestMatchIndex(String string, List<SharedConf> list) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = list.get(i).getGameTitle();
        }
        return StringRelatedUtils.findBestMatchIndex(string, stringArray);
    }

    private void displaySharedConfData(Table table, Text text, Text text2, Text text3, Text text4, Text text5) {
        int n = table.getSelectionIndex();
        if (n != -1) {
            SharedConf sharedConf = this.confs.get(n);
            text.setText(sharedConf.getAuthor());
            text2.setText(sharedConf.getDosboxTitle() + " (" + sharedConf.getDosboxVersion() + ")");
            text3.setText(sharedConf.getIncrConf());
            text4.setText(sharedConf.getExplanation());
            text5.setText(sharedConf.getNotes());
        }
    }

    public final class SharedConfLoading {
        public SharedConf conf;
        public boolean reloadDosboxDefaults;
    }
}

