/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.util.List;
import org.dbgl.interfaces.Configurable;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.Template;
import org.dbgl.model.conf.Conf;
import org.dbgl.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExpTemplate
extends Template
implements Configurable {
    private Conf conf;
    private String importedFullConfig;
    private String importedIncrConfig;
    private List<NativeCommand> nativeCommandsList;

    public ExpTemplate(Conf conf, List<NativeCommand> list) {
        super(-1, null, -1, false);
        this.conf = conf;
        this.nativeCommandsList = list;
    }

    public ExpTemplate(int n, Conf conf, Template template) {
        super(n, template);
        this.conf = conf;
    }

    public ExpTemplate(Element element, int n) {
        super(-1, XmlUtils.getTextValue(element, "title"), n, false);
        this.importedFullConfig = XmlUtils.getTextValue(element, "full-configuration");
        this.importedIncrConfig = XmlUtils.getTextValue(element, "incremental-configuration");
    }

    public void setDbversionId(int n) {
        this.dbversionId = n;
    }

    public String getImportedFullConfig() {
        return this.importedFullConfig;
    }

    public String getImportedIncrConfig() {
        return this.importedIncrConfig;
    }

    @Override
    public Conf getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Conf conf) {
        this.conf = conf;
    }

    public Element getXml(Document document, List<DosboxVersion> list) {
        Element element = document.createElement("template");
        XmlUtils.addCDataElement(document, element, "title", this.getTitle());
        if (this.conf != null) {
            XmlUtils.addCDataElement(document, element, "full-configuration", XmlUtils.cleanEolnForXml(this.conf.toFullConfString(false)));
            XmlUtils.addCDataElement(document, element, "incremental-configuration", XmlUtils.cleanEolnForXml(this.conf.toIncrConfString(false)));
        }
        DosboxVersion dosboxVersion = DosboxVersion.findById(list, this.getDbversionId());
        Element element2 = document.createElement("dosbox");
        XmlUtils.addCDataElement(document, element2, "title", dosboxVersion.getValue());
        XmlUtils.addElement(document, element2, "version", dosboxVersion.getVersion());
        element.appendChild(element2);
        return element;
    }

    @Override
    public List<NativeCommand> getNativeCommandsList() {
        return this.nativeCommandsList;
    }

    @Override
    public void setNativeCommandsList(List<NativeCommand> list) {
        this.nativeCommandsList = list;
    }
}

