/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf;

import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.dbgl.gui.ProfilesList;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.StringRelatedUtils;

public final class Settings
extends Conf {
    private static final String SAMPLE_RATES = "8000 11025 16000 22050 32000 44100 48000 49716";
    private static final String BASE_ADDRS = "220 240 260 280 2a0 2c0 2e0 300";
    private static final String IRQS = "3 5 7 9 10 11 12";
    private static final String DMAS = "0 1 3 5 6 7";
    private static Locale locale;
    private static ResourceBundle mes;
    private static MessageFormat formatter;

    private Settings() {
        super(Settings.defaultSettings(), PlatformUtils.USE_USER_HOME_DIR || !PlatformUtils.isDirectoryWritable(new File(".")) ? new File(PlatformUtils.USER_DATA_DIR_FILE, "settings.conf") : new File("settings.conf"), System.err);
        locale = new Locale(this.getSettings().getValue("locale", "language"), this.getSettings().getValue("locale", "country"), this.getSettings().getValue("locale", "variant"));
        try {
            mes = ResourceBundle.getBundle("plugins/i18n/MessagesBundle", locale);
        }
        catch (MissingResourceException missingResourceException) {
            mes = ResourceBundle.getBundle("i18n/MessagesBundle", locale);
        }
        formatter = new MessageFormat("");
        formatter.setLocale(locale);
    }

    public static Settings getInstance() {
        return SettingsHolder.instance;
    }

    public String msg(String string) {
        try {
            return mes.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "[" + string + "]";
        }
    }

    public String msg(String string, Object[] objectArray) {
        try {
            formatter.applyPattern(this.msg(string));
            return formatter.format(objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return StringRelatedUtils.toString(illegalArgumentException) + "[" + this.msg(string) + "]";
        }
    }

    private static SectionsWrapper defaultSettings() {
        SectionsWrapper sectionsWrapper = new SectionsWrapper();
        sectionsWrapper.setValue("gui", "width", "904");
        sectionsWrapper.setValue("gui", "height", "475");
        sectionsWrapper.setValue("gui", "x", "10");
        sectionsWrapper.setValue("gui", "y", "10");
        sectionsWrapper.setValue("gui", "profiledialog_width", "768");
        sectionsWrapper.setValue("gui", "profiledialog_height", "588");
        sectionsWrapper.setValue("gui", "profileloaderdialog_width", "375");
        sectionsWrapper.setValue("gui", "profileloaderdialog_height", "300");
        sectionsWrapper.setValue("gui", "profiledeletedialog_width", "550");
        sectionsWrapper.setValue("gui", "profiledeletedialog_height", "224");
        sectionsWrapper.setValue("gui", "multiprofiledialog_width", "600");
        sectionsWrapper.setValue("gui", "multiprofiledialog_height", "375");
        sectionsWrapper.setValue("gui", "addgamewizard_width", "500");
        sectionsWrapper.setValue("gui", "addgamewizard_height", "375");
        sectionsWrapper.setValue("gui", "dosboxdialog_width", "600");
        sectionsWrapper.setValue("gui", "dosboxdialog_height", "400");
        sectionsWrapper.setValue("gui", "templatedialog_width", "768");
        sectionsWrapper.setValue("gui", "templatedialog_height", "588");
        sectionsWrapper.setValue("gui", "mountdialog_width", "640");
        sectionsWrapper.setValue("gui", "mountdialog_height", "500");
        sectionsWrapper.setValue("gui", "imgsizedialog_width", "330");
        sectionsWrapper.setValue("gui", "imgsizedialog_height", "260");
        sectionsWrapper.setValue("gui", "archivebrowser_width", "400");
        sectionsWrapper.setValue("gui", "mobygamesbrowser_width", "650");
        sectionsWrapper.setValue("gui", "mobygamesbrowser_height", "375");
        sectionsWrapper.setValue("gui", "mixerdialog_width", "950");
        sectionsWrapper.setValue("gui", "mixerdialog_height", "450");
        sectionsWrapper.setValue("gui", "archivebrowser_height", "375");
        sectionsWrapper.setValue("gui", "dfendimportdialog_width", "600");
        sectionsWrapper.setValue("gui", "dfendimportdialog_height", "375");
        sectionsWrapper.setValue("gui", "exportlistdialog_width", "550");
        sectionsWrapper.setValue("gui", "exportlistdialog_height", "190");
        sectionsWrapper.setValue("gui", "nativecommanddialog_width", "520");
        sectionsWrapper.setValue("gui", "nativecommanddialog_height", "225");
        sectionsWrapper.setValue("gui", "export_width", "550");
        sectionsWrapper.setValue("gui", "export_height", "500");
        sectionsWrapper.setValue("gui", "import_width", "654");
        sectionsWrapper.setValue("gui", "import_height", "500");
        sectionsWrapper.setValue("gui", "migratedialog_width", "600");
        sectionsWrapper.setValue("gui", "migratedialog_height", "375");
        sectionsWrapper.setValue("gui", "settingsdialog_width", "715");
        sectionsWrapper.setValue("gui", "settingsdialog_height", "560");
        sectionsWrapper.setValue("gui", "shareconfdialog_width", "560");
        sectionsWrapper.setValue("gui", "shareconfdialog_height", "540");
        sectionsWrapper.setValue("gui", "sharedconfbrowser_width", "860");
        sectionsWrapper.setValue("gui", "sharedconfbrowser_height", "540");
        sectionsWrapper.setValue("gui", "filterdialog_width", "725");
        sectionsWrapper.setValue("gui", "filterdialog_height", "540");
        sectionsWrapper.setValue("gui", "filtertab", "0");
        sectionsWrapper.setBooleanValue("gui", "maximized", false);
        sectionsWrapper.setValue("gui", "column1width", "150");
        sectionsWrapper.setValue("gui", "column2width", "48");
        sectionsWrapper.setValue("gui", "column3width", "100");
        sectionsWrapper.setValue("gui", "column4width", "100");
        sectionsWrapper.setValue("gui", "column5width", "70");
        sectionsWrapper.setValue("gui", "column6width", "40");
        sectionsWrapper.setValue("gui", "column7width", "60");
        sectionsWrapper.setValue("gui", "column8width", "60");
        sectionsWrapper.setValue("gui", "column9width", "38");
        sectionsWrapper.setValue("gui", "column10width", "40");
        sectionsWrapper.setValue("gui", "column11width", "70");
        sectionsWrapper.setValue("gui", "column12width", "70");
        sectionsWrapper.setValue("gui", "column13width", "70");
        sectionsWrapper.setValue("gui", "column14width", "70");
        sectionsWrapper.setValue("gui", "column15width", "70");
        sectionsWrapper.setValue("gui", "column16width", "70");
        sectionsWrapper.setValue("gui", "column17width", "70");
        sectionsWrapper.setValue("gui", "column18width", "70");
        sectionsWrapper.setValue("gui", "column19width", "44");
        sectionsWrapper.setValue("gui", "column20width", "44");
        sectionsWrapper.setValue("gui", "column21width", "82");
        sectionsWrapper.setValue("gui", "column22width", "70");
        sectionsWrapper.setBooleanValue("gui", "column1visible", true);
        sectionsWrapper.setBooleanValue("gui", "column2visible", true);
        sectionsWrapper.setBooleanValue("gui", "column3visible", true);
        sectionsWrapper.setBooleanValue("gui", "column4visible", true);
        sectionsWrapper.setBooleanValue("gui", "column5visible", true);
        sectionsWrapper.setBooleanValue("gui", "column6visible", true);
        sectionsWrapper.setBooleanValue("gui", "column7visible", true);
        sectionsWrapper.setBooleanValue("gui", "column8visible", true);
        sectionsWrapper.setBooleanValue("gui", "column9visible", true);
        sectionsWrapper.setBooleanValue("gui", "column10visible", false);
        sectionsWrapper.setBooleanValue("gui", "column11visible", false);
        sectionsWrapper.setBooleanValue("gui", "column12visible", false);
        sectionsWrapper.setBooleanValue("gui", "column13visible", false);
        sectionsWrapper.setBooleanValue("gui", "column14visible", false);
        sectionsWrapper.setBooleanValue("gui", "column15visible", false);
        sectionsWrapper.setBooleanValue("gui", "column16visible", false);
        sectionsWrapper.setBooleanValue("gui", "column17visible", false);
        sectionsWrapper.setBooleanValue("gui", "column18visible", false);
        sectionsWrapper.setBooleanValue("gui", "column19visible", false);
        sectionsWrapper.setBooleanValue("gui", "column20visible", false);
        sectionsWrapper.setBooleanValue("gui", "column21visible", false);
        sectionsWrapper.setBooleanValue("gui", "column22visible", false);
        sectionsWrapper.setValue("gui", "column2_1width", "300");
        sectionsWrapper.setValue("gui", "column2_2width", "250");
        sectionsWrapper.setValue("gui", "column2_3width", "150");
        sectionsWrapper.setValue("gui", "column2_4width", "68");
        sectionsWrapper.setValue("gui", "column3_1width", "500");
        sectionsWrapper.setValue("gui", "column3_2width", "50");
        sectionsWrapper.setValue("gui", "column3_3width", "68");
        sectionsWrapper.setValue("gui", "sortcolumn", "0 8");
        sectionsWrapper.setValue("gui", "sortascending", "true true");
        sectionsWrapper.setValue("gui", "columnorder", "0 1 2 3 4 5 6 7 8");
        sectionsWrapper.setValue("gui", "sashweights", "777 222");
        sectionsWrapper.setValue("gui", "screenshotsheight", "100");
        sectionsWrapper.setValue("gui", "screenshotscolumnheight", "50");
        sectionsWrapper.setBooleanValue("gui", "screenshotscolumnstretch", false);
        sectionsWrapper.setBooleanValue("gui", "screenshotscolumnkeepaspectratio", false);
        sectionsWrapper.setBooleanValue("gui", "screenshotsvisible", true);
        sectionsWrapper.setBooleanValue("gui", "autosortonupdate", false);
        sectionsWrapper.setBooleanValue("gui", "screenshotsfilename", true);
        sectionsWrapper.setIntValue("gui", "buttondisplay", 0);
        sectionsWrapper.setValue("gui", "custom1", "Custom1");
        sectionsWrapper.setValue("gui", "custom2", "Custom2");
        sectionsWrapper.setValue("gui", "custom3", "Custom3");
        sectionsWrapper.setValue("gui", "custom4", "Custom4");
        sectionsWrapper.setValue("gui", "custom5", "Custom5");
        sectionsWrapper.setValue("gui", "custom6", "Custom6");
        sectionsWrapper.setValue("gui", "custom7", "Custom7");
        sectionsWrapper.setValue("gui", "custom8", "Custom8");
        sectionsWrapper.setValue("gui", "custom9", "Custom9");
        sectionsWrapper.setValue("gui", "custom10", "Custom10");
        sectionsWrapper.setValue("gui", "searchengine", "mobygames");
        sectionsWrapper.setValue("gui", "notesfont", "Courier 10 0");
        sectionsWrapper.setBooleanValue("gui", "notesvisible", true);
        sectionsWrapper.setValue("gui", "viewstyle", ProfilesList.ProfilesListType.TABLE.toString().toLowerCase());
        sectionsWrapper.setIntValue("gui", "small_tile_width", 100);
        sectionsWrapper.setIntValue("gui", "small_tile_height", 82);
        sectionsWrapper.setIntValue("gui", "medium_tile_width", 132);
        sectionsWrapper.setIntValue("gui", "medium_tile_height", 102);
        sectionsWrapper.setIntValue("gui", "large_tile_width", 164);
        sectionsWrapper.setIntValue("gui", "large_tile_height", 122);
        sectionsWrapper.setIntValue("gui", "small_box_width", 75);
        sectionsWrapper.setIntValue("gui", "small_box_height", 100);
        sectionsWrapper.setIntValue("gui", "medium_box_width", 120);
        sectionsWrapper.setIntValue("gui", "medium_box_height", 150);
        sectionsWrapper.setIntValue("gui", "large_box_width", 150);
        sectionsWrapper.setIntValue("gui", "large_box_height", 200);
        sectionsWrapper.setValue("gui", "tile_title_trunc_pos", "end");
        sectionsWrapper.setValue("gui", "gallerybackgroundcolor", "-1");
        sectionsWrapper.setIntValue("profiledefaults", "confpath", 0);
        sectionsWrapper.setIntValue("profiledefaults", "conffile", 0);
        sectionsWrapper.setBooleanValue("dosbox", "hideconsole", false);
        sectionsWrapper.setBooleanValue("communication", "port_enabled", PlatformUtils.IS_WINDOWS);
        sectionsWrapper.setValue("communication", "port", "4740");
        sectionsWrapper.setValue("database", "connectionstring", "jdbc:hsqldb:file:./db/database");
        sectionsWrapper.setValue("database", "username", "sa");
        sectionsWrapper.setValue("database", "pasword", "");
        sectionsWrapper.setValue("directory", "data", ".");
        sectionsWrapper.setValue("directory", "dosbox", ".");
        sectionsWrapper.setValue("directory", "tmpinstall", "TMP_INST");
        sectionsWrapper.setValue("directory", "orgimages", "ORGIMAGE");
        sectionsWrapper.setValue("locale", "language", "en");
        sectionsWrapper.setValue("locale", "country", "");
        sectionsWrapper.setValue("locale", "variant", "");
        sectionsWrapper.setValue("mobygames", "platform_filter", "dos pc<space>booter");
        sectionsWrapper.setBooleanValue("mobygames", "set_title", true);
        sectionsWrapper.setBooleanValue("mobygames", "set_developer", true);
        sectionsWrapper.setBooleanValue("mobygames", "set_publisher", true);
        sectionsWrapper.setBooleanValue("mobygames", "set_year", true);
        sectionsWrapper.setBooleanValue("mobygames", "set_genre", true);
        sectionsWrapper.setBooleanValue("mobygames", "set_link", true);
        sectionsWrapper.setBooleanValue("mobygames", "set_description", true);
        sectionsWrapper.setBooleanValue("mobygames", "set_rank", true);
        sectionsWrapper.setBooleanValue("mobygames", "choose_coverart", false);
        sectionsWrapper.setBooleanValue("mobygames", "choose_screenshot", false);
        sectionsWrapper.setBooleanValue("mobygames", "force_all_regions_coverart", false);
        sectionsWrapper.setIntValue("mobygames", "multi_max_coverart", 0);
        sectionsWrapper.setIntValue("mobygames", "multi_max_screenshot", 0);
        sectionsWrapper.setIntValue("mobygames", "image_width", 128);
        sectionsWrapper.setIntValue("mobygames", "image_height", 80);
        sectionsWrapper.setIntValue("mobygames", "image_columns", 2);
        sectionsWrapper.setValue("pouet", "platform_filter", "ms-dos ms-dos/gus");
        sectionsWrapper.setBooleanValue("pouet", "set_title", true);
        sectionsWrapper.setBooleanValue("pouet", "set_developer", true);
        sectionsWrapper.setBooleanValue("pouet", "set_year", true);
        sectionsWrapper.setBooleanValue("pouet", "set_genre", true);
        sectionsWrapper.setBooleanValue("pouet", "set_link", true);
        sectionsWrapper.setBooleanValue("pouet", "set_rank", true);
        sectionsWrapper.setBooleanValue("pouet", "choose_coverart", false);
        sectionsWrapper.setBooleanValue("pouet", "choose_screenshot", false);
        sectionsWrapper.setIntValue("pouet", "multi_max_coverart", 0);
        sectionsWrapper.setIntValue("pouet", "multi_max_screenshot", 0);
        sectionsWrapper.setValue("hotud", "platform_filter", "dos");
        sectionsWrapper.setBooleanValue("hotud", "set_title", true);
        sectionsWrapper.setBooleanValue("hotud", "set_developer", true);
        sectionsWrapper.setBooleanValue("hotud", "set_publisher", true);
        sectionsWrapper.setBooleanValue("hotud", "set_year", true);
        sectionsWrapper.setBooleanValue("hotud", "set_genre", true);
        sectionsWrapper.setBooleanValue("hotud", "set_link", true);
        sectionsWrapper.setBooleanValue("hotud", "set_description", true);
        sectionsWrapper.setBooleanValue("hotud", "set_rank", true);
        sectionsWrapper.setValue("thegamesdb", "platform_filter", "pc");
        sectionsWrapper.setBooleanValue("thegamesdb", "set_title", true);
        sectionsWrapper.setBooleanValue("thegamesdb", "set_developer", true);
        sectionsWrapper.setBooleanValue("thegamesdb", "set_publisher", true);
        sectionsWrapper.setBooleanValue("thegamesdb", "set_year", true);
        sectionsWrapper.setBooleanValue("thegamesdb", "set_genre", true);
        sectionsWrapper.setBooleanValue("thegamesdb", "set_link", true);
        sectionsWrapper.setBooleanValue("thegamesdb", "set_description", true);
        sectionsWrapper.setBooleanValue("thegamesdb", "set_rank", true);
        sectionsWrapper.setBooleanValue("thegamesdb", "choose_coverart", false);
        sectionsWrapper.setBooleanValue("thegamesdb", "choose_screenshot", false);
        sectionsWrapper.setIntValue("thegamesdb", "multi_max_coverart", 0);
        sectionsWrapper.setIntValue("thegamesdb", "multi_max_screenshot", 0);
        sectionsWrapper.setBooleanValue("environment", "use", false);
        sectionsWrapper.setValue("environment", "value", "");
        sectionsWrapper.setValue("profile", "priority_active", "lowest lower normal higher highest");
        sectionsWrapper.setValue("profile", "priority_inactive", "lowest lower normal higher highest pause");
        sectionsWrapper.setValue("profile", "output", "ddraw overlay opengl openglnb surface");
        sectionsWrapper.setValue("profile", "frameskip", "0 1 2 3 4 5 6 7 8 9 10");
        sectionsWrapper.setValue("profile", "scaler", "none normal2x normal3x advmame2x advmame3x advinterp2x advinterp3x hq2x hq3x 2xsai super2xsai supereagle tv2x tv3x rgb2x rgb3x scan2x scan3x");
        sectionsWrapper.setValue("profile", "fullresolution", "original 0x0 320x200 640x480 800x600 1024x768 1280x768 1280x960 1280x1024");
        sectionsWrapper.setValue("profile", "windowresolution", "original 320x200 640x480 800x600 1024x768 1280x768 1280x960 1280x1024");
        sectionsWrapper.setValue("profile", "machine", "cga hercules pcjr tandy vga");
        sectionsWrapper.setValue("profile", "machine073", "cga hercules pcjr tandy ega vgaonly svga_s3 svga_et3000 svga_et4000 svga_paradise vesa_nolfb vesa_oldvbe");
        sectionsWrapper.setValue("profile", "cputype", "auto 386 386_slow 486_slow pentium_slow 386_prefetch");
        sectionsWrapper.setValue("profile", "core", "dynamic full normal simple auto");
        sectionsWrapper.setValue("profile", "cycles", "350 500 750 1000 2000 3000 4000 5000 7500 10000 12500 15000 17500 20000 25000 30000 32500 35000 40000 45000 50000 55000 60000 auto max<space>50% max<space>80% max<space>90% max");
        sectionsWrapper.setValue("profile", "cycles_up", "10 20 50 100 500 1000 2000 5000 10000");
        sectionsWrapper.setValue("profile", "cycles_down", "10 20 50 100 500 1000 2000 5000 10000");
        sectionsWrapper.setValue("profile", "memsize", "0 1 2 4 8 16 32 63");
        sectionsWrapper.setValue("profile", "ems", "false true");
        sectionsWrapper.setValue("profile", "umb", "false true max");
        sectionsWrapper.setValue("profile", "loadfix_value", "1 63 64 127");
        sectionsWrapper.setValue("profile", "rate", SAMPLE_RATES);
        sectionsWrapper.setValue("profile", "blocksize", "256 512 1024 2048 4096 8192");
        sectionsWrapper.setValue("profile", "prebuffer", "10");
        sectionsWrapper.setValue("profile", "mpu401", "none intelligent uart");
        sectionsWrapper.setValue("profile", "device", "alsa default coreaudio coremidi none oss win32");
        sectionsWrapper.setValue("profile", "sbtype", "none gb sb1 sb2 sbpro1 sbpro2 sb16");
        sectionsWrapper.setValue("profile", "oplrate", SAMPLE_RATES);
        sectionsWrapper.setValue("profile", "oplmode", "auto cms opl2 dualopl2 opl3");
        sectionsWrapper.setValue("profile", "oplemu", "default compat fast");
        sectionsWrapper.setValue("profile", "sbbase", BASE_ADDRS);
        sectionsWrapper.setValue("profile", "irq", IRQS);
        sectionsWrapper.setValue("profile", "dma", DMAS);
        sectionsWrapper.setValue("profile", "hdma", DMAS);
        sectionsWrapper.setValue("profile", "gusrate", SAMPLE_RATES);
        sectionsWrapper.setValue("profile", "gusbase", BASE_ADDRS);
        sectionsWrapper.setValue("profile", "irq1", IRQS);
        sectionsWrapper.setValue("profile", "irq2", IRQS);
        sectionsWrapper.setValue("profile", "dma1", DMAS);
        sectionsWrapper.setValue("profile", "dma2", DMAS);
        sectionsWrapper.setValue("profile", "pcrate", SAMPLE_RATES);
        sectionsWrapper.setValue("profile", "tandy", "auto off on");
        sectionsWrapper.setValue("profile", "tandyrate", SAMPLE_RATES);
        sectionsWrapper.setValue("profile", "sensitivity", "10 20 30 40 50 60 70 80 90 100 125 150 175 200 250 300 350 400 450 500 550 600 700 800 900 1000");
        sectionsWrapper.setValue("profile", "joysticktype", "auto none 2axis 4axis 4axis_2 ch fcs");
        sectionsWrapper.setValue("profile", "mount_type", "cdrom dir floppy");
        sectionsWrapper.setValue("profile", "imgmount_type", "iso floppy hdd");
        sectionsWrapper.setValue("profile", "imgmount_fs", "iso fat none");
        sectionsWrapper.setValue("profile", "zipmount_type", "cdrom dir floppy");
        sectionsWrapper.setValue("profile", "freesize", "1 10 100 200 500 1000");
        sectionsWrapper.setValue("profile", "lowlevelcd_type", "aspi ioctl ioctl_dx ioctl_dio ioctl_mci noioctl");
        sectionsWrapper.setValue("profile", "keyboardlayout", "auto none ba234 be120 bg241 bg442 bl463 br274 br275 by463 ca58 ca445 cf58 cf445 cf501 cz243 de129 de453 dk159 dv103 ee454 el220 el319 el459 es172 es173 et454 fi153 fo fr120 fr189 gk220 gk319 gk459 gr129 gr453 hr234 hu208 is161 is197 is458 it141 it142 la171 lt210 lt211 lt212 lt221 lt456 lh103 mk449 ml47 mt47 nl143 no155 ph pl214 pl457 po163 rh103 ro333 ro446 ru441 ru443 sd150 sf150 sg150 si234 sk245 sp172 sp173 sq448 sq452 sr118 sr450 su153 sv153 tm tr179 tr440 ua465 uk166 uk168 ur465 us103 ux103 yc118 yc450 yu234");
        sectionsWrapper.setValue("profile", "pixelshader", "none 2xSaI.fx 2xSaI_sRGB.fx 2xSaL.fx 2xSaL_Ls.fx 2xSaL2xAA.fx 2xSaLAA.fx 4xSaL.fx 4xSoft.fx 4xSoft_PS3.0.fx AdvancedAA.fx bilinear.fx Cartoon.fx ColorSketch.fx CRT.D3D.fx CRT.D3D.br.fx CRT-simple.D3D.fx CRT-simple.D3D.br.fx DotnBloom.D3D.fx GS2x.fx GS2xFilter.fx Gs2xLS.fx Gs2xSmartFilter.fx GS2xSuper.fx GS2xTwo.fx GS4x.fx GS4xColorScale.fx GS4xFilter.fx GS4xHqFilter.fx GS4xScale.fx GS4xSoft.fx HQ2x.fx Lanczos.fx Lanczos12.fx Lanczos16.fx Matrix.fx MCAmber.fx MCGreen.fx MCHerc.fx MCOrange.fx none.fx point.fx scale2x.fx scale2x_ps14.fx Scale2xPlus.fx Scale4x.fx SimpleAA.fx Sketch.fx Super2xSaI.fx SuperEagle.fx Tv.fx");
        sectionsWrapper.setValue("profile", "overscan", "1 2 3 4 5 6 7 8 9 10");
        sectionsWrapper.setValue("profile", "vsyncmode", "off on force host");
        sectionsWrapper.setValue("profile", "lfbglide", "full read write none");
        sectionsWrapper.setValue("profile", "vmemsize", "0 1 2 4 8");
        sectionsWrapper.setValue("profile", "glide", "false true emu");
        sectionsWrapper.setValue("profile", "memalias", "0 24 26");
        sectionsWrapper.setValue("profile", "hardwaresbbase", "210 220 230 240 250 260 280");
        sectionsWrapper.setValue("profile", "mt32dac", "0 1 2 3 auto");
        sectionsWrapper.setValue("profile", "mt32reverbmode", "0 1 2 3 auto");
        sectionsWrapper.setValue("profile", "mt32reverbtime", "0 1 2 3 4 5 6 7");
        sectionsWrapper.setValue("profile", "mt32reverblevel", "0 1 2 3 4 5 6 7");
        sectionsWrapper.setValue("profile", "ps1rate", SAMPLE_RATES);
        sectionsWrapper.setValue("profile", "innovarate", SAMPLE_RATES);
        sectionsWrapper.setValue("profile", "innovabase", BASE_ADDRS);
        sectionsWrapper.setValue("profile", "innovaquality", "0 1 2 3");
        sectionsWrapper.setValue("profile", "auxdevice", "none 2button 3button intellimouse intellimouse45");
        sectionsWrapper.setValue("profile", "printeroutput", "png ps bmp printer");
        sectionsWrapper.setBooleanValue("addgamewizard", "requiresinstallation", false);
        sectionsWrapper.setBooleanValue("addgamewizard", "consultsearchengine", true);
        sectionsWrapper.setBooleanValue("addgamewizard", "consultdbconfws", true);
        sectionsWrapper.setValue("confsharing", "endpoint", "http://www.squadrablu.nl:8080/DBConfWS/apiv1/");
        return sectionsWrapper;
    }

    private static class SettingsHolder {
        private static Settings instance = new Settings();

        private SettingsHolder() {
        }
    }
}

