/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import SevenZip.Archive.IArchiveExtractCallback;
import SevenZip.Archive.IInArchive;
import SevenZip.Archive.SevenZip.Handler;
import SevenZip.IInStream;
import SevenZip.MyRandomAccessFile;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.KeyValuePair;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Conf;
import org.dbgl.util.DFendImportThread;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.ProgressNotifyable;
import org.dbgl.util.SevenzipExtractFilesCallback;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.UIThread;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public final class ImportThread
extends UIThread {
    private boolean importCaptures;
    private boolean importMapperfiles;
    private boolean importNativecommands;
    private boolean importGameData;
    private boolean importFullSettings;
    private boolean customValues;
    private String[] customFields;
    private boolean useExistingConf;
    private File zipfile;
    private boolean sevenzip;
    private int[] entryIdsToBeExtracted;
    private Map<Integer, File> sevenzipDstFileMap = new TreeMap<Integer, File>();
    private IInArchive zArchive;

    public ImportThread(Text text, ProgressBar progressBar, Label label, List<ExpProfile> list, File file, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, String[] stringArray) throws IOException, SQLException {
        super(text, progressBar, label);
        this.zipfile = file;
        this.importCaptures = bl;
        this.importMapperfiles = bl2;
        this.importNativecommands = bl3;
        this.useExistingConf = bl4;
        this.importGameData = bl5;
        this.importFullSettings = bl6;
        this.customValues = bl7;
        this.customFields = stringArray != null ? (String[])stringArray.clone() : null;
        this.sevenzip = file.getPath().toLowerCase().endsWith(FileUtils.ARCHIVES[1]);
        long l = 0L;
        if (this.sevenzip) {
            MyRandomAccessFile myRandomAccessFile = new MyRandomAccessFile(file.getPath(), "r");
            this.zArchive = new Handler();
            if (this.zArchive.Open((IInStream)myRandomAccessFile) != 0) {
                throw new IOException(this.settings.msg("general.error.opensevenzip", new Object[]{file.getPath()}));
            }
            for (int i = 0; i < this.zArchive.size(); ++i) {
                l += this.zArchive.getEntry(i).getSize();
            }
        } else {
            for (ExpProfile expProfile : list) {
                if (this.importCaptures) {
                    l += FileUtils.extractZipSizeInBytes(file, new File(expProfile.getCaptures()));
                }
                if (this.importMapperfiles && expProfile.getMapperfile() != null) {
                    l += FileUtils.extractZipEntrySizeInBytes(file, PlatformUtils.toArchivePath(expProfile.getMapperfile()));
                }
                if (!this.importGameData) continue;
                l += FileUtils.extractZipSizeInBytes(file, new File(FileUtils.DOSROOT_DIR, new File(String.valueOf(expProfile.getImportedId()), expProfile.getGameDir().getPath()).getPath()));
            }
        }
        this.objects = list;
        this.setTotal((int)(l / 1024L));
        this.extensiveLogging = true;
    }

    @Override
    public void doFancyStuff(Object object, StringBuffer stringBuffer) throws IOException, SQLException {
        int n;
        ExpProfile expProfile = (ExpProfile)object;
        this.displayTitle(this.settings.msg("dialog.import.importing", new Object[]{expProfile.getTitle()}));
        int n2 = KeyValuePair.findIdByValue(this.dbase.readDevelopersList(), expProfile.getDeveloperName());
        int n3 = KeyValuePair.findIdByValue(this.dbase.readPublishersList(), expProfile.getPublisherName());
        int n4 = KeyValuePair.findIdByValue(this.dbase.readGenresList(), expProfile.getGenre());
        int n5 = KeyValuePair.findIdByValue(this.dbase.readYearsList(), expProfile.getYear());
        int n6 = KeyValuePair.findIdByValue(this.dbase.readStatusList(), expProfile.getStatus());
        String[] stringArray = DFendImportThread.CUST_STRINGS;
        int[] nArray = DFendImportThread.CUST_INTS;
        int[] nArray2 = DFendImportThread.CUST_IDS;
        if (this.customValues) {
            stringArray = expProfile.getCustomStrings();
            nArray = expProfile.getCustomInts();
            for (n = 0; n < 4; ++n) {
                nArray2[n] = KeyValuePair.findIdByValue(this.dbase.readCustomList(n), expProfile.getCustomString(n));
            }
        }
        n = this.dbase.addOrEditProfile(expProfile.getTitle(), expProfile.getDeveloperName(), expProfile.getPublisherName(), expProfile.getGenre(), expProfile.getYear(), expProfile.getStatus(), expProfile.getNotes(), expProfile.isDefault(), expProfile.getSetup(), expProfile.getSetupParameters(), n2, n3, n4, n5, n6, expProfile.getDbversionId(), expProfile.getLinks(), expProfile.getLinkTitles(), stringArray, nArray, nArray2, -1);
        String string = FileUtils.constructCapturesDir(n);
        File file = new File(expProfile.getCaptures());
        File file2 = FileUtils.canonicalToData(string);
        if (!file2.exists()) {
            FileUtils.createDir(file2);
            stringBuffer.append("  + ").append(this.settings.msg("dialog.import.notice.createddir", new Object[]{file2})).append('\n');
            if (this.importCaptures) {
                if (this.sevenzip) {
                    for (Object object2 : (File)FileUtils.findRelatedEntryIds(this.zArchive, file)) {
                        this.sevenzipDstFileMap.put((int)object2, FileUtils.determineDstSevenzipFile(file, file2, this.zArchive.getEntry((int)object2).getName()));
                    }
                } else {
                    try {
                        FileUtils.extractZip(this.zipfile, file, file2, (ProgressNotifyable)this);
                        stringBuffer.append("  + ").append(this.settings.msg("dialog.import.notice.extractedcaptures", new Object[]{file2})).append('\n');
                    }
                    catch (IOException iOException) {
                        stringBuffer.append("  - ").append(this.settings.msg("dialog.import.error.capturesextraction", new Object[]{StringRelatedUtils.toString(iOException)})).append('\n');
                    }
                }
            }
        } else {
            stringBuffer.append("  - ").append(this.settings.msg("dialog.import.error.capturesdirexists", new Object[]{file2})).append('\n');
        }
        File file3 = expProfile.getGameDir();
        File file4 = new File(FileUtils.DOSROOT_DIR, new File(String.valueOf(expProfile.getImportedId()), file3.getPath()).getPath());
        File file5 = FileUtils.canonicalToDosroot(new File(expProfile.getBaseDir(), expProfile.getGameDir().getPath()).getPath());
        if (this.importGameData && !file5.exists()) {
            FileUtils.createDir(file5);
            stringBuffer.append("  + ").append(this.settings.msg("dialog.import.notice.createddir", new Object[]{file5})).append('\n');
            if (this.sevenzip) {
                for (int n7 : FileUtils.findRelatedEntryIds(this.zArchive, file4)) {
                    this.sevenzipDstFileMap.put(n7, FileUtils.determineDstSevenzipFile(file4, file5, this.zArchive.getEntry(n7).getName()));
                }
            } else {
                try {
                    FileUtils.extractZip(this.zipfile, file4, file5, (ProgressNotifyable)this);
                    stringBuffer.append("  + ").append(this.settings.msg("dialog.import.notice.extractedgamedata", new Object[]{file5})).append('\n');
                }
                catch (IOException iOException) {
                    throw new IOException(this.settings.msg("dialog.import.error.gamedataextraction", new Object[]{StringRelatedUtils.toString(iOException)}), iOException);
                }
            }
        }
        DosboxVersion dosboxVersion = (DosboxVersion)DosboxVersion.findById(this.dbversions, expProfile.getDbversionId());
        String string2 = null;
        if (this.useExistingConf && FileUtils.areRelated(new File(FileUtils.getDosRoot()), expProfile.getCanonicalConfFile()) && FileUtils.isExistingFile(expProfile.getCanonicalConfFile())) {
            string2 = expProfile.getCanonicalConfFile().getPath();
            stringBuffer.append("  + ").append(this.settings.msg("dialog.import.notice.usingexistingconf", new Object[]{expProfile.getCanonicalConfFile()})).append('\n');
        } else {
            Conf conf = new Conf(expProfile.getImportedFullConfig(), expProfile.getImportedIncrConfig(), this.importFullSettings, this.zipfile.getPath(), expProfile, n, dosboxVersion, this.ps);
            string2 = FileUtils.makeRelativeToData(conf.getConfFile()).getPath();
            Profile profile = new Profile(n, string2, string, expProfile);
            if (!profile.getCanonicalConfFile().getParentFile().exists()) {
                FileUtils.createDir(profile.getCanonicalConfFile().getParentFile());
                stringBuffer.append("  + ").append(this.settings.msg("dialog.import.notice.createddir", new Object[]{profile.getCanonicalConfFile().getParentFile()})).append('\n');
            }
            String string3 = FileUtils.constructRelativeCapturesDir(n, profile.getCanonicalConfFile().getParentFile(), conf.getSettings().detectDosboxVersionGeneration());
            conf.getSettings().setValue("dosbox", "captures", string3);
            String string4 = expProfile.getMapperfile();
            if (this.importMapperfiles && string4 != null) {
                File file6 = new File(StringUtils.replace((String)profile.getCanonicalConfFile().getPath(), (String)".conf", (String)".map"));
                conf.getSettings().setValue("sdl", "mapperfile", file6.getName());
                if (this.sevenzip) {
                    int n8 = FileUtils.findEntryId(this.zArchive, PlatformUtils.toArchivePath(string4));
                    if (n8 != -1) {
                        this.sevenzipDstFileMap.put(n8, file6);
                    }
                } else {
                    try {
                        FileUtils.extractZip(this.zipfile, PlatformUtils.toArchivePath(string4), file6, (ProgressNotifyable)this);
                        stringBuffer.append("  + ").append(this.settings.msg("dialog.import.notice.extractedmapperfile", new Object[]{file6})).append('\n');
                    }
                    catch (IOException iOException) {
                        stringBuffer.append("  - ").append(this.settings.msg("dialog.import.error.mapperfileextraction", new Object[]{StringRelatedUtils.toString(iOException)})).append('\n');
                    }
                }
            }
            conf.save();
            stringBuffer.append("  + ").append(this.settings.msg("dialog.import.notice.createdconf", new Object[]{profile.getCanonicalConfFile()})).append('\n');
        }
        this.dbase.updateProfileConf(string2, string, n);
        String[] stringArray2 = expProfile.getSetup();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].length() <= 0) continue;
            stringArray2[i] = FileUtils.prefixAndSanitizeToDosroot(expProfile.getBaseDir(), new File(stringArray2[i])).getPath();
        }
        String[] stringArray3 = expProfile.getLinks();
        for (int i = 0; i < stringArray3.length; ++i) {
            if (stringArray3[i].equals("") || stringArray3[i].contains("://")) continue;
            stringArray3[i] = FileUtils.makeRelativeToDosroot(FileUtils.canonicalToData(stringArray3[i])).getPath();
            stringArray3[i] = FileUtils.prefixAndSanitizeToDosroot(expProfile.getBaseDir(), new File(stringArray3[i])).getPath();
            if (expProfile.getBaseDir().isAbsolute()) continue;
            stringArray3[i] = FileUtils.DOSROOT_DIR + stringArray3[i];
        }
        this.dbase.updateProfileSetupAndLinks(stringArray2, stringArray3, n);
        if (this.importNativecommands) {
            this.dbase.saveNativeCommands(expProfile.getNativeCommandsList(), n, -1);
        }
        stringBuffer.append("  + ").append(this.settings.msg("dialog.import.notice.createddbentry", new Object[]{n, string2, string, dosboxVersion.getTitle()})).append('\n');
    }

    @Override
    public String getTitle(Object object) {
        return ((ExpProfile)object).getTitle();
    }

    @Override
    public void preFinish() throws IOException {
        if (this.customFields != null) {
            for (int i = 0; i < 10; ++i) {
                if (this.customFields[i].equalsIgnoreCase("Custom" + (i + 1))) continue;
                this.settings.getSettings().setValue("gui", "custom" + (i + 1), this.customFields[i]);
            }
        }
        if (this.sevenzip) {
            this.entryIdsToBeExtracted = ArrayUtils.toPrimitive((Integer[])this.sevenzipDstFileMap.keySet().toArray(new Integer[0]));
            SevenzipExtractFilesCallback sevenzipExtractFilesCallback = new SevenzipExtractFilesCallback(this, this.zArchive, this.sevenzipDstFileMap);
            this.zArchive.Extract(this.entryIdsToBeExtracted, this.entryIdsToBeExtracted.length, 0, (IArchiveExtractCallback)sevenzipExtractFilesCallback);
            for (int i = 0; i < this.entryIdsToBeExtracted.length; ++i) {
                int n = this.entryIdsToBeExtracted[i];
                FileUtils.fileSetLastModified(this.sevenzipDstFileMap.get(n), this.zArchive.getEntry(n).getTime());
            }
            this.zArchive.close();
        }
    }

    public String[] getCustomFields() {
        return this.customFields != null ? (String[])this.customFields.clone() : null;
    }
}

