/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.searchengine;

import java.io.IOException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.WebProfile;
import org.dbgl.util.XmlUtils;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TheGamesDBSearchEngine
extends WebSearchEngine {
    private static final String THE_GAMES_DB_HOST_NAME = "thegamesdb.net";

    private TheGamesDBSearchEngine() {
    }

    public static WebSearchEngine getInstance() {
        return SearchEngineHolder.instance;
    }

    @Override
    public String getIcon() {
        return "thegamesdb.png";
    }

    @Override
    public String getName() {
        return "TheGamesDB.net";
    }

    @Override
    public String getSimpleName() {
        return "thegamesdb";
    }

    @Override
    public List<WebProfile> getEntries(String string, String[] stringArray) throws IOException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(TheGamesDBSearchEngine.getInputStream("http://thegamesdb.net/api/GetGamesList.php?name=" + URLEncoder.encode(string.replaceAll("/", " "), "UTF-8") + (stringArray.length == 1 ? "&platform=" + stringArray[0] : "")));
            NodeList nodeList = (NodeList)XPathFactory.newInstance().newXPath().evaluate("/Data/Game", document, XPathConstants.NODESET);
            ArrayList<WebProfile> arrayList = new ArrayList<WebProfile>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                WebProfile webProfile = new WebProfile();
                webProfile.setTitle(XmlUtils.getTextValue(element, "GameTitle"));
                webProfile.setUrl(TheGamesDBSearchEngine.absoluteUrl(THE_GAMES_DB_HOST_NAME, "/api/GetGame.php?id=" + XmlUtils.getTextValue(element, "id")));
                webProfile.setPlatform(XmlUtils.getTextValue(element, "Platform"));
                webProfile.setPublisherName("");
                String string2 = XmlUtils.getTextValue(element, "ReleaseDate");
                if (string2 != null && string2.length() == 10) {
                    webProfile.setYear(string2.substring(string2.length() - 4));
                } else {
                    webProfile.setYear("");
                }
                arrayList.add(webProfile);
            }
            return arrayList;
        }
        catch (ParserConfigurationException | XPathExpressionException | SAXException exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public WebProfile getEntryDetailedInformation(WebProfile webProfile) throws UnknownHostException, IOException {
        WebProfile webProfile2 = new WebProfile();
        webProfile2.setTitle(webProfile.getTitle());
        webProfile2.setYear(webProfile.getYear());
        webProfile2.setUrl(webProfile.getUrl());
        webProfile2.setPlatform(webProfile.getPlatform());
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(TheGamesDBSearchEngine.getInputStream(webProfile.getUrl()));
            Element element = (Element)document.getFirstChild();
            webProfile2.setDeveloperName(StringUtils.defaultString((String)XmlUtils.getTextValue(element, "Developer")));
            webProfile2.setPublisherName(StringUtils.defaultString((String)XmlUtils.getTextValue(element, "Publisher")));
            webProfile2.setNotes(StringUtils.defaultString((String)XmlUtils.getTextValue(element, "Overview")));
            String string = XmlUtils.getTextValue(element, "Rating");
            if (string != null) {
                webProfile2.setRank((int)(Double.parseDouble(string) * 10.0 + 0.5));
            } else {
                webProfile2.setRank(0);
            }
            webProfile2.setCoreGameCoverUrl(XmlUtils.getTextValue(element, "baseImgUrl"));
            webProfile2.setXmlElementWithAllImages(XmlUtils.getNode(element, "Images"));
            StringBuffer stringBuffer = new StringBuffer();
            Element element2 = XmlUtils.getNode(element, "Genres");
            if (element2 != null) {
                NodeList nodeList = element2.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(nodeList.item(i).getFirstChild().getNodeValue());
                }
            }
            webProfile2.setGenre(stringBuffer.toString());
            webProfile2.setUrl(TheGamesDBSearchEngine.absoluteUrl(THE_GAMES_DB_HOST_NAME, "/game/" + XmlUtils.getTextValue(element, "id")));
        }
        catch (ParserConfigurationException | SAXException exception) {
            throw new IOException(exception);
        }
        return webProfile2;
    }

    @Override
    public SearchEngineImageInformation[] getEntryImages(WebProfile webProfile, int n, int n2, boolean bl) throws IOException {
        ArrayList<SearchEngineImageInformation> arrayList = new ArrayList<SearchEngineImageInformation>();
        if (n > 0) {
            try {
                arrayList.addAll(this.getEntryCoverArtInformation(webProfile, n, bl));
            }
            catch (XPathExpressionException xPathExpressionException) {
                throw new IOException(xPathExpressionException);
            }
        }
        if (n2 > 0) {
            try {
                arrayList.addAll(this.getEntryScreenshotInformation(webProfile, n2));
            }
            catch (XPathExpressionException xPathExpressionException) {
                throw new IOException(xPathExpressionException);
            }
        }
        webProfile.setWebImages(arrayList.toArray(new SearchEngineImageInformation[0]));
        return webProfile.getWebImages();
    }

    private List<SearchEngineImageInformation> getEntryScreenshotInformation(WebProfile webProfile, int n) throws IOException, XPathExpressionException {
        ArrayList<SearchEngineImageInformation> arrayList = new ArrayList<SearchEngineImageInformation>();
        NodeList nodeList = (NodeList)XPathFactory.newInstance().newXPath().evaluate("screenshot", webProfile.getXmlElementWithAllImages(), XPathConstants.NODESET);
        for (int i = 0; i < Math.min(nodeList.getLength(), n); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = webProfile.getCoreGameCoverUrl() + XmlUtils.getTextValue(element, "original");
            arrayList.add(new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.Screenshot, string, ""));
        }
        return arrayList;
    }

    private List<SearchEngineImageInformation> getEntryCoverArtInformation(WebProfile webProfile, int n, boolean bl) throws IOException, XPathExpressionException {
        ArrayList<SearchEngineImageInformation> arrayList = new ArrayList<SearchEngineImageInformation>();
        NodeList nodeList = (NodeList)XPathFactory.newInstance().newXPath().evaluate("boxart", webProfile.getXmlElementWithAllImages(), XPathConstants.NODESET);
        for (int i = 0; i < Math.min(nodeList.getLength(), n); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = webProfile.getCoreGameCoverUrl() + element.getFirstChild().getNodeValue();
            String string2 = element.getAttribute("side");
            arrayList.add(new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.CoverArt, string, string2));
        }
        return arrayList;
    }

    private static class SearchEngineHolder {
        private static WebSearchEngine instance = new TheGamesDBSearchEngine();

        private SearchEngineHolder() {
        }
    }
}

