/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.searchengine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.WebProfile;
import org.dbgl.util.StringRelatedUtils;

public abstract class WebSearchEngine {
    protected static final String HTTP_PROTOCOL = "http://";
    protected static final String HTML_HREF_OPEN = " href=\"";
    protected static final String HTML_HREF_OPEN_SQ = " href='";
    protected static final String HTML_SRC_OPEN = " src=\"";
    protected static final String HTML_SRC_OPEN_SQ = " src='";
    protected static final String HTML_QUOTE = "\"";
    protected static final String HTML_QUOTE_SQ = "'";
    protected static final String HTML_MOBY_OPEN = "</moby ";
    protected static final String HTML_MOBY_CLOSE = "</moby>";
    protected static final String HTML_SPAN_OPEN = "<span ";
    protected static final String HTML_SPAN_CLOSE = "</span>";
    protected static final String HTML_ANCHOR_OPEN = "<a ";
    protected static final String HTML_ANCHOR_CLOSE = "</a>";
    protected static final String HTML_DIV_OPEN = "<div";
    protected static final String HTML_DIV_CLOSE = "</div>";
    protected static final String HTML_BLOCKQUOTE_OPEN = "<blockquote>";
    protected static final String HTML_BLOCKQUOTE_CLOSE = "</blockquote>";
    protected static final String HTML_I_OPEN = "<i>";
    protected static final String HTML_I_CLOSE = "</i>";
    protected static final String HTML_UL_OPEN = "<ul>";
    protected static final String HTML_UL_CLOSE = "</ul>";
    protected static final String HTML_OL_OPEN = "<ol>";
    protected static final String HTML_OL_CLOSE = "</ol>";
    protected static final String HTML_LI_OPEN = "<li>";
    protected static final String HTML_LI_CLOSE = "</li>";
    protected static final String HTML_B_OPEN = "<b>";
    protected static final String HTML_B_CLOSE = "</b>";
    protected static final String HTML_STRONG_OPEN = "<strong>";
    protected static final String HTML_STRONG_CLOSE = "</strong>";
    protected static final String HTML_P_OPEN = "<p>";
    protected static final String HTML_PU_OPEN = "<p ";
    protected static final String HTML_P_CLOSE = "</p>";
    protected static final String HTML_EM_OPEN = "<em>";
    protected static final String HTML_EM_CLOSE = "</em>";
    protected static final String HTML_BR_UNCLOSED = "<br>";
    protected static final String HTML_BR_CLOSED = "<br/>";
    protected static final String HTML_BR_CLOSED_ALT = "<br />";
    protected static final String HTML_TD_OPEN = "<td>";
    protected static final String HTML_TD_CLOSE = "</td>";
    protected static final String HTML_TITLE_OPEN = "<title>";
    protected static final String HTML_TITLE_CLOSE = "</title>";

    public abstract String getIcon();

    public abstract String getName();

    public abstract String getSimpleName();

    public abstract WebProfile getEntryDetailedInformation(WebProfile var1) throws UnknownHostException, IOException;

    public abstract SearchEngineImageInformation[] getEntryImages(WebProfile var1, int var2, int var3, boolean var4) throws IOException;

    public abstract List<WebProfile> getEntries(String var1, String[] var2) throws IOException;

    public static int getEntryFirstExactMatchIndex(String string, List<WebProfile> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equalsIgnoreCase(list.get(i).getTitle())) continue;
            return i;
        }
        return -1;
    }

    public static int getEntryBestMatchIndex(String string, List<WebProfile> list) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = list.get(i).getTitle();
        }
        return StringRelatedUtils.findBestMatchIndex(string, stringArray);
    }

    public static InputStream getInputStream(String string) throws IOException {
        try {
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.setReadTimeout(20000);
            httpURLConnection.setRequestProperty("User-Agent", "DOSBox Game Launcher");
            return httpURLConnection.getInputStream();
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException(malformedURLException);
        }
    }

    protected static String getResponseContent(String string, String string2) throws IOException {
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(WebSearchEngine.getInputStream(string), string2));
            StringBuffer stringBuffer = new StringBuffer(8192);
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3);
            }
            bufferedReader.close();
            return stringBuffer.toString();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    protected static String absoluteUrl(String string, String string2) {
        return string2.startsWith(HTTP_PROTOCOL) ? string2 : HTTP_PROTOCOL + string + (string2.charAt(0) == '/' ? "" : Character.valueOf('/')) + string2;
    }

    protected static String extractNextContent(String string, int n, String string2, String string3) {
        int n2 = string.indexOf(string2, n);
        n2 = string.indexOf(">", n2) + 1;
        int n3 = string.indexOf(string3, n2);
        return string.substring(n2, n3);
    }

    protected static String extractNextHrefContent(String string, int n) {
        int n2 = string.indexOf(HTML_HREF_OPEN, n) + HTML_HREF_OPEN.length();
        int n3 = string.indexOf(HTML_QUOTE, n2);
        return string.substring(n2, n3);
    }

    protected static String extractNextHrefContentSingleQuotes(String string, int n) {
        int n2 = string.indexOf(HTML_HREF_OPEN_SQ, n) + HTML_HREF_OPEN_SQ.length();
        int n3 = string.indexOf(HTML_QUOTE_SQ, n2);
        return string.substring(n2, n3);
    }

    protected static int idxNextHrefContent(String string, int n) {
        int n2 = string.indexOf(HTML_ANCHOR_OPEN, n);
        if (n2 != -1 && string.indexOf(HTML_ANCHOR_CLOSE, n2 + HTML_ANCHOR_OPEN.length()) != -1) {
            return n2;
        }
        return -1;
    }

    protected static String extractNextSrcContent(String string, int n) {
        int n2 = string.indexOf(HTML_SRC_OPEN, n) + HTML_SRC_OPEN.length();
        int n3 = string.indexOf(HTML_QUOTE, n2);
        return string.substring(n2, n3);
    }

    protected static String extractNextDoubleQuotedContent(String string, int n) {
        int n2 = string.indexOf(HTML_QUOTE, n) + 1;
        int n3 = string.indexOf(HTML_QUOTE, n2);
        return string.substring(n2, n3);
    }

    protected static String extractNextSrcContentSingleQuotes(String string, int n) {
        int n2 = string.indexOf(HTML_SRC_OPEN_SQ, n) + HTML_SRC_OPEN_SQ.length();
        int n3 = string.indexOf(HTML_QUOTE_SQ, n2);
        return string.substring(n2, n3);
    }

    protected static String removeAllTags(String string) {
        String string2 = WebSearchEngine.removeTag(HTML_DIV_OPEN, HTML_DIV_CLOSE, string);
        string2 = WebSearchEngine.removeTag(HTML_ANCHOR_OPEN, HTML_ANCHOR_CLOSE, string2);
        string2 = WebSearchEngine.removeTag(HTML_MOBY_OPEN, HTML_MOBY_CLOSE, string2);
        string2 = WebSearchEngine.replaceTag(HTML_I_OPEN, HTML_I_CLOSE, "", "", string2);
        string2 = WebSearchEngine.replaceTag(HTML_B_OPEN, HTML_B_CLOSE, "", "", string2);
        string2 = WebSearchEngine.replaceTag(HTML_STRONG_OPEN, HTML_STRONG_CLOSE, "", "", string2);
        string2 = WebSearchEngine.replaceTag(HTML_LI_OPEN, HTML_LI_CLOSE, "", "\n", string2);
        string2 = WebSearchEngine.replaceTag(HTML_EM_OPEN, HTML_EM_CLOSE, "", "", string2);
        string2 = WebSearchEngine.replaceTag(HTML_UL_OPEN, HTML_UL_CLOSE, "\n\n", "\n", string2);
        string2 = WebSearchEngine.replaceTag(HTML_OL_OPEN, HTML_OL_CLOSE, "\n\n", "\n", string2);
        string2 = WebSearchEngine.replaceTag(HTML_BLOCKQUOTE_OPEN, HTML_BLOCKQUOTE_CLOSE, "\n\n", "\n", string2);
        string2 = string2.replaceAll("</p>\\s*<p>", "\n\n");
        string2 = WebSearchEngine.replaceTag(HTML_P_OPEN, HTML_P_CLOSE, "\n", "", string2);
        return string2;
    }

    protected static String replaceTag(String string, String string2, String string3, String string4, String string5) {
        return WebSearchEngine.replaceTag(string2, string4, WebSearchEngine.replaceTag(string, string3, string5));
    }

    protected static String replaceTag(String string, String string2, String string3) {
        return string3.replace(string, string2).replace(string.toUpperCase(), string2);
    }

    protected static String removeTag(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string3);
        int n = StringUtils.indexOfIgnoreCase((CharSequence)stringBuffer, (CharSequence)string);
        while (n != -1) {
            stringBuffer.delete(n, stringBuffer.indexOf(">", n + string.length()) + 1);
            int n2 = StringUtils.indexOfIgnoreCase((CharSequence)stringBuffer, (CharSequence)string2);
            stringBuffer.delete(n2, n2 + string2.length());
            n = StringUtils.indexOfIgnoreCase((CharSequence)stringBuffer, (CharSequence)string);
        }
        return stringBuffer.toString();
    }

    protected static String unescapeHtml(String string) {
        String string2 = WebSearchEngine.replaceTag(HTML_BR_UNCLOSED, "\n", string);
        string2 = WebSearchEngine.replaceTag(HTML_BR_CLOSED, "\n", string2);
        string2 = WebSearchEngine.replaceTag(HTML_BR_CLOSED_ALT, "\n", string2);
        string2 = WebSearchEngine.replaceTag("&nbsp;", " ", string2);
        string2 = WebSearchEngine.replaceTag("&apos;", HTML_QUOTE_SQ, string2);
        return StringEscapeUtils.unescapeHtml4((String)StringUtils.strip((String)string2));
    }

    private static boolean isAllowed(WebProfile webProfile, String[] stringArray) {
        boolean bl = stringArray.length == 0;
        for (String string : stringArray) {
            if (!webProfile.getPlatform().equalsIgnoreCase(string)) continue;
            return true;
        }
        return bl;
    }

    protected static List<WebProfile> filterEntries(String[] stringArray, Collection<WebProfile> collection) {
        ArrayList<WebProfile> arrayList = new ArrayList<WebProfile>();
        for (WebProfile webProfile : collection) {
            if (!WebSearchEngine.isAllowed(webProfile, stringArray)) continue;
            arrayList.add(webProfile);
        }
        if (arrayList.isEmpty()) {
            arrayList.addAll(collection);
        }
        Collections.sort(arrayList);
        return arrayList;
    }
}

