/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

import org.dbgl.waldheinz.fs.fat.BlockDevice;
import org.dbgl.waldheinz.fs.fat.BootSector;
import org.dbgl.waldheinz.fs.fat.FatType;

final class Fat16BootSector
extends BootSector {
    public static final int DEFAULT_ROOT_DIR_ENTRY_COUNT = 512;
    public static final String DEFAULT_VOLUME_LABEL = "NO NAME";
    public static final int MAX_FAT12_CLUSTERS = 4084;
    public static final int MAX_FAT16_CLUSTERS = 65524;
    public static final int SECTORS_PER_FAT_OFFSET = 22;
    public static final int ROOT_DIR_ENTRIES_OFFSET = 17;
    public static final int VOLUME_LABEL_OFFSET = 43;
    public static final int FILE_SYSTEM_TYPE_OFFSET = 54;
    public static final int MAX_VOLUME_LABEL_LENGTH = 11;
    public static final int EXTENDED_BOOT_SIGNATURE_OFFSET = 38;

    public Fat16BootSector(BlockDevice blockDevice, long l) {
        super(blockDevice, l);
    }

    public String getVolumeLabel() {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 11 && (c = (char)this.get8(43 + i)) != '\u0000'; ++i) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    @Override
    public long getSectorsPerFat() {
        return this.get16(22);
    }

    @Override
    public FatType getFatType() {
        long l = (this.getRootDirEntryCount() * 32 + (this.getBytesPerSector() - 1)) / this.getBytesPerSector();
        long l2 = this.getSectorCount() - ((long)this.getNrReservedSectors() + (long)this.getNrFats() * this.getSectorsPerFat() + l);
        long l3 = l2 / (long)this.getSectorsPerCluster();
        if (l3 > 65524L) {
            throw new IllegalStateException("too many clusters for FAT12/16: " + l3);
        }
        return l3 > 4084L ? FatType.FAT16 : FatType.FAT12;
    }

    @Override
    public long getSectorCount() {
        if (this.getNrLogicalSectors() == 0) {
            return this.getNrTotalSectors();
        }
        return this.getNrLogicalSectors();
    }

    @Override
    public int getRootDirEntryCount() {
        return this.get16(17);
    }

    @Override
    public int getFileSystemTypeLabelOffset() {
        return 54;
    }

    @Override
    public int getExtendedBootSignatureOffset() {
        return 38;
    }
}

