/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

import java.util.Arrays;
import org.dbgl.loopy.util.LittleEndian;

final class ShortName {
    private final char[] name;

    public ShortName(byte[] byArray) {
        char[] cArray = new char[8];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)LittleEndian.getUInt8(byArray, i);
        }
        if (LittleEndian.getUInt8(byArray, 0) == 5) {
            cArray[0] = 229;
        }
        char[] cArray2 = new char[3];
        for (int i = 0; i < cArray2.length; ++i) {
            cArray2[i] = (char)LittleEndian.getUInt8(byArray, 8 + i);
        }
        this.name = ShortName.toCharArray(new String(cArray).trim(), new String(cArray2).trim());
    }

    private static char[] toCharArray(String string, String string2) {
        ShortName.checkValidName(string);
        ShortName.checkValidExt(string2);
        char[] cArray = new char[11];
        Arrays.fill(cArray, ' ');
        System.arraycopy(string.toCharArray(), 0, cArray, 0, string.length());
        System.arraycopy(string2.toCharArray(), 0, cArray, 8, string2.length());
        return cArray;
    }

    public String asSimpleString() {
        return new String(this.name).trim();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.asSimpleString() + "]";
    }

    private static void checkValidName(String string) {
        ShortName.checkString(string, "name", 1, 8);
    }

    private static void checkValidExt(String string) {
        ShortName.checkString(string, "extension", 0, 3);
    }

    private static void checkString(String string, String string2, int n, int n2) {
        if (string == null) {
            throw new IllegalArgumentException(string2 + " is null");
        }
        if (string.length() < n) {
            throw new IllegalArgumentException(string2 + " must have at least " + n + " characters: " + string);
        }
        if (string.length() > n2) {
            throw new IllegalArgumentException(string2 + " has more than " + n2 + " characters: " + string);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShortName)) {
            return false;
        }
        ShortName shortName = (ShortName)object;
        return Arrays.equals(this.name, shortName.name);
    }

    public int hashCode() {
        return Arrays.hashCode(this.name);
    }
}

