/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.db;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Filter;
import org.dbgl.model.KeyValuePair;
import org.dbgl.model.LogEntry;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.Profile;
import org.dbgl.model.Template;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.StringRelatedUtils;
import org.eclipse.swt.widgets.Shell;

public class Database {
    private static Connection con = null;
    private static boolean initializedNewDatabase = false;
    private static final String GET_IDENTITY_QRY = "CALL IDENTITY()";
    private static final String GAME_LIST_QRY = "SELECT GAM.ID, GAM.TITLE, DEV.NAME, PUBL.NAME, GEN.NAME, YR.YEAR, STAT.STAT, GAM.NOTES, GAM.FAVORITE, GAM.SETUP, GAM.SETUP_PARAMS, GAM.ALT1, GAM.ALT1_PARAMS, GAM.ALT2, GAM.ALT2_PARAMS, GAM.CONFFILE, GAM.CAPTURES, GAM.DBVERSION_ID, GAM.LINK1, GAM.LINK2, GAM.LINK3, GAM.LINK4, GAM.LINK5, GAM.LINK6, GAM.LINK7, GAM.LINK8, GAM.LINK1_TITLE, GAM.LINK2_TITLE, GAM.LINK3_TITLE, GAM.LINK4_TITLE, GAM.LINK5_TITLE, GAM.LINK6_TITLE, GAM.LINK7_TITLE, GAM.LINK8_TITLE, CUST1.VALUE, CUST2.VALUE, CUST3.VALUE, CUST4.VALUE, GAM.CUSTOM5, GAM.CUSTOM6, GAM.CUSTOM7, GAM.CUSTOM8, GAM.CUSTOM9, GAM.CUSTOM10, GAM.STATS_CREATED, GAM.STATS_LASTMODIFY, GAM.STATS_LASTRUN, GAM.STATS_LASTSETUP, GAM.STATS_RUNS, GAM.STATS_SETUPS FROM GAMES GAM, DEVELOPERS DEV, PUBLISHERS PUBL, GENRES GEN, PUBLYEARS YR, STATUS STAT, CUSTOM1 CUST1, CUSTOM2 CUST2, CUSTOM3 CUST3, CUSTOM4 CUST4 WHERE GAM.DEV_ID=DEV.ID AND GAM.PUBL_ID=PUBL.ID AND GAM.GENRE_ID=GEN.ID AND GAM.YEAR_ID=YR.ID AND GAM.STAT_ID=STAT.ID AND   GAM.CUST1_ID=CUST1.ID AND GAM.CUST2_ID=CUST2.ID AND GAM.CUST3_ID=CUST3.ID AND GAM.CUST4_ID=CUST4.ID";
    private static final String DUPL_GAME_QRY = "INSERT INTO GAMES(TITLE, DEV_ID, PUBL_ID, GENRE_ID, YEAR_ID, STAT_ID, NOTES, FAVORITE, SETUP, SETUP_PARAMS, ALT1, ALT1_PARAMS, ALT2, ALT2_PARAMS,CONFFILE, CAPTURES, DBVERSION_ID, LINK1, LINK2, LINK3, LINK4, LINK5, LINK6, LINK7, LINK8,LINK1_TITLE, LINK2_TITLE, LINK3_TITLE, LINK4_TITLE, LINK5_TITLE, LINK6_TITLE, LINK7_TITLE, LINK8_TITLE,CUST1_ID, CUST2_ID, CUST3_ID, CUST4_ID, CUSTOM5, CUSTOM6, CUSTOM7, CUSTOM8, CUSTOM9, CUSTOM10) (SELECT TITLE, DEV_ID, PUBL_ID, GENRE_ID, YEAR_ID, STAT_ID, NOTES, FAVORITE,SETUP, SETUP_PARAMS, ALT1, ALT1_PARAMS, ALT2, ALT2_PARAMS, NULL, NULL, DBVERSION_ID,LINK1, LINK2, LINK3, LINK4, LINK5, LINK6, LINK7, LINK8, LINK1_TITLE, LINK2_TITLE, LINK3_TITLE, LINK4_TITLE, LINK5_TITLE, LINK6_TITLE, LINK7_TITLE, LINK8_TITLE,CUST1_ID, CUST2_ID, CUST3_ID, CUST4_ID, CUSTOM5, CUSTOM6, CUSTOM7, CUSTOM8, CUSTOM9, CUSTOM10 FROM GAMES WHERE ID = ?)";
    private static final String DUPL_TEMPLATE_QRY = "INSERT INTO TEMPLATES(TITLE, DBVERSION_ID, ISDEFAULT) (SELECT TITLE, DBVERSION_ID, FALSE FROM TEMPLATES WHERE ID = ?)";
    private static final String DEV_LIST_QRY = "SELECT ID, NAME FROM DEVELOPERS ORDER BY NAME";
    private static final String PUBL_LIST_QRY = "SELECT ID, NAME FROM PUBLISHERS ORDER BY NAME";
    private static final String GENRE_LIST_QRY = "SELECT ID, NAME FROM GENRES ORDER BY NAME";
    private static final String PUBLYEAR_LIST_QRY = "SELECT ID, YEAR FROM PUBLYEARS ORDER BY YEAR";
    private static final String DBVERS_LIST_QRY = "SELECT ID, TITLE, PATH, CONFFILE, MULTICONF, USINGCURSES, ISDEFAULT, PARAMETERS, VERSION, STATS_CREATED, STATS_LASTMODIFY, STATS_LASTRUN, STATS_RUNS FROM DOSBOXVERSIONS ORDER BY TITLE";
    private static final String FLTRS_LIST_QRY = "SELECT ID, TITLE, FILTER FROM FILTERS";
    private static final String LOG_LIST_QRY = "SELECT ID, TIME, EVENT, ENTITY_TYPE, ENTITY_ID, ENTITY_TITLE FROM LOG";
    private static final String TEMPL_LIST_QRY = "SELECT ID, TITLE, DBVERSION_ID, ISDEFAULT, STATS_CREATED, STATS_LASTMODIFY, STATS_LASTRUN, STATS_RUNS FROM TEMPLATES ORDER BY ID";
    private static final String STATUS_LIST_QRY = "SELECT ID, STAT FROM STATUS ORDER BY STAT";
    private static final String[] CUSTOM_LIST_QRY = new String[]{"SELECT ID, VALUE FROM CUSTOM1 ORDER BY VALUE", "SELECT ID, VALUE FROM CUSTOM2 ORDER BY VALUE", "SELECT ID, VALUE FROM CUSTOM3 ORDER BY VALUE", "SELECT ID, VALUE FROM CUSTOM4 ORDER BY VALUE"};
    private static final String DBV_USE_QRY = "SELECT TITLE FROM GAMES WHERE DBVERSION_ID = ? UNION ALL SELECT TITLE FROM TEMPLATES WHERE DBVERSION_ID = ?";
    private static final String NTVCMD_LIST_QRY_TEMPLATE = "SELECT COMMAND, PARAMETERS, CWD, WAITFOR, ORDERNR FROM NATIVECOMMANDS WHERE GAME_ID IS NULL AND TEMPLATE_ID = ? ORDER BY ORDERNR";
    private static final String NTVCMD_LIST_QRY_GAME = "SELECT COMMAND, PARAMETERS, CWD, WAITFOR, ORDERNR FROM NATIVECOMMANDS WHERE GAME_ID = ? AND TEMPLATE_ID IS NULL ORDER BY ORDERNR";
    private static final String ADD_GAME_QRY = "INSERT INTO GAMES(TITLE, DEV_ID, PUBL_ID, GENRE_ID, YEAR_ID, STAT_ID, NOTES, FAVORITE,SETUP, SETUP_PARAMS, ALT1, ALT1_PARAMS, ALT2, ALT2_PARAMS, CONFFILE, CAPTURES, DBVERSION_ID,LINK1, LINK2, LINK3, LINK4, LINK5, LINK6, LINK7, LINK8,LINK1_TITLE, LINK2_TITLE, LINK3_TITLE, LINK4_TITLE, LINK5_TITLE, LINK6_TITLE, LINK7_TITLE, LINK8_TITLE,CUST1_ID, CUST2_ID, CUST3_ID, CUST4_ID, CUSTOM5, CUSTOM6, CUSTOM7, CUSTOM8, CUSTOM9, CUSTOM10) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NULL, NULL, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String ADD_DEVELOPER_QRY = "INSERT INTO DEVELOPERS(NAME) VALUES (?)";
    private static final String ADD_PUBLISHER_QRY = "INSERT INTO PUBLISHERS(NAME) VALUES (?)";
    private static final String ADD_GENRE_QRY = "INSERT INTO GENRES(NAME) VALUES (?)";
    private static final String ADD_YEAR_QRY = "INSERT INTO PUBLYEARS(YEAR) VALUES (?)";
    private static final String ADD_DBVERSION_QRY = "INSERT INTO DOSBOXVERSIONS(TITLE, PATH, CONFFILE, MULTICONF, USINGCURSES, ISDEFAULT, PARAMETERS, VERSION) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String ADD_TEMPLATE_QRY = "INSERT INTO TEMPLATES(TITLE, DBVERSION_ID, ISDEFAULT) VALUES (?, ?, ?)";
    private static final String ADD_FILTER_QRY = "INSERT INTO FILTERS(TITLE, FILTER, CONF_FILTER) VALUES (?, ?, '')";
    private static final String ADD_STATUS_QRY = "INSERT INTO STATUS(STAT) VALUES (?)";
    private static final String[] ADD_CUSTOM_QRY = new String[]{"INSERT INTO CUSTOM1(VALUE) VALUES (?)", "INSERT INTO CUSTOM2(VALUE) VALUES (?)", "INSERT INTO CUSTOM3(VALUE) VALUES (?)", "INSERT INTO CUSTOM4(VALUE) VALUES (?)"};
    private static final String ADD_NATIVECOMMAND_QRY = "INSERT INTO NATIVECOMMANDS(COMMAND, PARAMETERS, CWD, WAITFOR, ORDERNR, GAME_ID, TEMPLATE_ID) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private static final String ADD_LOG_QRY = "INSERT INTO LOG(EVENT, ENTITY_TYPE, ENTITY_ID, ENTITY_TITLE) VALUES(?, ?, ?, ?)";
    private static final String UPD_GAME_QRY = "UPDATE GAMES SET TITLE = ?, DEV_ID = ?, PUBL_ID = ?, GENRE_ID = ?, YEAR_ID = ?, STAT_ID = ?, NOTES = ?, FAVORITE = ?, SETUP = ?, SETUP_PARAMS = ?, ALT1 = ?, ALT1_PARAMS = ?, ALT2 = ?, ALT2_PARAMS = ?,DBVERSION_ID = ?, LINK1 = ?, LINK2 = ?, LINK3 = ?, LINK4 = ?, LINK5 = ?, LINK6 = ?, LINK7 = ?, LINK8 = ?, LINK1_TITLE = ?, LINK2_TITLE = ?, LINK3_TITLE = ?, LINK4_TITLE = ?, LINK5_TITLE = ?, LINK6_TITLE = ?, LINK7_TITLE = ?, LINK8_TITLE = ?,CUST1_ID = ?, CUST2_ID = ?, CUST3_ID = ?, CUST4_ID = ?, CUSTOM5 = ?, CUSTOM6 = ?, CUSTOM7 = ?, CUSTOM8 = ?, CUSTOM9 = ?, CUSTOM10 = ?, STATS_LASTMODIFY = CURRENT_TIMESTAMP WHERE ID = ?";
    private static final String RUN_GAME_QRY = "UPDATE GAMES SET STATS_LASTRUN = CURRENT_TIMESTAMP, STATS_RUNS = (STATS_RUNS + 1) WHERE ID = ?";
    private static final String SETUP_GAME_QRY = "UPDATE GAMES SET STATS_LASTSETUP = CURRENT_TIMESTAMP, STATS_SETUPS = (STATS_SETUPS + 1) WHERE ID = ?";
    private static final String UPD_GAME_CONF_QRY = "UPDATE GAMES SET CONFFILE = ?, CAPTURES = ? WHERE ID = ?";
    private static final String UPD_STPLNKS_QRY = "UPDATE GAMES SET SETUP = ?, ALT1 = ?, ALT2 = ?, LINK1 = ?, LINK2 = ?, LINK3 = ?, LINK4 = ?, LINK5 = ?, LINK6 = ?, LINK7 = ?, LINK8 = ? WHERE ID = ?";
    private static final String UPD_DBV_NODEFAULT = "UPDATE DOSBOXVERSIONS SET ISDEFAULT = FALSE";
    private static final String UPD_DBVERSION_QRY = "UPDATE DOSBOXVERSIONS SET TITLE = ?, PATH = ?, CONFFILE = ?, MULTICONF = ?, USINGCURSES = ?, ISDEFAULT = ?, PARAMETERS = ?, VERSION = ?, STATS_LASTMODIFY = CURRENT_TIMESTAMP WHERE ID = ?";
    private static final String RUN_DBVERSION_QRY = "UPDATE DOSBOXVERSIONS SET STATS_LASTRUN = CURRENT_TIMESTAMP, STATS_RUNS = (STATS_RUNS + 1) WHERE ID = ?";
    private static final String UPD_TEMPLATE_QRY = "UPDATE TEMPLATES SET TITLE = ?, DBVERSION_ID = ?, ISDEFAULT = ?, STATS_LASTMODIFY = CURRENT_TIMESTAMP WHERE ID = ?";
    private static final String RUN_TEMPLATE_QRY = "UPDATE TEMPLATES SET STATS_LASTRUN = CURRENT_TIMESTAMP, STATS_RUNS = (STATS_RUNS + 1) WHERE ID = ?";
    private static final String UPD_FILTER_QRY = "UPDATE FILTERS SET TITLE = ?, FILTER = ? WHERE ID = ?";
    private static final String UPD_TEMPL_NODFLT = "UPDATE TEMPLATES SET ISDEFAULT = FALSE";
    private static final String REMOVE_GAME_QRY = "DELETE FROM GAMES WHERE ID = ?";
    private static final String REMOVE_DBV_QRY = "DELETE FROM DOSBOXVERSIONS WHERE ID = ?";
    private static final String REMOVE_TEMPL_QRY = "DELETE FROM TEMPLATES WHERE ID = ?";
    private static final String REMOVE_FLTR_QRY = "DELETE FROM FILTERS WHERE ID = ?";
    private static final String REMOVE_NTVCMD_QRY_TEMPLATE = "DELETE FROM NATIVECOMMANDS WHERE GAME_ID IS NULL AND TEMPLATE_ID = ?";
    private static final String REMOVE_NTVCMD_QRY_GAME = "DELETE FROM NATIVECOMMANDS WHERE GAME_ID = ? AND TEMPLATE_ID IS NULL";
    private static final String CLEAR_LOG_QRY = "DELETE FROM LOG";
    private static final String TOGGLE_FAV_QRY = "UPDATE GAMES SET FAVORITE = NOT FAVORITE WHERE ID = ?";
    private static final String GET_VERSION = "SELECT MAJORVERSION, MINORVERSION FROM VERSION";
    private static final String UP_TO_V050_QRY = "ALTER TABLE GAMES ADD COLUMN CONFFILE VARCHAR(256);ALTER TABLE GAMES ADD COLUMN CAPTURES VARCHAR(256);CREATE TABLE VERSION(MAJORVERSION INTEGER NOT NULL, MINORVERSION INTEGER NOT NULL);INSERT INTO VERSION VALUES(0, 50);UPDATE GAMES SET CAPTURES = '" + FileUtils.CAPTURES_DIR + "' || GAMES.ID," + " CONFFILE = '" + FileUtils.PROFILES_DIR + "' || GAMES.ID || '" + ".conf" + "';";
    private static final String UP_TO_V051_QRY = "ALTER TABLE DOSBOXVERSIONS ADD COLUMN PARAMETERS VARCHAR(256) DEFAULT '';UPDATE VERSION SET MINORVERSION = 51;";
    private static final String UP_TO_V056_QRY = "ALTER TABLE GAMES ADD COLUMN LINK3 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK4 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN CUST1_ID INTEGER DEFAULT 0;ALTER TABLE GAMES ADD COLUMN CUST2_ID INTEGER DEFAULT 0;ALTER TABLE GAMES ADD COLUMN CUST3_ID INTEGER DEFAULT 0;ALTER TABLE GAMES ADD COLUMN CUST4_ID INTEGER DEFAULT 0;ALTER TABLE GAMES ADD COLUMN CUSTOM5 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN CUSTOM6 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN CUSTOM7 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN CUSTOM8 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN CUSTOM9  INTEGER DEFAULT 0;ALTER TABLE GAMES ADD COLUMN CUSTOM10 INTEGER DEFAULT 0;CREATE TABLE CUSTOM1(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY, VALUE VARCHAR(256) NOT NULL);CREATE TABLE CUSTOM2(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY, VALUE VARCHAR(256) NOT NULL);CREATE TABLE CUSTOM3(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY, VALUE VARCHAR(256) NOT NULL);CREATE TABLE CUSTOM4(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY, VALUE VARCHAR(256) NOT NULL);INSERT INTO CUSTOM1(VALUE) VALUES('');INSERT INTO CUSTOM2(VALUE) VALUES('');INSERT INTO CUSTOM3(VALUE) VALUES('');INSERT INTO CUSTOM4(VALUE) VALUES('');UPDATE VERSION SET MINORVERSION = 56;";
    private static final String UP_TO_V062_QRY = "ALTER TABLE DOSBOXVERSIONS ADD COLUMN VERSION VARCHAR(256) DEFAULT '0.72' NOT NULL;UPDATE VERSION SET MINORVERSION = 62;";
    private static final String UP_TO_V065_QRY = "ALTER TABLE GAMES ADD COLUMN LINK1_TITLE VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK2_TITLE VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK3_TITLE VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK4_TITLE VARCHAR(256) DEFAULT '';UPDATE VERSION SET MINORVERSION = 65;";
    private static final String UP_TO_V067_QRY = "ALTER TABLE DOSBOXVERSIONS ADD COLUMN USINGCURSES BOOLEAN;UPDATE VERSION SET MINORVERSION = 67;";
    private static final String UP_TO_V068_QRY = "CREATE MEMORY TABLE FILTERS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,TITLE VARCHAR(256) NOT NULL,FILTER VARCHAR(256) NOT NULL,CONF_FILTER VARCHAR(256) NOT NULL);UPDATE VERSION SET MINORVERSION = 68;";
    private static final String UP_TO_V072_QRY = "ALTER TABLE DOSBOXVERSIONS ADD COLUMN CONFFILE VARCHAR(256) DEFAULT '' NOT NULL;UPDATE DOSBOXVERSIONS SET CONFFILE = CONCAT(PATH, '" + File.separatorChar + "dosbox.conf" + "');" + "UPDATE VERSION SET MINORVERSION = 72;";
    private static final String UP_TO_V073_QRY = "ALTER TABLE GAMES ADD COLUMN ALT1 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN ALT1_PARAMS VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN ALT2 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN ALT2_PARAMS VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK5 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK6 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK7 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK8 VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK5_TITLE VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK6_TITLE VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK7_TITLE VARCHAR(256) DEFAULT '';ALTER TABLE GAMES ADD COLUMN LINK8_TITLE VARCHAR(256) DEFAULT '';UPDATE VERSION SET MINORVERSION = 73;";
    private static final String UP_TO_V074_QRY = "ALTER TABLE DOSBOXVERSIONS ALTER COLUMN DEFAULT RENAME TO ISDEFAULT;ALTER TABLE TEMPLATES ALTER COLUMN DEFAULT RENAME TO ISDEFAULT;UPDATE VERSION SET MINORVERSION = 74;";
    private static final String UP_TO_V075_QRY = "CREATE MEMORY TABLE NATIVECOMMANDS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,COMMAND VARCHAR(256) NOT NULL,PARAMETERS VARCHAR(256) NOT NULL,CWD VARCHAR(256) NOT NULL,WAITFOR BOOLEAN,ORDERNR INTEGER,GAME_ID INTEGER,TEMPLATE_ID INTEGER,CONSTRAINT SYS_FK_180 FOREIGN KEY(GAME_ID) REFERENCES GAMES(ID),CONSTRAINT SYS_FK_181 FOREIGN KEY(TEMPLATE_ID) REFERENCES TEMPLATES(ID));UPDATE VERSION SET MINORVERSION = 75;";
    private static final String UP_TO_V076_QRY = "ALTER TABLE GAMES ADD COLUMN STATS_CREATED TIMESTAMP(0) DEFAULT CURRENT_TIMESTAMP NOT NULL;ALTER TABLE GAMES ADD COLUMN STATS_LASTMODIFY TIMESTAMP(0);ALTER TABLE GAMES ADD COLUMN STATS_LASTRUN TIMESTAMP(0);ALTER TABLE GAMES ADD COLUMN STATS_RUNS INTEGER DEFAULT 0 NOT NULL;ALTER TABLE GAMES ADD COLUMN STATS_LASTSETUP TIMESTAMP(0);ALTER TABLE GAMES ADD COLUMN STATS_SETUPS INTEGER DEFAULT 0 NOT NULL;ALTER TABLE DOSBOXVERSIONS ADD COLUMN STATS_CREATED TIMESTAMP(0) DEFAULT CURRENT_TIMESTAMP NOT NULL;ALTER TABLE DOSBOXVERSIONS ADD COLUMN STATS_LASTMODIFY TIMESTAMP(0);ALTER TABLE DOSBOXVERSIONS ADD COLUMN STATS_LASTRUN TIMESTAMP(0);ALTER TABLE DOSBOXVERSIONS ADD COLUMN STATS_RUNS INTEGER DEFAULT 0 NOT NULL;ALTER TABLE TEMPLATES ADD COLUMN STATS_CREATED TIMESTAMP(0) DEFAULT CURRENT_TIMESTAMP NOT NULL;ALTER TABLE TEMPLATES ADD COLUMN STATS_LASTMODIFY TIMESTAMP(0);ALTER TABLE TEMPLATES ADD COLUMN STATS_LASTRUN TIMESTAMP(0);ALTER TABLE TEMPLATES ADD COLUMN STATS_RUNS INTEGER DEFAULT 0 NOT NULL;UPDATE VERSION SET MINORVERSION = 76;";
    private static final String UP_TO_V077_QRY = "CREATE MEMORY TABLE LOG (ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,TIME TIMESTAMP(0) DEFAULT CURRENT_TIMESTAMP NOT NULL,EVENT TINYINT NOT NULL, ENTITY_TYPE TINYINT NOT NULL,ENTITY_ID INT NOT NULL, ENTITY_TITLE VARCHAR(256) NOT NULL);UPDATE VERSION SET MINORVERSION = 77;";
    private static final String CREATE_INITIAL_DB = "SET WRITE_DELAY 1;CREATE MEMORY TABLE VERSION(MAJORVERSION INTEGER NOT NULL,MINORVERSION INTEGER NOT NULL);CREATE MEMORY TABLE DEVELOPERS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,NAME VARCHAR(256) NOT NULL);CREATE MEMORY TABLE PUBLISHERS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,NAME VARCHAR(256) NOT NULL);CREATE MEMORY TABLE GENRES(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,NAME VARCHAR(256) NOT NULL);CREATE MEMORY TABLE PUBLYEARS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,YEAR CHAR(4) NOT NULL);CREATE MEMORY TABLE STATUS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,STAT VARCHAR(256) NOT NULL);CREATE MEMORY TABLE CUSTOM1(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,VALUE VARCHAR(256) NOT NULL);CREATE MEMORY TABLE CUSTOM2(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,VALUE VARCHAR(256) NOT NULL);CREATE MEMORY TABLE CUSTOM3(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,VALUE VARCHAR(256) NOT NULL);CREATE MEMORY TABLE CUSTOM4(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,VALUE VARCHAR(256) NOT NULL);CREATE MEMORY TABLE DOSBOXVERSIONS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,TITLE VARCHAR(256) NOT NULL,PATH VARCHAR(256) NOT NULL,CONFFILE VARCHAR(256) NOT NULL,MULTICONF BOOLEAN,ISDEFAULT BOOLEAN,PARAMETERS VARCHAR(256) DEFAULT '',VERSION VARCHAR(256) NOT NULL,USINGCURSES BOOLEAN,STATS_CREATED TIMESTAMP(0) DEFAULT CURRENT_TIMESTAMP NOT NULL,STATS_LASTMODIFY TIMESTAMP(0),STATS_LASTRUN TIMESTAMP(0),STATS_RUNS INTEGER DEFAULT 0 NOT NULL);CREATE MEMORY TABLE TEMPLATES(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,TITLE VARCHAR(256) NOT NULL,DBVERSION_ID INTEGER,ISDEFAULT BOOLEAN,STATS_CREATED TIMESTAMP(0) DEFAULT CURRENT_TIMESTAMP NOT NULL,STATS_LASTMODIFY TIMESTAMP(0),STATS_LASTRUN TIMESTAMP(0),STATS_RUNS INTEGER DEFAULT 0 NOT NULL,CONSTRAINT SYS_FK_185 FOREIGN KEY(DBVERSION_ID) REFERENCES DOSBOXVERSIONS(ID));CREATE MEMORY TABLE GAMES(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,TITLE VARCHAR(256) NOT NULL,DEV_ID INTEGER,PUBL_ID INTEGER,GENRE_ID INTEGER,YEAR_ID INTEGER,STAT_ID INTEGER,NOTES LONGVARCHAR,FAVORITE BOOLEAN,SETUP VARCHAR(256),SETUP_PARAMS VARCHAR(256),ALT1 VARCHAR(256) DEFAULT '',ALT1_PARAMS VARCHAR(256) DEFAULT '',ALT2 VARCHAR(256) DEFAULT '',ALT2_PARAMS VARCHAR(256) DEFAULT '',CONFFILE VARCHAR(256),CAPTURES VARCHAR(256),DBVERSION_ID INTEGER,LINK1 VARCHAR(256),LINK2 VARCHAR(256),LINK3 VARCHAR(256) DEFAULT '',LINK4 VARCHAR(256) DEFAULT '',LINK5 VARCHAR(256) DEFAULT '',LINK6 VARCHAR(256) DEFAULT '',LINK7 VARCHAR(256) DEFAULT '',LINK8 VARCHAR(256) DEFAULT '',LINK1_TITLE VARCHAR(256) DEFAULT '',LINK2_TITLE VARCHAR(256) DEFAULT '',LINK3_TITLE VARCHAR(256) DEFAULT '',LINK4_TITLE VARCHAR(256) DEFAULT '',LINK5_TITLE VARCHAR(256) DEFAULT '',LINK6_TITLE VARCHAR(256) DEFAULT '',LINK7_TITLE VARCHAR(256) DEFAULT '',LINK8_TITLE VARCHAR(256) DEFAULT '',CUST1_ID INTEGER DEFAULT 0,CUST2_ID INTEGER DEFAULT 0,CUST3_ID INTEGER DEFAULT 0,CUST4_ID INTEGER DEFAULT 0,CUSTOM5 VARCHAR(256) DEFAULT '',CUSTOM6 VARCHAR(256) DEFAULT '',CUSTOM7 VARCHAR(256) DEFAULT '',CUSTOM8 VARCHAR(256) DEFAULT '',CUSTOM9 INTEGER DEFAULT 0,CUSTOM10 INTEGER DEFAULT 0,STATS_CREATED TIMESTAMP(0) DEFAULT CURRENT_TIMESTAMP NOT NULL,STATS_LASTMODIFY TIMESTAMP(0),STATS_LASTRUN TIMESTAMP(0),STATS_RUNS INTEGER DEFAULT 0 NOT NULL,STATS_LASTSETUP TIMESTAMP(0),STATS_SETUPS INTEGER DEFAULT 0 NOT NULL,CONSTRAINT SYS_FK_165 FOREIGN KEY(DEV_ID) REFERENCES DEVELOPERS(ID),CONSTRAINT SYS_FK_166 FOREIGN KEY(PUBL_ID) REFERENCES PUBLISHERS(ID),CONSTRAINT SYS_FK_167 FOREIGN KEY(GENRE_ID) REFERENCES GENRES(ID),CONSTRAINT SYS_FK_168 FOREIGN KEY(YEAR_ID) REFERENCES PUBLYEARS(ID),CONSTRAINT SYS_FK_169 FOREIGN KEY(DBVERSION_ID) REFERENCES DOSBOXVERSIONS(ID),CONSTRAINT SYS_FK_170 FOREIGN KEY(STAT_ID) REFERENCES STATUS(ID));CREATE MEMORY TABLE FILTERS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,TITLE VARCHAR(256) NOT NULL,FILTER VARCHAR(256) NOT NULL,CONF_FILTER VARCHAR(256) NOT NULL);CREATE MEMORY TABLE NATIVECOMMANDS(ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,COMMAND VARCHAR(256) NOT NULL,PARAMETERS VARCHAR(256) NOT NULL,CWD VARCHAR(256) NOT NULL,WAITFOR BOOLEAN,ORDERNR INTEGER,GAME_ID INTEGER,TEMPLATE_ID INTEGER,CONSTRAINT SYS_FK_180 FOREIGN KEY(GAME_ID) REFERENCES GAMES(ID),CONSTRAINT SYS_FK_181 FOREIGN KEY(TEMPLATE_ID) REFERENCES TEMPLATES(ID));CREATE MEMORY TABLE LOG (ID INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 0) NOT NULL PRIMARY KEY,TIME TIMESTAMP(0) DEFAULT CURRENT_TIMESTAMP NOT NULL,EVENT TINYINT NOT NULL, ENTITY_TYPE TINYINT NOT NULL,ENTITY_ID INT NOT NULL, ENTITY_TITLE VARCHAR(256) NOT NULL);INSERT INTO CUSTOM1(VALUE) VALUES(''); INSERT INTO CUSTOM2(VALUE) VALUES('');INSERT INTO CUSTOM3(VALUE) VALUES(''); INSERT INTO CUSTOM4(VALUE) VALUES('');INSERT INTO VERSION VALUES(0,77);";
    private static final String TEST_QRY = "SELECT TOP 1 ID FROM GAMES";
    private static final String CLEANUP_QRY = "DELETE FROM DEVELOPERS WHERE ID NOT IN (SELECT DISTINCT DEV_ID FROM GAMES);DELETE FROM PUBLISHERS WHERE ID NOT IN (SELECT DISTINCT PUBL_ID FROM GAMES);DELETE FROM GENRES WHERE ID NOT IN (SELECT DISTINCT GENRE_ID FROM GAMES);DELETE FROM PUBLYEARS WHERE ID NOT IN (SELECT DISTINCT YEAR_ID FROM GAMES);DELETE FROM STATUS WHERE ID NOT IN (SELECT DISTINCT STAT_ID FROM GAMES);DELETE FROM CUSTOM1 WHERE ID NOT IN (SELECT DISTINCT CUST1_ID FROM GAMES);DELETE FROM CUSTOM2 WHERE ID NOT IN (SELECT DISTINCT CUST2_ID FROM GAMES);DELETE FROM CUSTOM3 WHERE ID NOT IN (SELECT DISTINCT CUST3_ID FROM GAMES);DELETE FROM CUSTOM4 WHERE ID NOT IN (SELECT DISTINCT CUST4_ID FROM GAMES)";
    private static final String FIND_INVALID_PROFILES = "SELECT GAM.ID, GAM.TITLE, DEV.NAME, PUBL.NAME, GEN.NAME, YR.YEAR, STAT.STAT, GAM.NOTES, GAM.FAVORITE, GAM.SETUP, GAM.SETUP_PARAMS, GAM.ALT1, GAM.ALT1_PARAMS, GAM.ALT2, GAM.ALT2_PARAMS, GAM.CONFFILE, GAM.CAPTURES, GAM.DBVERSION_ID, GAM.LINK1, GAM.LINK2, GAM.LINK3, GAM.LINK4, GAM.LINK5, GAM.LINK6, GAM.LINK7, GAM.LINK8, GAM.LINK1_TITLE, GAM.LINK2_TITLE, GAM.LINK3_TITLE, GAM.LINK4_TITLE, GAM.LINK5_TITLE, GAM.LINK6_TITLE, GAM.LINK7_TITLE, GAM.LINK8_TITLE, CUST1.VALUE, CUST2.VALUE, CUST3.VALUE, CUST4.VALUE, GAM.CUSTOM5, GAM.CUSTOM6, GAM.CUSTOM7, GAM.CUSTOM8, GAM.CUSTOM9, GAM.CUSTOM10, GAM.STATS_CREATED, GAM.STATS_LASTMODIFY, GAM.STATS_LASTRUN, GAM.STATS_LASTSETUP, GAM.STATS_RUNS, GAM.STATS_SETUPS FROM GAMES GAM, DEVELOPERS DEV, PUBLISHERS PUBL, GENRES GEN, PUBLYEARS YR, STATUS STAT, CUSTOM1 CUST1, CUSTOM2 CUST2, CUSTOM3 CUST3, CUSTOM4 CUST4 WHERE GAM.DEV_ID=DEV.ID AND GAM.PUBL_ID=PUBL.ID AND GAM.GENRE_ID=GEN.ID AND GAM.YEAR_ID=YR.ID AND GAM.STAT_ID=STAT.ID AND   GAM.CUST1_ID=CUST1.ID AND GAM.CUST2_ID=CUST2.ID AND GAM.CUST3_ID=CUST3.ID AND GAM.CUST4_ID=CUST4.ID AND (GAM.CONFFILE IS NULL OR GAM.CAPTURES IS NULL)";
    private static final int COMPLEX_STRINGS = CUSTOM_LIST_QRY.length;
    private static final int SIMPLE_STRINGS = 4;

    private Database() {
        this.init();
    }

    public static Database getInstance() {
        return DatabaseHolder.instance;
    }

    public static boolean isInitializedNewDatabase() {
        return initializedNewDatabase;
    }

    /*
     * Exception decompiling
     */
    private int[] getVersion() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void upgradeToVersion(String string, int n) throws SQLException {
        System.out.println(Settings.getInstance().msg("database.notice.upgrade", new Object[]{0, n}));
        try (Statement statement = con.createStatement();){
            for (String string2 : string.split(";")) {
                statement.addBatch(string2);
            }
            statement.executeBatch();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.upgrade", new Object[]{0, n}));
        }
    }

    private void initializeIfNecessary() throws SQLException {
        try (Statement statement = con.createStatement();){
            statement.executeQuery(TEST_QRY);
        }
        catch (SQLException sQLException) {
            try (Statement statement2 = con.createStatement();){
                for (String string : CREATE_INITIAL_DB.split(";")) {
                    statement2.addBatch(string);
                }
                statement2.executeBatch();
                initializedNewDatabase = true;
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"create initial tables"}));
            }
        }
    }

    private void upgradeIfNecessary() throws SQLException {
        int[] nArray = this.getVersion();
        if (nArray[0] <= 0 && nArray[1] < 50) {
            this.upgradeToVersion(UP_TO_V050_QRY, 50);
        }
        if (nArray[0] <= 0 && nArray[1] < 51) {
            this.upgradeToVersion(UP_TO_V051_QRY, 51);
        }
        if (nArray[0] <= 0 && nArray[1] < 56) {
            this.upgradeToVersion(UP_TO_V056_QRY, 56);
        }
        if (nArray[0] <= 0 && nArray[1] < 62) {
            this.upgradeToVersion(UP_TO_V062_QRY, 62);
        }
        if (nArray[0] <= 0 && nArray[1] < 65) {
            this.upgradeToVersion(UP_TO_V065_QRY, 65);
        }
        if (nArray[0] <= 0 && nArray[1] < 67) {
            this.upgradeToVersion(UP_TO_V067_QRY, 67);
        }
        if (nArray[0] <= 0 && nArray[1] < 68) {
            this.upgradeToVersion(UP_TO_V068_QRY, 68);
        }
        if (nArray[0] <= 0 && nArray[1] < 72) {
            this.upgradeToVersion(UP_TO_V072_QRY, 72);
        }
        if (nArray[0] <= 0 && nArray[1] < 73) {
            this.upgradeToVersion(UP_TO_V073_QRY, 73);
        }
        if (nArray[0] <= 0 && nArray[1] < 74) {
            this.upgradeToVersion(UP_TO_V074_QRY, 74);
        }
        if (nArray[0] <= 0 && nArray[1] < 75) {
            this.upgradeToVersion(UP_TO_V075_QRY, 75);
        }
        if (nArray[0] <= 0 && nArray[1] < 76) {
            this.upgradeToVersion(UP_TO_V076_QRY, 76);
        }
        if (nArray[0] <= 0 && nArray[1] < 77) {
            this.upgradeToVersion(UP_TO_V077_QRY, 77);
        }
    }

    private void init() {
        Settings settings = Settings.getInstance();
        System.out.println(settings.msg("database.notice.startup"));
        String string = settings.getSettings().getValue("database", "connectionstring");
        if (string.contains("file:")) {
            int n = string.indexOf("file:") + 5;
            int n2 = string.indexOf(59, n);
            if (n2 == -1) {
                n2 = string.length();
            }
            String string2 = FileUtils.getDatabaseFile(string).getPath();
            string = string.substring(0, n) + string2 + string.substring(n2);
        }
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            con = DriverManager.getConnection(string, settings.getSettings().getValue("database", "username"), settings.getSettings().getValue("database", "password"));
            this.initializeIfNecessary();
            this.upgradeIfNecessary();
        }
        catch (SQLException sQLException) {
            Shell shell = new Shell();
            GeneralPurposeDialogs.fatalMessage(shell, settings.msg("database.error.initconnection", new Object[]{StringRelatedUtils.toString(sQLException)}), sQLException);
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException sQLException2) {
                GeneralPurposeDialogs.warningMessage(shell, settings.msg("database.error.connectionclose", new Object[]{StringRelatedUtils.toString(sQLException2)}), sQLException2);
            }
            throw new RuntimeException();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Shell shell = new Shell();
            GeneralPurposeDialogs.fatalMessage(shell, settings.msg("database.error.registerdriver", new Object[]{StringRelatedUtils.toString(classNotFoundException)}), classNotFoundException);
            throw new RuntimeException();
        }
    }

    /*
     * Exception decompiling
     */
    private int identity() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int addSomething(String string, String string2) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(string);){
            preparedStatement.setString(1, string2);
            preparedStatement.executeUpdate();
            int n = this.identity();
            return n;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"add " + string2}));
        }
    }

    private void removeSomething(String string, String string2, int n) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(string);){
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"remove " + string2}));
        }
    }

    /*
     * Exception decompiling
     */
    private List<KeyValuePair> readKeyValuePairList(String var1_1) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void shutdown() throws SQLException {
        System.out.println(Settings.getInstance().msg("database.notice.shutdown"));
        try (Statement statement = con.createStatement();){
            statement.execute("SHUTDOWN");
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.shutdown"));
        }
        finally {
            con.close();
        }
    }

    /*
     * Exception decompiling
     */
    public List<Profile> readProfilesList(String var1_1, String var2_2) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<KeyValuePair> readDevelopersList() throws SQLException {
        return this.readKeyValuePairList(DEV_LIST_QRY);
    }

    public List<KeyValuePair> readPublishersList() throws SQLException {
        return this.readKeyValuePairList(PUBL_LIST_QRY);
    }

    public List<KeyValuePair> readGenresList() throws SQLException {
        return this.readKeyValuePairList(GENRE_LIST_QRY);
    }

    public List<KeyValuePair> readYearsList() throws SQLException {
        return this.readKeyValuePairList(PUBLYEAR_LIST_QRY);
    }

    public List<KeyValuePair> readStatusList() throws SQLException {
        return this.readKeyValuePairList(STATUS_LIST_QRY);
    }

    public List<KeyValuePair> readCustomList(int n) throws SQLException {
        return this.readKeyValuePairList(CUSTOM_LIST_QRY[n]);
    }

    /*
     * Exception decompiling
     */
    public List<DosboxVersion> readDosboxVersionsList() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<Template> readTemplatesList() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<Filter> readFiltersList() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<LogEntry> readLogEntries(String var1_1, String var2_2) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<NativeCommand> readNativeCommandsList(int n, int n2) throws SQLException {
        ArrayList<NativeCommand> arrayList = new ArrayList<NativeCommand>();
        if (n != -1 || n2 != -1) {
            try (PreparedStatement preparedStatement = con.prepareStatement(n != -1 ? NTVCMD_LIST_QRY_GAME : NTVCMD_LIST_QRY_TEMPLATE);){
                preparedStatement.setInt(1, n != -1 ? n : n2);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        arrayList.add(new NativeCommand(new File(resultSet.getString(1)), resultSet.getString(2), new File(resultSet.getString(3)), resultSet.getBoolean(4), resultSet.getInt(5)));
                    }
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"read native commands"}));
            }
        }
        NativeCommand.insertDosboxCommand(arrayList);
        return arrayList;
    }

    public void saveNativeCommands(List<NativeCommand> list, int n, int n2) throws SQLException {
        this.removeNativeCommands(n, n2);
        for (int i = 0; i < list.size(); ++i) {
            NativeCommand nativeCommand = list.get(i);
            if (nativeCommand.getCommand() == null) continue;
            try (PreparedStatement preparedStatement = con.prepareStatement(ADD_NATIVECOMMAND_QRY);){
                preparedStatement.setString(1, nativeCommand.getCommand().getPath());
                preparedStatement.setString(2, nativeCommand.getParameters());
                preparedStatement.setString(3, nativeCommand.getCwd().getPath());
                preparedStatement.setBoolean(4, nativeCommand.isWaitFor());
                preparedStatement.setInt(5, i);
                if (n != -1) {
                    preparedStatement.setInt(6, n);
                } else {
                    preparedStatement.setNull(6, 4);
                }
                if (n2 != -1) {
                    preparedStatement.setInt(7, n2);
                } else {
                    preparedStatement.setNull(7, 4);
                }
                preparedStatement.executeUpdate();
                continue;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"save native commands"}));
            }
        }
    }

    public void removeNativeCommands(int n, int n2) throws SQLException {
        block30: {
            if (n != -1) {
                try (PreparedStatement preparedStatement = con.prepareStatement(REMOVE_NTVCMD_QRY_GAME);){
                    preparedStatement.setInt(1, n);
                    preparedStatement.executeUpdate();
                    break block30;
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"remove native commands"}));
                }
            }
            if (n2 != -1) {
                try (PreparedStatement preparedStatement = con.prepareStatement(REMOVE_NTVCMD_QRY_TEMPLATE);){
                    preparedStatement.setInt(1, n2);
                    preparedStatement.executeUpdate();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"remove native commands"}));
                }
            }
        }
    }

    public void removeProfile(Profile profile) throws SQLException {
        this.removeSomething(REMOVE_GAME_QRY, "profile", profile.getId());
        this.addLogEntry(LogEntry.Event.REMOVE, LogEntry.EntityType.PROFILE, profile.getId(), profile.getTitle());
    }

    public void removeDosboxVersion(DosboxVersion dosboxVersion) throws SQLException {
        try {
            this.removeSomething(REMOVE_DBV_QRY, "dosboxversion", dosboxVersion.getId());
            this.addLogEntry(LogEntry.Event.REMOVE, LogEntry.EntityType.DOSBOXVERSION, dosboxVersion.getId(), dosboxVersion.getTitle());
        }
        catch (SQLException sQLException) {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            try (PreparedStatement preparedStatement = con.prepareStatement(DBV_USE_QRY);){
                preparedStatement.setInt(1, dosboxVersion.getId());
                preparedStatement.setInt(2, dosboxVersion.getId());
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        if (n++ >= 10) continue;
                        if (n > 1) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(resultSet.getString(1));
                    }
                }
            }
            throw new SQLException(Settings.getInstance().msg("general.error.profilesandtemplatesusingdbversion", new Object[]{StringRelatedUtils.toString(sQLException), n, stringBuffer}));
        }
    }

    public void removeTemplate(Template template) throws SQLException {
        this.removeSomething(REMOVE_TEMPL_QRY, "template", template.getId());
        this.addLogEntry(LogEntry.Event.REMOVE, LogEntry.EntityType.TEMPLATE, template.getId(), template.getTitle());
    }

    public void removeFilter(Filter filter) throws SQLException {
        this.removeSomething(REMOVE_FLTR_QRY, "filter", filter.getId());
        this.addLogEntry(LogEntry.Event.REMOVE, LogEntry.EntityType.FILTER, filter.getId(), filter.getTitle());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Profile addOrEditProfile(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, String[] stringArray, String[] stringArray2, int n, int n2, int n3, int n4, int n5, int n6, String[] stringArray3, String[] stringArray4, String[] stringArray5, int[] nArray, int[] nArray2, int n7) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(n7 != -1 ? UPD_GAME_QRY : ADD_GAME_QRY);){
            int n8;
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n == -1 ? this.addSomething(ADD_DEVELOPER_QRY, string2) : n);
            preparedStatement.setInt(3, n2 == -1 ? this.addSomething(ADD_PUBLISHER_QRY, string3) : n2);
            preparedStatement.setInt(4, n3 == -1 ? this.addSomething(ADD_GENRE_QRY, string4) : n3);
            preparedStatement.setInt(5, n4 == -1 ? this.addSomething(ADD_YEAR_QRY, string5) : n4);
            preparedStatement.setInt(6, n5 == -1 ? this.addSomething(ADD_STATUS_QRY, string6) : n5);
            preparedStatement.setString(7, string7);
            preparedStatement.setBoolean(8, bl);
            for (n8 = 0; n8 < stringArray.length; ++n8) {
                preparedStatement.setString(n8 * 2 + 9, stringArray[n8]);
                preparedStatement.setString(n8 * 2 + 10, stringArray2[n8]);
            }
            preparedStatement.setInt(15, n6);
            for (n8 = 0; n8 < stringArray3.length; ++n8) {
                preparedStatement.setString(n8 + 16, stringArray3[n8]);
            }
            for (n8 = 0; n8 < stringArray4.length; ++n8) {
                preparedStatement.setString(n8 + 16 + stringArray3.length, stringArray4[n8]);
            }
            for (n8 = 0; n8 < nArray2.length; ++n8) {
                preparedStatement.setInt(n8 + 16 + stringArray3.length + stringArray4.length, nArray2[n8] == -1 ? this.addSomething(ADD_CUSTOM_QRY[n8], stringArray5[n8]) : nArray2[n8]);
            }
            for (n8 = 0; n8 < 4; ++n8) {
                preparedStatement.setString(n8 + 16 + stringArray3.length + stringArray4.length + nArray2.length, stringArray5[n8 + nArray2.length]);
            }
            for (n8 = 0; n8 < nArray.length; ++n8) {
                preparedStatement.setInt(n8 + 16 + stringArray3.length + stringArray4.length + nArray2.length + 4, nArray[n8]);
            }
            if (n7 != -1) {
                preparedStatement.setInt(16 + stringArray3.length + stringArray4.length + nArray2.length + 4 + nArray.length, n7);
            }
            preparedStatement.executeUpdate();
            n8 = n7 != -1 ? n7 : this.identity();
            this.addLogEntry(n7 != -1 ? LogEntry.Event.EDIT : LogEntry.Event.ADD, LogEntry.EntityType.PROFILE, n8, string);
            Profile profile = Profile.findById(this.readProfilesList("", ""), n8);
            return profile;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"add/edit profile"}));
        }
    }

    public synchronized Profile addOrEditProfile(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, String[] stringArray, String[] stringArray2, int n, String[] stringArray3, String[] stringArray4, String[] stringArray5, int[] nArray, int n2) throws SQLException {
        int n3 = KeyValuePair.findIdByValue(this.readDevelopersList(), string2);
        int n4 = KeyValuePair.findIdByValue(this.readPublishersList(), string3);
        int n5 = KeyValuePair.findIdByValue(this.readGenresList(), string4);
        int n6 = KeyValuePair.findIdByValue(this.readYearsList(), string5);
        int n7 = KeyValuePair.findIdByValue(this.readStatusList(), string6);
        int[] nArray2 = new int[COMPLEX_STRINGS];
        for (int i = 0; i < COMPLEX_STRINGS; ++i) {
            nArray2[i] = KeyValuePair.findIdByValue(this.readCustomList(i), stringArray5[i]);
        }
        return this.addOrEditProfile(string, string2, string3, string4, string5, string6, string7, bl, stringArray, stringArray2, n3, n4, n5, n6, n7, n, stringArray3, stringArray4, stringArray5, nArray, nArray2, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Profile updateProfileConf(String string, String string2, int n) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(UPD_GAME_CONF_QRY);){
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            preparedStatement.setInt(3, n);
            preparedStatement.executeUpdate();
            Profile profile = Profile.findById(this.readProfilesList("", ""), n);
            return profile;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"update profile conf"}));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Profile updateProfileSetupAndLinks(String[] stringArray, String[] stringArray2, int n) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(UPD_STPLNKS_QRY);){
            int n2;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                preparedStatement.setString(n2 + 1, stringArray[n2]);
            }
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                preparedStatement.setString(n2 + 4, stringArray2[n2]);
            }
            preparedStatement.setInt(4 + stringArray2.length, n);
            preparedStatement.executeUpdate();
            Profile profile = Profile.findById(this.readProfilesList("", ""), n);
            return profile;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"update profile setup and links"}));
        }
    }

    public void toggleFavorite(int n) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(TOGGLE_FAV_QRY);){
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"toggle favorite"}));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Profile runProfile(Profile profile) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(RUN_GAME_QRY);){
            preparedStatement.setInt(1, profile.getId());
            preparedStatement.executeUpdate();
            this.addLogEntry(LogEntry.Event.RUN, LogEntry.EntityType.PROFILE, profile.getId(), profile.getTitle());
            Profile profile2 = Profile.findById(this.readProfilesList("", ""), profile.getId());
            return profile2;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"run profile"}));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Profile setupProfile(Profile profile) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(SETUP_GAME_QRY);){
            preparedStatement.setInt(1, profile.getId());
            preparedStatement.executeUpdate();
            this.addLogEntry(LogEntry.Event.SETUP, LogEntry.EntityType.PROFILE, profile.getId(), profile.getTitle());
            Profile profile2 = Profile.findById(this.readProfilesList("", ""), profile.getId());
            return profile2;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"setup profile"}));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Profile duplicateProfile(Profile profile) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(DUPL_GAME_QRY);){
            preparedStatement.setInt(1, profile.getId());
            preparedStatement.executeUpdate();
            int n = this.identity();
            this.addLogEntry(LogEntry.Event.DUPLICATE, LogEntry.EntityType.PROFILE, profile.getId(), profile.getTitle());
            this.addLogEntry(LogEntry.Event.ADD, LogEntry.EntityType.PROFILE, n, profile.getTitle());
            Profile profile2 = Profile.findById(this.readProfilesList("", ""), n);
            return profile2;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"duplicate profile"}));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Template duplicateTemplate(Template template) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(DUPL_TEMPLATE_QRY);){
            preparedStatement.setInt(1, template.getId());
            preparedStatement.executeUpdate();
            int n = this.identity();
            this.addLogEntry(LogEntry.Event.DUPLICATE, LogEntry.EntityType.TEMPLATE, template.getId(), template.getTitle());
            this.addLogEntry(LogEntry.Event.ADD, LogEntry.EntityType.TEMPLATE, n, template.getTitle());
            Template template2 = Template.findById(this.readTemplatesList(), n);
            return template2;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"duplicate template"}));
        }
    }

    /*
     * Exception decompiling
     */
    public DosboxVersion addOrEditDosboxVersion(String var1_1, String var2_2, String var3_3, boolean var4_4, boolean var5_5, boolean var6_6, String var7_7, String var8_8, int var9_9) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void runDosboxVersion(DosboxVersion dosboxVersion) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(RUN_DBVERSION_QRY);){
            preparedStatement.setInt(1, dosboxVersion.getId());
            preparedStatement.executeUpdate();
            this.addLogEntry(LogEntry.Event.RUN, LogEntry.EntityType.DOSBOXVERSION, dosboxVersion.getId(), dosboxVersion.getTitle());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"run dosboxversion"}));
        }
    }

    /*
     * Exception decompiling
     */
    public Template addOrEditTemplate(String var1_1, int var2_2, boolean var3_3, int var4_4) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void runTemplate(Template template) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(RUN_TEMPLATE_QRY);){
            preparedStatement.setInt(1, template.getId());
            preparedStatement.executeUpdate();
            this.addLogEntry(LogEntry.Event.RUN, LogEntry.EntityType.TEMPLATE, template.getId(), template.getTitle());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"run template"}));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addOrEditFilter(String string, String string2, int n) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(n != -1 ? UPD_FILTER_QRY : ADD_FILTER_QRY);){
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            if (n != -1) {
                preparedStatement.setInt(3, n);
            }
            preparedStatement.executeUpdate();
            int n2 = n != -1 ? n : this.identity();
            this.addLogEntry(n != -1 ? LogEntry.Event.EDIT : LogEntry.Event.ADD, LogEntry.EntityType.FILTER, n2, string);
            int n3 = n2;
            return n3;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"add/edit filter"}));
        }
    }

    public void addLogEntry(LogEntry.Event event, LogEntry.EntityType entityType, int n, String string) throws SQLException {
        if (Settings.getInstance().getSettings().getBooleanValue("log", "enabled")) {
            try (PreparedStatement preparedStatement = con.prepareStatement(ADD_LOG_QRY);){
                preparedStatement.setByte(1, (byte)event.ordinal());
                preparedStatement.setByte(2, (byte)entityType.ordinal());
                preparedStatement.setInt(3, n);
                preparedStatement.setString(4, string);
                preparedStatement.executeUpdate();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"add log entry"}));
            }
        }
    }

    public void clearLog() throws SQLException {
        try (Statement statement = con.createStatement();){
            ResultSet resultSet = statement.executeQuery(CLEAR_LOG_QRY);
            Throwable throwable = null;
            if (resultSet != null) {
                if (throwable != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    resultSet.close();
                }
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"clear log"}));
        }
    }

    public void startTransaction() {
        try {
            con.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void rollbackTransaction() throws SQLException {
        con.rollback();
    }

    public void commitTransaction() throws SQLException {
        con.commit();
    }

    public void finishTransaction() {
        try {
            con.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int cleanup() throws SQLException {
        try (Statement statement = con.createStatement();){
            int n3;
            void n2;
            String[] objectArray = CLEANUP_QRY.split(";");
            int n = objectArray.length;
            boolean bl = false;
            while (n2 < n) {
                String string = objectArray[n2];
                statement.addBatch(string);
                ++n2;
            }
            int[] nArray = statement.executeBatch();
            n = 0;
            int[] nArray2 = nArray;
            int n4 = nArray2.length;
            for (int i = 0; i < n4; n += n3, ++i) {
                n3 = nArray2[i];
            }
            int n42 = n;
            return n42;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(Settings.getInstance().msg("database.error.query", new Object[]{"cleanup"}));
        }
    }

    /*
     * Exception decompiling
     */
    public List<Profile> findInvalidProfiles() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class DatabaseHolder {
        private static Database instance = new Database();

        private DatabaseHolder() {
        }
    }
}

