/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.GenericType;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.db.Database;
import org.dbgl.gui.BrowseButton;
import org.dbgl.gui.BrowseSearchEngineDialog;
import org.dbgl.gui.EditMountDialog;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.LoadSharedConfDialog;
import org.dbgl.gui.Wizard;
import org.dbgl.loopy.iso9660.ISO9660FileSystem;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.KeyValuePair;
import org.dbgl.model.Mount;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.Profile;
import org.dbgl.model.Template;
import org.dbgl.model.WebProfile;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.SectionsWrapper;
import org.dbgl.model.conf.Settings;
import org.dbgl.model.conf.SharedConf;
import org.dbgl.swtdesigner.SWTImageManager;
import org.dbgl.util.FileUtils;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.searchengine.HotudSearchEngine;
import org.dbgl.util.searchengine.MobyGamesSearchEngine;
import org.dbgl.util.searchengine.PouetSearchEngine;
import org.dbgl.util.searchengine.TheGamesDBSearchEngine;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class AddGameWizardDialog
extends Wizard {
    static final List<WebSearchEngine> webSearchEngines = Arrays.asList(MobyGamesSearchEngine.getInstance(), PouetSearchEngine.getInstance(), HotudSearchEngine.getInstance(), TheGamesDBSearchEngine.getInstance());
    private static final String[] CUST_STRINGS = new String[]{"", "", "", "", "", "", "", ""};
    private Text title;
    private String developer;
    private String publisher;
    private String year;
    private String genre;
    private String notes;
    private String[] link = new String[]{"", "", "", "", "", "", "", ""};
    private String[] linkTitle = new String[]{"", "", "", "", "", "", "", ""};
    private final int[] customInts = new int[]{0, 0};
    private Button moveImages;
    private Button templateReload;
    private ToolItem loadSharedConfButton;
    private ToolItem engineSelector;
    private Button btnPreinstalledGame;
    private Button btnGameNeedsToBeInstalled;
    private Button btnInstallManual;
    private Button btnPatchManual;
    private Combo main;
    private Combo setup;
    private Text mainText;
    private Text setupText;
    private Text installExe;
    private Text installParameters;
    private Text patchExe;
    private Text patchParameters;
    private Text dstDirectory;
    private Text imagesDstDirectory;
    private org.eclipse.swt.widgets.List mountingpoints;
    private File[] installedFiles;
    private List<File> orgImages;
    private org.eclipse.swt.widgets.List installedFilesList;
    private org.eclipse.swt.widgets.List orgImagesList;
    private Combo template;
    private Combo machine;
    private Combo core;
    private Combo cycles;
    private Database dbase;
    private List<DosboxVersion> dbversionsList;
    private List<Template> templatesList;
    private ExpProfile profile;
    private int templateIndex = -1;

    public AddGameWizardDialog(Shell shell, int n) {
        super(shell, n, Settings.getInstance().msg("dialog.addgamewizard.title"), "addgamewizard", false);
    }

    @Override
    protected boolean init() {
        this.dbase = Database.getInstance();
        try {
            this.dbversionsList = this.dbase.readDosboxVersionsList();
            this.templatesList = this.dbase.readTemplatesList();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            DosboxVersion dosboxVersion = DosboxVersion.findDefault(this.dbversionsList);
            this.templateIndex = Template.indexOfDefault(this.templatesList);
            if (this.templateIndex != -1) {
                List<NativeCommand> list = this.dbase.readNativeCommandsList(-1, this.templatesList.get(this.templateIndex).getId());
                this.profile = new ExpProfile(new Conf((File)null, this.templatesList.get(this.templateIndex), dosboxVersion, printStream), list);
            } else {
                List<NativeCommand> list = this.dbase.readNativeCommandsList(-1, -1);
                this.profile = new ExpProfile(new Conf((File)null, (Template)null, dosboxVersion, printStream), list);
            }
            this.developer = "";
            this.publisher = "";
            this.year = "";
            this.genre = "";
            this.notes = "";
            return true;
        }
        catch (Exception exception) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), exception);
            return false;
        }
    }

    @Override
    protected void onExit() {
        try {
            org.apache.commons.io.FileUtils.deleteDirectory((File)FileUtils.getTmpInstallFile());
        }
        catch (IOException iOException) {
            GeneralPurposeDialogs.warningMessage(this.shell, iOException);
        }
    }

    @Override
    protected int stepSize(boolean bl) {
        if (this.btnPreinstalledGame.getSelection()) {
            if (bl && this.stepNr == 0 || !bl && this.stepNr == 4) {
                return 4;
            }
            if (bl && this.stepNr == 4 || !bl && this.stepNr == 6) {
                return 2;
            }
        } else if (bl && this.stepNr == 3 || !bl && this.stepNr == 5) {
            return 2;
        }
        return super.stepSize(bl);
    }

    @Override
    protected boolean isValidInput() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.stepNr == 0) {
            return this.titleEntered();
        }
        if (this.stepNr == 1) {
            return this.installExeEntered();
        }
        if (this.stepNr == 2) {
            return true;
        }
        if (this.stepNr == 3) {
            return this.mainExeEntered();
        }
        if (this.stepNr == 4) {
            return this.mainExeEntered();
        }
        if (this.stepNr == 5) {
            return this.conditionsOkForStep5();
        }
        if (this.stepNr == 6) {
            return true;
        }
        return true;
    }

    @Override
    protected boolean actionAfterNext() {
        if (this.stepNr == 0) {
            return this.doWebSearch();
        }
        if (this.stepNr == 1) {
            return this.runInstallerAndCheckResults();
        }
        if (this.stepNr == 2) {
            return this.determineMainAndSetup();
        }
        if (this.stepNr == 3) {
            return this.setMain();
        }
        if (this.stepNr == 4) {
            return this.setMain();
        }
        if (this.stepNr == 5) {
            return true;
        }
        if (this.stepNr == 6) {
            return this.createProfile();
        }
        return false;
    }

    protected void doReloadTemplate(int n) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            Conf conf = new Conf(this.templatesList.get(n), this.profile.getConf().getDbversion(), printStream);
            this.profile.getConf().reloadTemplate(conf);
            this.selectSettingsByConfiguration(this.profile.getConf());
            this.profile.setNativeCommandsList(this.dbase.readNativeCommandsList(-1, this.templatesList.get(n).getId()));
            if (byteArrayOutputStream.size() > 0) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), byteArrayOutputStream.toString());
                byteArrayOutputStream.reset();
            }
        }
        catch (IOException | SQLException exception) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), exception);
        }
    }

    protected void selectSettingsByConfiguration(Conf conf) {
        SectionsWrapper sectionsWrapper = conf.getSettings();
        this.machine.setText(sectionsWrapper.getValue("dosbox", "machine"));
        this.core.setText(sectionsWrapper.getValue("cpu", "core"));
        this.cycles.setText(sectionsWrapper.getValue("cpu", "cycles"));
    }

    protected void updateConfigurationBySettings(Conf conf) {
        conf.updateValue("dosbox", "machine", this.machine.getText(), true);
        conf.updateValue("cpu", "core", this.core.getText(), true);
        conf.updateValue("cpu", "cycles", this.cycles.getText(), true);
    }

    protected void doAddMount() {
        EditMountDialog editMountDialog = new EditMountDialog(this.shell);
        try {
            editMountDialog.setDefaultDriveletter(Mount.getFreeDriveletter(false, this.profile.getConf().nettoMountedDriveLetters()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = (String)editMountDialog.open();
        if (string != null) {
            this.mountingpoints.setItems(this.profile.getConf().addMount(string));
            this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
        }
    }

    protected void doEditMount() {
        int n = this.mountingpoints.getItemCount();
        int n2 = this.mountingpoints.getSelectionIndex();
        if (n2 != -1) {
            EditMountDialog editMountDialog = new EditMountDialog(this.shell);
            editMountDialog.setMount(this.mountingpoints.getItem(n2));
            String string = (String)editMountDialog.open();
            if (string != null) {
                this.mountingpoints.setItems(this.profile.getConf().editMount(n2, string));
                if (this.mountingpoints.getItemCount() == n) {
                    this.mountingpoints.select(n2);
                } else {
                    this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
                }
            }
        }
    }

    protected void doRemoveMount() {
        int n = this.mountingpoints.getItemCount();
        int n2 = this.mountingpoints.getSelectionIndex();
        if (n2 == -1 && n == 1) {
            n2 = 0;
            this.mountingpoints.select(n2);
        }
        if (n2 != -1) {
            this.mountingpoints.setItems(this.profile.getConf().removeMount(n2));
            if (this.mountingpoints.getItemCount() == n) {
                this.mountingpoints.select(n2);
            } else if (this.mountingpoints.getItemCount() > 0) {
                this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
            }
        }
    }

    private boolean titleEntered() {
        if (this.title.getText().trim().length() <= 0) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.title"), (Control)this.title);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    private boolean doWebSearch() {
        Object object;
        List list;
        Object object2;
        Object object3;
        String string;
        if (((Boolean)this.loadSharedConfButton.getData("selected")).booleanValue() && (string = this.title.getText()).length() >= 1) {
            try {
                object3 = ClientBuilder.newClient();
                object2 = new GenericType<List<SharedConf>>(){};
                list = (List)object3.target(this.settings.getSettings().getValue("confsharing", "endpoint")).path("/configurations/bytitle/{i}").resolveTemplate("i", (Object)string).request().accept(new String[]{"application/xml"}).get((GenericType)object2);
                object3.close();
                if (list.size() == 0) {
                    GeneralPurposeDialogs.infoMessage(this.shell, this.settings.msg("general.notice.searchenginenoresults", new String[]{"DBConfWS", string}));
                } else {
                    object = (LoadSharedConfDialog.SharedConfLoading)new LoadSharedConfDialog(this.shell, string, list).open();
                    if (object != null) {
                        this.profile.getConf().loadSharedConf(((LoadSharedConfDialog.SharedConfLoading)object).conf.getIncrConf(), ((LoadSharedConfDialog.SharedConfLoading)object).reloadDosboxDefaults);
                        this.selectSettingsByConfiguration(this.profile.getConf());
                    }
                }
            }
            catch (Exception exception) {
                GeneralPurposeDialogs.warningMessage(this.shell, this.settings.msg("general.error.retrieveinfosearchengine", new String[]{"DBConfWS", string, StringRelatedUtils.toString(exception)}), exception);
            }
        }
        if (((Boolean)this.engineSelector.getData("selected")).booleanValue() && (string = this.title.getText()).length() >= 1) {
            object3 = this.getSelectedSearchEngine();
            try {
                object2 = null;
                list = ((WebSearchEngine)object3).getEntries(string, this.settings.getSettings().getValues(((WebSearchEngine)object3).getSimpleName(), "platform_filter"));
                if (list.size() >= 1) {
                    object = new BrowseSearchEngineDialog(this.shell);
                    ((BrowseSearchEngineDialog)((Object)object)).setProfilesToBrowse(string, list);
                    ((BrowseSearchEngineDialog)((Object)object)).setEngine((WebSearchEngine)object3);
                    Integer n = (Integer)((BrowseSearchEngineDialog)((Object)object)).open();
                    if (n != null) {
                        object2 = (WebProfile)list.get(n);
                    }
                }
                if (object2 != null) {
                    object = ((WebSearchEngine)object3).getEntryDetailedInformation((WebProfile)object2);
                    if (this.settings.getSettings().getBooleanValue(((WebSearchEngine)object3).getSimpleName(), "set_title")) {
                        this.title.setText(((WebProfile)object).getTitle());
                    }
                    if (this.settings.getSettings().getBooleanValue(((WebSearchEngine)object3).getSimpleName(), "set_developer")) {
                        this.developer = ((WebProfile)object).getDeveloperName();
                    }
                    if (this.settings.getSettings().getBooleanValue(((WebSearchEngine)object3).getSimpleName(), "set_publisher")) {
                        this.publisher = ((WebProfile)object).getPublisherName();
                    }
                    if (this.settings.getSettings().getBooleanValue(((WebSearchEngine)object3).getSimpleName(), "set_year")) {
                        this.year = ((WebProfile)object).getYear();
                    }
                    if (this.settings.getSettings().getBooleanValue(((WebSearchEngine)object3).getSimpleName(), "set_genre")) {
                        this.genre = ((WebProfile)object).getGenre();
                    }
                    if (this.settings.getSettings().getBooleanValue(((WebSearchEngine)object3).getSimpleName(), "set_link")) {
                        this.link[0] = ((WebProfile)object).getUrl();
                        this.linkTitle[0] = this.settings.msg("dialog.profile.searchengine.link.maininfo", new String[]{((WebSearchEngine)object3).getName()});
                    }
                    if (this.settings.getSettings().getBooleanValue(((WebSearchEngine)object3).getSimpleName(), "set_description")) {
                        this.notes = ((WebProfile)object).getNotes();
                    }
                    if (this.settings.getSettings().getBooleanValue(((WebSearchEngine)object3).getSimpleName(), "set_rank")) {
                        this.customInts[0] = ((WebProfile)object).getRank();
                    }
                }
            }
            catch (Exception exception) {
                GeneralPurposeDialogs.warningMessage(this.shell, this.settings.msg("general.error.retrieveinfosearchengine", new String[]{((WebSearchEngine)object3).getName(), string, StringRelatedUtils.toString(exception)}), exception);
            }
        }
        if (this.btnGameNeedsToBeInstalled.getSelection() && StringUtils.isBlank((CharSequence)this.installExe.getText())) {
            this.profile.getConf().unmountDosboxMounts();
            this.profile.getConf().addMount("mount C \"" + FileUtils.getTmpInstallFile() + "\"");
            this.mountingpoints.setItems(this.profile.getConf().getAutoexec().getMountingpoints());
        }
        return true;
    }

    private boolean installExeEntered() {
        if (this.installExe.getText().trim().length() <= 0) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.addgamewizard.required.installexe"), (Control)this.installExe);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    private boolean runInstallerAndCheckResults() {
        try {
            org.apache.commons.io.FileUtils.deleteDirectory((File)FileUtils.getTmpInstallFile());
            FileUtils.createDir(FileUtils.getTmpInstallFile());
            this.profile.getConf().getAutoexec().setMainExecutable(this.installExe.getText(), this.installParameters.getText());
            FileUtils.doRunInstaller(this.profile, this.profile.getConf(), this.dbversionsList, null, this.btnInstallManual.getSelection());
            this.shell.forceFocus();
            this.shell.forceActive();
            this.orgImages = new ArrayList<File>();
            File[] fileArray = this.profile.getConf().getFirstImageMountPath();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    this.orgImages.add(FileUtils.canonicalToDosroot(file2.getPath()));
                }
            }
            ArrayList arrayList = new ArrayList();
            for (File file : this.orgImages) {
                File file2;
                if (!file.getName().toLowerCase().endsWith(FileUtils.CDIMAGES[1]) || (file2 = ISO9660FileSystem.parseCueSheet(file)) == null || !file.getParentFile().equals(file2.getParentFile())) continue;
                arrayList.add(FileUtils.canonicalToDosroot(file2.getPath()));
            }
            this.orgImages.addAll(arrayList);
            this.installedFiles = FileUtils.getTmpInstallFile().listFiles();
            if (this.installedFiles.length == 0) {
                GeneralPurposeDialogs.warningMessage(this.shell, this.settings.msg("dialog.addgamewizard.error.nofilesinstalled"));
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            GeneralPurposeDialogs.warningMessage(this.shell, iOException);
            return false;
        }
    }

    private boolean determineMainAndSetup() {
        int n;
        if (this.patchExe.getText().trim().length() > 0) {
            try {
                this.profile.getConf().getAutoexec().setMainExecutable(this.patchExe.getText(), this.patchParameters.getText());
                FileUtils.doRunInstaller(this.profile, this.profile.getConf(), this.dbversionsList, null, this.btnPatchManual.getSelection());
                this.shell.forceFocus();
                this.shell.forceActive();
            }
            catch (IOException iOException) {
                GeneralPurposeDialogs.warningMessage(this.shell, iOException);
                return false;
            }
        }
        this.orgImagesList.removeAll();
        if (this.orgImages != null) {
            for (File object2 : this.orgImages) {
                this.orgImagesList.add(FileUtils.makeRelativeToDosroot(object2).getPath());
            }
        }
        this.orgImagesList.selectAll();
        this.orgImagesList.pack();
        this.orgImagesList.getParent().layout();
        this.installedFilesList.removeAll();
        Object object3 = null;
        for (File file : this.installedFiles) {
            if (file.isDirectory()) {
                this.installedFilesList.add("[ " + FileUtils.makeRelativeToDosroot(file).getPath() + " ]");
                if (object3 != null) continue;
                object3 = file;
                continue;
            }
            this.installedFilesList.add(FileUtils.makeRelativeToDosroot(file).getPath());
        }
        this.installedFilesList.selectAll();
        this.installedFilesList.pack();
        this.installedFilesList.getParent().layout();
        this.moveImages.setEnabled(this.profile.getConf().countImageMounts() == 1);
        String string = this.settings.getSettings().getValue("directory", "orgimages");
        File file = object3 != null ? new File(((File)object3).getName(), string) : new File(string);
        this.imagesDstDirectory.setText(file.getPath());
        List<File> list = FileUtils.getExecutablesInDirRecursive(FileUtils.getTmpInstallFile());
        this.main.removeAll();
        this.setup.removeAll();
        this.setup.add("");
        for (File file2 : list) {
            this.main.add(FileUtils.makeRelativeToDosroot(file2).getPath());
            this.setup.add(FileUtils.makeRelativeToDosroot(file2).getPath());
        }
        if (list.isEmpty()) {
            this.main.add(this.installExe.getText());
        }
        if ((n = FileUtils.findMostLikelyMainIndex(this.title.getText(), list)) != -1) {
            this.main.select(n);
        } else {
            this.main.select(0);
        }
        int n2 = FileUtils.findSetupIndex(list);
        if (n2 != -1) {
            this.setup.select(n2 + 1);
        } else {
            this.setup.select(0);
        }
        this.setup.setEnabled(this.setup.getItemCount() > 1);
        return true;
    }

    private boolean mainExeEntered() {
        if (this.btnPreinstalledGame.getSelection()) {
            if (this.mainText.getText().trim().length() <= 0) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.mainexe"), (Control)this.mainText);
            }
        } else if (this.main.getText().trim().length() <= 0) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.mainexe"), (Control)this.main);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    private boolean setMain() {
        if (this.btnPreinstalledGame.getSelection()) {
            if (this.profile.getConf().getRequiredMount(false, this.mainText.getText()) != null) {
                this.profile.getConf().addRequiredMount(false, this.mainText.getText());
            }
            this.profile.getConf().getAutoexec().setMainExecutable(this.mainText.getText(), "");
        } else {
            if (this.profile.getConf().getRequiredMount(false, this.main.getText()) != null) {
                this.profile.getConf().addRequiredMount(false, this.main.getText());
            }
            this.profile.getConf().getAutoexec().setMainExecutable(this.main.getText(), "");
        }
        return true;
    }

    private boolean conditionsOkForStep5() {
        if (this.btnPreinstalledGame.getSelection()) {
            return true;
        }
        try {
            if (this.installedFilesList.getSelectionCount() > 0) {
                File file = new File(this.dstDirectory.getText());
                if (!file.isDirectory() && GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.addgamewizard.confirm.createdestinationdir", new String[]{file.toString()}))) {
                    file.mkdirs();
                }
                if (!file.isDirectory()) {
                    GeneralPurposeDialogs.addError(this.settings.msg("dialog.addgamewizard.error.destinationdirmissing", new String[]{file.toString()}), (Control)this.dstDirectory);
                } else {
                    for (int i = 0; i < this.installedFiles.length; ++i) {
                        File file2;
                        if (!this.installedFilesList.isSelected(i) || !org.apache.commons.io.FileUtils.directoryContains((File)file, (File)(file2 = new File(file, this.installedFiles[i].getName())))) continue;
                        GeneralPurposeDialogs.addError(this.settings.msg("dialog.addgamewizard.error.gamedatadirexists", new String[]{file2.toString()}), (Control)this.dstDirectory);
                    }
                }
            } else {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.addgamewizard.error.gamedatamustbemoved"), (Control)this.installedFilesList);
            }
            return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
        }
        catch (IOException iOException) {
            GeneralPurposeDialogs.warningMessage(this.shell, iOException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createProfile() {
        try {
            boolean bl;
            Object object;
            String string;
            String string2 = string = this.btnPreinstalledGame.getSelection() ? this.setupText.getText() : this.setup.getText();
            if (this.installedFilesList.getSelectionCount() > 0) {
                object = new File(this.dstDirectory.getText());
                this.profile.getConf().getAutoexec().migrateTo(FileUtils.getTmpInstallFile(), (File)object);
                this.profile.getConf().removeFloppyMounts();
                this.profile.getConf().removeUnnecessaryMounts();
                if (StringUtils.isNotBlank((CharSequence)string)) {
                    string = FileUtils.makeRelativeTo(FileUtils.canonicalToDosroot(string), FileUtils.getTmpInstallFile()).getPath();
                    string = FileUtils.makeRelativeToDosroot(new File((File)object, string)).getPath();
                }
                for (bl = false; bl < this.installedFiles.length; bl += 1) {
                    File file = this.installedFiles[bl];
                    if (!this.installedFilesList.isSelected(bl ? 1 : 0)) continue;
                    org.apache.commons.io.FileUtils.moveToDirectory((File)file, (File)object, (boolean)true);
                }
                if (this.moveImages.getSelection()) {
                    File file = new File((File)object, this.imagesDstDirectory.getText());
                    FileUtils.createDir(file);
                    for (int i = 0; i < this.orgImages.size(); ++i) {
                        File file2 = this.orgImages.get(i);
                        if (!this.orgImagesList.isSelected(i)) continue;
                        org.apache.commons.io.FileUtils.moveToDirectory((File)file2, (File)file, (boolean)true);
                        this.profile.getConf().getAutoexec().migrateTo(file2, new File(file, file2.getName()));
                    }
                }
            }
            object = "";
            bl = false;
            int n = KeyValuePair.findIdByValue(this.dbase.readDevelopersList(), this.developer);
            int n2 = KeyValuePair.findIdByValue(this.dbase.readPublishersList(), this.publisher);
            int n3 = KeyValuePair.findIdByValue(this.dbase.readGenresList(), this.genre);
            int n4 = KeyValuePair.findIdByValue(this.dbase.readYearsList(), this.year);
            int n5 = KeyValuePair.findIdByValue(this.dbase.readStatusList(), (String)object);
            int[] nArray = new int[]{0, 0, 0, 0};
            for (int i = 0; i < 4; ++i) {
                nArray[i] = KeyValuePair.findIdByValue(this.dbase.readCustomList(i), "");
            }
            this.dbase.startTransaction();
            Profile profile = this.dbase.addOrEditProfile(this.title.getText(), this.developer, this.publisher, this.genre, this.year, (String)object, this.notes, bl, new String[]{string, "", ""}, new String[]{"", "", ""}, n, n2, n3, n4, n5, this.profile.getDbversionId(), this.link, this.linkTitle, CUST_STRINGS, this.customInts, nArray, -1);
            this.dbase.saveNativeCommands(this.profile.getNativeCommandsList(), profile.getId(), -1);
            String string3 = FileUtils.constructUniqueConfigFileString(profile.getId(), this.title.getText(), this.profile.getConf().getAutoexec().isIncomplete() ? null : this.profile.getConf().getAutoexec().getCanonicalMainDir());
            String string4 = FileUtils.constructCapturesDir(profile.getId());
            FileUtils.createDir(FileUtils.canonicalToData(string4));
            profile = this.dbase.updateProfileConf(string3, string4, profile.getId());
            this.updateConfigurationBySettings(this.profile.getConf());
            this.profile.getConf().injectOrUpdateProfile(profile);
            this.profile.getConf().save();
            this.dbase.commitTransaction();
            this.result = profile;
        }
        catch (IOException | SQLException exception) {
            GeneralPurposeDialogs.warningMessage(this.shell, exception);
            try {
                this.dbase.rollbackTransaction();
            }
            catch (SQLException sQLException) {
                GeneralPurposeDialogs.warningMessage(this.shell, sQLException);
            }
        }
        finally {
            this.dbase.finishTransaction();
        }
        return true;
    }

    private WebSearchEngine getSearchEngineBySimpleName(String string) {
        for (WebSearchEngine webSearchEngine : webSearchEngines) {
            if (!webSearchEngine.getSimpleName().equalsIgnoreCase(string)) continue;
            return webSearchEngine;
        }
        return null;
    }

    private WebSearchEngine getSelectedSearchEngine() {
        WebSearchEngine webSearchEngine = null;
        for (WebSearchEngine webSearchEngine2 : webSearchEngines) {
            if (!webSearchEngine2.getName().equals(this.engineSelector.getData("engine"))) continue;
            webSearchEngine = webSearchEngine2;
        }
        return webSearchEngine;
    }

    @Override
    protected void fillPages() {
        this.addStep(this.page0());
        this.addStep(this.page1());
        this.addStep(this.page2());
        this.addStep(this.page3());
        this.addStep(this.page4());
        this.addStep(this.page5());
        this.addStep(this.page6());
    }

    private Control page0() {
        MenuItem menuItem;
        WebSearchEngine webSearchEngine3;
        Group group = new Group((Composite)this.shell, 0);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setText(this.settings.msg("dialog.addgamewizard.step1"));
        group.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label((Composite)group, 0);
        label.setText(this.settings.msg("dialog.profile.title"));
        this.title = new Text((Composite)group, 2048);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.title.setFocus();
        WebSearchEngine webSearchEngine2 = this.getSearchEngineBySimpleName(this.settings.getSettings().getValue("gui", "searchengine"));
        if (webSearchEngine2 == null) {
            webSearchEngine2 = webSearchEngines.get(0);
        }
        final ToolBar toolBar = new ToolBar((Composite)group, 0x800000);
        this.engineSelector = new ToolItem(toolBar, 4);
        boolean bl = this.settings.getSettings().getBooleanValue("addgamewizard", "consultsearchengine");
        if (bl) {
            this.engineSelector.setImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), webSearchEngine2.getIcon()));
        } else {
            this.engineSelector.setImage(SWTImageManager.createDisabledImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), webSearchEngine2.getIcon())));
        }
        this.engineSelector.setData("selected", (Object)bl);
        this.engineSelector.setToolTipText(this.settings.msg("dialog.profile.consultsearchengine", new String[]{webSearchEngine2.getName()}));
        this.engineSelector.setData("engine", (Object)webSearchEngine2.getName());
        final Menu menu = new Menu((Decorations)this.shell, 8);
        for (final WebSearchEngine webSearchEngine3 : webSearchEngines) {
            menuItem = new MenuItem(menu, 8);
            menuItem.setImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), webSearchEngine3.getIcon()));
            menuItem.setText(webSearchEngine3.getName());
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    MenuItem menuItem = (MenuItem)selectionEvent.widget;
                    AddGameWizardDialog.this.engineSelector.setImage(menuItem.getImage());
                    AddGameWizardDialog.this.engineSelector.setData("engine", (Object)menuItem.getText());
                    AddGameWizardDialog.this.engineSelector.setToolTipText(AddGameWizardDialog.this.settings.msg("dialog.profile.consultsearchengine", new String[]{AddGameWizardDialog.this.engineSelector.getData("engine").toString()}));
                    AddGameWizardDialog.this.engineSelector.setData("selected", (Object)true);
                    AddGameWizardDialog.this.settings.getSettings().setBooleanValue("addgamewizard", "consultsearchengine", true);
                    AddGameWizardDialog.this.settings.getSettings().setValue("gui", "searchengine", webSearchEngine3.getSimpleName());
                }
            });
        }
        this.engineSelector.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    Rectangle rectangle = AddGameWizardDialog.this.engineSelector.getBounds();
                    Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
                    point = toolBar.toDisplay(point);
                    menu.setLocation(point.x, point.y);
                    menu.setVisible(true);
                } else {
                    boolean bl;
                    WebSearchEngine webSearchEngine = AddGameWizardDialog.this.getSelectedSearchEngine();
                    boolean bl2 = bl = (Boolean)AddGameWizardDialog.this.engineSelector.getData("selected") == false;
                    if (bl) {
                        AddGameWizardDialog.this.engineSelector.setImage(SWTImageManager.getResourceImage(AddGameWizardDialog.this.shell.getDisplay(), webSearchEngine.getIcon()));
                    } else {
                        AddGameWizardDialog.this.engineSelector.setImage(SWTImageManager.createDisabledImage(SWTImageManager.getResourceImage(AddGameWizardDialog.this.shell.getDisplay(), webSearchEngine.getIcon())));
                    }
                    AddGameWizardDialog.this.engineSelector.setData("selected", (Object)bl);
                    AddGameWizardDialog.this.settings.getSettings().setBooleanValue("addgamewizard", "consultsearchengine", bl);
                }
            }
        });
        this.loadSharedConfButton = new ToolItem(toolBar, 8);
        boolean bl2 = this.settings.getSettings().getBooleanValue("addgamewizard", "consultdbconfws");
        if (bl2) {
            this.loadSharedConfButton.setImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), "share.png"));
        } else {
            this.loadSharedConfButton.setImage(SWTImageManager.createDisabledImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), "share.png")));
        }
        this.loadSharedConfButton.setData("selected", (Object)bl2);
        this.loadSharedConfButton.setToolTipText(this.settings.msg("button.consultconfsearchengine", new String[]{"DBConfWS"}));
        this.loadSharedConfButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (((Boolean)AddGameWizardDialog.this.loadSharedConfButton.getData("selected")).booleanValue()) {
                    AddGameWizardDialog.this.loadSharedConfButton.setImage(SWTImageManager.createDisabledImage(SWTImageManager.getResourceImage(AddGameWizardDialog.this.shell.getDisplay(), "share.png")));
                    AddGameWizardDialog.this.loadSharedConfButton.setData("selected", (Object)false);
                    AddGameWizardDialog.this.settings.getSettings().setBooleanValue("addgamewizard", "consultdbconfws", false);
                } else {
                    AddGameWizardDialog.this.loadSharedConfButton.setImage(SWTImageManager.getResourceImage(AddGameWizardDialog.this.shell.getDisplay(), "share.png"));
                    AddGameWizardDialog.this.loadSharedConfButton.setData("selected", (Object)true);
                    AddGameWizardDialog.this.settings.getSettings().setBooleanValue("addgamewizard", "consultdbconfws", true);
                }
            }
        });
        webSearchEngine3 = new Composite((Composite)group, 0);
        webSearchEngine3.setLayout((Layout)new GridLayout());
        menuItem = new GridData(4, 0x1000000, true, false, 4, 1);
        menuItem.verticalIndent = 20;
        webSearchEngine3.setLayoutData(menuItem);
        Label label2 = new Label((Composite)webSearchEngine3, 0);
        label2.setText(this.settings.msg("dialog.addgamewizard.thisgame"));
        this.btnPreinstalledGame = new Button((Composite)webSearchEngine3, 16);
        this.btnPreinstalledGame.setText(this.settings.msg("dialog.addgamewizard.preinstalled"));
        this.btnGameNeedsToBeInstalled = new Button((Composite)webSearchEngine3, 16);
        this.btnGameNeedsToBeInstalled.setText(this.settings.msg("dialog.addgamewizard.notyetinstalled"));
        boolean bl3 = this.settings.getSettings().getBooleanValue("addgamewizard", "requiresinstallation");
        this.btnPreinstalledGame.setSelection(!bl3);
        this.btnGameNeedsToBeInstalled.setSelection(bl3);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddGameWizardDialog.this.settings.getSettings().setBooleanValue("addgamewizard", "requiresinstallation", selectionEvent.widget == AddGameWizardDialog.this.btnGameNeedsToBeInstalled);
            }
        };
        this.btnPreinstalledGame.addSelectionListener((SelectionListener)selectionAdapter);
        this.btnGameNeedsToBeInstalled.addSelectionListener((SelectionListener)selectionAdapter);
        return group;
    }

    private Control page1() {
        Group group = new Group((Composite)this.shell, 0);
        group.setText(this.settings.msg("dialog.addgamewizard.step2"));
        group.setLayout((Layout)new GridLayout());
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText(this.settings.msg("dialog.addgamewizard.installexe"));
        this.installExe = new Text(composite, 2048);
        this.installExe.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        BrowseButton browseButton = new BrowseButton(composite, 0);
        browseButton.connect(this.shell, this.installExe, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.INSTALLER, false, null);
        Label label2 = new Label(composite, 0);
        label2.setText(this.settings.msg("dialog.profile.mainparameters"));
        this.installParameters = new Text(composite, 2048);
        this.installParameters.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label label3 = new Label(composite, 0);
        label3.setText(this.settings.msg("dialog.addgamewizard.manualmode"));
        this.btnInstallManual = new Button(composite, 32);
        this.btnInstallManual.setText(this.settings.msg("dialog.addgamewizard.manualmodeinfo"));
        this.btnInstallManual.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        Group group2 = new Group((Composite)group, 0);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.verticalIndent = 20;
        group2.setLayoutData((Object)gridData);
        group2.setText(this.settings.msg("dialog.template.mountingoverview"));
        group2.setLayout((Layout)new GridLayout(2, false));
        this.mountingpoints = new org.eclipse.swt.widgets.List((Composite)group2, 2560);
        this.mountingpoints.setLayoutData((Object)new GridData(4, 4, true, false, 1, 3));
        this.mountingpoints.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                if (AddGameWizardDialog.this.mountingpoints.getSelectionIndex() == -1) {
                    AddGameWizardDialog.this.doAddMount();
                } else {
                    AddGameWizardDialog.this.doEditMount();
                }
            }
        });
        Button button = new Button((Composite)group2, 0);
        button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button.setText(this.settings.msg("dialog.template.mount.add"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddGameWizardDialog.this.doAddMount();
            }
        });
        Button button2 = new Button((Composite)group2, 0);
        button2.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button2.setText(this.settings.msg("dialog.template.mount.edit"));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddGameWizardDialog.this.doEditMount();
            }
        });
        Button button3 = new Button((Composite)group2, 0);
        button3.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button3.setText(this.settings.msg("dialog.template.mount.remove"));
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddGameWizardDialog.this.doRemoveMount();
            }
        });
        VerifyListener verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                if (verifyEvent.text.length() > 1) {
                    AddGameWizardDialog.this.addMountIfNoMounts(verifyEvent.text);
                }
            }
        };
        this.installExe.addVerifyListener(verifyListener);
        Group group3 = new Group((Composite)group, 0);
        group3.setText(this.settings.msg("dialog.template.association"));
        group3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group3.setLayout((Layout)new GridLayout(2, false));
        Label label4 = new Label((Composite)group3, 0);
        label4.setText(this.settings.msg("dialog.template.dosboxversion"));
        final Combo combo = new Combo((Composite)group3, 8);
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        combo.setVisibleItemCount(20);
        for (DosboxVersion dosboxVersion : this.dbversionsList) {
            combo.add(dosboxVersion.getTitle());
        }
        int n = DosboxVersion.findIndexById(this.dbversionsList, this.profile.getDbversionId());
        combo.select(n);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    String[] stringArray = AddGameWizardDialog.this.profile.getConf().getAutoexec().getMountingpoints();
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    PrintStream printStream = new PrintStream(byteArrayOutputStream);
                    Conf conf = new Conf((DosboxVersion)AddGameWizardDialog.this.dbversionsList.get(combo.getSelectionIndex()), printStream);
                    AddGameWizardDialog.this.profile.getConf().switchToDosboxVersion(conf);
                    AddGameWizardDialog.this.profile.setDbversionId(conf.getDbversion().getId());
                    AddGameWizardDialog.this.profile.getConf().unmountDosboxMounts();
                    for (String string : stringArray) {
                        AddGameWizardDialog.this.profile.getConf().addMount(string);
                    }
                    AddGameWizardDialog.this.mountingpoints.setItems(AddGameWizardDialog.this.profile.getConf().getAutoexec().getMountingpoints());
                    if (byteArrayOutputStream.size() > 0) {
                        GeneralPurposeDialogs.warningMessage(AddGameWizardDialog.this.getParent(), byteArrayOutputStream.toString());
                        byteArrayOutputStream.reset();
                    }
                }
                catch (IOException iOException) {
                    GeneralPurposeDialogs.warningMessage(AddGameWizardDialog.this.getParent(), iOException);
                }
            }
        });
        return group;
    }

    private void addMountIfNoMounts(String string) {
        this.profile.getConf().unmountDosboxMounts();
        this.profile.getConf().addMount("mount C \"" + FileUtils.getTmpInstallFile() + "\"");
        this.mountingpoints.setItems(this.profile.getConf().addRequiredMountForInstaller(string));
    }

    private Control page2() {
        Group group = new Group((Composite)this.shell, 0);
        group.setText(this.settings.msg("dialog.addgamewizard.step3"));
        group.setLayout((Layout)new GridLayout());
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText(this.settings.msg("dialog.addgamewizard.patcherexe"));
        this.patchExe = new Text(composite, 2048);
        this.patchExe.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        BrowseButton browseButton = new BrowseButton(composite, 0);
        browseButton.connect(this.shell, this.patchExe, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.INSTALLER, false, null);
        Label label2 = new Label(composite, 0);
        label2.setText(this.settings.msg("dialog.profile.mainparameters"));
        this.patchParameters = new Text(composite, 2048);
        this.patchParameters.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label label3 = new Label(composite, 0);
        label3.setText(this.settings.msg("dialog.addgamewizard.manualmode"));
        this.btnPatchManual = new Button(composite, 32);
        this.btnPatchManual.setText(this.settings.msg("dialog.addgamewizard.manualpatchmodeinfo"));
        this.btnPatchManual.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        return group;
    }

    private Control page3() {
        Group group = new Group((Composite)this.shell, 0);
        group.setText(this.settings.msg("dialog.addgamewizard.step4"));
        group.setLayout((Layout)new GridLayout());
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText(this.settings.msg("dialog.profile.mainexe"));
        this.main = new Combo(composite, 8);
        this.main.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label2 = new Label(composite, 0);
        label2.setText(this.settings.msg("dialog.profile.setupexe"));
        this.setup = new Combo(composite, 8);
        this.setup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return group;
    }

    private Control page4() {
        Group group = new Group((Composite)this.shell, 0);
        group.setText(this.settings.msg("dialog.addgamewizard.step4"));
        group.setLayout((Layout)new GridLayout());
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText(this.settings.msg("dialog.profile.mainexe"));
        this.mainText = new Text(composite, 2048);
        this.mainText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        BrowseButton browseButton = new BrowseButton(composite, 0);
        browseButton.connect(this.shell, this.mainText, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, false, null);
        Label label2 = new Label(composite, 0);
        label2.setText(this.settings.msg("dialog.profile.setupexe"));
        this.setupText = new Text(composite, 2048);
        this.setupText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        BrowseButton browseButton2 = new BrowseButton(composite, 0);
        browseButton2.connect(this.shell, this.setupText, this.mainText, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, false, null);
        return group;
    }

    private Control page5() {
        Group group = new Group((Composite)this.shell, 0);
        group.setText(this.settings.msg("dialog.addgamewizard.step5"));
        group.setLayout((Layout)new GridLayout());
        Group group2 = new Group((Composite)group, 0);
        group2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        group2.setLayout((Layout)new GridLayout(3, false));
        group2.setText(this.settings.msg("dialog.addgamewizard.installedfiles"));
        this.installedFilesList = new org.eclipse.swt.widgets.List((Composite)group2, 2562);
        this.installedFilesList.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        Label label = new Label((Composite)group2, 0);
        label.setText(this.settings.msg("dialog.migration.to"));
        this.dstDirectory = new Text((Composite)group2, 2048);
        this.dstDirectory.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dstDirectory.setText(FileUtils.getDosRoot());
        BrowseButton browseButton = new BrowseButton((Composite)group2, 0);
        browseButton.connect(this.shell, this.dstDirectory, null, BrowseButton.BrowseType.DIR, BrowseButton.CanonicalType.NONE, false, null);
        Group group3 = new Group((Composite)group, 0);
        group3.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        group3.setLayout((Layout)new GridLayout(3, false));
        group3.setText(this.settings.msg("dialog.addgamewizard.originalimages"));
        this.orgImagesList = new org.eclipse.swt.widgets.List((Composite)group3, 2562);
        this.orgImagesList.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        Label label2 = new Label((Composite)group3, 0);
        label2.setText(this.settings.msg("dialog.addgamewizard.moveimages"));
        this.moveImages = new Button((Composite)group3, 32);
        new Label((Composite)group3, 0);
        Label label3 = new Label((Composite)group3, 0);
        label3.setText(this.settings.msg("dialog.migration.to"));
        this.imagesDstDirectory = new Text((Composite)group3, 2048);
        this.imagesDstDirectory.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)group3, 0);
        this.moveImages.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddGameWizardDialog.this.imagesDstDirectory.setEnabled(AddGameWizardDialog.this.moveImages.getSelection());
            }
        });
        this.imagesDstDirectory.setEnabled(this.moveImages.getSelection());
        return group;
    }

    private Control page6() {
        Template template2;
        Group group = new Group((Composite)this.shell, 0);
        group.setText(this.settings.msg("dialog.addgamewizard.step6"));
        group.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label((Composite)group, 0);
        label.setText(this.settings.msg("dialog.profile.template"));
        this.template = new Combo((Composite)group, 8);
        this.template.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.template.setVisibleItemCount(10);
        for (Template template2 : this.templatesList) {
            this.template.add(template2.getTitle());
        }
        if (this.templateIndex != -1) {
            this.template.select(this.templateIndex);
        }
        this.templateReload = new Button((Composite)group, 0);
        this.templateReload.setText(this.settings.msg("dialog.profile.reloadsettings"));
        this.templateReload.setToolTipText(this.settings.msg("dialog.profile.reloadsettings.tooltip"));
        this.templateReload.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (AddGameWizardDialog.this.template.getSelectionIndex() != -1) {
                    AddGameWizardDialog.this.doReloadTemplate(AddGameWizardDialog.this.template.getSelectionIndex());
                }
            }
        });
        Label label2 = new Label((Composite)group, 0);
        label2.setText(this.settings.msg("dialog.template.machine"));
        this.machine = new Combo((Composite)group, 8);
        this.machine.setLayoutData((Object)new GridData());
        this.machine.setVisibleItemCount(20);
        this.machine.setToolTipText(this.settings.msg("dialog.template.machine.tooltip"));
        if (this.profile.getConf().getSettings().detectDosboxVersionGeneration() >= 3) {
            this.machine.setItems(this.settings.getSettings().getValues("profile", "machine073"));
        } else {
            this.machine.setItems(this.settings.getSettings().getValues("profile", "machine"));
        }
        new Label((Composite)group, 0);
        template2 = new Label((Composite)group, 0);
        template2.setText(this.settings.msg("dialog.template.core"));
        this.core = new Combo((Composite)group, 8);
        this.core.setLayoutData((Object)new GridData());
        this.core.setToolTipText(this.settings.msg("dialog.template.core.tooltip"));
        this.core.setItems(this.settings.getSettings().getValues("profile", "core"));
        new Label((Composite)group, 0);
        Label label3 = new Label((Composite)group, 0);
        label3.setText(this.settings.msg("dialog.template.cycles"));
        this.cycles = new Combo((Composite)group, 0);
        this.cycles.setLayoutData((Object)new GridData(100, -1));
        this.cycles.setVisibleItemCount(15);
        this.cycles.setToolTipText(this.settings.msg("dialog.template.cycles.tooltip"));
        this.cycles.setItems(this.settings.getSettings().getValues("profile", "cycles"));
        new Label((Composite)group, 0);
        this.selectSettingsByConfiguration(this.profile.getConf());
        return group;
    }
}

