/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.GenericType;
import org.dbgl.db.Database;
import org.dbgl.gui.AutoSelectCombo;
import org.dbgl.gui.BrowseButton;
import org.dbgl.gui.BrowseSearchEngineDialog;
import org.dbgl.gui.EditMultiProfileDialog;
import org.dbgl.gui.EditTemplateDialog;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.GeneralPurposeGUI;
import org.dbgl.gui.GrabButton;
import org.dbgl.gui.LoadSharedConfDialog;
import org.dbgl.gui.SettingsDialog;
import org.dbgl.gui.ShareConfDialog;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.interfaces.Configurable;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.KeyValuePair;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.Profile;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.Template;
import org.dbgl.model.WebProfile;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.Settings;
import org.dbgl.model.conf.SharedConf;
import org.dbgl.swtdesigner.SWTImageManager;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.searchengine.HotudSearchEngine;
import org.dbgl.util.searchengine.MobyGamesSearchEngine;
import org.dbgl.util.searchengine.PouetSearchEngine;
import org.dbgl.util.searchengine.TheGamesDBSearchEngine;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import swing2swt.layout.BorderLayout;

public class EditProfileDialog
extends EditTemplateDialog {
    static final List<WebSearchEngine> webSearchEngines = Arrays.asList(MobyGamesSearchEngine.getInstance(), PouetSearchEngine.getInstance(), HotudSearchEngine.getInstance(), TheGamesDBSearchEngine.getInstance());
    public static final String DBCONFWS = "DBConfWS";
    public static final int AMOUNT_OF_LINKS = 8;
    private static final int AMOUNT_OF_CUSTOM_STRINGS = 4;
    private boolean focusOnTitle = false;
    private List<KeyValuePair> developersList;
    private List<KeyValuePair> publishersList;
    private List<KeyValuePair> genresList;
    private List<KeyValuePair> yearsList;
    private List<KeyValuePair> statusList;
    private List<Template> templatesList;
    private List<List<KeyValuePair>> customList = new ArrayList<List<KeyValuePair>>();
    private SizeControlAdapter sizeControlAdapter;
    private SearchEngineImageInformation[] imageInformation = null;
    private Button[] imgButtons;
    private AutoSelectCombo developer;
    private AutoSelectCombo publisher;
    private AutoSelectCombo genre;
    private AutoSelectCombo year;
    private AutoSelectCombo status;
    private Button favorite;
    private Button templateReload;
    private Button loadfix;
    private Button loadhigh;
    private ToolItem engineSelector;
    private Composite webImagesSpaceHolder;
    private ScrolledComposite webImagesSpace;
    private Text[] link = new Text[8];
    private Text[] linkTitle = new Text[8];
    private BrowseButton[] linkBrowseButton = new BrowseButton[8];
    private AutoSelectCombo[] customCombo = new AutoSelectCombo[4];
    private Text[] customText = new Text[4];
    private Scale custom9;
    private Spinner custom10;
    private Combo template;
    private Combo loadfix_value;
    private Text notes;
    private Text main;
    private Text main_params;
    private Text setup;
    private Text setup_params;
    private Text alt1;
    private Text alt1_params;
    private Text alt2;
    private Text alt2_params;
    private Text img1;
    private Text img2;
    private Text img3;
    private Combo imgDriveletter;
    protected ExpProfile multiProfileCombined;
    private int templateIndex = -1;

    public EditProfileDialog(Shell shell) {
        super(shell);
    }

    public void setProfile(Profile profile) {
        this.result = profile;
    }

    public void setConfigurables(List<Configurable> list) {
        this.multiProfileList = list;
        if (this.multiProfileList.size() == 1) {
            this.setProfile((ExpProfile)this.multiProfileList.get(0));
            this.multiProfileList.remove(0);
        }
    }

    public void setMultiProfileCombined(ExpProfile expProfile) {
        this.multiProfileCombined = expProfile;
    }

    public void sendToProfile(String string) {
        this.result = FileUtils.makeRelativeToDosroot(new File(string)).getPath();
    }

    public void focusTitle() {
        this.focusOnTitle = true;
    }

    @Override
    protected boolean init() {
        try {
            this.dbversionsList = this.dbase.readDosboxVersionsList();
            this.developersList = this.dbase.readDevelopersList();
            this.publishersList = this.dbase.readPublishersList();
            this.genresList = this.dbase.readGenresList();
            this.yearsList = this.dbase.readYearsList();
            this.templatesList = this.dbase.readTemplatesList();
            this.statusList = this.dbase.readStatusList();
            for (int i = 0; i < 4; ++i) {
                this.customList.add(this.dbase.readCustomList(i));
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            if (this.result instanceof Profile) {
                Profile profile = (Profile)this.result;
                this.dbversionIndex = DosboxVersion.findIndexById(this.dbversionsList, profile.getDbversionId());
                DosboxVersion dosboxVersion = (DosboxVersion)this.dbversionsList.get(this.dbversionIndex);
                Conf conf = new Conf(profile, dosboxVersion, printStream);
                if (conf.getAutoexec().isIncomplete() && !GeneralPurposeDialogs.confirmMessage(this.getParent(), this.settings.msg("dialog.profile.confirm.profileincomplete", new Object[]{"dosbox.conf", dosboxVersion.getCanonicalConfFile()}))) {
                    return false;
                }
                List<NativeCommand> list = this.dbase.readNativeCommandsList(profile.getId(), -1);
                this.multiProfileList.add(new ExpProfile(profile.getId(), conf, FileUtils.makeRelativeToDosroot(conf.getAutoexec().getCanonicalMainDir()), list, profile));
            } else if (this.isMultiEdit()) {
                this.dbversionIndex = DosboxVersion.findIndexById(this.dbversionsList, this.multiProfileCombined.getDbversionId());
            } else {
                this.dbversionIndex = DosboxVersion.indexOfDefault(this.dbversionsList);
                DosboxVersion dosboxVersion = (DosboxVersion)this.dbversionsList.get(this.dbversionIndex);
                this.templateIndex = Template.indexOfDefault(this.templatesList);
                Conf conf = null;
                List<NativeCommand> list = null;
                if (this.result instanceof String && FileUtils.isConfFile((String)this.result)) {
                    conf = new Conf(FileUtils.canonicalToDosroot((String)this.result), (Template)null, dosboxVersion, printStream);
                    list = this.dbase.readNativeCommandsList(-1, -1);
                } else if (this.templateIndex != -1) {
                    conf = new Conf((File)null, this.templatesList.get(this.templateIndex), dosboxVersion, printStream);
                    list = this.dbase.readNativeCommandsList(-1, this.templatesList.get(this.templateIndex).getId());
                } else {
                    conf = new Conf((File)null, (Template)null, dosboxVersion, printStream);
                    list = this.dbase.readNativeCommandsList(-1, -1);
                }
                this.multiProfileList.add(new ExpProfile(conf, list));
            }
            if (byteArrayOutputStream.size() > 0) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), byteArrayOutputStream.toString());
                byteArrayOutputStream.reset();
            }
            return true;
        }
        catch (Exception exception) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), exception);
            return false;
        }
    }

    @Override
    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new BorderLayout(0, 0));
        this.sizeControlAdapter = new SizeControlAdapter(this.shell, "profiledialog");
        this.shell.addControlListener((ControlListener)this.sizeControlAdapter);
        if (this.result instanceof Profile) {
            this.shell.setText(this.settings.msg("dialog.profile.title.edit", new Object[]{((Profile)this.result).getTitle(), ((Profile)this.result).getId()}));
        } else if (this.isMultiEdit()) {
            this.shell.setText(this.settings.msg("dialog.multiprofile.title.edit", new Object[]{this.multiProfileList.size()}));
        } else if (this.result instanceof String) {
            this.shell.setText(this.settings.msg("dialog.profile.title.send", new Object[]{(String)this.result}));
        } else {
            this.shell.setText(this.settings.msg("dialog.profile.title.add"));
        }
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        this.createInfoTab(tabFolder);
        this.createCustomTab(tabFolder);
        this.createGeneralTab(tabFolder);
        this.createDisplayTab(tabFolder);
        this.createMachineTab(tabFolder);
        this.createAudioTab(tabFolder);
        this.createIOTab(tabFolder);
        this.createCustomCommandsTab(tabFolder);
        this.createMountingTab(tabFolder);
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)"South");
        this.okButton = new Button(composite, 0);
        this.shell.setDefaultButton(this.okButton);
        this.okButton.setText(this.settings.msg("button.ok"));
        this.cancelButton = new Button(composite, 0);
        this.cancelButton.setText(this.settings.msg("button.cancel"));
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (EditProfileDialog.this.cancelButton.getText().equals(EditProfileDialog.this.settings.msg("button.cancel"))) {
                    EditProfileDialog.this.result = null;
                }
                EditProfileDialog.this.shell.close();
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.widthHint = GeneralPurposeGUI.getWidth(this.okButton, this.cancelButton);
        this.okButton.setLayoutData((Object)gridData);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 1;
        gridData2.widthHint = gridData.widthHint;
        gridData2.grabExcessHorizontalSpace = true;
        this.cancelButton.setLayoutData((Object)gridData2);
        Button button = new Button(composite, 0);
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 131072;
        button.setLayoutData((Object)gridData3);
        button.setImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), "share.png"));
        button.setText(this.settings.msg("button.shareconf"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditProfileDialog.this.updateAllConfigurationsBySettings();
                new ShareConfDialog(EditProfileDialog.this.shell, EditProfileDialog.this.title.getText(), EditProfileDialog.this.year.getText(), ((Configurable)EditProfileDialog.this.multiProfileList.get(0)).getConf().toShareString(), ((Configurable)EditProfileDialog.this.multiProfileList.get(0)).getConf().toFullConfString(false), ((Configurable)EditProfileDialog.this.multiProfileList.get(0)).getConf().getDbversion()).open();
            }
        });
        button.setEnabled(!this.isMultiEdit());
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!EditProfileDialog.this.isValid()) {
                    return;
                }
                if (EditProfileDialog.this.isMultiEdit()) {
                    EditProfileDialog.this.updateAllConfigurationsBySettings();
                    EditMultiProfileDialog editMultiProfileDialog = new EditMultiProfileDialog(EditProfileDialog.this.shell);
                    DosboxVersion dosboxVersion = null;
                    if (EditProfileDialog.this.dbversion.getSelectionIndex() != -1) {
                        dosboxVersion = (DosboxVersion)EditProfileDialog.this.dbversionsList.get(EditProfileDialog.this.dbversion.getSelectionIndex());
                    }
                    Profile profile = new Profile(-1, EditProfileDialog.this.fetch(EditProfileDialog.this.title), EditProfileDialog.this.fetch(EditProfileDialog.this.developer), EditProfileDialog.this.fetch(EditProfileDialog.this.publisher), EditProfileDialog.this.fetch(EditProfileDialog.this.genre), EditProfileDialog.this.fetch(EditProfileDialog.this.year), EditProfileDialog.this.fetch(EditProfileDialog.this.status), EditProfileDialog.this.fetch(EditProfileDialog.this.notes), EditProfileDialog.this.fetch(EditProfileDialog.this.favorite), new String[]{EditProfileDialog.this.fetch(EditProfileDialog.this.setup), EditProfileDialog.this.fetch(EditProfileDialog.this.alt1), EditProfileDialog.this.fetch(EditProfileDialog.this.alt2)}, new String[]{EditProfileDialog.this.fetch(EditProfileDialog.this.setup_params), EditProfileDialog.this.fetch(EditProfileDialog.this.alt1_params), EditProfileDialog.this.fetch(EditProfileDialog.this.alt2_params)}, null, null, dosboxVersion != null ? dosboxVersion.getId() : -1, new String[]{EditProfileDialog.this.fetch(EditProfileDialog.this.link[0]), EditProfileDialog.this.fetch(EditProfileDialog.this.link[1]), EditProfileDialog.this.fetch(EditProfileDialog.this.link[2]), EditProfileDialog.this.fetch(EditProfileDialog.this.link[3]), EditProfileDialog.this.fetch(EditProfileDialog.this.link[4]), EditProfileDialog.this.fetch(EditProfileDialog.this.link[5]), EditProfileDialog.this.fetch(EditProfileDialog.this.link[6]), EditProfileDialog.this.fetch(EditProfileDialog.this.link[7])}, new String[]{EditProfileDialog.this.fetch(EditProfileDialog.this.linkTitle[0]), EditProfileDialog.this.fetch(EditProfileDialog.this.linkTitle[1]), EditProfileDialog.this.fetch(EditProfileDialog.this.linkTitle[2]), EditProfileDialog.this.fetch(EditProfileDialog.this.linkTitle[3]), EditProfileDialog.this.fetch(EditProfileDialog.this.linkTitle[4]), EditProfileDialog.this.fetch(EditProfileDialog.this.linkTitle[5]), EditProfileDialog.this.fetch(EditProfileDialog.this.linkTitle[6]), EditProfileDialog.this.fetch(EditProfileDialog.this.linkTitle[7])}, new String[]{EditProfileDialog.this.fetch(EditProfileDialog.this.customCombo[0]), EditProfileDialog.this.fetch(EditProfileDialog.this.customCombo[1]), EditProfileDialog.this.fetch(EditProfileDialog.this.customCombo[2]), EditProfileDialog.this.fetch(EditProfileDialog.this.customCombo[3]), EditProfileDialog.this.fetch(EditProfileDialog.this.customText[0]), EditProfileDialog.this.fetch(EditProfileDialog.this.customText[1]), EditProfileDialog.this.fetch(EditProfileDialog.this.customText[2]), EditProfileDialog.this.fetch(EditProfileDialog.this.customText[3])}, new int[]{EditProfileDialog.this.fetch(EditProfileDialog.this.custom9), EditProfileDialog.this.fetch(EditProfileDialog.this.custom10)}, null, null, null, null, 0, 0);
                    for (int i = 0; i < EditProfileDialog.this.multiProfileList.size(); ++i) {
                        ExpProfile expProfile = (ExpProfile)EditProfileDialog.this.multiProfileList.get(i);
                        expProfile = new ExpProfile(expProfile, profile);
                        EditProfileDialog.this.multiProfileList.set(i, expProfile);
                    }
                    editMultiProfileDialog.setData(EditProfileDialog.this.multiProfileList, (Boolean)EditProfileDialog.this.engineSelector.getData("selected") != false ? EditProfileDialog.this.getSelectedSearchEngine() : null);
                    if (editMultiProfileDialog.open() != null) {
                        EditProfileDialog.this.result = EditProfileDialog.this.multiProfileList;
                        EditProfileDialog.this.shell.close();
                    }
                } else {
                    try {
                        String string;
                        if (EditProfileDialog.this.dosExpandItem.getExpanded()) {
                            EditProfileDialog.this.img1.setText("");
                            EditProfileDialog.this.img2.setText("");
                            EditProfileDialog.this.img3.setText("");
                        } else {
                            EditProfileDialog.this.main.setText("");
                            EditProfileDialog.this.main_params.setText("");
                        }
                        EditProfileDialog.this.dbase.startTransaction();
                        Conf conf = ((Configurable)EditProfileDialog.this.multiProfileList.get(0)).getConf();
                        Profile profile = EditProfileDialog.this.dbase.addOrEditProfile(EditProfileDialog.this.title.getText(), EditProfileDialog.this.developer.getText(), EditProfileDialog.this.publisher.getText(), EditProfileDialog.this.genre.getText(), EditProfileDialog.this.year.getText(), EditProfileDialog.this.status.getText(), EditProfileDialog.this.notes.getText(), EditProfileDialog.this.favorite.getSelection(), new String[]{EditProfileDialog.this.setup.getText(), EditProfileDialog.this.alt1.getText(), EditProfileDialog.this.alt2.getText()}, new String[]{EditProfileDialog.this.setup_params.getText(), EditProfileDialog.this.alt1_params.getText(), EditProfileDialog.this.alt2_params.getText()}, conf.getDbversion().getId(), new String[]{EditProfileDialog.this.link[0].getText(), EditProfileDialog.this.link[1].getText(), EditProfileDialog.this.link[2].getText(), EditProfileDialog.this.link[3].getText(), EditProfileDialog.this.link[4].getText(), EditProfileDialog.this.link[5].getText(), EditProfileDialog.this.link[6].getText(), EditProfileDialog.this.link[7].getText()}, new String[]{EditProfileDialog.this.linkTitle[0].getText(), EditProfileDialog.this.linkTitle[1].getText(), EditProfileDialog.this.linkTitle[2].getText(), EditProfileDialog.this.linkTitle[3].getText(), EditProfileDialog.this.linkTitle[4].getText(), EditProfileDialog.this.linkTitle[5].getText(), EditProfileDialog.this.linkTitle[6].getText(), EditProfileDialog.this.linkTitle[7].getText()}, new String[]{EditProfileDialog.this.customCombo[0].getText(), EditProfileDialog.this.customCombo[1].getText(), EditProfileDialog.this.customCombo[2].getText(), EditProfileDialog.this.customCombo[3].getText(), EditProfileDialog.this.customText[0].getText(), EditProfileDialog.this.customText[1].getText(), EditProfileDialog.this.customText[2].getText(), EditProfileDialog.this.customText[3].getText()}, new int[]{EditProfileDialog.this.custom9.getSelection(), EditProfileDialog.this.custom10.getSelection()}, EditProfileDialog.this.result instanceof Profile ? ((Profile)EditProfileDialog.this.result).getId() : -1);
                        EditProfileDialog.this.dbase.saveNativeCommands(((Configurable)EditProfileDialog.this.multiProfileList.get(0)).getNativeCommandsList(), profile.getId(), -1);
                        EditProfileDialog.this.updateAllConfigurationsBySettings();
                        String string2 = EditProfileDialog.this.result instanceof Profile ? ((Profile)EditProfileDialog.this.result).getConfPathAndFile() : FileUtils.constructUniqueConfigFileString(profile.getId(), EditProfileDialog.this.title.getText(), conf.getAutoexec().isIncomplete() ? null : conf.getAutoexec().getCanonicalMainDir());
                        if (EditProfileDialog.this.result instanceof Profile) {
                            string = ((Profile)EditProfileDialog.this.result).getCaptures();
                        } else {
                            string = FileUtils.constructCapturesDir(profile.getId());
                            FileUtils.createDir(FileUtils.canonicalToData(string));
                        }
                        if (!(EditProfileDialog.this.result instanceof Profile)) {
                            profile = EditProfileDialog.this.dbase.updateProfileConf(string2, string, profile.getId());
                        }
                        EditProfileDialog.this.result = profile;
                        conf.injectOrUpdateProfile((Profile)EditProfileDialog.this.result);
                        conf.save();
                        if (EditProfileDialog.this.imageInformation != null) {
                            EditProfileDialog.this.saveWebImages(FileUtils.canonicalToData(string));
                        }
                        EditProfileDialog.this.dbase.commitTransaction();
                    }
                    catch (IOException | SQLException exception) {
                        GeneralPurposeDialogs.warningMessage(EditProfileDialog.this.shell, exception);
                        try {
                            EditProfileDialog.this.dbase.rollbackTransaction();
                        }
                        catch (SQLException sQLException) {
                            GeneralPurposeDialogs.warningMessage(EditProfileDialog.this.shell, sQLException);
                        }
                    }
                    finally {
                        EditProfileDialog.this.dbase.finishTransaction();
                    }
                    EditProfileDialog.this.shell.close();
                }
            }
        });
        for (DosboxVersion keyTitleDefault : this.dbversionsList) {
            this.dbversion.add(keyTitleDefault.getTitle());
        }
        for (Template template : this.templatesList) {
            this.template.add(template.getTitle());
        }
        this.dbversion.select(this.dbversionIndex);
        this.templateReload.setEnabled(this.dbversionIndex != -1);
        if (this.result instanceof Profile) {
            this.setProfileMetaData((Profile)this.result);
            if (this.focusOnTitle) {
                this.title.selectAll();
                this.title.setFocus();
            }
        } else if (this.isMultiEdit()) {
            this.setProfileMetaData(this.multiProfileCombined);
        } else {
            this.title.setFocus();
            if (this.templateIndex != -1) {
                this.template.select(this.templateIndex);
            }
        }
        if (this.isMultiEdit()) {
            this.enableSettingsByConfiguration(this.multiProfileCombined.getConf().getDosboxSettings());
            this.selectSettingsByConfiguration(this.multiProfileCombined.getConf());
        } else {
            this.enableSettingsByConfiguration(((Configurable)this.multiProfileList.get(0)).getConf().getDosboxSettings());
            this.selectSettingsByConfiguration(((Configurable)this.multiProfileList.get(0)).getConf());
        }
        this.startListeners();
        if (this.result instanceof String) {
            if (FileUtils.isExecutable((String)this.result)) {
                this.main.setText((String)this.result);
            } else if (FileUtils.isBooterImage((String)this.result)) {
                this.img1.setText((String)this.result);
            }
        }
    }

    @Override
    protected void createMachineTab(TabFolder tabFolder) {
        super.createMachineTab(tabFolder);
        Label label = new Label((Composite)this.memoryGroup, 0);
        label.setText(this.settings.msg("dialog.profile.loadfix"));
        this.loadfix = new Button((Composite)this.memoryGroup, 32);
        this.loadfix.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                EditProfileDialog.this.loadfix_value.setEnabled(EditProfileDialog.this.loadfix.getSelection());
            }
        });
        this.loadfix_value = new Combo((Composite)this.memoryGroup, 0);
        this.loadfix_value.setItems(this.settings.getSettings().getValues("profile", "loadfix_value"));
        this.loadfix_value.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label2 = new Label((Composite)this.memoryGroup, 0);
        label2.setText(this.settings.msg("dialog.profile.kb"));
        Label label3 = new Label((Composite)this.memoryGroup, 0);
        label3.setText(this.settings.msg("dialog.profile.loadhigh"));
        this.loadhigh = new Button((Composite)this.memoryGroup, 32);
        new Label((Composite)this.memoryGroup, 0);
        new Label((Composite)this.memoryGroup, 0);
    }

    @Override
    protected void createInfoTab(TabFolder tabFolder) {
        Label label;
        Label label2;
        WebSearchEngine webSearchEngine3;
        this.infoTabItem = new TabItem(tabFolder, 0);
        this.infoTabItem.setText(this.settings.msg("dialog.profile.tab.info"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(8, false));
        this.infoTabItem.setControl((Control)composite);
        Label label3 = new Label(composite, 0);
        label3.setText(this.settings.msg("dialog.profile.title"));
        this.title = new Text(composite, 2048);
        this.title.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 6, 1));
        WebSearchEngine webSearchEngine2 = this.getSearchEngineBySimpleName(this.settings.getSettings().getValue("gui", "searchengine"));
        if (webSearchEngine2 == null) {
            webSearchEngine2 = webSearchEngines.get(0);
        }
        final ToolBar toolBar = new ToolBar(composite, 0x800000);
        this.engineSelector = new ToolItem(toolBar, 4);
        this.engineSelector.setImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), webSearchEngine2.getIcon()));
        this.engineSelector.setToolTipText(this.settings.msg("dialog.profile.consultsearchengine", new String[]{webSearchEngine2.getName()}));
        this.engineSelector.setData("engine", (Object)webSearchEngine2.getName());
        if (this.isMultiEdit()) {
            this.engineSelector.setImage(SWTImageManager.createDisabledImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), webSearchEngine2.getIcon())));
            this.engineSelector.setData("selected", (Object)false);
        }
        final Menu menu = new Menu((Decorations)this.shell, 8);
        for (final WebSearchEngine webSearchEngine3 : webSearchEngines) {
            MenuItem menuItem = new MenuItem(menu, 8);
            menuItem.setImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), webSearchEngine3.getIcon()));
            menuItem.setText(webSearchEngine3.getName());
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    MenuItem menuItem = (MenuItem)selectionEvent.widget;
                    EditProfileDialog.this.engineSelector.setImage(menuItem.getImage());
                    EditProfileDialog.this.engineSelector.setData("engine", (Object)menuItem.getText());
                    EditProfileDialog.this.engineSelector.setToolTipText(EditProfileDialog.this.settings.msg("dialog.profile.consultsearchengine", new String[]{EditProfileDialog.this.engineSelector.getData("engine").toString()}));
                    if (EditProfileDialog.this.isMultiEdit()) {
                        EditProfileDialog.this.engineSelector.setData("selected", (Object)true);
                    }
                    EditProfileDialog.this.settings.getSettings().setValue("gui", "searchengine", webSearchEngine3.getSimpleName());
                }
            });
        }
        this.engineSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.detail == 4) {
                    if (EditProfileDialog.this.engineSelector.getData("profile") == null) {
                        Rectangle rectangle = EditProfileDialog.this.engineSelector.getBounds();
                        Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
                        point = toolBar.toDisplay(point);
                        menu.setLocation(point.x, point.y);
                        menu.setVisible(true);
                    }
                } else if (EditProfileDialog.this.isMultiEdit()) {
                    WebSearchEngine webSearchEngine = EditProfileDialog.this.getSelectedSearchEngine();
                    if (((Boolean)EditProfileDialog.this.engineSelector.getData("selected")).booleanValue()) {
                        EditProfileDialog.this.engineSelector.setImage(SWTImageManager.createDisabledImage(SWTImageManager.getResourceImage(EditProfileDialog.this.shell.getDisplay(), webSearchEngine.getIcon())));
                        EditProfileDialog.this.engineSelector.setData("selected", (Object)false);
                    } else {
                        EditProfileDialog.this.engineSelector.setImage(SWTImageManager.getResourceImage(EditProfileDialog.this.shell.getDisplay(), webSearchEngine.getIcon()));
                        EditProfileDialog.this.engineSelector.setData("selected", (Object)true);
                    }
                } else {
                    int n = EditProfileDialog.this.settings.getSettings().getIntValue("mobygames", "image_width");
                    int n2 = EditProfileDialog.this.settings.getSettings().getIntValue("mobygames", "image_height");
                    int n3 = EditProfileDialog.this.settings.getSettings().getIntValue("mobygames", "image_columns");
                    int n4 = (n + 10) * n3 + 3 * (n3 - 1) + 19;
                    WebProfile webProfile = (WebProfile)EditProfileDialog.this.engineSelector.getData("profile");
                    if (webProfile == null) {
                        String string = EditProfileDialog.this.title.getText();
                        if (string.length() >= 1) {
                            WebSearchEngine webSearchEngine = EditProfileDialog.this.getSelectedSearchEngine();
                            try {
                                Comparable<WebProfile> comparable;
                                Object object;
                                WebProfile webProfile2 = null;
                                List<WebProfile> list = webSearchEngine.getEntries(string, EditProfileDialog.this.settings.getSettings().getValues(webSearchEngine.getSimpleName(), "platform_filter"));
                                if (list.size() == 0) {
                                    GeneralPurposeDialogs.infoMessage(EditProfileDialog.this.shell, EditProfileDialog.this.settings.msg("general.notice.searchenginenoresults", new String[]{webSearchEngine.getName(), string}));
                                } else if (list.size() == 1) {
                                    webProfile2 = list.get(0);
                                } else {
                                    object = new BrowseSearchEngineDialog(EditProfileDialog.this.shell);
                                    ((BrowseSearchEngineDialog)((Object)object)).setProfilesToBrowse(string, list);
                                    ((BrowseSearchEngineDialog)((Object)object)).setEngine(webSearchEngine);
                                    comparable = (Integer)((BrowseSearchEngineDialog)((Object)object)).open();
                                    if (comparable != null) {
                                        webProfile2 = list.get((Integer)comparable);
                                    }
                                }
                                if (webProfile2 != null) {
                                    int n5;
                                    String string2;
                                    String string3;
                                    object = webSearchEngine.getEntryDetailedInformation(webProfile2);
                                    comparable = new WebProfile();
                                    ((WebProfile)comparable).setTitle(EditProfileDialog.this.title.getText());
                                    ((WebProfile)comparable).setDeveloperName(EditProfileDialog.this.developer.getText());
                                    ((WebProfile)comparable).setPublisherName(EditProfileDialog.this.publisher.getText());
                                    ((WebProfile)comparable).setYear(EditProfileDialog.this.year.getText());
                                    ((WebProfile)comparable).setGenre(EditProfileDialog.this.genre.getText());
                                    ((WebProfile)comparable).setUrl(EditProfileDialog.this.link[0].getText());
                                    ((WebProfile)comparable).setPlatform(EditProfileDialog.this.linkTitle[0].getText());
                                    ((WebProfile)comparable).setNotes(EditProfileDialog.this.notes.getText());
                                    ((WebProfile)comparable).setRank(EditProfileDialog.this.custom9.getSelection());
                                    EditProfileDialog.this.engineSelector.setData("profile", comparable);
                                    EditProfileDialog.this.engineSelector.setImage(SWTImageManager.getResourceImage(EditProfileDialog.this.shell.getDisplay(), "undo.png"));
                                    EditProfileDialog.this.engineSelector.setToolTipText(EditProfileDialog.this.settings.msg("dialog.profile.undosearchengine"));
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue(webSearchEngine.getSimpleName(), "set_title")) {
                                        EditProfileDialog.this.title.setText(((WebProfile)object).getTitle());
                                    }
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue(webSearchEngine.getSimpleName(), "set_developer")) {
                                        EditProfileDialog.this.developer.setText(((WebProfile)object).getDeveloperName());
                                    }
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue(webSearchEngine.getSimpleName(), "set_publisher")) {
                                        EditProfileDialog.this.publisher.setText(((WebProfile)object).getPublisherName());
                                    }
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue(webSearchEngine.getSimpleName(), "set_year")) {
                                        EditProfileDialog.this.year.setText(((WebProfile)object).getYear());
                                    }
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue(webSearchEngine.getSimpleName(), "set_genre")) {
                                        EditProfileDialog.this.genre.setText(((WebProfile)object).getGenre());
                                    }
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue(webSearchEngine.getSimpleName(), "set_link")) {
                                        EditProfileDialog.this.link[0].setText(((WebProfile)object).getUrl());
                                        EditProfileDialog.this.linkTitle[0].setText(EditProfileDialog.this.settings.msg("dialog.profile.searchengine.link.maininfo", new String[]{webSearchEngine.getName()}));
                                    }
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue(webSearchEngine.getSimpleName(), "set_description") && !(string3 = EditProfileDialog.this.notes.getText()).endsWith(string2 = ((WebProfile)object).getNotes().replaceAll("\n", EditProfileDialog.this.notes.getLineDelimiter()))) {
                                        if (string3.length() > 0) {
                                            EditProfileDialog.this.notes.append(EditProfileDialog.this.notes.getLineDelimiter() + EditProfileDialog.this.notes.getLineDelimiter());
                                        }
                                        EditProfileDialog.this.notes.append(string2);
                                    }
                                    if (EditProfileDialog.this.settings.getSettings().getBooleanValue(webSearchEngine.getSimpleName(), "set_rank")) {
                                        EditProfileDialog.this.custom9.setSelection(((WebProfile)object).getRank());
                                    }
                                    int n6 = EditProfileDialog.this.settings.getSettings().getBooleanValue(webSearchEngine.getSimpleName(), "choose_coverart") ? Integer.MAX_VALUE : 0;
                                    int n7 = n5 = EditProfileDialog.this.settings.getSettings().getBooleanValue(webSearchEngine.getSimpleName(), "choose_screenshot") ? Integer.MAX_VALUE : 0;
                                    if (n6 > 0 || n5 > 0) {
                                        Button button;
                                        Button button2;
                                        boolean bl = EditProfileDialog.this.settings.getSettings().getBooleanValue(webSearchEngine.getSimpleName(), "force_all_regions_coverart");
                                        EditProfileDialog.access$2602(EditProfileDialog.this, webSearchEngine.getEntryImages((WebProfile)object, n6, n5, bl));
                                        EditProfileDialog.this.webImagesSpaceHolder = new Composite((Composite)EditProfileDialog.this.shell, 0);
                                        EditProfileDialog.this.webImagesSpaceHolder.setLayoutData((Object)"East");
                                        GridLayout gridLayout = new GridLayout();
                                        gridLayout.numColumns = 2;
                                        gridLayout.marginHeight = 0;
                                        gridLayout.marginWidth = 0;
                                        gridLayout.horizontalSpacing = 0;
                                        gridLayout.verticalSpacing = 0;
                                        EditProfileDialog.this.webImagesSpaceHolder.setLayout((Layout)gridLayout);
                                        if (EditProfileDialog.this.imageInformation.length > 0) {
                                            button2 = new Button(EditProfileDialog.this.webImagesSpaceHolder, 0);
                                            button2.setLayoutData((Object)new GridData(50, -1));
                                            button2.setText(EditProfileDialog.this.settings.msg("button.all"));
                                            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                                public void widgetSelected(SelectionEvent selectionEvent) {
                                                    for (Button button : EditProfileDialog.this.imgButtons) {
                                                        button.setSelection(true);
                                                    }
                                                }
                                            });
                                            button = new Button(EditProfileDialog.this.webImagesSpaceHolder, 0);
                                            button.setLayoutData((Object)new GridData(50, -1));
                                            button.setText(EditProfileDialog.this.settings.msg("button.none"));
                                            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                                public void widgetSelected(SelectionEvent selectionEvent) {
                                                    for (Button button : EditProfileDialog.this.imgButtons) {
                                                        button.setSelection(false);
                                                    }
                                                }
                                            });
                                        }
                                        EditProfileDialog.this.webImagesSpace = new ScrolledComposite(EditProfileDialog.this.webImagesSpaceHolder, 512);
                                        EditProfileDialog.this.webImagesSpace.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
                                        EditProfileDialog.this.webImagesSpace.setLayout((Layout)new GridLayout());
                                        EditProfileDialog.this.webImagesSpace.getVerticalBar().setIncrement(n2 / n3);
                                        EditProfileDialog.this.webImagesSpace.getVerticalBar().setPageIncrement(n2 / n3 * 8);
                                        button2 = new Composite((Composite)EditProfileDialog.this.webImagesSpace, 0);
                                        button = new GridLayout();
                                        button.numColumns = n3;
                                        button.marginHeight = 0;
                                        button.marginWidth = 0;
                                        button.horizontalSpacing = 1;
                                        button.verticalSpacing = 1;
                                        button.makeColumnsEqualWidth = true;
                                        button2.setLayout((Layout)button);
                                        EditProfileDialog.this.webImagesSpace.setContent((Control)button2);
                                        if (EditProfileDialog.this.imageInformation.length > 0) {
                                            EditProfileDialog.access$3102(EditProfileDialog.this, new Button[EditProfileDialog.this.imageInformation.length]);
                                            int n8 = 0;
                                            while (n8 < EditProfileDialog.this.imageInformation.length) {
                                                ((EditProfileDialog)EditProfileDialog.this).imgButtons[n8] = new Button((Composite)button2, 0x800002);
                                                EditProfileDialog.this.imgButtons[n8].setLayoutData((Object)new GridData(16384, 1024, true, true));
                                                EditProfileDialog.this.imgButtons[n8].setToolTipText(((EditProfileDialog)EditProfileDialog.this).imageInformation[n8].description);
                                                EditProfileDialog.this.imgButtons[n8].setImage(SWTImageManager.getEmptyImage(EditProfileDialog.this.shell.getDisplay(), n, n2));
                                                EditProfileDialog.this.imgButtons[n8].addDisposeListener(new DisposeListener(){

                                                    public void widgetDisposed(DisposeEvent disposeEvent) {
                                                        ((Button)disposeEvent.getSource()).getImage().dispose();
                                                    }
                                                });
                                                int n9 = n8++;
                                                Thread thread = new Thread((WebProfile)object, n9, n, (Composite)button2){
                                                    final /* synthetic */ WebProfile val$profExt;
                                                    final /* synthetic */ int val$j;
                                                    final /* synthetic */ int val$WEB_IMAGE_WIDTH;
                                                    final /* synthetic */ Composite val$webImagesComposite;
                                                    {
                                                        this.val$profExt = webProfile;
                                                        this.val$j = n;
                                                        this.val$WEB_IMAGE_WIDTH = n2;
                                                        this.val$webImagesComposite = composite;
                                                    }

                                                    @Override
                                                    public void run() {
                                                        try {
                                                            ImageData imageData = this.val$profExt.getWebImage(this.val$j);
                                                            if (!EditProfileDialog.this.shell.isDisposed() && !EditProfileDialog.this.imgButtons[this.val$j].isDisposed()) {
                                                                final Image image = SWTImageManager.getWidthLimitedImage(EditProfileDialog.this.shell.getDisplay(), this.val$WEB_IMAGE_WIDTH, imageData);
                                                                if (!EditProfileDialog.this.shell.isDisposed() && !EditProfileDialog.this.imgButtons[this.val$j].isDisposed()) {
                                                                    EditProfileDialog.this.shell.getDisplay().syncExec(new Runnable(){

                                                                        @Override
                                                                        public void run() {
                                                                            EditProfileDialog.this.imgButtons[val$j].getImage().dispose();
                                                                            EditProfileDialog.this.imgButtons[val$j].setImage(image);
                                                                            val$webImagesComposite.setSize(val$webImagesComposite.computeSize(-1, -1));
                                                                            val$webImagesComposite.layout();
                                                                        }
                                                                    });
                                                                }
                                                            }
                                                        }
                                                        catch (IOException iOException) {
                                                            // empty catch block
                                                        }
                                                    }
                                                };
                                                thread.start();
                                            }
                                        } else {
                                            Label label = new Label((Composite)button2, 0x1000040);
                                            label.setText(EditProfileDialog.this.settings.msg("dialog.profile.notice.noimagesfound", new String[]{webSearchEngine.getName()}));
                                            GridData gridData = new GridData(0x1000000, 4, true, true, n3, 1);
                                            gridData.widthHint = (n + 10) * n3 + 3 * (n3 - 1) + 2;
                                            gridData.verticalIndent = n2 / 2;
                                            label.setLayoutData((Object)gridData);
                                        }
                                        EditProfileDialog.this.sizeControlAdapter.setEnabled(false);
                                        button2.pack();
                                        EditProfileDialog.this.shell.setSize(EditProfileDialog.this.shell.getSize().x + n4, EditProfileDialog.this.shell.getSize().y);
                                        EditProfileDialog.this.shell.layout();
                                    }
                                }
                            }
                            catch (Exception exception) {
                                GeneralPurposeDialogs.warningMessage(EditProfileDialog.this.shell, EditProfileDialog.this.settings.msg("general.error.retrieveinfosearchengine", new String[]{webSearchEngine.getName(), string, StringRelatedUtils.toString(exception)}), exception);
                            }
                        }
                    } else {
                        EditProfileDialog.this.title.setText(webProfile.getTitle());
                        EditProfileDialog.this.developer.setText(webProfile.getDeveloperName());
                        EditProfileDialog.this.publisher.setText(webProfile.getPublisherName());
                        EditProfileDialog.this.year.setText(webProfile.getYear());
                        EditProfileDialog.this.genre.setText(webProfile.getGenre());
                        EditProfileDialog.this.link[0].setText(webProfile.getUrl());
                        EditProfileDialog.this.linkTitle[0].setText(webProfile.getPlatform());
                        EditProfileDialog.this.notes.setText(webProfile.getNotes());
                        EditProfileDialog.this.custom9.setSelection(webProfile.getRank());
                        EditProfileDialog.this.engineSelector.setData("profile", null);
                        EditProfileDialog.this.engineSelector.setImage(SWTImageManager.getResourceImage(EditProfileDialog.this.shell.getDisplay(), EditProfileDialog.this.getSelectedSearchEngine().getIcon()));
                        EditProfileDialog.this.engineSelector.setToolTipText(EditProfileDialog.this.settings.msg("dialog.profile.consultsearchengine", new String[]{EditProfileDialog.this.engineSelector.getData("engine").toString()}));
                        if (EditProfileDialog.this.webImagesSpaceHolder != null) {
                            EditProfileDialog.this.webImagesSpaceHolder.dispose();
                            EditProfileDialog.this.webImagesSpaceHolder = null;
                            EditProfileDialog.this.shell.setSize(EditProfileDialog.this.shell.getSize().x - n4, EditProfileDialog.this.shell.getSize().y);
                            EditProfileDialog.this.shell.layout();
                            EditProfileDialog.this.sizeControlAdapter.setEnabled(true);
                            EditProfileDialog.access$2602(EditProfileDialog.this, null);
                        }
                    }
                }
            }
        });
        ToolItem toolItem = new ToolItem(toolBar, 8);
        webSearchEngine3 = new GridData();
        ((GridData)webSearchEngine3).horizontalAlignment = 4;
        toolItem.setImage(SWTImageManager.getResourceImage(this.shell.getDisplay(), "share.png"));
        toolItem.setToolTipText(this.settings.msg("button.consultconfsearchengine", new String[]{DBCONFWS}));
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = EditProfileDialog.this.title.getText();
                if (string.length() >= 1) {
                    try {
                        Client client = ClientBuilder.newClient();
                        GenericType<List<SharedConf>> genericType = new GenericType<List<SharedConf>>(){};
                        List list = (List)client.target(EditProfileDialog.this.settings.getSettings().getValue("confsharing", "endpoint")).path("/configurations/bytitle/{i}").resolveTemplate("i", (Object)string).request().accept(new String[]{"application/xml"}).get((GenericType)genericType);
                        client.close();
                        if (list.size() == 0) {
                            GeneralPurposeDialogs.infoMessage(EditProfileDialog.this.shell, EditProfileDialog.this.settings.msg("general.notice.searchenginenoresults", new String[]{EditProfileDialog.DBCONFWS, string}));
                            return;
                        }
                        LoadSharedConfDialog.SharedConfLoading sharedConfLoading = (LoadSharedConfDialog.SharedConfLoading)new LoadSharedConfDialog(EditProfileDialog.this.shell, string, list).open();
                        if (sharedConfLoading != null) {
                            EditProfileDialog.this.updateAllConfigurationsBySettings();
                            ((Configurable)EditProfileDialog.this.multiProfileList.get(0)).getConf().loadSharedConf(sharedConfLoading.conf.getIncrConf(), sharedConfLoading.reloadDosboxDefaults);
                            EditProfileDialog.this.enableSettingsByConfiguration(((Configurable)EditProfileDialog.this.multiProfileList.get(0)).getConf().getDosboxSettings());
                            EditProfileDialog.this.selectSettingsByConfiguration(((Configurable)EditProfileDialog.this.multiProfileList.get(0)).getConf());
                        }
                    }
                    catch (Exception exception) {
                        GeneralPurposeDialogs.warningMessage(EditProfileDialog.this.shell, EditProfileDialog.this.settings.msg("general.error.retrieveinfosearchengine", new String[]{EditProfileDialog.DBCONFWS, string, StringRelatedUtils.toString(exception)}), exception);
                    }
                }
            }
        });
        toolItem.setEnabled(!this.isMultiEdit());
        int n = this.settings.getSettings().getIntValue("gui", "profiledialog_width") / 3;
        Label label4 = new Label(composite, 0);
        label4.setText(this.settings.msg("dialog.profile.developer"));
        GridData gridData = new GridData(4, 0x1000000, true, false, 2, 1);
        gridData.minimumWidth = n;
        this.developer = new AutoSelectCombo(composite, 0, this.developersList, gridData);
        Label label5 = new Label(composite, 0);
        label5.setLayoutData((Object)new GridData());
        label5.setText(this.settings.msg("dialog.profile.publisher"));
        GridData gridData2 = new GridData(4, 0x1000000, true, false, 4, 1);
        gridData2.minimumWidth = n;
        this.publisher = new AutoSelectCombo(composite, 0, this.publishersList, gridData2);
        Label label6 = new Label(composite, 0);
        label6.setText(this.settings.msg("dialog.profile.genre"));
        this.genre = new AutoSelectCombo(composite, 0, this.genresList, new GridData(4, 0x1000000, true, false, 2, 1));
        Label label7 = new Label(composite, 0);
        label7.setLayoutData((Object)new GridData());
        label7.setText(this.settings.msg("dialog.profile.year"));
        this.year = new AutoSelectCombo(composite, 0, this.yearsList, new GridData(4, 0x1000000, true, false, 4, 1));
        for (int i = 0; i < 4; ++i) {
            label2 = new Label(composite, 0);
            label2.setText(this.settings.msg("dialog.profile.link", new Object[]{i + 1}));
            this.link[i] = new Text(composite, 2048);
            this.link[i].setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.linkBrowseButton[i] = new BrowseButton(composite, 0);
            label = new Label(composite, 0);
            label.setText(this.settings.msg("dialog.profile.linktitle"));
            this.linkTitle[i] = new Text(composite, 2048);
            this.linkTitle[i].setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        }
        Label label8 = new Label(composite, 0);
        label8.setText(this.settings.msg("dialog.profile.status"));
        this.status = new AutoSelectCombo(composite, 0, this.statusList, new GridData(4, 0x1000000, true, false, 2, 1));
        label2 = new Label(composite, 0);
        label2.setText(this.settings.msg("dialog.profile.favorite"));
        this.favorite = new Button(composite, 32);
        label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label(composite, 0);
        new Label(composite, 0);
        Label label9 = new Label(composite, 0);
        label9.setText(this.settings.msg("dialog.profile.notes"));
        this.notes = new Text(composite, 2626);
        this.notes.setLayoutData((Object)new GridData(4, 4, true, true, 7, 1));
        this.notes.setFont(GeneralPurposeGUI.stringToFont((Device)this.shell.getDisplay(), this.notes.getFont(), this.settings.getSettings().getValues("gui", "notesfont")));
    }

    protected void createCustomTab(TabFolder tabFolder) {
        Label label;
        int n;
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(this.settings.msg("dialog.profile.tab.custominfo"));
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(5, false));
        tabItem.setControl((Control)composite);
        for (n = 0; n < 4; ++n) {
            label = new Label(composite, 0);
            label.setText(this.settings.getSettings().getValue("gui", "custom" + (n + 1)));
            this.customCombo[n] = new AutoSelectCombo(composite, 0, this.customList.get(n), new GridData(4, 0x1000000, true, false, 4, 1));
        }
        for (n = 0; n < 4; ++n) {
            label = new Label(composite, 0);
            label.setText(this.settings.getSettings().getValue("gui", "custom" + (n + 1 + 4)));
            this.customText[n] = new Text(composite, 2048);
            this.customText[n].setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        }
        Label label2 = new Label(composite, 0);
        label2.setText(this.settings.getSettings().getValue("gui", "custom9"));
        this.custom9 = new Scale(composite, 0);
        this.custom9.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        label = new Label(composite, 0);
        label.setText(this.settings.getSettings().getValue("gui", "custom10"));
        this.custom10 = new Spinner(composite, 2048);
        this.custom10.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.custom10.setMinimum(Integer.MIN_VALUE);
        this.custom10.setMaximum(Integer.MAX_VALUE);
        for (int i = 4; i < 8; ++i) {
            Label label3 = new Label(composite, 0);
            label3.setText(this.settings.msg("dialog.profile.link", new Object[]{i + 1}));
            this.link[i] = new Text(composite, 2048);
            this.link[i].setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.linkBrowseButton[i] = new BrowseButton(composite, 0);
            Label label4 = new Label(composite, 0);
            label4.setText(this.settings.msg("dialog.profile.linktitle"));
            this.linkTitle[i] = new Text(composite, 2048);
            this.linkTitle[i].setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
    }

    @Override
    protected void createGeneralTab(TabFolder tabFolder) {
        super.createGeneralTab(tabFolder);
        Label label = new Label((Composite)this.associationGroup, 0);
        label.setText(this.settings.msg("dialog.profile.template"));
        this.template = new Combo((Composite)this.associationGroup, 8);
        this.template.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.template.setVisibleItemCount(10);
        this.templateReload = new Button((Composite)this.associationGroup, 0);
        this.templateReload.setText(this.settings.msg("dialog.profile.reloadsettings"));
        this.templateReload.setToolTipText(this.settings.msg("dialog.profile.reloadsettings.tooltip"));
        this.templateReload.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (EditProfileDialog.this.template.getSelectionIndex() != -1) {
                    if (EditProfileDialog.this.setButton.isEnabled()) {
                        GeneralPurposeDialogs.initErrorDialog();
                        GeneralPurposeDialogs.addError(EditProfileDialog.this.settings.msg("dialog.template.required.dosboxassociation"), (Control)EditProfileDialog.this.setButton, EditProfileDialog.this.generalTabItem);
                        GeneralPurposeDialogs.displayErrorDialog(EditProfileDialog.this.shell);
                        return;
                    }
                    EditProfileDialog.this.doPerformDosboxConfAction(EditTemplateDialog.DosboxConfAction.RELOAD_TEMPLATE);
                }
            }
        });
        this.config_file.setText(this.result instanceof Profile ? ((Profile)this.result).getConfPathAndFile() : SettingsDialog.confLocations[this.settings.getSettings().getIntValue("profiledefaults", "confpath")] + ", " + SettingsDialog.confFilenames[this.settings.getSettings().getIntValue("profiledefaults", "conffile")]);
    }

    @Override
    protected void createBooterComposite(Composite composite) {
        composite.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label(composite, 0);
        label.setText(this.settings.msg("dialog.profile.booterimage1"));
        this.img1 = new Text(composite, 2048);
        this.img1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        BrowseButton browseButton = new BrowseButton(composite, 0);
        browseButton.connect(this.shell, this.img1, this.main, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.BOOTER, false, null);
        GrabButton grabButton = new GrabButton(composite, 0);
        grabButton.connect(this.img1, this.mountingpoints, true);
        Label label2 = new Label(composite, 0);
        label2.setText(this.settings.msg("dialog.profile.booterimage2"));
        this.img2 = new Text(composite, 2048);
        this.img2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        BrowseButton browseButton2 = new BrowseButton(composite, 0);
        browseButton2.connect(this.shell, this.img2, this.img1, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.BOOTER, false, null);
        GrabButton grabButton2 = new GrabButton(composite, 0);
        grabButton2.connect(this.img2, this.mountingpoints, true);
        Label label3 = new Label(composite, 0);
        label3.setText(this.settings.msg("dialog.profile.booterimage3"));
        this.img3 = new Text(composite, 2048);
        this.img3.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        BrowseButton browseButton3 = new BrowseButton(composite, 0);
        browseButton3.connect(this.shell, this.img3, this.img1, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.BOOTER, false, null);
        GrabButton grabButton3 = new GrabButton(composite, 0);
        grabButton3.connect(this.img3, this.mountingpoints, true);
        Label label4 = new Label(composite, 0);
        label4.setText(this.settings.msg("dialog.profile.booterdriveletter"));
        this.imgDriveletter = new Combo(composite, 8);
        this.imgDriveletter.setItems(new String[]{"", "A", "C", "D"});
        new Label(composite, 0);
        new Label(composite, 0);
    }

    @Override
    protected void createDosComposite(Composite composite) {
        composite.setLayout((Layout)new GridLayout(6, false));
        Label label = new Label(composite, 0);
        label.setText(this.settings.msg("dialog.profile.mainexe"));
        this.main = new Text(composite, 2048);
        this.main.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        for (int i = 0; i < 8; ++i) {
            this.linkBrowseButton[i].connect(this.shell, this.link[i], this.main, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.DOC, false, null);
        }
        BrowseButton browseButton = new BrowseButton(composite, 0);
        browseButton.connect(this.shell, this.main, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, false, this.pixelshader);
        GrabButton grabButton = new GrabButton(composite, 0);
        grabButton.connect(this.main, this.mountingpoints, false);
        new Label(composite, 0);
        Label label2 = new Label(composite, 0);
        label2.setText(this.settings.msg("dialog.profile.mainparameters"));
        this.main_params = new Text(composite, 2048);
        this.main_params.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        new Label(composite, 0);
        new Label(composite, 0);
        Label label3 = new Label(composite, 0);
        label3.setText(this.settings.msg("dialog.profile.setupexe"));
        this.setup = new Text(composite, 2048);
        this.setup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        BrowseButton browseButton2 = new BrowseButton(composite, 0);
        browseButton2.connect(this.shell, this.setup, this.main, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, false, this.pixelshader);
        GrabButton grabButton2 = new GrabButton(composite, 0);
        grabButton2.connect(this.setup, this.mountingpoints, false);
        new Label(composite, 0);
        Label label4 = new Label(composite, 0);
        label4.setText(this.settings.msg("dialog.profile.setupparameters"));
        this.setup_params = new Text(composite, 2048);
        this.setup_params.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        new Label(composite, 0);
        new Label(composite, 0);
        Label label5 = new Label(composite, 0);
        label5.setText(this.settings.msg("dialog.profile.altexe", new Object[]{1}));
        this.alt1 = new Text(composite, 2048);
        this.alt1.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.alt1_params = new Text(composite, 2048);
        BrowseButton browseButton3 = new BrowseButton(composite, 0);
        browseButton3.connect(this.shell, this.alt1, this.main, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, false, this.pixelshader);
        GrabButton grabButton3 = new GrabButton(composite, 0);
        grabButton3.connect(this.alt1, this.mountingpoints, false);
        Label label6 = new Label(composite, 0);
        label6.setText(this.settings.msg("dialog.profile.altexe", new Object[]{2}));
        this.alt2 = new Text(composite, 2048);
        this.alt2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.alt2_params = new Text(composite, 2048);
        BrowseButton browseButton4 = new BrowseButton(composite, 0);
        browseButton4.connect(this.shell, this.alt2, this.main, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, false, this.pixelshader);
        GrabButton grabButton4 = new GrabButton(composite, 0);
        grabButton4.connect(this.alt2, this.mountingpoints, false);
    }

    private void startListeners() {
        VerifyListener verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                if (verifyEvent.text.length() > 1) {
                    boolean bl = verifyEvent.widget == EditProfileDialog.this.img1 || verifyEvent.widget == EditProfileDialog.this.img2 || verifyEvent.widget == EditProfileDialog.this.img3;
                    EditProfileDialog.this.addMountIfNoMounts(verifyEvent.text, bl);
                }
            }
        };
        this.main.addVerifyListener(verifyListener);
        this.setup.addVerifyListener(verifyListener);
        this.img1.addVerifyListener(verifyListener);
        this.img2.addVerifyListener(verifyListener);
        this.img3.addVerifyListener(verifyListener);
        if (this.isMultiEdit()) {
            ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    Control control = (Control)modifyEvent.widget;
                    control.setData((Object)true);
                    EditTemplateDialog.highlight(control, 3);
                }
            };
            SelectionListener selectionListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Control control = (Control)selectionEvent.widget;
                    control.setData((Object)true);
                    EditTemplateDialog.highlight(control, 3);
                    if (control instanceof Button) {
                        ((Button)control).setGrayed(false);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    this.widgetSelected(selectionEvent);
                }
            };
            for (Control control : this.shell.getChildren()) {
                if (!(control instanceof TabFolder)) continue;
                TabFolder tabFolder = (TabFolder)control;
                for (TabItem tabItem : tabFolder.getItems()) {
                    Composite composite = (Composite)tabItem.getControl();
                    for (Control control2 : EditProfileDialog.getChangeables(composite)) {
                        Combo combo;
                        if (control2 instanceof Combo) {
                            combo = (Combo)control2;
                            combo.setData((Object)false);
                            combo.addModifyListener(modifyListener);
                            continue;
                        }
                        if (control2 instanceof Text) {
                            combo = (Text)control2;
                            combo.setData((Object)false);
                            combo.addModifyListener(modifyListener);
                            continue;
                        }
                        if (control2 instanceof Button) {
                            combo = (Button)control2;
                            combo.setData((Object)false);
                            combo.addSelectionListener(selectionListener);
                            continue;
                        }
                        if (control2 instanceof Spinner) {
                            combo = (Spinner)control2;
                            combo.setData((Object)false);
                            combo.addModifyListener(modifyListener);
                            continue;
                        }
                        if (control2 instanceof Scale) {
                            combo = (Scale)control2;
                            combo.setData((Object)false);
                            combo.addSelectionListener(selectionListener);
                            continue;
                        }
                        if (!(control2 instanceof org.eclipse.swt.widgets.List)) continue;
                        combo = (org.eclipse.swt.widgets.List)control2;
                        combo.setData((Object)false);
                        combo.addSelectionListener(selectionListener);
                    }
                }
            }
        }
    }

    private void addMountIfNoMounts(String string, boolean bl) {
        if (this.mountingpoints.getItemCount() == 0) {
            this.mountingpoints.setItems(((Configurable)this.multiProfileList.get(0)).getConf().addRequiredMount(bl, string));
            this.mountingpoints.select(this.mountingpoints.getItemCount() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Profile duplicateProfile(Profile profile, List<DosboxVersion> list, Database database, Shell shell) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        try {
            database.startTransaction();
            DosboxVersion dosboxVersion = DosboxVersion.findById(list, profile.getDbversionId());
            Conf conf = new Conf(profile, dosboxVersion, printStream);
            Profile profile2 = database.duplicateProfile(profile);
            database.saveNativeCommands(database.readNativeCommandsList(profile.getId(), -1), profile2.getId(), -1);
            String string = FileUtils.constructCapturesDir(profile2.getId());
            File file = FileUtils.canonicalToData(string);
            FileUtils.createDir(file);
            String string2 = FileUtils.constructUniqueConfigFileString(profile2.getId(), profile.getTitle(), conf.getAutoexec().isIncomplete() ? null : conf.getAutoexec().getCanonicalMainDir());
            profile2 = new Profile(profile2.getId(), string2, string, profile2);
            conf.injectOrUpdateProfile(profile2);
            conf.save();
            profile2 = database.updateProfileConf(string2, string, profile2.getId());
            database.commitTransaction();
            if (GeneralPurposeDialogs.confirmMessage(shell, Settings.getInstance().msg("dialog.profile.confirm.capturesduplication"))) {
                FileUtils.copyFiles(profile.getCanonicalCaptures(), file);
            }
            if (byteArrayOutputStream.size() > 0) {
                GeneralPurposeDialogs.warningMessage(shell, byteArrayOutputStream.toString());
                byteArrayOutputStream.reset();
            }
            Profile profile3 = profile2;
            return profile3;
        }
        catch (Exception exception) {
            GeneralPurposeDialogs.warningMessage(shell, exception);
            try {
                database.rollbackTransaction();
            }
            catch (SQLException sQLException) {
                GeneralPurposeDialogs.warningMessage(shell, sQLException);
            }
            Profile profile4 = null;
            return profile4;
        }
        finally {
            database.finishTransaction();
        }
    }

    @Override
    protected void doPerformDosboxConfAction(EditTemplateDialog.DosboxConfAction dosboxConfAction) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            this.updateAllConfigurationsBySettings();
            Conf conf = null;
            conf = dosboxConfAction == EditTemplateDialog.DosboxConfAction.RELOAD_TEMPLATE ? new Conf(this.templatesList.get(this.template.getSelectionIndex()), (DosboxVersion)this.dbversionsList.get(this.dbversion.getSelectionIndex()), printStream) : new Conf((DosboxVersion)this.dbversionsList.get(this.dbversion.getSelectionIndex()), printStream);
            if (this.isMultiEdit()) {
                for (Configurable configurable : this.multiProfileList) {
                    if (!configurable.getConf().hasDifferentBaseMountsThan(conf)) continue;
                    printStream.println(Settings.getInstance().msg("dialog.multiprofile.notice.basemountsconflicting"));
                    break;
                }
            }
            for (Configurable configurable : this.multiProfileList) {
                this.doPerformdosboxConfAction(dosboxConfAction, conf, configurable);
            }
            if (this.isMultiEdit()) {
                this.doPerformdosboxConfAction(dosboxConfAction, conf, this.multiProfileCombined);
                this.enableSettingsByConfiguration(this.multiProfileCombined.getConf().getDosboxSettings());
                this.selectSettingsByConfiguration(this.multiProfileCombined.getConf());
            } else {
                if (dosboxConfAction == EditTemplateDialog.DosboxConfAction.RELOAD_TEMPLATE && ((Configurable)this.multiProfileList.get(0)).getNativeCommandsList().size() == 1) {
                    ((Configurable)this.multiProfileList.get(0)).setNativeCommandsList(this.dbase.readNativeCommandsList(-1, this.templatesList.get(this.template.getSelectionIndex()).getId()));
                    this.updateNativeCommands(-1);
                }
                this.enableSettingsByConfiguration(((Configurable)this.multiProfileList.get(0)).getConf().getDosboxSettings());
                this.selectSettingsByConfiguration(((Configurable)this.multiProfileList.get(0)).getConf());
            }
            if (byteArrayOutputStream.size() > 0) {
                GeneralPurposeDialogs.warningMessage(this.getParent(), byteArrayOutputStream.toString());
                byteArrayOutputStream.reset();
            }
        }
        catch (IOException | SQLException exception) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), exception);
        }
    }

    private void doPerformdosboxConfAction(EditTemplateDialog.DosboxConfAction dosboxConfAction, Conf conf, Configurable configurable) {
        if (dosboxConfAction == EditTemplateDialog.DosboxConfAction.SET) {
            configurable.getConf().setToDosboxVersion(conf);
        } else if (dosboxConfAction == EditTemplateDialog.DosboxConfAction.SWITCH) {
            configurable.getConf().switchToDosboxVersion(conf);
        } else if (dosboxConfAction == EditTemplateDialog.DosboxConfAction.RELOAD) {
            configurable.getConf().reloadDosboxVersion(conf);
        } else if (dosboxConfAction == EditTemplateDialog.DosboxConfAction.RELOAD_TEMPLATE) {
            configurable.getConf().reloadTemplate(conf);
        }
    }

    @Override
    protected void selectSettingsByConfiguration(Conf conf) {
        super.selectSettingsByConfiguration(conf);
        EditProfileDialog.setFieldIfEnabled(this.result instanceof Profile ? ((Profile)this.result).getCaptures() : this.settings.msg("dialog.profile.automatic"), false, (Control)this.captures);
        EditProfileDialog.setFieldIfEnabled(String.valueOf(conf.getAutoexec().isLoadfix()), Conf.isConflictingValue(conf.getAutoexec().isLoadfix()), (Control)this.loadfix);
        EditProfileDialog.setFieldIfEnabled(String.valueOf(conf.getAutoexec().isLoadhigh()), Conf.isConflictingValue(conf.getAutoexec().isLoadhigh()), (Control)this.loadhigh);
        this.loadfix_value.setEnabled(this.loadfix.getSelection());
        EditProfileDialog.setFieldIfEnabled(String.valueOf(conf.getAutoexec().getLoadfixValue()), Conf.isConflictingValue(conf.getAutoexec().getLoadfixValue()), (Control)this.loadfix_value);
        if (!this.isMultiEdit()) {
            if (conf.getAutoexec().isBooter()) {
                this.img1.setText(conf.getAutoexec().getImg1());
                this.img2.setText(conf.getAutoexec().getImg2());
                this.img3.setText(conf.getAutoexec().getImg3());
                this.imgDriveletter.setText(conf.getAutoexec().getImgDriveletter());
            } else {
                this.main.setText(conf.getAutoexec().getMain());
                this.main_params.setText(conf.getAutoexec().getMainParameters());
            }
        }
    }

    protected void updateAllConfigurationsBySettings() {
        if (this.isMultiEdit()) {
            String[] stringArray = new String[this.customCommands.length];
            for (int i = 0; i < this.customCommands.length; ++i) {
                stringArray[i] = StringRelatedUtils.textAreaToString(this.fetch(this.customCommands[i]), this.customCommands[i].getLineDelimiter(), PlatformUtils.EOLN);
            }
            for (Configurable configurable : this.multiProfileList) {
                super.updateConfigurationBySettings(configurable.getConf());
                configurable.getConf().setAutoexecSettingsForProfileMultiEdit(this.fetch(this.loadhigh), this.fetch(this.loadfix), this.fetch(this.loadfix_value), this.fetch(this.exit), this.fetch(this.mixer_config), this.fetch(this.keyb), this.fetch(this.ipxnet), stringArray);
            }
            super.updateConfigurationBySettings(this.multiProfileCombined.getConf());
            this.multiProfileCombined.getConf().setAutoexecSettingsForProfileMultiEdit(this.fetch(this.loadhigh), this.fetch(this.loadfix), this.fetch(this.loadfix_value), this.fetch(this.exit), this.fetch(this.mixer_config), this.fetch(this.keyb), this.fetch(this.ipxnet), stringArray);
        } else {
            super.updateConfigurationBySettings(((Configurable)this.multiProfileList.get(0)).getConf());
            ((Configurable)this.multiProfileList.get(0)).getConf().setAutoexecSettingsForProfile(this.loadhigh.getSelection(), this.loadfix.getSelection(), this.loadfix_value.getText(), this.main.getText(), this.main_params.getText(), this.img1.getText(), this.img2.getText(), this.img3.getText(), this.imgDriveletter.getText());
        }
    }

    protected boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (!this.isMultiEdit()) {
            String string = null;
            if (this.title.getText().length() == 0) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.title"), (Control)this.title, this.infoTabItem);
            }
            if (this.dosExpandItem.getExpanded()) {
                if (FileUtils.isExecutable(this.main.getText())) {
                    string = this.dealWithField(false, this.main.getText());
                } else {
                    GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.mainexe"), (Control)this.main, this.mountingTabItem);
                }
                if (FileUtils.isExecutable(this.setup.getText())) {
                    string = this.dealWithField(false, this.setup.getText());
                }
            } else {
                if (this.img1.getText().length() == 0) {
                    GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.booterimage"), (Control)this.img1, this.mountingTabItem);
                } else {
                    string = this.dealWithField(true, this.img1.getText());
                }
                if (this.img2.getText().length() > 0) {
                    string = this.dealWithField(true, this.img2.getText());
                }
                if (this.img3.getText().length() > 0) {
                    string = this.dealWithField(true, this.img3.getText());
                }
            }
            if (string != null) {
                GeneralPurposeDialogs.addError(this.settings.msg("dialog.profile.required.mountlocation"), (Control)this.mountingpoints, this.mountingTabItem);
            }
        }
        if (this.setButton.isEnabled()) {
            GeneralPurposeDialogs.addError(this.settings.msg("dialog.template.required.dosboxassociation"), (Control)this.setButton, this.generalTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell);
    }

    private String dealWithField(boolean bl, String string) {
        String string2 = ((Configurable)this.multiProfileList.get(0)).getConf().getRequiredMount(bl, string);
        if (string2 != null && GeneralPurposeDialogs.confirmMessage(this.shell, this.settings.msg("dialog.profile.confirm.addmountlocation", new Object[]{string2}))) {
            this.mountingpoints.setItems(((Configurable)this.multiProfileList.get(0)).getConf().addRequiredMount(bl, string));
        }
        return ((Configurable)this.multiProfileList.get(0)).getConf().getRequiredMount(bl, string);
    }

    private void setProfileMetaData(Profile profile) {
        int n;
        EditProfileDialog.setFieldIfEnabled(profile.getTitle(), Conf.isConflictingValue(profile.getTitle()), (Control)this.title);
        EditProfileDialog.setFieldIfEnabled(profile.getDeveloperName(), Conf.isConflictingValue(profile.getDeveloperName()), this.developer);
        EditProfileDialog.setFieldIfEnabled(profile.getPublisherName(), Conf.isConflictingValue(profile.getPublisherName()), this.publisher);
        EditProfileDialog.setFieldIfEnabled(profile.getGenre(), Conf.isConflictingValue(profile.getGenre()), this.genre);
        EditProfileDialog.setFieldIfEnabled(profile.getYear(), Conf.isConflictingValue(profile.getYear()), this.year);
        for (n = 0; n < 8; ++n) {
            EditProfileDialog.setFieldIfEnabled(profile.getLink(n), Conf.isConflictingValue(profile.getLink(n)), (Control)this.link[n]);
            EditProfileDialog.setFieldIfEnabled(profile.getLinkTitle(n), Conf.isConflictingValue(profile.getLinkTitle(n)), (Control)this.linkTitle[n]);
        }
        EditProfileDialog.setFieldIfEnabled(profile.getStatus(), Conf.isConflictingValue(profile.getStatus()), this.status);
        EditProfileDialog.setFieldIfEnabled(String.valueOf(profile.isDefault()), Conf.isConflictingValue(profile.isDefault()), (Control)this.favorite);
        EditProfileDialog.setFieldIfEnabled(profile.getNotes(), Conf.isConflictingValue(profile.getNotes()), (Control)this.notes);
        EditProfileDialog.setFieldIfEnabled(profile.getSetup(0), Conf.isConflictingValue(profile.getSetup(0)), (Control)this.setup);
        EditProfileDialog.setFieldIfEnabled(profile.getSetupParameters(0), Conf.isConflictingValue(profile.getSetupParameters(0)), (Control)this.setup_params);
        EditProfileDialog.setFieldIfEnabled(profile.getSetup(1), Conf.isConflictingValue(profile.getSetup(1)), (Control)this.alt1);
        EditProfileDialog.setFieldIfEnabled(profile.getSetupParameters(1), Conf.isConflictingValue(profile.getSetupParameters(1)), (Control)this.alt1_params);
        EditProfileDialog.setFieldIfEnabled(profile.getSetup(2), Conf.isConflictingValue(profile.getSetup(2)), (Control)this.alt2);
        EditProfileDialog.setFieldIfEnabled(profile.getSetupParameters(2), Conf.isConflictingValue(profile.getSetupParameters(2)), (Control)this.alt2_params);
        for (n = 0; n < 4; ++n) {
            EditProfileDialog.setFieldIfEnabled(profile.getCustomString(n), Conf.isConflictingValue(profile.getCustomString(n)), this.customCombo[n]);
            EditProfileDialog.setFieldIfEnabled(profile.getCustomString(4 + n), Conf.isConflictingValue(profile.getCustomString(4 + n)), (Control)this.customText[n]);
        }
        EditProfileDialog.setFieldIfEnabled(String.valueOf(profile.getCustomInt(0)), Conf.isConflictingValue(profile.getCustomInt(0)), (Control)this.custom9);
        EditProfileDialog.setFieldIfEnabled(String.valueOf(profile.getCustomInt(1)), Conf.isConflictingValue(profile.getCustomInt(1)), (Control)this.custom10);
    }

    private static List<Control> getChangeables(Composite composite) {
        Control[] controlArray = composite.getChildren();
        ArrayList<Control> arrayList = new ArrayList<Control>();
        for (Control control : controlArray) {
            if (control instanceof Button && (control.getStyle() & 0x20) != 0 || control instanceof Combo || control instanceof Text || control instanceof Spinner || control instanceof Scale || control instanceof org.eclipse.swt.widgets.List) {
                arrayList.add(control);
                continue;
            }
            if (!(control instanceof Group) && !(control instanceof Composite)) continue;
            arrayList.addAll(EditProfileDialog.getChangeables((Composite)control));
        }
        return arrayList;
    }

    private void saveWebImages(File file) {
        for (int i = 0; i < this.imageInformation.length; ++i) {
            File file2;
            String string;
            if (!this.imgButtons[i].getSelection()) continue;
            String string2 = FileUtils.fileSystemSafeWebImages(this.imageInformation[i].description);
            if (this.imageInformation[i].type == SearchEngineImageInformation.SearchEngineImageType.CoverArt) {
                string = this.settings.msg("dialog.profile.mobygames.coverartfilename", new Object[]{i, string2});
                file2 = new File(file, string + ".jpg");
            } else {
                string = this.settings.msg("dialog.profile.mobygames.screenshotfilename", new Object[]{i, string2});
                file2 = new File(file, string + ".png");
            }
            if (!FileUtils.isExistingFile(file2)) {
                try {
                    SWTImageManager.save(this.imageInformation[i].data, file2.getPath());
                }
                catch (SWTException sWTException) {
                    GeneralPurposeDialogs.warningMessage(this.shell, this.settings.msg("general.error.savefile", new Object[]{file2.getPath()}), (Exception)((Object)sWTException));
                }
                continue;
            }
            GeneralPurposeDialogs.warningMessage(this.shell, this.settings.msg("dialog.profile.error.imagealreadyexists", new Object[]{file2.getPath(), this.getSelectedSearchEngine().getName()}));
        }
    }

    private WebSearchEngine getSelectedSearchEngine() {
        WebSearchEngine webSearchEngine = null;
        for (WebSearchEngine webSearchEngine2 : webSearchEngines) {
            if (!webSearchEngine2.getName().equals(this.engineSelector.getData("engine"))) continue;
            webSearchEngine = webSearchEngine2;
        }
        return webSearchEngine;
    }

    private WebSearchEngine getSearchEngineBySimpleName(String string) {
        for (WebSearchEngine webSearchEngine : webSearchEngines) {
            if (!webSearchEngine.getSimpleName().equalsIgnoreCase(string)) continue;
            return webSearchEngine;
        }
        return null;
    }

    static /* synthetic */ SearchEngineImageInformation[] access$2602(EditProfileDialog editProfileDialog, SearchEngineImageInformation[] searchEngineImageInformationArray) {
        editProfileDialog.imageInformation = searchEngineImageInformationArray;
        return searchEngineImageInformationArray;
    }

    static /* synthetic */ Button[] access$3102(EditProfileDialog editProfileDialog, Button[] buttonArray) {
        editProfileDialog.imgButtons = buttonArray;
        return buttonArray;
    }
}

