/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.StringRelatedUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public final class GeneralPurposeDialogs {
    private static List<String> errorMessages;
    private static Control wgt;
    private static TabItem tab;

    public static void fatalMessage(Shell shell, String string) {
        GeneralPurposeDialogs.fatalMessage(shell, System.err, string, null);
    }

    public static void fatalMessage(Shell shell, String string, Exception exception) {
        GeneralPurposeDialogs.fatalMessage(shell, System.err, string, exception);
    }

    private static void fatalMessage(Shell shell, PrintStream printStream, String string, Exception exception) {
        if (shell != null) {
            MessageBox messageBox = new MessageBox(shell, 65569);
            messageBox.setText(Settings.getInstance().msg("general.fatalerror"));
            messageBox.setMessage(string);
            messageBox.open();
        }
        printStream.println(Settings.getInstance().msg("general.fatalerror") + ": " + string);
        if (exception != null) {
            exception.printStackTrace(printStream);
        }
    }

    public static void warningMessage(Shell shell, String string) {
        GeneralPurposeDialogs.warningMessage(shell, System.err, string, null);
    }

    public static void warningMessage(Shell shell, Exception exception) {
        GeneralPurposeDialogs.warningMessage(shell, System.err, StringRelatedUtils.toString(exception), exception);
    }

    public static void warningMessage(Shell shell, String string, Exception exception) {
        GeneralPurposeDialogs.warningMessage(shell, System.err, string, exception);
    }

    private static void warningMessage(Shell shell, PrintStream printStream, String string, Exception exception) {
        if (shell != null) {
            MessageBox messageBox = new MessageBox(shell, 65576);
            messageBox.setText(Settings.getInstance().msg("general.warning"));
            messageBox.setMessage(string);
            messageBox.open();
        }
        printStream.println(Settings.getInstance().msg("general.warning") + ": " + string);
        if (exception != null) {
            exception.printStackTrace(printStream);
        }
    }

    public static void infoMessage(Shell shell, String string) {
        GeneralPurposeDialogs.infoMessage(shell, System.out, string);
    }

    private static void infoMessage(Shell shell, PrintStream printStream, String string) {
        if (shell != null) {
            MessageBox messageBox = new MessageBox(shell, 65570);
            messageBox.setText(Settings.getInstance().msg("general.information"));
            messageBox.setMessage(string);
            messageBox.open();
        }
        printStream.println(Settings.getInstance().msg("general.information") + ": " + string);
    }

    public static boolean confirmMessage(Shell shell, String string) {
        MessageBox messageBox = new MessageBox(shell, 65736);
        messageBox.setText(Settings.getInstance().msg("general.confirmation"));
        messageBox.setMessage(string);
        return messageBox.open() == 64;
    }

    public static void initErrorDialog() {
        errorMessages = new ArrayList<String>();
        wgt = null;
        tab = null;
    }

    public static void addError(String string, Control control) {
        GeneralPurposeDialogs.addError(string, control, null);
    }

    public static void addError(String string, Control control, TabItem tabItem) {
        if (errorMessages.isEmpty()) {
            wgt = control;
            tab = tabItem;
        }
        errorMessages.add(string);
    }

    public static boolean hasErrors() {
        return !errorMessages.isEmpty();
    }

    public static boolean displayErrorDialog(Shell shell) {
        boolean bl;
        boolean bl2 = bl = !errorMessages.isEmpty();
        if (bl) {
            if (tab != null) {
                TabFolder tabFolder = tab.getParent();
                tabFolder.setSelection(tab);
            }
            GeneralPurposeDialogs.infoMessage(shell, StringRelatedUtils.stringArrayToString(errorMessages.toArray(new String[errorMessages.size()]), "\n"));
            wgt.setFocus();
        }
        return bl;
    }
}

