/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.SizeControlAdapter;
import org.dbgl.interfaces.Configurable;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.LoaderThread;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class ProfileLoader
extends Dialog {
    private Shell shell;
    private ProgressBar progressBar;
    private List<Profile> profs;
    private LoaderThread job = null;
    private List<ExpProfile> result = null;
    private boolean combine;
    private Settings settings;
    private Label status;
    private Text log;
    private Button okButton;
    private Button cancelButton;

    public ProfileLoader(Shell shell, int n) {
        super(shell, n);
    }

    public ProfileLoader(Shell shell, List<Profile> list, boolean bl) {
        this(shell, 0);
        this.profs = list;
        this.combine = bl;
        this.settings = Settings.getInstance();
    }

    public ProfileLoader(Shell shell) {
        this(shell, 0);
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        try {
            this.job = new LoaderThread(this.log, this.progressBar, this.status, this.profs, this.combine);
            this.job.start();
        }
        catch (SQLException sQLException) {
            GeneralPurposeDialogs.warningMessage(this.shell, sQLException);
            this.shell.close();
        }
        boolean bl = false;
        while (!this.shell.isDisposed()) {
            if (this.job != null && !this.job.isAlive() && !bl) {
                if (!this.job.isEverythingOk()) {
                    String string = this.settings.msg("dialog.profileloader.error.reading");
                    if (!this.job.getResult().isEmpty()) {
                        this.okButton.setEnabled(true);
                        string = string + "\n\n" + this.settings.msg("dialog.profileloader.confirm.continue", new Object[]{this.job.getResult().size()});
                    }
                    GeneralPurposeDialogs.warningMessage(this.shell, string);
                    this.status.setText(this.settings.msg("dialog.migration.reviewlog"));
                    this.status.pack();
                } else {
                    this.result = this.job.getResult();
                    this.shell.close();
                }
                bl = true;
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    protected void createContents() {
        this.shell = new Shell(this.getParent(), 67696);
        this.shell.setLayout((Layout)new GridLayout());
        this.shell.addControlListener((ControlListener)new SizeControlAdapter(this.shell, "profileloaderdialog"));
        this.shell.setText(this.settings.msg("dialog.profileloader.title", new Object[]{this.profs.size()}));
        Group group = new Group((Composite)this.shell, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(this.settings.msg("dialog.migration.progress"));
        group.setLayout((Layout)new GridLayout());
        this.progressBar = new ProgressBar((Composite)group, 0);
        this.progressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.progressBar.setMaximum(this.profs.size());
        this.status = new Label((Composite)group, 0);
        this.status.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.log = new Text((Composite)group, 2826);
        this.log.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        this.okButton = new Button(composite, 0);
        this.shell.setDefaultButton(this.okButton);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 80;
        this.okButton.setLayoutData((Object)gridData);
        this.okButton.setText(this.settings.msg("button.ok"));
        this.okButton.setEnabled(false);
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProfileLoader.this.result = ProfileLoader.this.job.getResult();
                ProfileLoader.this.shell.close();
            }
        });
        this.cancelButton = new Button(composite, 0);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        this.cancelButton.setLayoutData((Object)gridData2);
        this.cancelButton.setText(this.settings.msg("button.cancel"));
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProfileLoader.this.shell.close();
            }
        });
    }

    public List<ExpProfile> getResult() {
        return this.result;
    }

    public List<Configurable> getResultAsConfigurables() {
        return new ArrayList<Configurable>(this.result);
    }

    public ExpProfile getMultiProfileCombined() {
        return this.job.getMultiProfileCombined();
    }
}

