/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.loopy.iso9660;

import org.dbgl.loopy.iso9660.ISO9660FileSystem;
import org.dbgl.loopy.util.Util;

public final class ISO9660FileEntry {
    private static final char ID_SEPARATOR = ';';
    private ISO9660FileSystem fileSystem;
    private String parentPath;
    private final int entryLength;
    private final long startSector;
    private final int dataLength;
    private final int flags;
    private final String identifier;

    public ISO9660FileEntry(ISO9660FileSystem iSO9660FileSystem, byte[] byArray, int n) {
        this(iSO9660FileSystem, null, byArray, n);
    }

    public ISO9660FileEntry(ISO9660FileSystem iSO9660FileSystem, String string, byte[] byArray, int n) {
        this.fileSystem = iSO9660FileSystem;
        this.parentPath = string;
        int n2 = n - 1;
        this.entryLength = Util.getUInt8(byArray, n2 + 1);
        this.startSector = Util.getUInt32LE(byArray, n2 + 3);
        this.dataLength = (int)Util.getUInt32LE(byArray, n2 + 11);
        this.flags = Util.getUInt8(byArray, n2 + 26);
        this.identifier = this.getFileIdentifier(byArray, n2, this.isDirectory());
    }

    private String getFileIdentifier(byte[] byArray, int n, boolean bl) {
        String string;
        int n2;
        int n3 = Util.getUInt8(byArray, n + 33);
        if (bl) {
            int n4 = Util.getUInt8(byArray, n + 34);
            if (n3 == 1 && n4 == 0) {
                return ".";
            }
            if (n3 == 1 && n4 == 1) {
                return "..";
            }
        }
        if ((n2 = (string = Util.getDChars(byArray, n + 34, n3, this.fileSystem.getEncoding())).indexOf(59)) >= 0) {
            return string.substring(0, n2);
        }
        return string;
    }

    public String getPath() {
        if (".".equals(this.getName())) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.parentPath != null) {
            stringBuffer.append(this.parentPath);
        }
        stringBuffer.append(this.getName());
        if (this.isDirectory()) {
            stringBuffer.append("/");
        }
        return stringBuffer.toString();
    }

    public boolean isDirectory() {
        return (this.flags & 2) != 0;
    }

    String getName() {
        return this.identifier;
    }

    int getSize() {
        return this.dataLength;
    }

    long getStartBlock() {
        return this.startSector;
    }

    int getEntryLength() {
        return this.entryLength;
    }
}

