/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.File;
import java.util.Date;
import java.util.List;
import org.dbgl.model.GenericStats;
import org.dbgl.model.KeyTitleDefault;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;

public class DosboxVersion
extends KeyTitleDefault
implements Comparable<DosboxVersion> {
    public static final String[] SUPP_RELEASES = new String[]{"0.63", "0.65", "0.70", "0.71", "0.72", "0.73", "0.74"};
    public static final String LATEST = SUPP_RELEASES[SUPP_RELEASES.length - 1];
    private final String path;
    private final String conf;
    private final boolean multiConfig;
    private final boolean usingCurses;
    private final String parameters;
    private final String version;
    protected GenericStats stats;

    public DosboxVersion(int n, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, String string4, String string5, Date date, Date date2, Date date3, int n2) {
        super(n, string, bl3);
        this.path = PlatformUtils.pathToNativePath(string2);
        this.conf = PlatformUtils.pathToNativePath(string3);
        this.multiConfig = bl;
        this.usingCurses = bl2;
        this.parameters = string4;
        this.version = string5;
        this.stats = new GenericStats(date, date2, date3, n2);
    }

    public boolean isMultiConfig() {
        return this.multiConfig;
    }

    public boolean isUsingCurses() {
        return this.usingCurses;
    }

    public String getPath() {
        return this.path;
    }

    public File getCanonicalExecutable() {
        return FileUtils.constructCanonicalDBExeLocation(this.path);
    }

    public String getConf() {
        return this.conf;
    }

    public File getCanonicalConfFile() {
        return FileUtils.canonicalToDosbox(this.conf);
    }

    public String getParameters() {
        return this.parameters;
    }

    public String getVersion() {
        return this.version;
    }

    public GenericStats getStats() {
        return this.stats;
    }

    public int findBestMatchId(List<DosboxVersion> list) {
        for (DosboxVersion dosboxVersion : list) {
            if (this.distance(dosboxVersion) != 0 || !this.getTitle().equals(dosboxVersion.getTitle())) continue;
            return dosboxVersion.getId();
        }
        DosboxVersion dosboxVersion = DosboxVersion.findDefault(list);
        if (this.distance(dosboxVersion) == 0) {
            return dosboxVersion.getId();
        }
        int n = list.get(0).getId();
        int n2 = this.distance(list.get(0));
        for (DosboxVersion dosboxVersion2 : list) {
            if (this.distance(dosboxVersion2) >= n2) continue;
            n = dosboxVersion2.getId();
            n2 = this.distance(dosboxVersion2);
        }
        return n;
    }

    private int getVersionInt() {
        return Integer.valueOf(this.version.substring(2));
    }

    private int distance(DosboxVersion dosboxVersion) {
        return Math.abs(dosboxVersion.getVersionInt() - this.getVersionInt());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DosboxVersion dosboxVersion = (DosboxVersion)object;
        return this.getVersionInt() == dosboxVersion.getVersionInt() && this.getTitle().equals(dosboxVersion.getTitle());
    }

    @Override
    public int compareTo(DosboxVersion dosboxVersion) {
        int n;
        DosboxVersion dosboxVersion2 = dosboxVersion;
        int n2 = this.getVersionInt();
        if (n2 != (n = dosboxVersion2.getVersionInt())) {
            return n2 - n;
        }
        return this.getTitle().compareTo(dosboxVersion2.getTitle());
    }
}

