/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.util.List;
import org.dbgl.model.KeyValuePair;
import org.dbgl.model.conf.Settings;

public class KeyTitleDefault
extends KeyValuePair {
    private Boolean defaultChoice;

    public KeyTitleDefault(int n, String string, Boolean bl) {
        super(n, string);
        this.defaultChoice = bl;
    }

    public String getTitle() {
        return this.getValue();
    }

    public Boolean isDefault() {
        return this.defaultChoice;
    }

    public String isDefaultString() {
        return this.defaultChoice != false ? Settings.getInstance().msg("general.yes") : Settings.getInstance().msg("general.no");
    }

    public void toggleDefault() {
        this.defaultChoice = this.defaultChoice == false;
    }

    public static <T extends KeyTitleDefault> int indexOfDefault(List<T> list) {
        int n = 0;
        for (KeyTitleDefault keyTitleDefault : list) {
            if (keyTitleDefault.isDefault().booleanValue()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static <T extends KeyTitleDefault> T findDefault(List<T> list) {
        for (KeyTitleDefault keyTitleDefault : list) {
            if (!keyTitleDefault.isDefault().booleanValue()) continue;
            return (T)keyTitleDefault;
        }
        return null;
    }
}

