/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MixerCommand {
    public static final String[] CHANNELS = new String[]{"master", "spkr", "sb", "gus", "fm", "disney", "cdaudio"};
    public static final int DEFAULT_VOLUME_LEVEL = 100;
    public static final int MAX_VOLUME_LEVEL = 200;
    private List<VolumeSetting> volumes;

    public MixerCommand(String string) {
        this.init();
        String[] stringArray = StringUtils.split((String)string, (char)' ');
        for (int i = 0; i < stringArray.length; i += 2) {
            for (VolumeSetting volumeSetting : this.volumes) {
                if (!stringArray[i].equalsIgnoreCase(volumeSetting.name) || i + 1 >= stringArray.length) continue;
                volumeSetting.setVolume(stringArray[i + 1]);
            }
        }
    }

    private void init() {
        this.volumes = new ArrayList<VolumeSetting>();
        for (String string : CHANNELS) {
            this.volumes.add(new VolumeSetting(string));
        }
    }

    public VolumeSetting getVolumeFor(String string) {
        for (VolumeSetting volumeSetting : this.volumes) {
            if (!string.equalsIgnoreCase(volumeSetting.name)) continue;
            return volumeSetting;
        }
        return null;
    }

    public void setVolumeFor(String string, int n, int n2) {
        for (VolumeSetting volumeSetting : this.volumes) {
            if (!string.equalsIgnoreCase(volumeSetting.name)) continue;
            volumeSetting.setVolume(n, n2);
        }
    }

    public String toString() {
        return StringUtils.join(this.volumes, (char)' ').trim().replaceAll("\\s+", " ");
    }

    public static class VolumeSetting {
        private String name;
        private int left;
        private int right;

        public VolumeSetting(String string) {
            this.name = string;
            this.left = 100;
            this.right = 100;
        }

        public void setVolume(String string) {
            try {
                String[] stringArray = StringUtils.split((String)string, (char)':');
                if (stringArray.length == 2) {
                    this.setVolume(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        private void setVolume(int n, int n2) {
            this.left = n;
            this.right = n2;
        }

        public int getLeft() {
            return this.left;
        }

        public int getRight() {
            return this.right;
        }

        public String toString() {
            return this.left != 100 || this.right != 100 ? new StringBuffer(this.name).append(' ').append(this.left).append(':').append(this.right).toString() : "";
        }
    }
}

