/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.KeyValuePair;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Conf;
import org.dbgl.util.FileUtils;
import org.dbgl.util.UIThread;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public final class DFendReloadedImportThread
extends UIThread {
    private static final int[] CUST_INTS = new int[]{0, 0};
    private static final int[] CUST_IDS = new int[]{0, 0, 0, 0};
    private final boolean performCleanup;
    private final DosboxVersion defaultDBVersion;
    private File dfendPath;
    private File profsPath;
    private File confsPath;

    public DFendReloadedImportThread(Text text, ProgressBar progressBar, Label label, File file, File file2, boolean bl, DosboxVersion dosboxVersion) throws IOException, SQLException {
        super(text, progressBar, label);
        this.performCleanup = bl;
        this.defaultDBVersion = dosboxVersion;
        this.dfendPath = file;
        this.profsPath = new File(this.dfendPath, "Confs");
        File file3 = new File(this.dfendPath, "Settings");
        File file4 = new File(file3, "DFend.ini");
        Conf conf = new Conf(file4, this.ps);
        String string = conf.getSettings().getValue("ProgramSets", "defloc");
        if (StringUtils.isNotBlank((CharSequence)string)) {
            this.dfendPath = new File(string);
        }
        this.confsPath = file2;
        this.objects = new ArrayList(org.apache.commons.io.FileUtils.listFiles((File)this.profsPath, (String[])new String[]{"prof"}, (boolean)false));
        progressBar.setMaximum(this.objects.size());
    }

    @Override
    public void doFancyStuff(Object object, StringBuffer stringBuffer) throws IOException, SQLException {
        File file = (File)object;
        Conf conf = new Conf(file, this.ps);
        String string = conf.getSettings().getValue("ExtraInfo", "name");
        this.displayTitle(this.settings.msg("dialog.dfendimport.importing", new Object[]{string}));
        boolean bl = conf.getSettings().getValue("ExtraInfo", "favorite").equals("1");
        String string2 = conf.getSettings().getValue("Extra", "setup");
        if (StringUtils.isNotEmpty((CharSequence)string2)) {
            string2 = FileUtils.canonical(new File(this.dfendPath, conf.getSettings().getValue("Extra", "setup")).getPath()).getPath();
        }
        String string3 = conf.getSettings().getValue("Extra", "setupparameters");
        String string4 = this.fixCRLF(conf.getSettings().getValue("ExtraInfo", "notes"));
        String string5 = conf.getSettings().getValue("ExtraInfo", "developer");
        String string6 = conf.getSettings().getValue("ExtraInfo", "publisher");
        String string7 = conf.getSettings().getValue("ExtraInfo", "genre");
        String string8 = conf.getSettings().getValue("ExtraInfo", "year");
        String string9 = conf.getSettings().getValue("ExtraInfo", "language");
        String string10 = conf.getSettings().getValue("ExtraInfo", "userinfo");
        if (StringUtils.isNotEmpty((CharSequence)string10)) {
            string10 = StringUtils.join((Object[])StringUtils.split((String)this.fixCRLF(string10), (String)"\n"), (String)", ");
        }
        String string11 = this.settings.msg("dialog.dfendimport.defaultprofilestatus");
        int n = KeyValuePair.findIdByValue(this.dbase.readDevelopersList(), string5);
        int n2 = KeyValuePair.findIdByValue(this.dbase.readPublishersList(), string6);
        int n3 = KeyValuePair.findIdByValue(this.dbase.readGenresList(), string7);
        int n4 = KeyValuePair.findIdByValue(this.dbase.readYearsList(), string8);
        int n5 = KeyValuePair.findIdByValue(this.dbase.readStatusList(), string11);
        String[] stringArray = new String[]{string9, "", "", "", string10, "", "", ""};
        int[] nArray = CUST_IDS;
        for (int i = 0; i < 4; ++i) {
            nArray[i] = KeyValuePair.findIdByValue(this.dbase.readCustomList(i), stringArray[i]);
        }
        String[] stringArray2 = new String[]{this.fixWWW(conf.getSettings().getValue("ExtraInfo", "www")), this.fixWWW(conf.getSettings().getValue("ExtraInfo", "www2")), this.fixWWW(conf.getSettings().getValue("ExtraInfo", "www3")), this.fixWWW(conf.getSettings().getValue("ExtraInfo", "www4")), this.fixWWW(conf.getSettings().getValue("ExtraInfo", "www5")), this.fixWWW(conf.getSettings().getValue("ExtraInfo", "www6")), this.fixWWW(conf.getSettings().getValue("ExtraInfo", "www7")), this.fixWWW(conf.getSettings().getValue("ExtraInfo", "www8"))};
        String[] stringArray3 = new String[]{conf.getSettings().getValue("ExtraInfo", "wwwname"), conf.getSettings().getValue("ExtraInfo", "www2name"), conf.getSettings().getValue("ExtraInfo", "www3name"), conf.getSettings().getValue("ExtraInfo", "www4name"), conf.getSettings().getValue("ExtraInfo", "www5name"), conf.getSettings().getValue("ExtraInfo", "www6name"), conf.getSettings().getValue("ExtraInfo", "www7name"), conf.getSettings().getValue("ExtraInfo", "www8name")};
        Profile profile = this.dbase.addOrEditProfile(string, string5, string6, string7, string8, string11, string4, bl, new String[]{string2, "", ""}, new String[]{string3, "", ""}, n, n2, n3, n4, n5, this.defaultDBVersion.getId(), stringArray2, stringArray3, stringArray, CUST_INTS, nArray, -1);
        Conf conf2 = new Conf(new File(this.confsPath, FilenameUtils.removeExtension((String)file.getName()) + ".conf"), string, profile.getId(), this.defaultDBVersion, this.ps);
        String string12 = conf2.getSettings().getValue("dosbox", "captures");
        String string13 = FileUtils.constructCapturesDir(profile.getId());
        String string14 = FileUtils.constructRelativeCapturesDir(profile.getId(), conf2.getConfFile().getParentFile(), conf2.getSettings().detectDosboxVersionGeneration());
        File file2 = FileUtils.canonicalToData(string13);
        FileUtils.createDir(file2);
        FileUtils.copyFiles(new File(string12), file2);
        conf2.getSettings().setValue("dosbox", "captures", string14);
        if (this.performCleanup) {
            conf2.getSettings().removeSection("joystick");
            conf2.getSettings().removeSection("sdl");
        }
        conf2.alterToDosboxVersionGeneration(conf2);
        conf2.save();
        profile = this.dbase.updateProfileConf(FileUtils.makeRelativeToData(conf2.getConfFile()).getPath(), string13, profile.getId());
        if (conf2.getAutoexec().isIncomplete()) {
            this.ps.println(this.settings.msg("dialog.multiprofile.error.profileincomplete"));
        }
    }

    private String fixCRLF(String string) {
        return StringUtils.replace((String)StringUtils.replace((String)string, (String)"[13][10]", (String)"\n"), (String)"[13]", (String)"").trim();
    }

    private String fixWWW(String string) {
        if (StringUtils.isNotEmpty((CharSequence)string) && !string.toLowerCase().startsWith("http://") && !string.toLowerCase().startsWith("https://")) {
            return "http://" + string;
        }
        return string;
    }

    @Override
    public String getTitle(Object object) {
        return ((File)object).getName();
    }

    @Override
    public void preFinish() {
    }
}

