/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.StreamGobbler;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Profile;
import org.dbgl.model.SearchResult;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.eclipse.swt.program.Program;

public final class PlatformUtils {
    private static final String DEFAULT_DOSBOX_DIR = "DOSBox-" + DosboxVersion.LATEST;
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final String JVM_ARCH = System.getProperty("sun.arch.data.model");
    public static final String JVM_VERSION = System.getProperty("java.version");
    public static final boolean IS_WINDOWS = OS_NAME.startsWith("Windows");
    public static final boolean IS_LINUX = OS_NAME.startsWith("Linux");
    public static final boolean IS_OSX = OS_NAME.startsWith("Mac OS");
    public static final String OSX_COCOA = "cocoa";
    public static final String DB_EXECUTABLE = IS_WINDOWS ? "DOSBox.exe" : (IS_OSX ? "DOSBox" : "dosbox");
    public static final String DB_APP_EXT = ".app";
    public static final String DB_APP = "DOSBox.app";
    public static final String DB_APP_EXE = "/Contents/MacOS/" + DB_EXECUTABLE;
    public static final String EOLN = System.getProperty("line.separator");
    public static final String NATIVE_EXE_FILTER = IS_WINDOWS ? "*.exe;*.EXE" : (IS_OSX ? "*.app" : "*");
    public static final boolean USE_USER_HOME_DIR = Boolean.valueOf(System.getProperty("dbgl.data.localappdata")) != false || Boolean.valueOf(System.getProperty("dbgl.data.userhome")) != false;
    public static final String DFEND_PATH = System.getenv("ProgramFiles") + "\\D-Fend\\";
    public static final String DFEND_PROFILES = "Profiles.dat";
    public static final File DFEND_RELOADED_PATH = new File(System.getProperty("user.home"), "D-Fend Reloaded");
    public static final File USER_DATA_DIR_FILE = IS_WINDOWS ? new File(System.getenv("LOCALAPPDATA"), "/DBGL") : (IS_LINUX || IS_OSX ? new File(System.getProperty("user.home"), "/.dbgl") : new File("."));

    public static String toNativePath(String string) {
        return string.replace('\\', File.separatorChar);
    }

    public static String toDosboxPath(String string) {
        return string.replace(File.separatorChar, '\\');
    }

    public static String archiveToNativePath(String string) {
        return string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public static String toArchivePath(String string) {
        return PlatformUtils.toArchivePath(new File(string), false);
    }

    public static String toArchivePath(File file, boolean bl) {
        String string = file.getPath().replace('\\', '/');
        if (bl) {
            string = string + "/";
        }
        return string;
    }

    public static String pathToNativePath(String string) {
        if (string != null && string.indexOf("://") == -1) {
            return PlatformUtils.archiveToNativePath(string);
        }
        return string;
    }

    private static boolean tryToRun(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            try {
                Runtime.getRuntime().exec(new String[]{string2, string}, null, null);
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public static void openForEditing(File file) {
        if (!Program.launch((String)file.getPath()) && IS_LINUX && !PlatformUtils.tryToRun(new String[]{"xdg-open", "gnome-open"}, file.getPath())) {
            System.err.println(Settings.getInstance().msg("general.error.openfile", new Object[]{file}));
        }
    }

    public static void openForBrowsing(String string) {
        if (!Program.launch((String)string) && IS_LINUX && !PlatformUtils.tryToRun(new String[]{"xdg-open", "gnome-open"}, string)) {
            System.err.println(Settings.getInstance().msg("general.error.openurl", new Object[]{string}));
        }
    }

    public static void openDirForViewing(File file) {
        if (!Program.launch((String)file.getPath()) && IS_LINUX && !PlatformUtils.tryToRun(new String[]{"nautilus", "dolphin", "kfmclient"}, file.getPath())) {
            System.err.println(Settings.getInstance().msg("general.error.opendir", new Object[]{file}));
        }
    }

    public static void createShortcut(Profile profile, List<DosboxVersion> list) throws IOException {
        DosboxVersion dosboxVersion = DosboxVersion.findById(list, profile.getDbversionId());
        String string = profile.getTitle().replaceAll("[\\/:*?\"<>|]", " ").trim();
        StringBuffer stringBuffer = new StringBuffer(128);
        if (dosboxVersion.isMultiConfig()) {
            stringBuffer.append("-conf \"\"").append(dosboxVersion.getCanonicalConfFile()).append("\"\" ");
        }
        stringBuffer.append("-conf \"\"").append(profile.getCanonicalConfFile()).append("\"\"");
        if (Settings.getInstance().getSettings().getBooleanValue("dosbox", "hideconsole")) {
            stringBuffer.append(" -noconsole");
        }
        if (IS_WINDOWS) {
            File file = FileSystemView.getFileSystemView().getHomeDirectory();
            File file2 = new File(file, string + ".lnk");
            File file3 = FileUtils.canonicalToData("shortcut.vbs");
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file3));
            bufferedWriter.write("Set oWS = WScript.CreateObject(\"WScript.Shell\")" + EOLN);
            bufferedWriter.write("Set oLink = oWS.CreateShortcut(\"" + file2.getCanonicalPath() + "\")" + EOLN);
            bufferedWriter.write("oLink.TargetPath = \"" + dosboxVersion.getCanonicalExecutable().getPath() + "\"" + EOLN);
            bufferedWriter.write("oLink.Arguments = \"" + stringBuffer.toString() + "\"" + EOLN);
            bufferedWriter.write("oLink.Description = \"" + Settings.getInstance().msg("general.shortcut.title", new Object[]{string}) + "\"" + EOLN);
            bufferedWriter.write("oLink.WorkingDirectory = \"" + FileUtils.getDosRoot() + "\"" + EOLN);
            bufferedWriter.write("oLink.Save" + EOLN);
            bufferedWriter.close();
            Process process = Runtime.getRuntime().exec(new String[]{"CSCRIPT", file3.getCanonicalPath()}, null, file3.getParentFile());
            StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream(), "CSCRIPT stderr");
            StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream(), "CSCRIPT stdout");
            streamGobbler2.start();
            streamGobbler.start();
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            FileUtils.removeFile(file3);
        } else if (IS_LINUX) {
            File file = new File(System.getProperty("user.home"), "/Desktop");
            File file4 = new File(file, string + ".desktop");
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file4), "UTF-8"));
            bufferedWriter.write("[Desktop Entry]" + EOLN);
            bufferedWriter.write("Version=1.0" + EOLN);
            bufferedWriter.write("Type=Application" + EOLN);
            bufferedWriter.write("Name=" + string + EOLN);
            bufferedWriter.write("Comment=" + Settings.getInstance().msg("general.shortcut.title", new Object[]{string}) + EOLN);
            bufferedWriter.write("Icon=" + new File(dosboxVersion.getCanonicalExecutable().getParent(), "dosbox.ico").getPath() + EOLN);
            bufferedWriter.write("TryExec=" + dosboxVersion.getCanonicalExecutable().getPath() + EOLN);
            bufferedWriter.write("Exec=" + dosboxVersion.getCanonicalExecutable().getPath() + " " + StringUtils.replace((String)stringBuffer.toString(), (String)"\"\"", (String)"\"") + EOLN);
            bufferedWriter.write("Path=" + FileUtils.getDosRoot() + EOLN);
            bufferedWriter.close();
            file4.setExecutable(true);
        }
    }

    public static boolean isDirectoryWritable(File file) {
        try {
            File.createTempFile("chkperm", null, file).delete();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static SearchResult findDosbox() {
        Object object;
        Object object2;
        File file = null;
        Object object3 = null;
        File file2 = null;
        String string = null;
        if (FileUtils.isExistingDirectory(FileUtils.canonicalToDosbox(DEFAULT_DOSBOX_DIR)) && FileUtils.isExistingFile((File)(object2 = FileUtils.constructCanonicalDBExeLocation(DEFAULT_DOSBOX_DIR)))) {
            file = ((File)object2).getParentFile();
            string = DosboxVersion.LATEST;
        }
        if (file == null) {
            if (IS_WINDOWS) {
                object2 = System.getenv("ProgramFiles(x86)");
                if (object2 == null) {
                    object2 = System.getenv("ProgramFiles");
                }
                if (FileUtils.isExistingFile(object = new File(new File((String)object2, DEFAULT_DOSBOX_DIR), DB_EXECUTABLE))) {
                    file = object.getParentFile();
                    string = DosboxVersion.LATEST;
                }
            } else if (IS_LINUX) {
                object2 = new File("/usr/bin", DB_EXECUTABLE);
                if (FileUtils.isExistingFile((File)object2)) {
                    file = ((File)object2).getParentFile();
                }
            } else if (IS_OSX && FileUtils.isExistingFile((File)(object2 = new File("/Applications/DOSBox.app/Contents/MacOS", DB_EXECUTABLE)))) {
                file = ((File)object2).getParentFile();
            }
        }
        if (file != null) {
            object2 = new File(file, "dosbox.conf");
            if (FileUtils.isExistingFile((File)object2)) {
                object3 = object2;
            } else if (IS_WINDOWS) {
                object = new File(new File(System.getenv("LOCALAPPDATA"), "DOSBox"), "dosbox-" + DosboxVersion.LATEST + ".conf");
                if (FileUtils.isExistingFile(object)) {
                    object3 = object;
                    string = DosboxVersion.LATEST;
                } else {
                    file2 = object;
                }
            } else if (IS_LINUX) {
                object = new File(new File(System.getProperty("user.home"), ".dosbox"), "dosbox-" + DosboxVersion.LATEST + ".conf");
                if (FileUtils.isExistingFile(object)) {
                    object3 = object;
                    string = DosboxVersion.LATEST;
                } else {
                    file2 = object;
                }
            } else if (IS_OSX) {
                object = new File(new File(System.getProperty("user.home"), "Library/Preferences"), "DOSBox " + DosboxVersion.LATEST + " Preferences");
                if (FileUtils.isExistingFile(object)) {
                    object3 = object;
                    string = DosboxVersion.LATEST;
                } else {
                    file2 = object;
                }
            }
        }
        object2 = new DosboxVersion(-1, "DOSBox " + (string != null ? string : DosboxVersion.LATEST), file != null ? FileUtils.makeRelativeToDosbox(file).getPath() : "", object3 != null ? FileUtils.makeRelativeToDosbox((File)object3).getPath() : (file2 != null ? FileUtils.makeRelativeToDosbox(file2).getPath() : ""), true, false, true, "", string != null ? string : DosboxVersion.LATEST, null, null, null, 0);
        object = SearchResult.ResultType.NOTFOUND;
        if (file != null) {
            object = SearchResult.ResultType.EXEONLY;
            if (object3 != null && string != null) {
                object = SearchResult.ResultType.COMPLETE;
            }
        }
        return new SearchResult((SearchResult.ResultType)((Object)object), (DosboxVersion)object2);
    }
}

