/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.dbgl.waldheinz.fs.fat.BlockDevice;

public final class FileDisk
implements BlockDevice {
    public static final int BYTES_PER_SECTOR = 512;
    private final RandomAccessFile raf;
    private final FileChannel fc;
    private boolean closed;

    public FileDisk(File file) throws FileNotFoundException {
        this.raf = new RandomAccessFile(file, "r");
        this.fc = this.raf.getChannel();
        this.closed = false;
    }

    @Override
    public long getSize() throws IOException {
        this.checkClosed();
        return this.raf.length();
    }

    @Override
    public void read(long l, ByteBuffer byteBuffer) throws IOException {
        this.checkClosed();
        int n = byteBuffer.remaining();
        if (l + (long)n > this.getSize()) {
            throw new IOException("reading past end of device");
        }
        while (n > 0) {
            int n2 = this.fc.read(byteBuffer, l);
            if (n2 < 0) {
                throw new IOException();
            }
            n -= n2;
            l += (long)n2;
        }
    }

    @Override
    public int getSectorSize() {
        this.checkClosed();
        return 512;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.fc.close();
        this.raf.close();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("device already closed");
        }
    }
}

