/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.loopy.iso9660;

import java.io.IOException;
import org.dbgl.loopy.iso9660.ISO9660FileEntry;
import org.dbgl.loopy.iso9660.ISO9660FileSystem;
import org.dbgl.loopy.util.Util;

public class ISO9660VolumeDescriptorSet {
    private static final int TYPE_PRIMARY_DESCRIPTOR = 1;
    private static final int TYPE_SUPPLEMENTARY_DESCRIPTOR = 2;
    private static final int TYPE_TERMINATOR = 255;
    private final ISO9660FileSystem fileSystem;
    private ISO9660FileEntry rootDirectoryEntry;
    private String encoding = "US-ASCII";
    private boolean hasPrimary = false;
    private boolean hasSupplementary = false;

    public ISO9660VolumeDescriptorSet(ISO9660FileSystem iSO9660FileSystem) {
        this.fileSystem = iSO9660FileSystem;
    }

    public boolean deserialize(byte[] byArray) throws IOException {
        int n = Util.getUInt8(byArray, 1);
        boolean bl = false;
        switch (n) {
            case 255: {
                if (!this.hasPrimary) {
                    throw new IOException("No primary volume descriptor found");
                }
                bl = true;
                break;
            }
            case 1: {
                this.deserializePrimary(byArray);
                break;
            }
            case 2: {
                this.deserializeSupplementary(byArray);
                break;
            }
        }
        return bl;
    }

    public ISO9660FileEntry getRootEntry() {
        return this.rootDirectoryEntry;
    }

    public String getEncoding() {
        return this.encoding;
    }

    private void deserializePrimary(byte[] byArray) throws IOException {
        if (this.hasPrimary) {
            return;
        }
        String string = Util.getDChars(byArray, 2, 5, this.fileSystem.getEncoding());
        int n = Util.getUInt8(byArray, 7);
        if (!string.equals("CD001") || n != 1) {
            throw new IOException("Invalid primary volume descriptor");
        }
        this.validateBlockSize(byArray);
        if (!this.hasSupplementary) {
            this.deserializeCommon(byArray);
        }
        this.hasPrimary = true;
    }

    private void deserializeCommon(byte[] byArray) throws IOException {
        this.rootDirectoryEntry = new ISO9660FileEntry(this.fileSystem, byArray, 157);
    }

    private void deserializeSupplementary(byte[] byArray) throws IOException {
        if (this.hasSupplementary) {
            return;
        }
        this.validateBlockSize(byArray);
        String string = Util.getDChars(byArray, 89, 32);
        String string2 = this.getEncoding(string);
        if (string2 != null) {
            this.encoding = string2;
            this.deserializeCommon(byArray);
            this.hasSupplementary = true;
        }
    }

    private void validateBlockSize(byte[] byArray) throws IOException {
        int n = Util.getUInt16Both(byArray, 129);
        if (n != 2048) {
            throw new IOException("Invalid block size: " + n);
        }
    }

    private String getEncoding(String string) {
        String string2 = null;
        if (string.equals("%/@")) {
            string2 = "UTF-16BE";
        } else if (string.equals("%/C")) {
            string2 = "UTF-16BE";
        } else if (string.equals("%/E")) {
            string2 = "UTF-16BE";
        }
        return string2;
    }
}

