/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui;

import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.RendererHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class GalleryItemRenderer
extends AbstractGalleryItemRenderer {
    private static final int lineWidth = 2;
    private static final int selectionRadius = 8;
    private static final String ELLIPSIS = "...";
    private final Color foregroundColor = Display.getDefault().getSystemColor(24);
    private final Color backgroundColor = Display.getDefault().getSystemColor(25);
    private final Color selectionForegroundColor = Display.getDefault().getSystemColor(27);
    private final Color selectionBackgroundColor = Display.getDefault().getSystemColor(26);
    private final String truncPosition;

    public GalleryItemRenderer(String string) {
        this.truncPosition = string;
    }

    public void draw(GC gC, GalleryItem galleryItem, int n, int n2, int n3, int n4, int n5) {
        int n6;
        Object object;
        Image image;
        gC.setFont(this.getFont(galleryItem));
        int n7 = gC.getFontMetrics().getHeight();
        boolean bl = this.selected;
        Color color = null;
        if (!bl && galleryItem.getBackground(true) != null && !RendererHelper.isColorsEquals((Color)(color = this.getBackground(galleryItem)), (Color)this.backgroundColor)) {
            bl = true;
        }
        if (bl) {
            if (this.selected) {
                gC.setBackground(this.selectionBackgroundColor);
                gC.setForeground(this.selectionBackgroundColor);
            } else if (color != null) {
                gC.setBackground(color);
            }
            gC.setLineStyle(3);
            gC.setLineWidth(2);
            gC.drawRoundRectangle(n2 + 1, n3 + 1, n4 - 2, n5 - 2, 8, 8);
            gC.fillRoundRectangle(n2 + 1, n3 + n5 - n7 - 1 - 1, n4 - 2, n7 + 1, 8, 8);
        }
        if ((image = galleryItem.getImage()) != null) {
            object = image.getBounds();
            n6 = RendererHelper.getShift((int)(n4 - 4), (int)object.width);
            gC.drawImage(image, n2 + 2 + n6, n3 + 2);
            this.drawAllOverlays(gC, galleryItem, n2, n3, new Point(object.width, object.height), n6, 2);
        }
        if (this.selected) {
            gC.setForeground(this.selectionForegroundColor);
            gC.setBackground(this.selectionBackgroundColor);
        } else {
            gC.setBackground(color != null ? color : this.backgroundColor);
            object = this.getForeground(galleryItem);
            gC.setForeground((Color)(object != null ? object : this.foregroundColor));
        }
        object = this.truncPosition.equalsIgnoreCase("end") ? GalleryItemRenderer.createLabelTruncAtEnd(galleryItem.getText(), gC, n4 - 8) : RendererHelper.createLabel((String)galleryItem.getText(), (GC)gC, (int)(n4 - 8));
        n6 = gC.textExtent((String)object).x;
        int n8 = RendererHelper.getShift((int)n4, (int)n6);
        gC.drawText((String)object, n2 + n8, n3 + n5 - n7 - 2, true);
    }

    public void dispose() {
    }

    public static String createLabelTruncAtEnd(String string, GC gC, int n) {
        int n2;
        int n3;
        if (string != null && (n3 = gC.textExtent((String)string).x) > n && n > (n2 = gC.textExtent((String)ELLIPSIS).x)) {
            int n4 = string.length();
            while (n3 > n) {
                n3 = gC.textExtent((String)string.substring((int)0, (int)(--n4))).x + n2;
            }
            return string.substring(0, n4) + ELLIPSIS;
        }
        return string;
    }
}

