/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.loopy.iso9660;

import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.dbgl.loopy.iso9660.ISO9660FileEntry;
import org.dbgl.loopy.iso9660.ISO9660FileSystem;
import org.dbgl.loopy.util.LittleEndian;

class EntryEnumeration
implements Enumeration<ISO9660FileEntry> {
    private final ISO9660FileSystem fileSystem;
    private final List<ISO9660FileEntry> queue;

    public EntryEnumeration(ISO9660FileSystem iSO9660FileSystem, ISO9660FileEntry iSO9660FileEntry) {
        this.fileSystem = iSO9660FileSystem;
        this.queue = new LinkedList<ISO9660FileEntry>();
        this.queue.add(iSO9660FileEntry);
    }

    @Override
    public boolean hasMoreElements() {
        return !this.queue.isEmpty();
    }

    @Override
    public ISO9660FileEntry nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        ISO9660FileEntry iSO9660FileEntry = this.queue.remove(0);
        if (iSO9660FileEntry.isDirectory()) {
            byte[] byArray;
            try {
                byArray = this.fileSystem.getBytes(iSO9660FileEntry);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            int n = 0;
            boolean bl = false;
            while (n < byArray.length) {
                if (LittleEndian.getUInt8(byArray, n) <= 0) {
                    bl = true;
                    n += 2;
                    continue;
                }
                ISO9660FileEntry iSO9660FileEntry2 = new ISO9660FileEntry(this.fileSystem, iSO9660FileEntry.getPath(), byArray, n + 1);
                if (bl && iSO9660FileEntry2.getSize() < 0) continue;
                n += iSO9660FileEntry2.getEntryLength();
                if (".".equals(iSO9660FileEntry2.getName()) || "..".equals(iSO9660FileEntry2.getName())) continue;
                this.queue.add(iSO9660FileEntry2);
            }
        }
        return iSO9660FileEntry;
    }
}

