/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Date;
import org.dbgl.model.KeyTitleDefault;
import org.dbgl.model.ProfileStats;
import org.dbgl.model.conf.Conf;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.FileUtils;
import org.dbgl.util.PlatformUtils;

public class Profile
extends KeyTitleDefault {
    protected String developerName;
    protected String publisherName;
    protected String genre;
    protected String year;
    protected String status;
    protected String notes;
    protected String confPathAndFile;
    protected String captures;
    protected int dbversionId;
    protected String[] setup;
    protected String[] setupParams;
    protected String[] link;
    protected String[] linkTitle;
    protected String[] customString;
    protected int[] customInt;
    protected ProfileStats stats;

    protected Profile(String string, boolean bl) {
        super(-1, string, bl);
        this.stats = new ProfileStats(null, null, null, null, 0, 0);
    }

    public Profile(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, Boolean bl, String[] stringArray, String[] stringArray2, String string8, String string9, int n2, String[] stringArray3, String[] stringArray4, String[] stringArray5, int[] nArray, Date date, Date date2, Date date3, Date date4, int n3, int n4) {
        super(n, string, bl);
        int n5;
        this.developerName = string2;
        this.publisherName = string3;
        this.genre = string4;
        this.year = string5;
        this.status = string6;
        this.notes = string7;
        this.setup = new String[stringArray.length];
        for (n5 = 0; n5 < stringArray.length; ++n5) {
            this.setup[n5] = PlatformUtils.pathToNativePath(stringArray[n5]);
        }
        this.setupParams = (String[])stringArray2.clone();
        this.confPathAndFile = PlatformUtils.pathToNativePath(string8);
        this.captures = PlatformUtils.pathToNativePath(string9);
        this.dbversionId = n2;
        this.link = new String[stringArray3.length];
        for (n5 = 0; n5 < stringArray3.length; ++n5) {
            this.link[n5] = PlatformUtils.pathToNativePath(stringArray3[n5]);
        }
        this.linkTitle = (String[])stringArray4.clone();
        this.customString = (String[])stringArray5.clone();
        this.customInt = (int[])nArray.clone();
        this.stats = new ProfileStats(date, date2, date3, date4, n3, n4);
    }

    public Profile(int n, String string, String string2, Profile profile) {
        this(n, profile.getTitle(), profile.getDeveloperName(), profile.getPublisherName(), profile.getGenre(), profile.getYear(), profile.getStatus(), profile.getNotes(), profile.isDefault(), profile.getSetup(), profile.getSetupParameters(), string, string2, profile.getDbversionId(), profile.getLinks(), profile.getLinkTitles(), profile.getCustomStrings(), profile.getCustomInts(), profile.stats.created, profile.stats.modified, profile.stats.lastrun, profile.stats.lastsetup, profile.stats.runs, profile.stats.setups);
    }

    private static String test(String string, String string2) {
        return string.equals(string2) ? string : "CONFLICTING_SETTING";
    }

    private static Boolean test(Boolean bl, Boolean bl2) {
        return bl == bl2 ? bl : Conf.CONFLICTING_BOOL_SETTING;
    }

    private static int test(int n, int n2) {
        return n == n2 ? n : Integer.MIN_VALUE;
    }

    private static String[] test(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray3[i] = Profile.test(stringArray[i], stringArray2[i]);
        }
        return stringArray3;
    }

    private static int[] test(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[i] = Profile.test(nArray[i], nArray2[i]);
        }
        return nArray3;
    }

    private static String either(String string, String string2) {
        return string2 == null ? string : string2;
    }

    private static Boolean either(Boolean bl, Boolean bl2) {
        return bl2 == null ? bl : bl2;
    }

    private static int either(int n, int n2) {
        return n2 == -1 ? n : n2;
    }

    private static String[] either(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray3[i] = Profile.either(stringArray[i], stringArray2[i]);
        }
        return stringArray3;
    }

    private static int[] either(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[i] = Profile.either(nArray[i], nArray2[i]);
        }
        return nArray3;
    }

    public Profile(Profile profile, Profile profile2) {
        this(-1, Profile.test(profile.getTitle(), profile2.getTitle()), Profile.test(profile.getDeveloperName(), profile2.getDeveloperName()), Profile.test(profile.getPublisherName(), profile2.getPublisherName()), Profile.test(profile.getGenre(), profile2.getGenre()), Profile.test(profile.getYear(), profile2.getYear()), Profile.test(profile.getStatus(), profile2.getStatus()), Profile.test(profile.getNotes(), profile2.getNotes()), Profile.test(profile.isDefault(), profile2.isDefault()), Profile.test(profile.getSetup(), profile2.getSetup()), Profile.test(profile.getSetupParameters(), profile2.getSetupParameters()), Profile.test(profile.getConfPathAndFile(), profile2.getConfPathAndFile()), Profile.test(profile.getCaptures(), profile2.getCaptures()), Profile.test(profile.getDbversionId(), profile2.getDbversionId()), Profile.test(profile.getLinks(), profile2.getLinks()), Profile.test(profile.getLinkTitles(), profile2.getLinkTitles()), Profile.test(profile.getCustomStrings(), profile2.getCustomStrings()), Profile.test(profile.getCustomInts(), profile2.getCustomInts()), null, null, null, null, 0, 0);
    }

    public Profile(Profile profile, Profile profile2, boolean bl) {
        this(profile.getId(), Profile.either(profile.getTitle(), profile2.getTitle()), Profile.either(profile.getDeveloperName(), profile2.getDeveloperName()), Profile.either(profile.getPublisherName(), profile2.getPublisherName()), Profile.either(profile.getGenre(), profile2.getGenre()), Profile.either(profile.getYear(), profile2.getYear()), Profile.either(profile.getStatus(), profile2.getStatus()), Profile.either(profile.getNotes(), profile2.getNotes()), Profile.either(profile.isDefault(), profile2.isDefault()), Profile.either(profile.getSetup(), profile2.getSetup()), Profile.either(profile.getSetupParameters(), profile2.getSetupParameters()), Profile.either(profile.getConfPathAndFile(), profile2.getConfPathAndFile()), Profile.either(profile.getCaptures(), profile2.getCaptures()), Profile.either(profile.getDbversionId(), profile2.getDbversionId()), Profile.either(profile.getLinks(), profile2.getLinks()), Profile.either(profile.getLinkTitles(), profile2.getLinkTitles()), Profile.either(profile.getCustomStrings(), profile2.getCustomStrings()), Profile.either(profile.getCustomInts(), profile2.getCustomInts()), null, null, null, null, 0, 0);
    }

    public String getDeveloperName() {
        return this.developerName;
    }

    public String getGenre() {
        return this.genre;
    }

    public String getPublisherName() {
        return this.publisherName;
    }

    public String getYear() {
        return this.year;
    }

    public int getDbversionId() {
        return this.dbversionId;
    }

    public boolean hasSetup(int n) {
        return !"".equals(this.setup[n]);
    }

    public String hasSetupString() {
        return this.hasSetup(0) ? Settings.getInstance().msg("general.yes") : Settings.getInstance().msg("general.no");
    }

    public String[] getLinks() {
        return (String[])this.link.clone();
    }

    public String getLink(int n) {
        return this.link[n];
    }

    public String getLinkTitle(int n) {
        return this.linkTitle[n];
    }

    public String[] getLinkTitles() {
        return (String[])this.linkTitle.clone();
    }

    public String getLinkAsUrl(int n) {
        String string = this.link[n];
        if (string != null && string.length() > 0 && string.indexOf("://") == -1) {
            try {
                string = FileUtils.getUrlFromFile(FileUtils.canonicalToData(string));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return string;
    }

    public String getNotes() {
        return this.notes;
    }

    public String[] getSetup() {
        return (String[])this.setup.clone();
    }

    public String[] getSetupParameters() {
        return (String[])this.setupParams.clone();
    }

    public String getSetup(int n) {
        return this.setup[n];
    }

    public String getSetupParameters(int n) {
        return this.setupParams[n];
    }

    public String getStatus() {
        return this.status;
    }

    public String getConfPathAndFile() {
        return this.confPathAndFile;
    }

    public File getCanonicalConfFile() {
        return FileUtils.canonicalToData(this.confPathAndFile);
    }

    public String getConfFileAsUrl() {
        try {
            return FileUtils.getUrlFromFile(this.getCanonicalConfFile());
        }
        catch (MalformedURLException malformedURLException) {
            return this.getCanonicalConfFile().getPath();
        }
    }

    public String getCaptures() {
        return this.captures;
    }

    public File getCanonicalCaptures() {
        return FileUtils.canonicalToData(this.captures);
    }

    public String getCapturesAsUrl() {
        try {
            return FileUtils.getUrlFromFile(this.getCanonicalCaptures());
        }
        catch (MalformedURLException malformedURLException) {
            return this.getCanonicalCaptures().getPath();
        }
    }

    public String getCustomString(int n) {
        return this.customString[n];
    }

    public String[] getCustomStrings() {
        return (String[])this.customString.clone();
    }

    public int getCustomInt(int n) {
        return this.customInt[n];
    }

    public int[] getCustomInts() {
        return (int[])this.customInt.clone();
    }

    public ProfileStats getStats() {
        return this.stats;
    }
}

