/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dbgl.model.Constants;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpProfile;
import org.dbgl.model.ExpTemplate;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.Settings;
import org.dbgl.util.PlatformUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtils {
    private static final String PROFILES_XML_FORMAT_VERSION = "1.3";
    private static final String TEMPLATES_XML_FORMAT_VERSION = "1.0";
    public static final SimpleDateFormat datetimeFormatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

    public static Element addElement(Document document, Element element, String string, String string2) {
        Element element2 = document.createElement(string);
        element2.appendChild(document.createTextNode(string2));
        element.appendChild(element2);
        return element;
    }

    public static Element addCDataElement(Document document, Element element, String string, String string2) {
        Element element2 = document.createElement(string);
        element2.appendChild(document.createCDATASection(string2));
        element.appendChild(element2);
        return element;
    }

    public static void saveDomSource(DOMSource dOMSource, File file, File file2) throws TransformerException, IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 2);
        Transformer transformer = file2 == null ? transformerFactory.newTransformer() : transformerFactory.newTransformer(new StreamSource(file2));
        transformer.setOutputProperty("indent", "yes");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        transformer.transform(dOMSource, new StreamResult(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8")));
        fileOutputStream.close();
    }

    public static void domToZipOutputStream(Document document, File file, ZipOutputStream zipOutputStream) throws IOException, TransformerException {
        ZipEntry zipEntry = new ZipEntry(PlatformUtils.toArchivePath(file, false));
        zipOutputStream.putNextEntry(zipEntry);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 2);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(new DOMSource(document), new StreamResult(new OutputStreamWriter((OutputStream)zipOutputStream, "UTF-8")));
        zipOutputStream.closeEntry();
    }

    public static Document getProfilesXML(List<Profile> list, List<DosboxVersion> list2) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("document");
        element.appendChild(XmlUtils.getProfileExportElement(document, Settings.getInstance().msg("exportlist.title"), "", "", false, false, false, false));
        for (Profile profile : list) {
            element.appendChild(new ExpProfile(profile.getId(), null, null, null, profile).getXml(document, list2));
        }
        document.appendChild(element);
        return document;
    }

    public static Document getFullProfilesXML(List<ExpProfile> list, List<DosboxVersion> list2, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("document");
        element.appendChild(XmlUtils.getProfileExportElement(document, string, string2, string3, bl, bl2, bl3, bl4));
        for (ExpProfile expProfile : list) {
            element.appendChild(expProfile.getXml(document, list2));
        }
        document.appendChild(element);
        return document;
    }

    private static Element getProfileExportElement(Document document, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Element element = document.createElement("export");
        XmlUtils.addElement(document, element, "format-version", PROFILES_XML_FORMAT_VERSION);
        XmlUtils.addCDataElement(document, element, "title", string);
        XmlUtils.addCDataElement(document, element, "author", string3);
        XmlUtils.addCDataElement(document, element, "notes", XmlUtils.cleanEolnForXml(string2));
        XmlUtils.addCDataElement(document, element, "creationdatetime", datetimeFormatter.format(new Date()));
        XmlUtils.addCDataElement(document, element, "generator-title", "DOSBox Game Launcher");
        XmlUtils.addElement(document, element, "generator-version", Constants.PROGRAM_VERSION);
        XmlUtils.addElement(document, element, "captures-available", String.valueOf(bl));
        XmlUtils.addElement(document, element, "keymapperfiles-available", String.valueOf(bl2));
        XmlUtils.addElement(document, element, "nativecommands-available", String.valueOf(bl3));
        XmlUtils.addElement(document, element, "gamedata-available", String.valueOf(bl4));
        Settings settings = Settings.getInstance();
        for (int i = 0; i < 14; ++i) {
            String string4 = settings.getSettings().getValue("gui", "custom" + (i + 1));
            XmlUtils.addCDataElement(document, element, "custom" + (i + 1), string4);
        }
        return element;
    }

    public static Document getFullTemplatesXML(List<ExpTemplate> list, List<DosboxVersion> list2, String string, String string2, String string3) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("document");
        Element element2 = document.createElement("export");
        XmlUtils.addElement(document, element2, "format-version", TEMPLATES_XML_FORMAT_VERSION);
        XmlUtils.addCDataElement(document, element2, "title", string);
        XmlUtils.addCDataElement(document, element2, "author", string3);
        XmlUtils.addCDataElement(document, element2, "notes", XmlUtils.cleanEolnForXml(string2));
        XmlUtils.addCDataElement(document, element2, "creationdatetime", datetimeFormatter.format(new Date()));
        XmlUtils.addCDataElement(document, element2, "generator-title", "DOSBox Game Launcher");
        XmlUtils.addElement(document, element2, "generator-version", Constants.PROGRAM_VERSION);
        element.appendChild(element2);
        for (ExpTemplate expTemplate : list) {
            element.appendChild(expTemplate.getXml(document, list2));
        }
        document.appendChild(element);
        return document;
    }

    public static String cleanEolnForXml(String string) {
        return string.replaceAll("\\r", "");
    }

    public static String getTextValue(Element element, String string) {
        Element element2 = XmlUtils.getNode(element, string);
        if (element2 != null) {
            Node node = element2.getFirstChild();
            return node == null ? "" : node.getNodeValue();
        }
        return null;
    }

    public static Element getNode(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }
}

