/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.util.searchengine;

import java.io.IOException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.WebProfile;
import org.dbgl.util.searchengine.WebSearchEngine;

public class MobyGamesSearchEngine
extends WebSearchEngine {
    private static final String HTML_MULTIPLE_RESULT_MARKER_START = "<div class=\"searchResult\">";
    private static final String HTML_GAME_TITLE_START = "<div class=\"searchTitle\">";
    private static final String HTML_GAME_END_MARKER = "<br clear=\"all\"></div>";
    private static final String MOBY_GAMES_HOST_NAME = "www.mobygames.com";
    private static final int RESULTS_PER_PAGE = 50;

    private MobyGamesSearchEngine() {
    }

    public static WebSearchEngine getInstance() {
        return SearchEngineHolder.instance;
    }

    @Override
    public String getIcon() {
        return "moby.png";
    }

    @Override
    public String getName() {
        return "MobyGames";
    }

    @Override
    public String getSimpleName() {
        return "mobygames";
    }

    @Override
    public String getProtocol() {
        return "https://";
    }

    @Override
    public List<WebProfile> getEntries(String string, String[] stringArray) throws IOException {
        int n = 1;
        ArrayList<WebProfile> arrayList = new ArrayList<WebProfile>();
        for (int i = 0; i < n; ++i) {
            String string2 = MobyGamesSearchEngine.getResponseContent("https://www.mobygames.com/search/quick?sFilter=1&p=-1&sG=on&q=" + URLEncoder.encode(string.replaceAll("/", " "), "UTF-8") + "&offset=" + i * 50, StandardCharsets.UTF_8);
            if (i == 0) {
                n = MobyGamesSearchEngine.getPages(string2);
            }
            arrayList.addAll(this.extractEntries(string2));
        }
        return MobyGamesSearchEngine.filterEntries(stringArray, arrayList);
    }

    private static int getPages(String string) {
        int n = string.indexOf("\"> Games (");
        int n2 = string.indexOf(")</label>", n);
        if (n == -1 || n2 == -1) {
            return 0;
        }
        int n3 = Integer.parseInt(string.substring(n + 10, n2));
        return (n3 + 50 - 1) / 50;
    }

    private List<WebProfile> extractEntries(String string) {
        ArrayList<WebProfile> arrayList = new ArrayList<WebProfile>();
        int n = (string = string.replaceAll("\\\\\"", "\"")).indexOf(HTML_MULTIPLE_RESULT_MARKER_START);
        if (n != -1) {
            n += HTML_MULTIPLE_RESULT_MARKER_START.length();
        }
        while (n != -1) {
            n = string.indexOf("<div", n);
            int n2 = string.indexOf(HTML_GAME_TITLE_START, n);
            String string2 = MobyGamesSearchEngine.extractNextContent(string, n2, "<div", "</div>");
            String string3 = MobyGamesSearchEngine.unescapeHtml(MobyGamesSearchEngine.removeAllTags(string2)).substring(6);
            String string4 = MobyGamesSearchEngine.extractNextHrefContent(string, n2);
            String string5 = MobyGamesSearchEngine.extractNextContent(string, n2 + string2.length(), "<div", "</div>");
            int n3 = string5.indexOf("<span ");
            while (n3 != -1) {
                String string6 = MobyGamesSearchEngine.extractNextContent(string5, n3, "<span ", "</span>");
                if (string6.indexOf("<a ") != -1) {
                    string6 = MobyGamesSearchEngine.extractNextContent(string5, n3, "<a ", "</a>");
                    string4 = MobyGamesSearchEngine.extractNextHrefContent(string5, n3);
                } else {
                    int n4 = string6.indexOf(" (");
                    if (n4 != -1) {
                        string6 = string6.substring(0, n4);
                    }
                }
                string4 = this.absoluteUrl(MOBY_GAMES_HOST_NAME, string4);
                String string7 = MobyGamesSearchEngine.extractNextContent(string5, n3, "<em>", "</em>");
                WebProfile webProfile = new WebProfile();
                webProfile.setTitle(string3);
                webProfile.setUrl(string4);
                webProfile.setPlatform(string6);
                webProfile.setPublisherName("");
                webProfile.setYear(string7);
                arrayList.add(webProfile);
                n3 = string5.indexOf("<span ", n3 + 1);
            }
            int n5 = string.indexOf(HTML_GAME_END_MARKER, n2);
            n = string.indexOf(HTML_MULTIPLE_RESULT_MARKER_START, n5 + HTML_GAME_END_MARKER.length());
        }
        return arrayList;
    }

    @Override
    public WebProfile getEntryDetailedInformation(WebProfile webProfile) throws UnknownHostException, IOException {
        WebProfile webProfile2 = new WebProfile();
        webProfile2.setTitle(webProfile.getTitle());
        webProfile2.setYear(webProfile.getYear());
        webProfile2.setUrl(webProfile.getUrl());
        String string = MobyGamesSearchEngine.getResponseContent(webProfile.getUrl(), StandardCharsets.UTF_8);
        webProfile2.setDeveloperName(MobyGamesSearchEngine.extractCategory(string, ">Developed by</div>"));
        webProfile2.setPublisherName(MobyGamesSearchEngine.extractCategory(string, ">Published by</div>"));
        webProfile2.setGenre(MobyGamesSearchEngine.extractCategory(string, ">Genre</div>"));
        webProfile2.setNotes(MobyGamesSearchEngine.extractDescription(string));
        webProfile2.setRank(MobyGamesSearchEngine.extractRank(string));
        webProfile2.setCoreGameCoverUrl(MobyGamesSearchEngine.extractCoreGameCoverUrl(string));
        if (StringUtils.isEmpty((CharSequence)webProfile2.getDeveloperName())) {
            webProfile2.setDeveloperName(this.extractCredits(string, "Credits</h2>"));
        }
        return webProfile2;
    }

    private String extractCredits(String string, String string2) {
        String string3;
        String string4;
        int n;
        int n2 = string.indexOf(string2);
        if (n2 != -1 && (n = string.indexOf("</div></div>", n2 + string2.length())) != -1 && (n2 = MobyGamesSearchEngine.idxNextHrefContent(string4 = string.substring(n2 + string2.length(), n), 0)) != -1 && MobyGamesSearchEngine.idxNextHrefContent(string4, n2 + (string3 = MobyGamesSearchEngine.extractNextContent(string4, n2, "<a ", "</a>")).length()) == -1 && !string3.equalsIgnoreCase("add credits")) {
            return MobyGamesSearchEngine.unescapeHtml(string3);
        }
        return "";
    }

    @Override
    public SearchEngineImageInformation[] getEntryImages(WebProfile webProfile, int n, int n2, boolean bl) throws IOException {
        ArrayList<SearchEngineImageInformation> arrayList = new ArrayList<SearchEngineImageInformation>();
        if (n > 0) {
            arrayList.addAll(this.getEntryCoverArtInformation(webProfile, n, bl));
        }
        if (n2 > 0) {
            arrayList.addAll(this.getEntryScreenshotInformation(webProfile, n2));
        }
        webProfile.setWebImages(arrayList.toArray(new SearchEngineImageInformation[0]));
        return webProfile.getWebImages();
    }

    private static String extractCoreGameCoverUrl(String string) {
        String string2 = "<div id=\"coreGameCover\">";
        String string3 = "<div class=\"links\">";
        int n = string.indexOf(string2) + string2.length();
        int n2 = string.indexOf(string3, n);
        if (n == -1 || n2 == -1) {
            return null;
        }
        String string4 = string.substring(n, n2);
        if ((n = MobyGamesSearchEngine.idxNextHrefContent(string4, 0)) == -1) {
            return null;
        }
        return MobyGamesSearchEngine.extractNextHrefContent(string4, n);
    }

    private static String extractCategory(String string, String string2) {
        int n = string.indexOf(string2);
        if (n != -1) {
            int n2 = string.indexOf("</div>", n + string2.length());
            return MobyGamesSearchEngine.unescapeHtml(MobyGamesSearchEngine.removeAllTags(string.substring(n + string2.length(), n2 + "</div>".length())));
        }
        return "";
    }

    private static String extractDescription(String string) {
        String string2 = "<h2>Description</h2>";
        int n = string.indexOf(string2) + string2.length();
        int n2 = string.indexOf("<div", n);
        return MobyGamesSearchEngine.unescapeHtml(MobyGamesSearchEngine.removeAllTags(string.substring(n, n2)));
    }

    private static Integer extractRank(String string) {
        String string2 = "scoreBoxBig";
        int n = string.indexOf(">", string.indexOf(string2) + string2.length()) + 1;
        int n2 = string.indexOf("<", n);
        try {
            return new Integer(string.substring(n, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private List<SearchEngineImageInformation> getEntryScreenshotInformation(WebProfile webProfile, int n) throws IOException {
        String string;
        int n2;
        String string2;
        ArrayList<SearchEngineImageInformation> arrayList = new ArrayList<SearchEngineImageInformation>();
        String string3 = MobyGamesSearchEngine.getResponseContent(webProfile.getScreenshotsUrl(), StandardCharsets.UTF_8);
        int n3 = string3.indexOf(string2 = "<div class=\"thumbnail\">");
        if (n3 != -1 && (n2 = string3.indexOf(string = "<div class=\"lifesupport-footer\">", n3)) != -1) {
            string3 = string3.substring(n3, n2);
            n3 = string3.indexOf("background-image:url(");
            for (int i = 0; i < n && n3 != -1; ++i) {
                String string4 = MobyGamesSearchEngine.extractNextSrcContentParentheses(string3, n3);
                string4 = this.absoluteUrl(MOBY_GAMES_HOST_NAME, string4.replaceAll("/images/shots/s/", "/images/shots/l/"));
                String string5 = MobyGamesSearchEngine.extractNextContent(string3, n3, "<small>", "</small>").replace("<br>", " ").replace("<br/>", " ").trim();
                arrayList.add(new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.Screenshot, string4, string5));
                n3 = string3.indexOf("background-image:url(", n3 + 1);
            }
        }
        return arrayList;
    }

    private List<SearchEngineImageInformation> getEntryCoverArtInformation(WebProfile webProfile, int n, boolean bl) throws IOException {
        ArrayList<SearchEngineImageInformation> arrayList = new ArrayList<SearchEngineImageInformation>();
        if (webProfile.getCoreGameCoverUrl() == null) {
            return arrayList;
        }
        int n2 = 0;
        String string = MobyGamesSearchEngine.getResponseContent(webProfile.getCoverArtUrl(), StandardCharsets.UTF_8);
        String string2 = bl ? "<div class=\"thumbnail\">" : webProfile.getCoreGameCoverUrlWithoutPathPrefix();
        int n3 = string.indexOf(string2);
        while (n3 != -1) {
            String string3 = "</div>    </div>  </div></div>";
            int n4 = string.indexOf(string3, n3);
            if (n4 != -1) {
                String string4 = string.substring(n3, n4);
                n3 = string4.indexOf("background-image:url(");
                while (n2 < n && n3 != -1) {
                    String string5 = MobyGamesSearchEngine.extractNextSrcContentParentheses(string4, n3);
                    string5 = this.absoluteUrl(MOBY_GAMES_HOST_NAME, string5.replaceAll("/images/covers/s/", "/images/covers/l/"));
                    String string6 = MobyGamesSearchEngine.extractNextContent(string4, n3, "<p>", "</p>").replace("<br>", " ").replace("<br/>", " ").trim();
                    arrayList.add(new SearchEngineImageInformation(SearchEngineImageInformation.SearchEngineImageType.CoverArt, string5, string6));
                    n3 = string4.indexOf("background-image:url(", n3 + 1);
                    ++n2;
                }
            }
            n3 = bl ? string.indexOf(string2, n4) : -1;
        }
        return arrayList;
    }

    private static class SearchEngineHolder {
        private static WebSearchEngine instance = new MobyGamesSearchEngine();

        private SearchEngineHolder() {
        }
    }
}

