/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.dbgl.waldheinz.fs.fat.AbstractDirectory;
import org.dbgl.waldheinz.fs.fat.BlockDevice;
import org.dbgl.waldheinz.fs.fat.Fat16BootSector;

final class Fat16RootDirectory
extends AbstractDirectory {
    private final BlockDevice device;
    private final long deviceOffset;

    private Fat16RootDirectory(Fat16BootSector fat16BootSector) {
        super(fat16BootSector.getRootDirEntryCount(), true);
        if (fat16BootSector.getRootDirEntryCount() <= 0) {
            throw new IllegalArgumentException("root directory size is " + fat16BootSector.getRootDirEntryCount());
        }
        this.deviceOffset = fat16BootSector.getRootDirOffset();
        this.device = fat16BootSector.getDevice();
    }

    public static Fat16RootDirectory read(Fat16BootSector fat16BootSector) throws IOException {
        Fat16RootDirectory fat16RootDirectory = new Fat16RootDirectory(fat16BootSector);
        fat16RootDirectory.read();
        return fat16RootDirectory;
    }

    @Override
    protected void read(ByteBuffer byteBuffer) throws IOException {
        this.device.read(this.deviceOffset, byteBuffer);
    }
}

