/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.waldheinz.fs.fat;

import java.io.IOException;
import org.dbgl.waldheinz.fs.fat.FatDirectoryEntry;
import org.dbgl.waldheinz.fs.fat.FatLfnDirectory;

public final class FatLfnDirectoryEntry {
    final FatDirectoryEntry realEntry;
    private FatLfnDirectory parent;
    private String fileName;

    FatLfnDirectoryEntry(FatLfnDirectory fatLfnDirectory, FatDirectoryEntry fatDirectoryEntry, String string) {
        this.parent = fatLfnDirectory;
        this.realEntry = fatDirectoryEntry;
        this.fileName = string;
    }

    static FatLfnDirectoryEntry extract(FatLfnDirectory fatLfnDirectory, int n, int n2) {
        String string;
        FatDirectoryEntry fatDirectoryEntry = fatLfnDirectory.dir.getEntry(n + n2 - 1);
        if (n2 == 1) {
            string = fatDirectoryEntry.getShortName().asSimpleString();
        } else {
            StringBuilder stringBuilder = new StringBuilder(13 * (n2 - 1));
            for (int i = n2 - 2; i >= 0; --i) {
                FatDirectoryEntry fatDirectoryEntry2 = fatLfnDirectory.dir.getEntry(i + n);
                stringBuilder.append(fatDirectoryEntry2.getLfnPart());
            }
            string = stringBuilder.toString().trim();
        }
        return new FatLfnDirectoryEntry(fatLfnDirectory, fatDirectoryEntry, string);
    }

    public boolean isHiddenFlag() {
        return this.realEntry.isHiddenFlag();
    }

    public boolean isSystemFlag() {
        return this.realEntry.isSystemFlag();
    }

    public boolean isReadOnlyFlag() {
        return this.realEntry.isReadonlyFlag();
    }

    public boolean isArchiveFlag() {
        return this.realEntry.isArchiveFlag();
    }

    public String getName() {
        return this.fileName;
    }

    public String getShortName() {
        return this.realEntry.getShortName().asSimpleString();
    }

    public FatLfnDirectory getDirectory() throws IOException {
        return this.parent.getDirectory(this.realEntry);
    }

    public String toString() {
        return "LFN = " + this.fileName + " / SFN = " + this.realEntry.getShortName();
    }

    public boolean isFile() {
        return this.realEntry.isFile();
    }

    public boolean isDirectory() {
        return this.realEntry.isDirectory();
    }
}

