/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.abstractdialog;

import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;
import org.dbgl.service.ITextService;
import org.dbgl.service.ImageService;
import org.dbgl.service.SettingsService;
import org.dbgl.service.TextService;
import org.dbgl.util.SystemUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class BaseDialog<T>
extends Dialog {
    private static final int MIN_BUTTON_WIDTH = 80;
    private static Integer averageCharacterWidth_;
    protected final SelectionAdapter closeShellAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            BaseDialog.this.shell_.close();
        }
    };
    protected final SelectionAdapter browseAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            SystemUtils.openForBrowsing(event.text);
        }
    };
    protected final Display display_;
    protected final int shellStyle_;
    protected Shell shell_;
    protected final ITextService text_;
    protected T result_;

    public BaseDialog(Shell parent, int shellStyle) {
        super(parent, 0);
        this.display_ = parent.getDisplay();
        this.shellStyle_ = shellStyle;
        this.text_ = TextService.getInstance();
    }

    public BaseDialog(Shell parent) {
        this(parent, 67696);
    }

    public T open() {
        if (!this.prepare()) {
            return null;
        }
        this.shell_ = this.shellStyle_ == 32768 ? this.getParent() : new Shell(this.getParent(), this.shellStyle_);
        this.shell_.setText(this.getDialogTitle());
        this.onShellInit();
        this.onShellCreated();
        this.shell_.open();
        this.onShellOpened();
        while (!this.shell_.isDisposed()) {
            this.shellDispatchCallback();
            if (this.display_.readAndDispatch()) continue;
            this.display_.sleep();
        }
        this.onClose();
        return this.result_;
    }

    protected boolean prepare() {
        return true;
    }

    protected void onShellInit() {
    }

    protected abstract String getDialogTitle();

    protected abstract void onShellCreated();

    protected void onShellOpened() {
    }

    protected void shellDispatchCallback() {
    }

    protected void onClose() {
    }

    protected static Font stringToFont(Device device, String[] font, Font defaultFont) {
        try {
            return new Font(device, font[0], Integer.parseInt(font[1]), Integer.parseInt(font[2]));
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultFont;
        }
    }

    protected static String fontToString(Device device, Font font) {
        FontData data = font.getFontData()[0];
        return data.getName() + '|' + data.getHeight() + '|' + data.getStyle();
    }

    protected static void setLayoutDataButtons(Button ... buttons) {
        Optional<Integer> maxWidth = Stream.of(buttons).map(x -> x.computeSize((int)-1, (int)-1).x).max(Comparator.naturalOrder());
        if (maxWidth.isPresent()) {
            if (averageCharacterWidth_ == null) {
                GC gc = new GC((Drawable)buttons[0]);
                averageCharacterWidth_ = (int)gc.getFontMetrics().getAverageCharacterWidth();
                gc.dispose();
            }
            int width = 4 * averageCharacterWidth_ + Math.max(maxWidth.get(), 80);
            for (Button button : buttons) {
                GridData gridData = new GridData(1, 4, true, false);
                gridData.widthHint = width;
                button.setLayoutData((Object)gridData);
            }
        }
    }

    protected static Composite createComposite(Composite composite, Object layoutData, Layout layout) {
        Composite inner = new Composite(composite, 0);
        if (layoutData != null) {
            inner.setLayoutData(layoutData);
        }
        if (layout != null) {
            inner.setLayout(layout);
        }
        return inner;
    }

    protected static Composite createComposite(Composite composite) {
        return BaseDialog.createComposite(composite, null, null);
    }

    protected static Composite createComposite(Composite composite, Object layoutData) {
        return BaseDialog.createComposite(composite, layoutData, null);
    }

    protected static Composite createComposite(Composite composite, int numColumns) {
        return BaseDialog.createComposite(composite, null, (Layout)new GridLayout(numColumns, false));
    }

    protected static Composite createInnerComposite(Composite composite, Object layoutData, int numColumns) {
        GridLayout layout = new GridLayout(numColumns, false);
        layout.horizontalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        return BaseDialog.createComposite(composite, layoutData, (Layout)layout);
    }

    protected static Composite createTabWithComposite(TabFolder tabFolder, String text, Layout layout) {
        Composite composite = BaseDialog.createComposite((Composite)tabFolder, null, layout);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(text);
        tabItem.setControl((Control)composite);
        return composite;
    }

    protected static Composite createTabWithComposite(TabFolder tabFolder, String text, int numColumns) {
        return BaseDialog.createTabWithComposite(tabFolder, text, (Layout)new GridLayout(numColumns, false));
    }

    protected static Composite createTabWithInnerComposite(TabFolder tabFolder, String text, int numColumns) {
        Composite composite = BaseDialog.createInnerComposite((Composite)tabFolder, null, numColumns);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(text);
        tabItem.setControl((Control)composite);
        return composite;
    }

    protected static Group createGroup(Composite composite, Object layoutData, String text, Layout layout) {
        Group group = new Group(composite, 0);
        if (layoutData != null) {
            group.setLayoutData(layoutData);
        }
        if (text != null) {
            group.setText(text);
        }
        if (layout != null) {
            group.setLayout(layout);
        }
        return group;
    }

    protected static Group createGroup(Composite composite, Object layoutData, String text, int numColumns) {
        return BaseDialog.createGroup(composite, layoutData, text, (Layout)new GridLayout(numColumns, false));
    }

    protected static Group createGroup(Composite composite, String text, Layout layout) {
        return BaseDialog.createGroup(composite, null, text, layout);
    }

    protected static Group createGroup(Composite composite, String text, int numColumns) {
        return BaseDialog.createGroup(composite, null, text, (Layout)new GridLayout(numColumns, false));
    }

    protected static Group createGroup(Composite composite, Layout layout) {
        return BaseDialog.createGroup(composite, null, null, layout);
    }

    protected static ExpandItem createExpandItem(ExpandBar expandBar, String text, boolean expanded, Composite composite) {
        ExpandItem expandItem = new ExpandItem(expandBar, 0);
        expandItem.setText(text);
        expandItem.setExpanded(expanded);
        expandItem.setControl((Control)composite);
        expandItem.setHeight(composite.computeSize((int)-1, (int)-1).y);
        return expandItem;
    }

    protected static Label createLabel(Composite composite, int style, Object layoutData, String text) {
        Label label = new Label(composite, style);
        if (layoutData != null) {
            label.setLayoutData(layoutData);
        }
        if (text != null) {
            label.setText(text);
        }
        return label;
    }

    protected static Label createLabel(Composite composite, int horizontalSpan, int verticalSpan, String text) {
        return BaseDialog.createLabel(composite, 0, new GridData(16384, 0x1000000, false, false, horizontalSpan, verticalSpan), text);
    }

    protected static Label createLabel(Composite composite, int horizontalSpan, int verticalSpan) {
        return BaseDialog.createLabel(composite, 0, new GridData(16384, 0x1000000, false, false, horizontalSpan, verticalSpan), null);
    }

    protected static Label createLabel(Composite composite, String text) {
        return BaseDialog.createLabel(composite, 0, null, text);
    }

    protected static Label createLabel(Composite composite) {
        return BaseDialog.createLabel(composite, 0, null, null);
    }

    protected static void createHorizontalSeparator(Composite composite, int horizontalSpan) {
        BaseDialog.createLabel(composite, 258, new GridData(4, 0x1000000, true, false, horizontalSpan, 1), null);
    }

    protected static void createVerticalSeparator(Composite composite, int verticalSpan) {
        BaseDialog.createLabel(composite, 514, new GridData(16384, 4, false, true, 1, verticalSpan), null);
    }

    protected static Text createText(Composite composite, int style, Object layoutData, String value, String tooltip) {
        Text text = new Text(composite, style);
        if (layoutData != null) {
            text.setLayoutData(layoutData);
        }
        if (value != null) {
            text.setText(value);
        }
        if (tooltip != null) {
            text.setToolTipText(tooltip);
        }
        return text;
    }

    protected static Text createText(Composite composite, int style, int horizontalSpan) {
        return BaseDialog.createText(composite, style, new GridData(4, 0x1000000, true, false, horizontalSpan, 1), null, null);
    }

    protected static Text createText(Composite composite, Object layoutData) {
        return BaseDialog.createText(composite, 2048, layoutData, null, null);
    }

    protected static Text createText(Composite composite, int horizontalSpan) {
        return BaseDialog.createText(composite, 2048, new GridData(4, 0x1000000, true, false, horizontalSpan, 1), null, null);
    }

    protected static Text createText(Composite composite, String value) {
        return BaseDialog.createText(composite, 2048, null, value, null);
    }

    protected static Text createText(Composite composite) {
        return BaseDialog.createText(composite, 2048, new GridData(4, 0x1000000, true, false), null, null);
    }

    protected static Text createTextarea(Composite composite, boolean readonly, boolean wrapping, int horizontalSpan, int verticalSpan, String value) {
        int style = 2562;
        if (readonly) {
            style |= 8;
        }
        return BaseDialog.createText(composite, style |= wrapping ? 64 : 256, new GridData(4, 4, true, true, horizontalSpan, verticalSpan), value, null);
    }

    protected static Text createTextarea(Composite composite, boolean readonly) {
        int style = 2818;
        if (readonly) {
            style |= 8;
        }
        return BaseDialog.createText(composite, style, new GridData(4, 4, true, true), null, null);
    }

    protected static Button createButton(Composite composite, int style, Object layoutData, String text, String tooltip) {
        Button button = new Button(composite, style);
        if (layoutData != null) {
            button.setLayoutData(layoutData);
        }
        if (text != null) {
            button.setText(text);
        }
        if (tooltip != null) {
            button.setToolTipText(tooltip);
        }
        return button;
    }

    protected static Button createButton(Composite composite, Object layoutData, String text, String tooltip, SelectionListener listener) {
        Button button = BaseDialog.createButton(composite, 0, layoutData, text, tooltip);
        button.addSelectionListener(listener);
        return button;
    }

    protected static Button createButton(Composite composite, String text, SelectionListener listener) {
        Button button = BaseDialog.createButton(composite, 0, new GridData(4, 0x1000000, false, false), text, null);
        button.addSelectionListener(listener);
        return button;
    }

    protected static Button createCheckButton(Composite composite, Object layoutData, String text, String tooltip, boolean selected) {
        Button button = BaseDialog.createButton(composite, 32, layoutData, text, tooltip);
        button.setSelection(selected);
        return button;
    }

    protected static Button createCheckButton(Composite composite, Object layoutData, String text, boolean selected) {
        return BaseDialog.createCheckButton(composite, layoutData, text, null, selected);
    }

    protected static Button createCheckButton(Composite composite, Object layoutData, boolean selected) {
        return BaseDialog.createCheckButton(composite, layoutData, null, null, selected);
    }

    protected static Button createCheckButton(Composite composite, int horizontalSpan, String text, String tooltip, boolean selected) {
        return BaseDialog.createCheckButton(composite, new GridData(1, 0x1000000, false, false, horizontalSpan, 1), text, tooltip, selected);
    }

    protected static Button createCheckButton(Composite composite, int horizontalSpan, String text, boolean selected) {
        return BaseDialog.createCheckButton(composite, new GridData(1, 0x1000000, false, false, horizontalSpan, 1), text, null, selected);
    }

    protected static Button createCheckButton(Composite composite, String tooltip) {
        return BaseDialog.createCheckButton(composite, null, null, tooltip, false);
    }

    protected static Button createCheckButton(Composite composite, boolean selected) {
        return BaseDialog.createCheckButton(composite, null, null, null, selected);
    }

    protected static Button createToggleButton(Composite composite, String text, boolean selected, SelectionListener listener) {
        Button button = BaseDialog.createButton(composite, 2, null, text, null);
        button.setSelection(selected);
        button.addSelectionListener(listener);
        return button;
    }

    protected static Button createImageButton(Composite composite, int style, Object layoutData, Image image, String text, String tooltip, SelectionListener listener, boolean enableDisposeListener) {
        Button button = BaseDialog.createButton(composite, style, layoutData, text, tooltip);
        button.setImage(image);
        if (enableDisposeListener) {
            button.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ((Button)e.getSource()).getImage().dispose();
                }
            });
        }
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    protected static Button createImageButton(Composite composite, int style, Object layoutData, Image image, String tooltip) {
        return BaseDialog.createImageButton(composite, style, layoutData, image, null, tooltip, null, true);
    }

    protected static Button createImageButton(Composite composite, int style, Image image, SelectionListener listener) {
        return BaseDialog.createImageButton(composite, style, null, image, null, null, listener, true);
    }

    protected static Button createImageButton(Composite composite, Image image, String text, SelectionListener listener) {
        int display = SettingsService.getInstance().getIntValue("gui", "buttondisplay");
        return BaseDialog.createImageButton(composite, 0, new GridData(4, 0x1000000, false, false), (Image)(display != 1 ? image : null), text, null, listener, display != 1);
    }

    public static Button createImageButton(Composite composite, String text, String image) {
        int display = SettingsService.getInstance().getIntValue("gui", "buttondisplay");
        return BaseDialog.createImageButton(composite, 0, null, display != 1 ? ImageService.getResourceImage(composite.getDisplay(), image) : null, display == 2 ? null : text, display == 2 ? text : null, null, display != 1);
    }

    protected static Button createRadioButton(Composite composite, String text, int numColumns, boolean selected) {
        Button button = BaseDialog.createButton(composite, 16, new GridData(1, 0x1000000, false, false, numColumns, 1), text, null);
        button.setSelection(selected);
        return button;
    }

    protected static Button createRadioButton(Composite composite, String text) {
        return BaseDialog.createRadioButton(composite, text, 1, false);
    }

    protected static Button createArrowButton(Composite composite, int directionStyle, SelectionListener listener) {
        Button button = new Button(composite, 4 | directionStyle);
        button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button.addSelectionListener(listener);
        return button;
    }

    protected static Button createUpButton(Composite composite, SelectionListener listener) {
        return BaseDialog.createArrowButton(composite, 128, listener);
    }

    protected static Button createDownButton(Composite composite, SelectionListener listener) {
        return BaseDialog.createArrowButton(composite, 1024, listener);
    }

    protected static Button createThreeDotButton(Composite composite, SelectionListener listener) {
        return BaseDialog.createButton(composite, null, "...", null, listener);
    }

    protected static Link createLink(Composite composite, String text, SelectionListener listener) {
        Link link = new Link(composite, 0);
        link.setText(text);
        link.addSelectionListener(listener);
        return link;
    }

    protected static ProgressBar createProgressBar(Composite composite) {
        ProgressBar progressBar = new ProgressBar(composite, 0);
        progressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return progressBar;
    }

    protected static Spinner createSpinner(Composite composite, int selection, int minimum, int maximum, int digits, int increment, int pageIncrement) {
        Spinner spinner = new Spinner(composite, 2048);
        spinner.setValues(selection, minimum, maximum, digits, increment, pageIncrement);
        return spinner;
    }

    protected static Spinner createSpinner(Composite composite, int minimum, int maximum) {
        Spinner spinner = new Spinner(composite, 2048);
        spinner.setMinimum(minimum);
        spinner.setMaximum(maximum);
        return spinner;
    }

    protected static Scale createScale(Composite composite, boolean vertical, Object layoutData, int selection, int minimum, int maximum, int increment, int pageIncrement) {
        Scale scale = new Scale(composite, vertical ? 512 : 256);
        if (layoutData != null) {
            scale.setLayoutData(layoutData);
        }
        scale.setMinimum(minimum);
        scale.setMaximum(maximum);
        scale.setIncrement(increment);
        scale.setPageIncrement(pageIncrement);
        scale.setSelection(selection);
        return scale;
    }

    protected static Scale createScale(Composite composite, boolean vertical, Object layoutData, int selection, int maximum, int pageIncrement) {
        Scale scale = new Scale(composite, vertical ? 512 : 256);
        if (layoutData != null) {
            scale.setLayoutData(layoutData);
        }
        scale.setMaximum(maximum);
        scale.setPageIncrement(pageIncrement);
        scale.setSelection(selection);
        return scale;
    }

    protected static Scale createScale(Composite composite, boolean vertical, Object layoutData) {
        Scale scale = new Scale(composite, vertical ? 512 : 256);
        if (layoutData != null) {
            scale.setLayoutData(layoutData);
        }
        return scale;
    }

    protected static ToolItem createImageToolItem(ToolBar toolBar, int style, Image image, String tooltip, SelectionListener listener) {
        ToolItem toolItem = new ToolItem(toolBar, style);
        toolItem.setImage(image);
        toolItem.setToolTipText(tooltip);
        if (listener != null) {
            toolItem.addSelectionListener(listener);
        }
        return toolItem;
    }

    protected static ToolItem createImageToolItem(ToolBar toolBar, String title, String img, SelectionListener listener) {
        ToolItem toolItem = new ToolItem(toolBar, 2056);
        int displaySelection = SettingsService.getInstance().getIntValue("gui", "buttondisplay");
        if (displaySelection != 1) {
            toolItem.setImage(ImageService.getResourceImage(toolBar.getDisplay(), img));
        }
        if (displaySelection == 2) {
            toolItem.setToolTipText(title);
        } else {
            toolItem.setText(title);
        }
        toolItem.addSelectionListener(listener);
        return toolItem;
    }

    protected static ToolItem createSeparatorToolItem(ToolBar toolBar, int width) {
        ToolItem toolItem = new ToolItem(toolBar, 2050);
        toolItem.setWidth(width);
        return toolItem;
    }

    protected static MenuItem createMenuItem(Menu menu, int style, int pos, String title, String img, int accelerator, SelectionListener listener) {
        MenuItem menuItem = pos != -1 ? new MenuItem(menu, style, pos) : new MenuItem(menu, style);
        menuItem.setText(title);
        if (accelerator != -1) {
            menuItem.setAccelerator(accelerator);
        }
        if (img != null && SettingsService.getInstance().getIntValue("gui", "buttondisplay") != 1) {
            menuItem.setImage(ImageService.getResourceImage(menu.getDisplay(), img));
        }
        if (listener != null) {
            menuItem.addSelectionListener(listener);
        }
        return menuItem;
    }

    protected static MenuItem createMenuItem(Menu menu, int style, String title, String img, int accelerator, SelectionListener listener) {
        return BaseDialog.createMenuItem(menu, style, -1, title, img, accelerator, listener);
    }

    protected static MenuItem createMenuItem(Menu menu, int pos, String title, SelectionListener listener) {
        return BaseDialog.createMenuItem(menu, listener == null ? 64 : 0, pos, title, null, -1, listener);
    }

    protected static MenuItem createMenuItem(Menu menu, String title, String img, SelectionListener listener) {
        return BaseDialog.createMenuItem(menu, listener == null ? 64 : 0, -1, title, img, -1, listener);
    }

    protected static MenuItem createTopMenuItem(Menu menu, String title, String img, SelectionListener listener) {
        return BaseDialog.createMenuItem(menu, listener == null ? 64 : 0, 0, title, img, -1, listener);
    }

    protected static MenuItem createSeparatorMenuItem(Menu menu) {
        return new MenuItem(menu, 2);
    }

    protected static Menu createMenu(Menu parentMenu, String text, String img) {
        MenuItem menuItem = BaseDialog.createMenuItem(parentMenu, text, img, null);
        Menu menu = new Menu(menuItem);
        menuItem.setMenu(menu);
        return menu;
    }

    protected static Menu createMenu(Menu parentMenu, String text) {
        return BaseDialog.createMenu(parentMenu, text, null);
    }

    protected static List createList(Composite composite, int style, String[] items, int select) {
        List list = new List(composite, style);
        list.setItems(items);
        list.select(select);
        list.showSelection();
        return list;
    }

    protected static List createList(Composite composite, int style, int horizontalSpan, int verticalSpan) {
        List list = new List(composite, style);
        list.setLayoutData((Object)new GridData(4, 4, true, true, horizontalSpan, verticalSpan));
        return list;
    }

    protected static List createList(Composite composite, int horizontalSpan, int verticalSpan) {
        return BaseDialog.createList(composite, 2560, horizontalSpan, verticalSpan);
    }

    protected static TableColumn createTableColumn(Table table, int width, String text) {
        TableColumn column = new TableColumn(table, 0);
        column.setWidth(width);
        column.setText(text);
        return column;
    }

    protected static Combo createCombo(Composite composite, int style, Object layoutData, String[] items, int visibleItemCount, int select, String tooltip) {
        Combo combo = new Combo(composite, style);
        if (layoutData != null) {
            combo.setLayoutData(layoutData);
        }
        if (items != null) {
            combo.setItems(items);
        }
        combo.setVisibleItemCount(visibleItemCount);
        if (select >= 0) {
            combo.select(select);
        }
        if (tooltip != null) {
            combo.setToolTipText(tooltip);
        }
        return combo;
    }

    protected static Combo createCombo(Composite composite, int style, String[] items, String tooltip) {
        return BaseDialog.createCombo(composite, style, null, items, 10, -1, tooltip);
    }

    protected static Combo createCombo(Composite composite, String[] items, int visibleItemCount, int select) {
        return BaseDialog.createCombo(composite, 8, null, items, visibleItemCount, select, null);
    }

    protected static Combo createCombo(Composite composite, String[] items, int visibleItemCount, String tooltip) {
        return BaseDialog.createCombo(composite, 8, null, items, visibleItemCount, -1, tooltip);
    }

    protected static Combo createCombo(Composite composite, String[] items, int visibleItemCount) {
        return BaseDialog.createCombo(composite, 8, null, items, visibleItemCount, -1, null);
    }

    protected static Combo createCombo(Composite composite, String[] items, String tooltip) {
        return BaseDialog.createCombo(composite, 8, null, items, 10, -1, tooltip);
    }

    protected static Combo createEditableCombo(Composite composite, String[] items, int visibleItemCount) {
        return BaseDialog.createCombo(composite, 0, null, items, visibleItemCount, -1, null);
    }

    protected static Combo createEditableCombo(Composite composite, String[] items, int visibleItemCount, String tooltip) {
        return BaseDialog.createCombo(composite, 0, null, items, visibleItemCount, -1, tooltip);
    }

    protected static Combo createWideEditableCombo(Composite composite, String[] items, int visibleItemCount, String tooltip) {
        return BaseDialog.createCombo(composite, 0, new GridData(4, 0x1000000, true, false), items, visibleItemCount, -1, tooltip);
    }

    protected static Text createLabelAndText(Composite composite, String labelText, int style, Object layoutData, String value, String tooltip) {
        BaseDialog.createLabel(composite, labelText);
        return BaseDialog.createText(composite, style, layoutData, value, tooltip);
    }

    protected static Text createLabelAndText(Composite composite, String labelText, int horizontalSpan, String value, String tooltip) {
        return BaseDialog.createLabelAndText(composite, labelText, 2048, new GridData(4, 0x1000000, true, false, horizontalSpan, 1), value, tooltip);
    }

    protected static Text createLabelAndText(Composite composite, String labelText, int horizontalSpan, String value) {
        return BaseDialog.createLabelAndText(composite, labelText, 2048, new GridData(4, 0x1000000, true, false, horizontalSpan, 1), value, null);
    }

    protected static Text createLabelAndText(Composite composite, String labelText, int horizontalSpan) {
        return BaseDialog.createLabelAndText(composite, labelText, 2048, new GridData(4, 0x1000000, true, false, horizontalSpan, 1), null, null);
    }

    protected static Text createLabelAndText(Composite composite, String labelText) {
        return BaseDialog.createLabelAndText(composite, labelText, 2048, new GridData(4, 0x1000000, true, false), null, null);
    }

    protected static Text createLabelAndText(Composite composite, String labelText, String value) {
        return BaseDialog.createLabelAndText(composite, labelText, 2048, new GridData(4, 0x1000000, true, false), value, null);
    }

    protected static Text createLabelAndTextarea(Composite composite, String labelText, boolean readonly, boolean wrapping, int horizontalSpan, int verticalSpan, String value) {
        BaseDialog.createLabel(composite, labelText);
        return BaseDialog.createTextarea(composite, readonly, wrapping, horizontalSpan, verticalSpan, value);
    }

    protected static Text createLabelAndTextarea(Composite composite, String labelText, boolean readonly, boolean wrapping, int horizontalSpan, int verticalSpan) {
        return BaseDialog.createLabelAndTextarea(composite, labelText, readonly, wrapping, horizontalSpan, verticalSpan, null);
    }

    protected static Text createLabelAndTextarea(Composite composite, String labelText, boolean readonly, String value) {
        return BaseDialog.createLabelAndTextarea(composite, labelText, readonly, false, 1, 1, value);
    }

    protected static Text createLabelAndTextarea(Composite composite, String labelText, boolean readonly) {
        return BaseDialog.createLabelAndTextarea(composite, labelText, readonly, false, 1, 1, null);
    }

    protected static Scale createLabelAndScale(Composite composite, String labelText, boolean vertical, Object layoutData, int selection, int minimum, int maximum, int increment, int pageIncrement) {
        BaseDialog.createLabel(composite, labelText);
        return BaseDialog.createScale(composite, vertical, layoutData, selection, minimum, maximum, increment, pageIncrement);
    }

    protected static Spinner createLabelAndSpinner(Composite composite, String labelText, int selection, int minimum, int maximum, int digits, int increment, int pageIncrement) {
        BaseDialog.createLabel(composite, labelText);
        return BaseDialog.createSpinner(composite, selection, minimum, maximum, digits, increment, pageIncrement);
    }

    protected static Spinner createLabelAndSpinner(Composite composite, String labelText, int selection) {
        return BaseDialog.createLabelAndSpinner(composite, labelText, selection, 0, Integer.MAX_VALUE, 0, 1, 10);
    }

    protected static Button createLabelAndButton(Composite composite, String labelText, String buttonText, SelectionListener listener) {
        BaseDialog.createLabel(composite, labelText);
        return BaseDialog.createButton(composite, buttonText, listener);
    }

    protected static Button createLabelAndRadioButton(Composite composite, String labelText, String text, boolean selected) {
        BaseDialog.createLabel(composite, labelText);
        return BaseDialog.createRadioButton(composite, text, 1, selected);
    }

    protected static Button createLabelAndCheckButton(Composite composite, String labelText, int horizontalSpan, String text, String tooltip, boolean selected) {
        BaseDialog.createLabel(composite, labelText);
        return BaseDialog.createCheckButton(composite, horizontalSpan, text, tooltip, selected);
    }

    protected static Button createLabelAndCheckButton(Composite composite, String labelText, int horizontalSpan, String text, boolean selected) {
        return BaseDialog.createLabelAndCheckButton(composite, labelText, horizontalSpan, text, null, selected);
    }

    protected static Button createLabelAndCheckButton(Composite composite, String labelText, int horizontalSpan, String text) {
        return BaseDialog.createLabelAndCheckButton(composite, labelText, horizontalSpan, text, false);
    }

    protected static Button createLabelAndCheckButton(Composite composite, String labelText, int horizontalSpan, boolean selected) {
        return BaseDialog.createLabelAndCheckButton(composite, labelText, horizontalSpan, null, selected);
    }

    protected static Button createLabelAndCheckButton(Composite composite, String labelText, int horizontalSpan) {
        return BaseDialog.createLabelAndCheckButton(composite, labelText, horizontalSpan, null, false);
    }

    protected static Button createLabelAndCheckButton(Composite composite, String labelText, String text, boolean selected) {
        return BaseDialog.createLabelAndCheckButton(composite, labelText, 1, text, selected);
    }

    protected static Button createLabelAndCheckButton(Composite composite, String labelText, boolean selected) {
        return BaseDialog.createLabelAndCheckButton(composite, labelText, 1, null, selected);
    }

    protected static Button createLabelAndTooltipCheckButton(Composite composite, String labelText, String tooltip, boolean selected) {
        return BaseDialog.createLabelAndCheckButton(composite, labelText, 1, null, tooltip, selected);
    }

    protected static Combo createLabelAndCombo(Composite composite, String labelText, int style, Object layoutData, String[] items, int visibleItemCount, int select, String tooltip) {
        BaseDialog.createLabel(composite, labelText);
        return BaseDialog.createCombo(composite, style, layoutData, items, visibleItemCount, select, tooltip);
    }

    protected static Combo createLabelAndCombo(Composite composite, String labelText, String[] items, int visibleItemCount, int select) {
        return BaseDialog.createLabelAndCombo(composite, labelText, 8, null, items, visibleItemCount, select, null);
    }

    protected static Combo createLabelAndCombo(Composite composite, String labelText, String[] items, int visibleItemCount) {
        return BaseDialog.createLabelAndCombo(composite, labelText, 8, null, items, visibleItemCount, -1, null);
    }

    protected static Combo createLabelAndCombo(Composite composite, String labelText, boolean wide, int horizontalSpan, String[] items, int visibleItemCount, int select, String tooltip) {
        GridData gd = wide ? new GridData(4, 0x1000000, true, false, horizontalSpan, 1) : new GridData(1, 0x1000000, false, false, horizontalSpan, 1);
        return BaseDialog.createLabelAndCombo(composite, labelText, 8, gd, items, visibleItemCount, select, tooltip);
    }

    protected static Combo createLabelAndCombo(Composite composite, String labelText, boolean wide, int horizontalSpan, String[] items, int visibleItemCount) {
        return BaseDialog.createLabelAndCombo(composite, labelText, wide, horizontalSpan, items, visibleItemCount, -1, null);
    }

    protected static Combo createLabelAndCombo(Composite composite, String labelText, int horizontalSpan, String[] items, int visibleItemCount, String tooltip) {
        return BaseDialog.createLabelAndCombo(composite, labelText, false, horizontalSpan, items, visibleItemCount, -1, tooltip);
    }

    protected static Combo createLabelAndWideCombo(Composite composite, String labelText) {
        return BaseDialog.createLabelAndCombo(composite, labelText, true, 1, null, 20, -1, null);
    }

    protected static Combo createLabelAndEditableCombo(Composite composite, String labelText, int horizontalSpan, String[] items, int visibleItemCount, String tooltip) {
        return BaseDialog.createLabelAndCombo(composite, labelText, 0, new GridData(1, 0x1000000, false, false, horizontalSpan, 1), items, visibleItemCount, -1, tooltip);
    }

    protected static Combo createLabelAndEditableCombo(Composite composite, String labelText, String[] items, int visibleItemCount) {
        return BaseDialog.createLabelAndEditableCombo(composite, labelText, 1, items, visibleItemCount, null);
    }
}

