/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.abstractdialog;

import org.dbgl.gui.abstractdialog.WizardDialog;
import org.dbgl.gui.thread.UIThread;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class JobWizardDialog<T>
extends WizardDialog<T> {
    protected ProgressBar progressBar_;
    protected Label status_;
    protected Text log_;
    protected UIThread<?> job_;

    public JobWizardDialog(Shell parent, String dialogName) {
        super(parent, dialogName);
    }

    @Override
    protected void shellDispatchCallback() {
        if (this.hasJobFinished() && !this.nextButton_.getEnabled()) {
            this.goForward();
        }
    }

    @Override
    protected void activateCurrentStep() {
        super.activateCurrentStep();
        if (this.job_ != null) {
            this.backButton_.setEnabled(false);
            this.nextButton_.setEnabled(this.hasJobFinished());
            this.cancelButton_.setEnabled(false);
            if (this.job_.getState() == Thread.State.NEW) {
                this.job_.start();
            }
        }
    }

    @Override
    protected int totalSteps() {
        return super.totalSteps() + 2;
    }

    private boolean hasJobFinished() {
        return this.job_ != null && this.job_.getState() == Thread.State.TERMINATED;
    }

    protected void addFinalStep(String groupTitle, String statusText) {
        Group progressGroup = JobWizardDialog.createGroup((Composite)this.shell_, groupTitle, (Layout)new GridLayout());
        this.progressBar_ = JobWizardDialog.createProgressBar((Composite)progressGroup);
        this.status_ = JobWizardDialog.createLabel((Composite)progressGroup, statusText);
        this.log_ = JobWizardDialog.createTextarea((Composite)progressGroup, true);
        this.addStep(progressGroup);
    }
}

