/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.sql.SQLException;
import java.util.List;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.abstractdialog.SizeControlledTabbedDialog;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.repository.ProfileRepository;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class DeleteProfilesDialog
extends SizeControlledTabbedDialog<List<Profile>> {
    private final List<Profile> profilesToBeDeleted_;

    public DeleteProfilesDialog(Shell parent, List<Profile> profs) {
        super(parent, "profiledeletedialog");
        this.profilesToBeDeleted_ = profs;
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.deleteprofiles.title", new Object[]{this.profilesToBeDeleted_.size()});
    }

    @Override
    protected void onShellCreated() {
        Composite composite = this.createTabWithComposite(this.text_.get("dialog.deleteprofiles.options"), 2);
        DeleteProfilesDialog.createLabelAndCheckButton(composite, this.text_.get("dialog.deleteprofiles.confirm.removedatabaseentry"), true).setEnabled(false);
        final Button deleteConfs = DeleteProfilesDialog.createLabelAndCheckButton(composite, this.text_.get("dialog.deleteprofiles.confirm.removeprofileconf"), true);
        final Button deleteMapperfiles = DeleteProfilesDialog.createLabelAndCheckButton(composite, this.text_.get("dialog.deleteprofiles.confirm.removemapperfile"), true);
        final Button deleteCaptures = DeleteProfilesDialog.createLabelAndCheckButton(composite, this.text_.get("dialog.deleteprofiles.confirm.removeprofilecaptures"), true);
        this.createOkCancelButtons((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (GeneralPurposeDialogs.confirmMessage(DeleteProfilesDialog.this.shell_, DeleteProfilesDialog.this.text_.get("dialog.deleteprofiles.confirm.removal", new Object[]{DeleteProfilesDialog.this.profilesToBeDeleted_.size()}))) {
                    for (Profile prof : DeleteProfilesDialog.this.profilesToBeDeleted_) {
                        try {
                            new ProfileRepository().remove(prof, deleteConfs.getSelection(), deleteMapperfiles.getSelection(), deleteCaptures.getSelection());
                        }
                        catch (SQLException e) {
                            GeneralPurposeDialogs.warningMessage(DeleteProfilesDialog.this.shell_, e);
                        }
                    }
                    DeleteProfilesDialog.this.result_ = DeleteProfilesDialog.this.profilesToBeDeleted_;
                }
                DeleteProfilesDialog.this.shell_.close();
            }
        });
    }
}

