/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.abstractdialog.SizeControlledTabbedDialog;
import org.dbgl.gui.controls.BrowseButton;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.factory.DosboxVersionFactory;
import org.dbgl.model.repository.DosboxVersionRepository;
import org.dbgl.service.FileLocationService;
import org.dbgl.util.ExecuteUtils;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.SystemUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditDosboxVersionDialog
extends SizeControlledTabbedDialog<DosboxVersion> {
    private final boolean isDefault_;
    private final DosboxVersion dbversion_;

    public EditDosboxVersionDialog(Shell parent, boolean isDefault, DosboxVersion dbversion) {
        super(parent, "dosboxdialog");
        this.isDefault_ = isDefault;
        this.dbversion_ = dbversion;
    }

    @Override
    protected String getDialogTitle() {
        return this.dbversion_ == null || this.dbversion_.getId() == -1 ? this.text_.get("dialog.dosboxversion.title.add") : this.text_.get("dialog.dosboxversion.title.edit", new Object[]{this.dbversion_.getTitle(), this.dbversion_.getId()});
    }

    @Override
    protected void onShellCreated() {
        Composite composite = this.createTabWithComposite(this.text_.get("dialog.dosboxversion.tab.info"), 3);
        final Text title = EditDosboxVersionDialog.createLabelAndText(composite, this.text_.get("dialog.dosboxversion.title"), 2);
        title.setFocus();
        final Text path = EditDosboxVersionDialog.createLabelAndText(composite, this.text_.get("dialog.dosboxversion.path"));
        BrowseButton browsePathButton = new BrowseButton(composite);
        final Text exe = EditDosboxVersionDialog.createLabelAndText(composite, this.text_.get("dialog.dosboxversion.executable"), 1, "", this.text_.get("dialog.dosboxversion.executable.tooltip", new Object[]{FileLocationService.DOSBOX_EXE_STRING}));
        BrowseButton browseExeButton = new BrowseButton(composite);
        final Text conf = EditDosboxVersionDialog.createLabelAndText(composite, this.text_.get("dialog.profile.configfile"));
        BrowseButton browseConfButton = new BrowseButton(composite);
        browsePathButton.connect(this.shell_, path, conf, SystemUtils.IS_OSX ? BrowseButton.BrowseType.FILE : BrowseButton.BrowseType.DIR, BrowseButton.CanonicalType.DOSBOX, false, null);
        browseExeButton.connect(this.shell_, exe, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.DOSBOXEXE, false, null);
        browseConfButton.connect(this.shell_, conf, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.DOSBOXCONF, false, null);
        final Text parameters = EditDosboxVersionDialog.createLabelAndText(composite, this.text_.get("dialog.dosboxversion.parameters"), 2);
        final Combo version = EditDosboxVersionDialog.createLabelAndCombo(composite, this.text_.get("dialog.dosboxversion.version"), false, 2, DosboxVersion.SUPP_RELEASES, 15);
        final Button multiconf = EditDosboxVersionDialog.createLabelAndCheckButton(composite, this.text_.get("dialog.dosboxversion.multiconfsupport"), 2);
        final Button usingCurses = EditDosboxVersionDialog.createLabelAndCheckButton(composite, this.text_.get("dialog.dosboxversion.altstartup"), 2, this.text_.get("dialog.dosboxversion.altstartupexplanation"));
        final Button defaultButton = EditDosboxVersionDialog.createLabelAndCheckButton(composite, this.text_.get("dialog.dosboxversion.default"), 2);
        this.createOkCancelButtons((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EditDosboxVersionDialog.this.isValid(title, path, exe, conf, usingCurses)) {
                    return;
                }
                try {
                    if (EditDosboxVersionDialog.this.dbversion_ == null || EditDosboxVersionDialog.this.dbversion_.getId() == -1) {
                        DosboxVersion dbv = DosboxVersionFactory.create(title.getText(), version.getText(), defaultButton.getSelection(), multiconf.getSelection(), usingCurses.getSelection(), path.getText(), exe.getText(), parameters.getText(), conf.getText());
                        EditDosboxVersionDialog.this.result_ = new DosboxVersionRepository().add(dbv);
                    } else {
                        EditDosboxVersionDialog.this.dbversion_.setTitle(title.getText());
                        EditDosboxVersionDialog.this.dbversion_.setVersion(version.getText());
                        EditDosboxVersionDialog.this.dbversion_.setDefault(defaultButton.getSelection());
                        EditDosboxVersionDialog.this.dbversion_.setMultiConfig(multiconf.getSelection());
                        EditDosboxVersionDialog.this.dbversion_.setUsingCurses(usingCurses.getSelection());
                        EditDosboxVersionDialog.this.dbversion_.setPath(path.getText());
                        EditDosboxVersionDialog.this.dbversion_.setExe(exe.getText());
                        EditDosboxVersionDialog.this.dbversion_.setExecutableParameters(parameters.getText());
                        EditDosboxVersionDialog.this.dbversion_.setConfigurationFileLocation(conf.getText());
                        new DosboxVersionRepository().update(EditDosboxVersionDialog.this.dbversion_);
                        EditDosboxVersionDialog.this.result_ = EditDosboxVersionDialog.this.dbversion_;
                    }
                }
                catch (SQLException e) {
                    GeneralPurposeDialogs.warningMessage(EditDosboxVersionDialog.this.shell_, e);
                }
                EditDosboxVersionDialog.this.shell_.close();
            }
        });
        if (this.dbversion_ != null) {
            title.setText(this.dbversion_.getTitle());
            path.setText(this.dbversion_.getPath().getPath());
            exe.setText(this.dbversion_.getExe().getPath());
            conf.setText(this.dbversion_.getConfigurationFile().getPath());
            parameters.setText(this.dbversion_.getExecutableParameters());
            version.setText(this.dbversion_.getVersion());
            defaultButton.setSelection(this.dbversion_.isDefault());
            multiconf.setSelection(this.dbversion_.isMultiConfig());
            usingCurses.setSelection(this.dbversion_.isUsingCurses());
        } else {
            version.select(version.getItemCount() - 1);
            defaultButton.setSelection(this.isDefault_);
            multiconf.setSelection(true);
        }
    }

    private boolean isValid(Text title, Text path, Text exe, Text conf, Button usingCurses) {
        GeneralPurposeDialogs.initErrorDialog();
        if (StringUtils.isBlank((CharSequence)title.getText())) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.dosboxversion.required.title"), (Control)title);
        }
        if (StringUtils.isBlank((CharSequence)path.getText())) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.dosboxversion.required.path"), (Control)path);
        }
        if (StringUtils.isBlank((CharSequence)conf.getText())) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.dosboxversion.required.conf"), (Control)conf);
        }
        if (!GeneralPurposeDialogs.hasErrors()) {
            DosboxVersion dbversion = DosboxVersionFactory.create("", "", false, false, false, path.getText(), exe.getText(), "", conf.getText());
            File executable = dbversion.getCanonicalExecutable();
            File configFile = dbversion.getConfigurationCanonicalFile();
            boolean exeAvailable = FilesUtils.isReadableFile(executable);
            if (!exeAvailable) {
                GeneralPurposeDialogs.addError(this.text_.get("dialog.dosboxversion.error.dosboxexemissing", new Object[]{executable}), (Control)path);
            }
            if (!FilesUtils.isReadableFile(configFile) && exeAvailable && GeneralPurposeDialogs.confirmMessage(this.shell_, this.text_.get("dialog.dosboxversion.confirm.createmissingdosboxconf", new Object[]{configFile}))) {
                try {
                    ExecuteUtils.doCreateDosboxConf(dbversion);
                }
                catch (IOException e) {
                    GeneralPurposeDialogs.warningMessage(this.shell_, e);
                }
            }
            if (!usingCurses.getSelection() && !FilesUtils.isReadableFile(configFile)) {
                GeneralPurposeDialogs.addError(this.text_.get("dialog.dosboxversion.error.dosboxconfmissing", new Object[]{configFile}), (Control)path);
            }
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell_);
    }
}

