/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import org.dbgl.gui.abstractdialog.SizeControlledButtonDialog;
import org.dbgl.model.MixerCommand;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;

public class EditMixerDialog
extends SizeControlledButtonDialog<String> {
    private final MixerCommand mixerCommand_;

    public EditMixerDialog(Shell parent, String command) {
        super(parent, "mixerdialog");
        this.mixerCommand_ = new MixerCommand(command);
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.mixer.title");
    }

    @Override
    protected void onShellCreated() {
        this.contents_.setLayout((Layout)new GridLayout(MixerCommand.CHANNELS.length, true));
        for (final String channelName : MixerCommand.CHANNELS) {
            Group channelGroup = EditMixerDialog.createGroup(this.contents_, (Object)new GridData(4, 4, true, true), this.text_.get("dialog.mixer." + channelName), 2);
            final Label left = EditMixerDialog.createLabel((Composite)channelGroup);
            final Label right = EditMixerDialog.createLabel((Composite)channelGroup);
            final Scale scaleLeft = EditMixerDialog.createScale((Composite)channelGroup, true, new GridData(0x1000000, 4, true, true), 200 - this.mixerCommand_.getVolumeFor(channelName).getLeft(), 200, 10);
            final Scale scaleRight = EditMixerDialog.createScale((Composite)channelGroup, true, new GridData(0x1000000, 4, true, true), 200 - this.mixerCommand_.getVolumeFor(channelName).getRight(), 200, 10);
            final Button lock = EditMixerDialog.createCheckButton((Composite)channelGroup, new GridData(0x1000000, 4, true, false, 2, 1), this.text_.get("dialog.mixer.lockbalance"), scaleLeft.getSelection() == scaleRight.getSelection());
            this.setVolumeBar(left, right, scaleLeft, scaleRight);
            scaleLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    if (lock.getSelection()) {
                        scaleRight.setSelection(scaleLeft.getSelection());
                    }
                    EditMixerDialog.this.mixerCommand_.setVolumeFor(channelName, 200 - scaleLeft.getSelection(), 200 - scaleRight.getSelection());
                    EditMixerDialog.this.setVolumeBar(left, right, scaleLeft, scaleRight);
                }
            });
            scaleRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    if (lock.getSelection()) {
                        scaleLeft.setSelection(scaleRight.getSelection());
                    }
                    EditMixerDialog.this.mixerCommand_.setVolumeFor(channelName, 200 - scaleLeft.getSelection(), 200 - scaleRight.getSelection());
                    EditMixerDialog.this.setVolumeBar(left, right, scaleLeft, scaleRight);
                }
            });
        }
        this.createOkCancelButtons((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditMixerDialog.this.result_ = EditMixerDialog.this.mixerCommand_.toString();
                EditMixerDialog.this.shell_.close();
            }
        });
    }

    private void setVolumeBar(Label left, Label right, Scale scaleLeft, Scale scaleRight) {
        left.setText(this.text_.get("dialog.mixer.leftchannelvolume", new Integer[]{200 - scaleLeft.getSelection()}));
        left.pack();
        right.setText(this.text_.get("dialog.mixer.rightchannelvolume", new Integer[]{200 - scaleRight.getSelection()}));
        right.pack();
    }
}

