/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import org.apache.commons.lang3.StringUtils;
import org.dbgl.exception.InvalidMountstringException;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.abstractdialog.SizeControlledButtonDialog;
import org.dbgl.gui.controls.BrowseButton;
import org.dbgl.gui.dialog.EditImgSizeDialog;
import org.dbgl.model.conf.mount.DirMount;
import org.dbgl.model.conf.mount.ImageMount;
import org.dbgl.model.conf.mount.Mount;
import org.dbgl.model.conf.mount.PhysFsMount;
import org.dbgl.model.factory.MountFactory;
import org.dbgl.util.StringRelatedUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditMountDialog
extends SizeControlledButtonDialog<String> {
    private final String mount_;
    private final char driveletter_;

    public EditMountDialog(Shell parent, String mount, char driveletter) {
        super(parent, "mountdialog");
        this.mount_ = mount;
        this.driveletter_ = driveletter;
    }

    @Override
    protected String getDialogTitle() {
        return this.mount_ == null ? this.text_.get("dialog.mount.title.add") : this.text_.get("dialog.mount.title.edit");
    }

    @Override
    protected void onShellCreated() {
        this.contents_.setLayout((Layout)new GridLayout(5, false));
        final Combo driveletter = EditMountDialog.createLabelAndCombo(this.contents_, this.text_.get("dialog.mount.driveletter"), false, 4, "ABCDEFGHIJKLMNOPQRSTUVWXY".split("(?!^)"), 10);
        final Button mountDirButton = EditMountDialog.createRadioButton(this.contents_, this.text_.get("dialog.mount.mountdir"));
        final Text dirMountDir = EditMountDialog.createText(this.contents_, 3);
        new BrowseButton(this.contents_).connect(this.shell_, dirMountDir, null, BrowseButton.BrowseType.DIR, BrowseButton.CanonicalType.DOSROOT, false, null);
        EditMountDialog.createLabel(this.contents_, 1, 4);
        final Combo dirMountType = EditMountDialog.createLabelAndCombo(this.contents_, this.text_.get("dialog.mount.mountdiras"), false, 3, this.settings_.getValues("profile", "mount_type"), 10);
        dirMountType.add("", 0);
        final Text dirMountLabel = EditMountDialog.createLabelAndText(this.contents_, this.text_.get("dialog.mount.drivelabel"), 3);
        Composite lowlevelComposite = EditMountDialog.createInnerComposite(this.contents_, new GridData(4, 0x1000000, true, false, 4, 1), 4);
        final Combo dirMountLowlevelCdType = EditMountDialog.createLabelAndCombo(lowlevelComposite, this.text_.get("dialog.mount.lowlevelcdsupport"), this.settings_.getValues("profile", "lowlevelcd_type"), 10);
        dirMountLowlevelCdType.add("", 0);
        final Combo dirMountUseCd = EditMountDialog.createLabelAndCombo(lowlevelComposite, this.text_.get("dialog.mount.usecd"), new String[]{"", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}, 10);
        final Combo dirMountFreesize = EditMountDialog.createLabelAndEditableCombo(this.contents_, this.text_.get("dialog.mount.freesize"), this.settings_.getValues("profile", "freesize"), 10);
        dirMountFreesize.add("", 0);
        final Label dirMountMbLabel = EditMountDialog.createLabel(this.contents_, 2, 1);
        EditMountDialog.createHorizontalSeparator(this.contents_, 5);
        final Button mountImageButton = EditMountDialog.createRadioButton(this.contents_, this.text_.get("dialog.mount.mountimages"));
        final Text imgMountImage = EditMountDialog.createTextarea(this.contents_, false, false, 3, 1, null);
        BrowseButton imgBrowseButton = new BrowseButton(this.contents_);
        EditMountDialog.createLabel(this.contents_, 1, 2);
        EditMountDialog.createLabel(this.contents_, this.text_.get("dialog.mount.mountdiras"));
        Composite imgComposite = EditMountDialog.createInnerComposite(this.contents_, new GridData(4, 0x1000000, true, false, 3, 1), 3);
        final Combo imgMountType = EditMountDialog.createCombo(imgComposite, this.settings_.getValues("profile", "imgmount_type"), 10);
        imgMountType.setText("iso");
        final Combo imgMountFs = EditMountDialog.createLabelAndCombo(imgComposite, this.text_.get("dialog.mount.imgmountfs"), this.settings_.getValues("profile", "imgmount_fs"), 10);
        imgMountFs.add("", 0);
        final Text imgMountSize = EditMountDialog.createLabelAndText(this.contents_, this.text_.get("dialog.mount.imgmountsize"), 2);
        final Button imgSizeHelperButton = EditMountDialog.createThreeDotButton(this.contents_, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String command = (String)new EditImgSizeDialog(EditMountDialog.this.shell_, imgMountSize.getText()).open();
                if (command != null) {
                    imgMountSize.setText(command);
                }
            }
        });
        imgBrowseButton.connect(this.shell_, imgMountImage, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.CDIMAGE, false, imgMountType);
        EditMountDialog.createHorizontalSeparator(this.contents_, 5);
        final Button mountZipButton = EditMountDialog.createRadioButton(this.contents_, this.text_.get("dialog.mount.mountzip"));
        final Text zipMountZip = EditMountDialog.createLabelAndText(this.contents_, this.text_.get("dialog.mount.zipfile"), 2);
        new BrowseButton(this.contents_).connect(this.shell_, zipMountZip, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.ZIP, false, null);
        EditMountDialog.createLabel(this.contents_, 1, 3);
        final Text zipMountWrite = EditMountDialog.createLabelAndText(this.contents_, this.text_.get("dialog.mount.writedirectory"), 2);
        new BrowseButton(this.contents_).connect(this.shell_, zipMountWrite, null, BrowseButton.BrowseType.DIR, BrowseButton.CanonicalType.DOSROOT, false, null);
        final Combo zipMountType = EditMountDialog.createLabelAndCombo(this.contents_, this.text_.get("dialog.mount.mountzipas"), false, 3, this.settings_.getValues("profile", "zipmount_type"), 10);
        zipMountType.add("", 0);
        final Text zipMountLabel = EditMountDialog.createLabelAndText(this.contents_, this.text_.get("dialog.mount.drivelabel"), 3);
        dirMountType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditMountDialog.this.updateInterfaceElements(imgSizeHelperButton, dirMountUseCd, dirMountFreesize, dirMountMbLabel, dirMountType, dirMountLowlevelCdType, imgMountFs, imgMountSize);
            }
        });
        imgMountFs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditMountDialog.this.updateInterfaceElements(imgSizeHelperButton, dirMountUseCd, dirMountFreesize, dirMountMbLabel, dirMountType, dirMountLowlevelCdType, imgMountFs, imgMountSize);
            }
        });
        SelectionAdapter driveLetterSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean imgFsNone = "none".equalsIgnoreCase(imgMountFs.getText());
                int sel = driveletter.getSelectionIndex();
                if (mountImageButton.getSelection() && imgFsNone) {
                    if (!StringUtils.isNumeric((CharSequence)driveletter.getItem(sel))) {
                        driveletter.setItems(new String[]{"0", "1", "2", "3"});
                        driveletter.setText(driveletter.getItem(Math.min(sel, 3)));
                    }
                } else if (StringUtils.isNumeric((CharSequence)driveletter.getItem(sel))) {
                    driveletter.setItems("ABCDEFGHIJKLMNOPQRSTUVWXY".split("(?!^)"));
                    driveletter.setText(driveletter.getItem(Math.min(sel, 3)));
                }
            }
        };
        imgMountFs.addSelectionListener((SelectionListener)driveLetterSelectionAdapter);
        mountDirButton.addSelectionListener((SelectionListener)driveLetterSelectionAdapter);
        mountImageButton.addSelectionListener((SelectionListener)driveLetterSelectionAdapter);
        mountZipButton.addSelectionListener((SelectionListener)driveLetterSelectionAdapter);
        this.createOkCancelButtons((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!EditMountDialog.this.isValid(mountDirButton, dirMountDir, mountImageButton, imgMountImage, imgMountFs, imgMountSize, mountZipButton, zipMountZip)) {
                    return;
                }
                Mount mount = null;
                if (mountDirButton.getSelection()) {
                    mount = MountFactory.createDirMount(driveletter.getText(), dirMountDir.getText(), dirMountType.getText(), dirMountLabel.getText(), dirMountLowlevelCdType.isEnabled() ? dirMountLowlevelCdType.getText() : null, dirMountFreesize.isEnabled() ? dirMountFreesize.getText() : null, dirMountUseCd.isEnabled() ? dirMountUseCd.getText() : null);
                } else if (mountImageButton.getSelection()) {
                    mount = MountFactory.createImageMount(driveletter.getText(), StringRelatedUtils.textAreaToStringArray(imgMountImage.getText(), imgMountImage.getLineDelimiter()), imgMountType.getText(), imgMountFs.getText(), imgMountSize.isEnabled() ? imgMountSize.getText() : null);
                } else if (mountZipButton.getSelection()) {
                    mount = MountFactory.createPhysFsMount(driveletter.getText(), zipMountZip.getText(), zipMountWrite.getText(), zipMountType.getText(), zipMountLabel.getText());
                }
                if (mount != null) {
                    EditMountDialog.this.result_ = mount.toString();
                }
                EditMountDialog.this.shell_.close();
            }
        });
        ModifyListener modListener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                mountDirButton.setSelection(event.widget == dirMountDir);
                mountImageButton.setSelection(event.widget == imgMountImage);
                mountZipButton.setSelection(event.widget == zipMountZip);
                mountDirButton.notifyListeners(13, null);
            }
        };
        dirMountDir.addModifyListener(modListener);
        imgMountImage.addModifyListener(modListener);
        zipMountZip.addModifyListener(modListener);
        Mount mount = null;
        if (this.mount_ != null) {
            try {
                mount = MountFactory.create(this.mount_);
            }
            catch (InvalidMountstringException invalidMountstringException) {
                // empty catch block
            }
        }
        if (mount == null) {
            mount = MountFactory.createDefaultNewMount(this.driveletter_);
        }
        driveletter.select(mount.getDrive() - 65);
        if (mount instanceof PhysFsMount) {
            PhysFsMount physFsMount = (PhysFsMount)mount;
            mountZipButton.setSelection(true);
            zipMountZip.setText(physFsMount.getPath().getPath());
            if (physFsMount.getWrite() != null) {
                zipMountWrite.setText(physFsMount.getWrite().getPath());
            }
            if (StringUtils.isNotBlank((CharSequence)physFsMount.getMountAs())) {
                zipMountType.setText(physFsMount.getMountAs());
            }
            zipMountLabel.setText(physFsMount.getLabel());
            zipMountZip.selectAll();
            zipMountZip.setFocus();
        } else if (mount instanceof ImageMount) {
            ImageMount imageMount = (ImageMount)mount;
            mountImageButton.setSelection(true);
            if (StringUtils.isNotBlank((CharSequence)imageMount.getMountAs())) {
                imgMountType.setText(imageMount.getMountAs());
            }
            if (imageMount.getFs().equalsIgnoreCase("none")) {
                driveletter.setItems(new String[]{"0", "1", "2", "3"});
            }
            if (StringUtils.isNotBlank((CharSequence)imageMount.getFs())) {
                imgMountFs.setText(imageMount.getFs());
            }
            if (StringUtils.isNotBlank((CharSequence)imageMount.getSize())) {
                imgMountSize.setText(imageMount.getSize());
            }
            imgMountImage.setText(StringRelatedUtils.stringArrayToString(imageMount.getImgPathStrings(), imgMountImage.getLineDelimiter()));
            imgMountImage.selectAll();
            imgMountImage.setFocus();
        } else if (mount instanceof DirMount) {
            DirMount dirMount = (DirMount)mount;
            mountDirButton.setSelection(true);
            dirMountDir.setText(dirMount.getPath().getPath());
            if (StringUtils.isNotBlank((CharSequence)dirMount.getMountAs())) {
                dirMountType.setText(dirMount.getMountAs());
            }
            dirMountLabel.setText(dirMount.getLabel());
            dirMountLowlevelCdType.setText(dirMount.getLowlevelCD());
            dirMountUseCd.setText(dirMount.getUseCD());
            if (StringUtils.isNotBlank((CharSequence)dirMount.getFreesize())) {
                dirMountFreesize.setText(dirMount.getFreesize());
            }
            dirMountDir.selectAll();
            dirMountDir.setFocus();
        }
        driveletter.setText(mount.getDriveAsString());
        this.updateInterfaceElements(imgSizeHelperButton, dirMountUseCd, dirMountFreesize, dirMountMbLabel, dirMountType, dirMountLowlevelCdType, imgMountFs, imgMountSize);
    }

    private void updateInterfaceElements(Button img_size_config, Combo usecd, Combo freesize, Label mbLabel, Combo mount_type, Combo lowlevelcd_type, Combo imgmount_fs, Text imgmount_size) {
        boolean enableLLItems = "cdrom".equalsIgnoreCase(mount_type.getText());
        lowlevelcd_type.setEnabled(enableLLItems);
        usecd.setEnabled(enableLLItems);
        freesize.setEnabled(!enableLLItems);
        String sizeLabel = "floppy".equalsIgnoreCase(mount_type.getText()) ? this.text_.get("dialog.mount.kb") : this.text_.get("dialog.mount.mb");
        mbLabel.setText(sizeLabel);
        mbLabel.pack();
        boolean imgFsNone = "none".equalsIgnoreCase(imgmount_fs.getText());
        imgmount_size.setEnabled(imgFsNone);
        img_size_config.setEnabled(imgFsNone);
    }

    private boolean isValid(Button imgSizeHelperButton, Text dirMountDir, Button mountImageButton, Text imgMountImage, Combo imgMountFs, Text imgMountSize, Button mountZipButton, Text zipMountZip) {
        GeneralPurposeDialogs.initErrorDialog();
        if (imgSizeHelperButton.getSelection() && StringUtils.isBlank((CharSequence)dirMountDir.getText())) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.mount.required.path"), (Control)dirMountDir);
        } else if (mountImageButton.getSelection()) {
            if (StringUtils.isBlank((CharSequence)imgMountImage.getText())) {
                GeneralPurposeDialogs.addError(this.text_.get("dialog.mount.required.image"), (Control)imgMountImage);
            }
            if (imgMountFs.getText().equalsIgnoreCase("none") && StringUtils.isBlank((CharSequence)imgMountSize.getText())) {
                GeneralPurposeDialogs.addError(this.text_.get("dialog.mount.required.imgsize"), (Control)imgMountSize);
            }
        } else if (mountZipButton.getSelection() && StringUtils.isBlank((CharSequence)zipMountZip.getText())) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.mount.required.zip"), (Control)zipMountZip);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell_);
    }
}

