/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.constants.Constants;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.abstractdialog.SizeControlledTabbedDialog;
import org.dbgl.gui.dialog.MainWindow;
import org.dbgl.service.TextService;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SettingsDialog
extends SizeControlledTabbedDialog<Boolean> {
    public static final String[] confLocations = new String[]{TextService.getInstance().get("dialog.settings.confindbgldir"), TextService.getInstance().get("dialog.settings.confingamedir")};
    public static final String[] confFilenames = new String[]{TextService.getInstance().get("dialog.settings.conffilebyid"), TextService.getInstance().get("dialog.settings.conffilebytitle")};
    private static final int EDITABLE_COLUMN = 0;
    private int lastOptionSelection = -1;

    public SettingsDialog(Shell parent) {
        super(parent, "settingsdialog");
        this.result_ = false;
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.settings.title");
    }

    @Override
    protected void onShellCreated() {
        Composite generalComposite = this.createTabWithComposite(this.text_.get("dialog.settings.tab.general"), (Layout)new GridLayout());
        final SortedMap<String, Locale> locales = this.getLocales();
        Locale locale = new Locale(this.settings_.getValue("locale", "language"), this.settings_.getValue("locale", "country"), this.settings_.getValue("locale", "variant"));
        String locString = locales.keySet().stream().filter(key -> ((Locale)locales.get(key)).equals(locale)).findFirst().orElse("");
        Group dosboxGroup = SettingsDialog.createGroup(generalComposite, this.text_.get("dialog.settings.dosbox"), 2);
        final Button console = SettingsDialog.createLabelAndCheckButton((Composite)dosboxGroup, this.text_.get("dialog.settings.hidestatuswindow"), this.settings_.getBooleanValue("dosbox", "hideconsole"));
        Group sendToGroup = SettingsDialog.createGroup(generalComposite, this.text_.get("dialog.settings.sendto"), 2);
        final Button portEnabled = SettingsDialog.createLabelAndCheckButton((Composite)sendToGroup, this.text_.get("dialog.settings.enableport"), this.settings_.getBooleanValue("communication", "port_enabled"));
        final Text port = SettingsDialog.createLabelAndText((Composite)sendToGroup, this.text_.get("dialog.settings.port"), this.settings_.getValue("communication", "port"));
        port.setEnabled(portEnabled.getSelection());
        portEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                port.setEnabled(portEnabled.getSelection());
            }
        });
        Group profileDefGroup = SettingsDialog.createGroup(generalComposite, this.text_.get("dialog.settings.profiledefaults"), 3);
        final Combo confLocation = SettingsDialog.createLabelAndCombo((Composite)profileDefGroup, this.text_.get("dialog.settings.configfile"), confLocations, 10, this.settings_.getIntValue("profiledefaults", "confpath"));
        final Combo confFilename = SettingsDialog.createCombo((Composite)profileDefGroup, confFilenames, 10, this.settings_.getIntValue("profiledefaults", "conffile"));
        Group i18nGroup = SettingsDialog.createGroup(generalComposite, this.text_.get("dialog.settings.i18n"), 2);
        final Combo localeCombo = SettingsDialog.createLabelAndCombo((Composite)i18nGroup, this.text_.get("dialog.settings.languagecountry"), locales.keySet().toArray(new String[0]), 20);
        localeCombo.setText(locString);
        final Composite profileTableComposite = this.createTabWithComposite(this.text_.get("dialog.settings.tab.profiletable"), (Layout)new GridLayout());
        final List<Integer> allColumnIds = this.getColumnIds();
        Group visColumnsGroup = SettingsDialog.createGroup(profileTableComposite, (Object)new GridData(4, 4, true, true), this.text_.get("dialog.settings.visiblecolunms"), (Layout)new FillLayout());
        final Table visibleColumnsTable = new Table((Composite)visColumnsGroup, 67616);
        visibleColumnsTable.setLinesVisible(true);
        TableColumn column1 = new TableColumn(visibleColumnsTable, 0);
        column1.setWidth(350);
        final TableItem[] visibleColumns = new TableItem[MainWindow.columnNames_.length];
        for (int i = 0; i < MainWindow.columnNames_.length; ++i) {
            visibleColumns[i] = new TableItem(visibleColumnsTable, 2048);
            visibleColumns[i].setText(MainWindow.columnNames_[allColumnIds.get(i)]);
            visibleColumns[i].setChecked(this.settings_.getBooleanValue("gui", "column" + (allColumnIds.get(i) + 1) + "visible"));
        }
        final TableEditor editor = new TableEditor(visibleColumnsTable);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        visibleColumnsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem item;
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = (TableItem)event.item) == null) {
                    return;
                }
                int selIdx = item.getParent().getSelectionIndex();
                if (selIdx == -1) {
                    return;
                }
                int idx = (Integer)allColumnIds.get(selIdx);
                if (idx >= 10 && idx < 20 || idx >= 28 && idx < 32) {
                    Text newEditor = SettingsDialog.createText((Composite)visibleColumnsTable, item.getText(0));
                    newEditor.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent mEvent) {
                            Text text = (Text)editor.getEditor();
                            editor.getItem().setText(0, text.getText());
                        }
                    });
                    newEditor.selectAll();
                    newEditor.setFocus();
                    editor.setEditor((Control)newEditor, item, 0);
                }
            }
        });
        Group addProfGroup = SettingsDialog.createGroup(profileTableComposite, (Object)new GridData(4, 4, true, false), this.text_.get("dialog.settings.addeditduplicateprofile"), 2);
        final Button autosort = SettingsDialog.createLabelAndCheckButton((Composite)addProfGroup, this.text_.get("dialog.settings.autosort"), this.settings_.getBooleanValue("gui", "autosortonupdate"));
        Composite dynamicOptionsComposite = this.createTabWithComposite(this.text_.get("dialog.settings.tab.dynamicoptions"), 2);
        SettingsDialog.createLabel(dynamicOptionsComposite, this.text_.get("dialog.settings.options"));
        SettingsDialog.createLabel(dynamicOptionsComposite, this.text_.get("dialog.settings.values"));
        final org.eclipse.swt.widgets.List optionsList = new org.eclipse.swt.widgets.List(dynamicOptionsComposite, 2560);
        optionsList.setLayoutData((Object)new GridData(4, 4, true, true));
        final Text values = SettingsDialog.createTextarea(dynamicOptionsComposite, false);
        final LinkedHashMap<String, String> optionsMap = new LinkedHashMap<String, String>();
        for (String s : this.settings_.getProfileSectionItemNames()) {
            optionsMap.put(s, this.settings_.getMultilineValue("profile", s, values.getLineDelimiter()));
            optionsList.add(s);
        }
        optionsList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SettingsDialog.this.updateOptionsMap(optionsMap, optionsList, SettingsDialog.this.lastOptionSelection, values);
                SettingsDialog.this.lastOptionSelection = optionsList.getSelectionIndex();
                if (SettingsDialog.this.lastOptionSelection != -1) {
                    values.setText((String)optionsMap.get(optionsList.getItem(SettingsDialog.this.lastOptionSelection)));
                }
            }
        });
        final Composite guiComposite = this.createTabWithComposite(this.text_.get("dialog.settings.tab.gui"), 2);
        Font notesFont = SettingsDialog.stringToFont((Device)this.shell_.getDisplay(), this.settings_.getValues("gui", "notesfont"), port.getFont());
        Group screenshots = SettingsDialog.createGroup(guiComposite, (Object)new GridData(4, 4, true, false, 2, 1), this.text_.get("dialog.settings.screenshots"), 3);
        final Scale screenshotsHeight = SettingsDialog.createLabelAndScale((Composite)screenshots, this.text_.get("dialog.settings.height"), false, new GridData(4, 4, true, false), this.settings_.getIntValue("gui", "screenshotsheight"), 50, 750, 25, 100);
        final Label heightValue = SettingsDialog.createLabel((Composite)screenshots, screenshotsHeight.getSelection() + this.text_.get("dialog.settings.px"));
        screenshotsHeight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                heightValue.setText(screenshotsHeight.getSelection() + SettingsDialog.this.text_.get("dialog.settings.px"));
                heightValue.pack();
            }
        });
        final Button displayFilename = SettingsDialog.createLabelAndCheckButton((Composite)screenshots, this.text_.get("dialog.settings.screenshotsfilename"), 2, this.settings_.getBooleanValue("gui", "screenshotsfilename"));
        Group screenshotsColumn = SettingsDialog.createGroup(guiComposite, (Object)new GridData(4, 4, true, false, 2, 1), this.text_.get("dialog.settings.screenshotscolumn"), 3);
        final Scale screenshotsColumnHeight = SettingsDialog.createLabelAndScale((Composite)screenshotsColumn, this.text_.get("dialog.settings.height"), false, new GridData(4, 4, true, false), this.settings_.getIntValue("gui", "screenshotscolumnheight"), 16, 200, 4, 16);
        final Label columnHeightValue = SettingsDialog.createLabel((Composite)screenshotsColumn, screenshotsColumnHeight.getSelection() + this.text_.get("dialog.settings.px"));
        screenshotsColumnHeight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                columnHeightValue.setText(screenshotsColumnHeight.getSelection() + SettingsDialog.this.text_.get("dialog.settings.px"));
                columnHeightValue.pack();
            }
        });
        final Button stretch = SettingsDialog.createLabelAndCheckButton((Composite)screenshotsColumn, this.text_.get("dialog.settings.screenshotscolumnstretch"), 2, this.settings_.getBooleanValue("gui", "screenshotscolumnstretch"));
        final Button keepAspectRatio = SettingsDialog.createLabelAndCheckButton((Composite)screenshotsColumn, this.text_.get("dialog.settings.screenshotscolumnkeepaspectratio"), 2, this.settings_.getBooleanValue("gui", "screenshotscolumnkeepaspectratio"));
        keepAspectRatio.setEnabled(stretch.getSelection());
        stretch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                keepAspectRatio.setEnabled(stretch.getSelection());
            }
        });
        Group buttonsGroup = SettingsDialog.createGroup(guiComposite, (Object)new GridData(4, 0x1000000, true, false), this.text_.get("dialog.settings.buttons"), 2);
        final Combo buttonDisplay = SettingsDialog.createLabelAndCombo((Composite)buttonsGroup, this.text_.get("dialog.settings.display"), new String[]{this.text_.get("dialog.settings.displaybuttonimageandtext"), this.text_.get("dialog.settings.displaybuttontextonly"), this.text_.get("dialog.settings.displaybuttonimageonly")}, 10, this.settings_.getIntValue("gui", "buttondisplay"));
        final Group notesGroup = SettingsDialog.createGroup(guiComposite, (Object)new GridData(4, 0x1000000, true, false), this.text_.get("dialog.profile.notes"), 2);
        final Button fontButton = SettingsDialog.createLabelAndButton((Composite)notesGroup, this.text_.get("dialog.settings.font"), notesFont.getFontData()[0].getName(), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button fontButton = (Button)e.getSource();
                FontDialog fd = new FontDialog(SettingsDialog.this.shell_, 0);
                fd.setFontList(fontButton.getFont().getFontData());
                FontData newFont = fd.open();
                if (newFont != null) {
                    fontButton.setText(newFont.getName());
                    fontButton.setFont(new Font((Device)SettingsDialog.this.shell_.getDisplay(), newFont));
                    notesGroup.setSize(notesGroup.computeSize(-1, -1));
                    guiComposite.layout();
                }
            }
        });
        fontButton.setFont(notesFont);
        Composite enginesComposite = this.createTabWithComposite(this.text_.get("dialog.settings.tab.engines"), (Layout)new FillLayout());
        final int nrOfEngines = Constants.WEBSEARCH_ENGINES.size();
        final Button[] setTitle = new Button[nrOfEngines];
        final Button[] setDev = new Button[nrOfEngines];
        final Button[] setPub = new Button[nrOfEngines];
        final Button[] setYear = new Button[nrOfEngines];
        final Button[] setGenre = new Button[nrOfEngines];
        final Button[] setLink = new Button[nrOfEngines];
        final Button[] setRank = new Button[nrOfEngines];
        final Button[] setDescr = new Button[nrOfEngines];
        final Button[] allRegionsCoverArt = new Button[nrOfEngines];
        final Button[] chooseCoverArt = new Button[nrOfEngines];
        final Button[] chooseScreenshot = new Button[nrOfEngines];
        final Spinner[] maxCoverArt = new Spinner[nrOfEngines];
        final Spinner[] maxScreenshots = new Spinner[nrOfEngines];
        final Text[] platformFilterValues = new Text[nrOfEngines];
        TabFolder enginesTabFolder = new TabFolder(enginesComposite, 0);
        for (int i = 0; i < nrOfEngines; ++i) {
            WebSearchEngine engine = Constants.WEBSEARCH_ENGINES.get(i);
            Composite engineComposite = SettingsDialog.createTabWithComposite(enginesTabFolder, this.text_.get("dialog.settings.tab." + engine.getSimpleName()), (Layout)new FillLayout());
            Group consultGroup = SettingsDialog.createGroup(engineComposite, this.text_.get("dialog.settings.consult", new String[]{engine.getName()}), 2);
            setTitle[i] = SettingsDialog.createLabelAndCheckButton((Composite)consultGroup, this.text_.get("dialog.settings.settitle"), this.settings_.getBooleanValue(engine.getSimpleName(), "set_title"));
            setDev[i] = SettingsDialog.createLabelAndCheckButton((Composite)consultGroup, this.text_.get("dialog.settings.setdeveloper"), this.settings_.getBooleanValue(engine.getSimpleName(), "set_developer"));
            if (engine.getSimpleName().equals("mobygames") || engine.getSimpleName().equals("thegamesdb")) {
                setPub[i] = SettingsDialog.createLabelAndCheckButton((Composite)consultGroup, this.text_.get("dialog.settings.setpublisher"), this.settings_.getBooleanValue(engine.getSimpleName(), "set_publisher"));
            }
            setYear[i] = SettingsDialog.createLabelAndCheckButton((Composite)consultGroup, this.text_.get("dialog.settings.setyear"), this.settings_.getBooleanValue(engine.getSimpleName(), "set_year"));
            setGenre[i] = SettingsDialog.createLabelAndCheckButton((Composite)consultGroup, this.text_.get("dialog.settings.setgenre"), this.settings_.getBooleanValue(engine.getSimpleName(), "set_genre"));
            setLink[i] = SettingsDialog.createLabelAndCheckButton((Composite)consultGroup, this.text_.get("dialog.settings.setlink", new String[]{engine.getName()}), this.settings_.getBooleanValue(engine.getSimpleName(), "set_link"));
            setRank[i] = SettingsDialog.createLabelAndCheckButton((Composite)consultGroup, this.text_.get("dialog.settings.setrank", new Object[]{MainWindow.columnNames_[18]}), this.settings_.getBooleanValue(engine.getSimpleName(), "set_rank"));
            if (engine.getSimpleName().equals("mobygames") || engine.getSimpleName().equals("thegamesdb")) {
                setDescr[i] = SettingsDialog.createLabelAndCheckButton((Composite)consultGroup, this.text_.get("dialog.settings.setdescription"), this.settings_.getBooleanValue(engine.getSimpleName(), "set_description"));
            }
            if (engine.getSimpleName().equals("mobygames") || engine.getSimpleName().equals("thegamesdb")) {
                SettingsDialog.createLabel((Composite)consultGroup, this.text_.get("dialog.settings.choosecoverart"));
                Composite comp = SettingsDialog.createInnerComposite((Composite)consultGroup, null, 3);
                chooseCoverArt[i] = SettingsDialog.createCheckButton(comp, this.settings_.getBooleanValue(engine.getSimpleName(), "choose_coverart"));
                if (engine.getSimpleName().equals("mobygames")) {
                    GridData gd = new GridData();
                    gd.horizontalIndent = 40;
                    SettingsDialog.createLabel(comp, this.text_.get("dialog.settings.allregionscoverart")).setLayoutData((Object)gd);
                    allRegionsCoverArt[i] = SettingsDialog.createCheckButton(comp, this.settings_.getBooleanValue(engine.getSimpleName(), "force_all_regions_coverart"));
                }
            }
            chooseScreenshot[i] = SettingsDialog.createLabelAndCheckButton((Composite)consultGroup, this.text_.get("dialog.settings.choosescreenshot"), this.settings_.getBooleanValue(engine.getSimpleName(), "choose_screenshot"));
            if (engine.getSimpleName().equals("mobygames") || engine.getSimpleName().equals("thegamesdb")) {
                maxCoverArt[i] = SettingsDialog.createLabelAndSpinner((Composite)consultGroup, this.text_.get("dialog.settings.multieditmaxcoverart"), this.settings_.getIntValue(engine.getSimpleName(), "multi_max_coverart"));
            }
            maxScreenshots[i] = SettingsDialog.createLabelAndSpinner((Composite)consultGroup, this.text_.get("dialog.settings.multieditmaxscreenshot"), this.settings_.getIntValue(engine.getSimpleName(), "multi_max_screenshot"));
            SettingsDialog.createLabel((Composite)consultGroup, this.text_.get("dialog.settings.platformfilter"));
            platformFilterValues[i] = engine.getSimpleName().equals("mobygames") || engine.getSimpleName().equals("pouet") ? SettingsDialog.createTextarea((Composite)consultGroup, false, false, 1, 1, this.settings_.getMultilineValue(engine.getSimpleName(), "platform_filter", values.getLineDelimiter())) : SettingsDialog.createText((Composite)consultGroup, 2048, new GridData(4, 4, true, false), this.settings_.getValue(engine.getSimpleName(), "platform_filter"), null);
        }
        Composite envComposite = this.createTabWithComposite(this.text_.get("dialog.settings.tab.environment"), (Layout)new FillLayout());
        Group envGroup = SettingsDialog.createGroup(envComposite, this.text_.get("dialog.settings.environment"), 2);
        final Button enableEnv = SettingsDialog.createLabelAndCheckButton((Composite)envGroup, this.text_.get("dialog.settings.enableenvironment"), this.settings_.getBooleanValue("environment", "use"));
        final Text envValues = SettingsDialog.createLabelAndTextarea((Composite)envGroup, this.text_.get("dialog.settings.environmentvariables"), false, this.settings_.getMultilineValue("environment", "value", values.getLineDelimiter()));
        envValues.setEnabled(enableEnv.getSelection());
        enableEnv.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                envValues.setEnabled(enableEnv.getSelection());
            }
        });
        this.createOkCancelButtons((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int i;
                if (!SettingsDialog.this.isValid(visibleColumnsTable, visibleColumns, SettingsDialog.this.getTabItemByComposite(profileTableComposite))) {
                    return;
                }
                boolean changedVisColumns = this.haveColumnsBeenChanged();
                if (changedVisColumns) {
                    SettingsDialog.this.updateColumnSettings(allColumnIds, visibleColumns);
                }
                SettingsDialog.this.settings_.setBooleanValue("dosbox", "hideconsole", console.getSelection());
                SettingsDialog.this.settings_.setBooleanValue("communication", "port_enabled", portEnabled.getSelection());
                SettingsDialog.this.settings_.setValue("communication", "port", port.getText());
                SettingsDialog.this.settings_.setIntValue("profiledefaults", "confpath", confLocation.getSelectionIndex());
                SettingsDialog.this.settings_.setIntValue("profiledefaults", "conffile", confFilename.getSelectionIndex());
                SettingsDialog.this.settings_.setValue("locale", "language", ((Locale)locales.get(localeCombo.getText())).getLanguage());
                SettingsDialog.this.settings_.setValue("locale", "country", ((Locale)locales.get(localeCombo.getText())).getCountry());
                SettingsDialog.this.settings_.setValue("locale", "variant", ((Locale)locales.get(localeCombo.getText())).getVariant());
                for (i = 0; i < MainWindow.columnNames_.length; ++i) {
                    SettingsDialog.this.settings_.setBooleanValue("gui", "column" + (i + 1) + "visible", visibleColumns[allColumnIds.indexOf(i)].getChecked());
                }
                SettingsDialog.this.settings_.setBooleanValue("gui", "autosortonupdate", autosort.getSelection());
                for (i = 0; i < 10; ++i) {
                    SettingsDialog.this.settings_.setValue("gui", "custom" + (i + 1), visibleColumns[allColumnIds.indexOf(i + 10)].getText());
                }
                for (i = 0; i < 4; ++i) {
                    SettingsDialog.this.settings_.setValue("gui", "custom" + (i + 10 + 1), visibleColumns[allColumnIds.indexOf(i + 10 + 10 + 8)].getText());
                }
                SettingsDialog.this.settings_.setIntValue("gui", "screenshotsheight", screenshotsHeight.getSelection());
                SettingsDialog.this.settings_.setBooleanValue("gui", "screenshotsfilename", displayFilename.getSelection());
                SettingsDialog.this.settings_.setIntValue("gui", "screenshotscolumnheight", screenshotsColumnHeight.getSelection());
                SettingsDialog.this.settings_.setBooleanValue("gui", "screenshotscolumnstretch", stretch.getSelection());
                SettingsDialog.this.settings_.setBooleanValue("gui", "screenshotscolumnkeepaspectratio", keepAspectRatio.getSelection());
                Rectangle rec = SettingsDialog.this.shell_.getBounds();
                SettingsDialog.this.settings_.setIntValue("gui", "settingsdialog_width", rec.width);
                SettingsDialog.this.settings_.setIntValue("gui", "settingsdialog_height", rec.height);
                SettingsDialog.this.settings_.setIntValue("gui", "buttondisplay", buttonDisplay.getSelectionIndex());
                SettingsDialog.this.settings_.setMultilineValue("gui", "notesfont", SettingsDialog.fontToString((Device)SettingsDialog.this.shell_.getDisplay(), fontButton.getFont()), "|");
                for (int i2 = 0; i2 < nrOfEngines; ++i2) {
                    WebSearchEngine engine = Constants.WEBSEARCH_ENGINES.get(i2);
                    SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "set_title", setTitle[i2].getSelection());
                    SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "set_developer", setDev[i2].getSelection());
                    if (engine.getSimpleName().equals("mobygames") || engine.getSimpleName().equals("thegamesdb")) {
                        SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "set_publisher", setPub[i2].getSelection());
                        SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "set_description", setDescr[i2].getSelection());
                    }
                    SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "set_year", setYear[i2].getSelection());
                    SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "set_genre", setGenre[i2].getSelection());
                    SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "set_link", setLink[i2].getSelection());
                    SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "set_rank", setRank[i2].getSelection());
                    if (engine.getSimpleName().equals("mobygames")) {
                        SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "force_all_regions_coverart", allRegionsCoverArt[i2].getSelection());
                    }
                    if (engine.getSimpleName().equals("mobygames") || engine.getSimpleName().equals("thegamesdb")) {
                        SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "choose_coverart", chooseCoverArt[i2].getSelection());
                        SettingsDialog.this.settings_.setIntValue(engine.getSimpleName(), "multi_max_coverart", maxCoverArt[i2].getSelection());
                    }
                    if (engine.getSimpleName().equals("mobygames") || engine.getSimpleName().equals("pouet") || engine.getSimpleName().equals("thegamesdb")) {
                        SettingsDialog.this.settings_.setBooleanValue(engine.getSimpleName(), "choose_screenshot", chooseScreenshot[i2].getSelection());
                        SettingsDialog.this.settings_.setIntValue(engine.getSimpleName(), "multi_max_screenshot", maxScreenshots[i2].getSelection());
                    }
                    if (engine.getSimpleName().equals("mobygames") || engine.getSimpleName().equals("pouet")) {
                        SettingsDialog.this.settings_.setMultilineValue(engine.getSimpleName(), "platform_filter", platformFilterValues[i2].getText(), platformFilterValues[i2].getLineDelimiter());
                        continue;
                    }
                    SettingsDialog.this.settings_.setValue(engine.getSimpleName(), "platform_filter", platformFilterValues[i2].getText());
                }
                SettingsDialog.this.settings_.setBooleanValue("environment", "use", enableEnv.getSelection());
                SettingsDialog.this.settings_.setMultilineValue("environment", "value", envValues.getText(), envValues.getLineDelimiter());
                SettingsDialog.this.updateOptionsMap(optionsMap, optionsList, SettingsDialog.this.lastOptionSelection, values);
                for (Map.Entry entry : optionsMap.entrySet()) {
                    SettingsDialog.this.settings_.setMultilineValue("profile", (String)entry.getKey(), (String)entry.getValue(), values.getLineDelimiter());
                }
                SettingsDialog.this.result_ = changedVisColumns;
                SettingsDialog.this.shell_.close();
            }

            private boolean haveColumnsBeenChanged() {
                for (int i = 0; i < MainWindow.columnNames_.length; ++i) {
                    if (SettingsDialog.this.settings_.getBooleanValue("gui", "column" + ((Integer)allColumnIds.get(i) + 1) + "visible") == visibleColumns[i].getChecked() && MainWindow.columnNames_[(Integer)allColumnIds.get(i)].equals(visibleColumns[i].getText())) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private void updateOptionsMap(Map<String, String> optionsMap, org.eclipse.swt.widgets.List options, int lastOptionSelection, Text values) {
        if (lastOptionSelection != -1) {
            optionsMap.put(options.getItem(lastOptionSelection), values.getText());
        }
    }

    private void updateColumnSettings(List<Integer> allColumnIds, TableItem[] visibleColumns) {
        OptionalInt firstVisibleColumn;
        int[] sort = this.settings_.getIntValues("gui", "sortcolumn");
        boolean[] ascs = this.settings_.getBooleanValues("gui", "sortascending");
        ArrayList<Integer> sortColumnIDs = new ArrayList<Integer>(sort.length);
        ArrayList<Boolean> sortColumnAscs = new ArrayList<Boolean>(sort.length);
        for (int i2 = 0; i2 < sort.length; ++i2) {
            if (!visibleColumns[allColumnIds.indexOf(sort[i2])].getChecked()) continue;
            sortColumnIDs.add(sort[i2]);
            sortColumnAscs.add(ascs[i2]);
        }
        if (sortColumnIDs.isEmpty() && (firstVisibleColumn = IntStream.range(0, visibleColumns.length).filter(i -> visibleColumns[i].getChecked()).findFirst()).isPresent()) {
            sortColumnIDs.add(allColumnIds.get(firstVisibleColumn.getAsInt()));
            sortColumnAscs.add(true);
        }
        this.settings_.setIntValues("gui", "sortcolumn", ArrayUtils.toPrimitive((Integer[])sortColumnIDs.toArray(new Integer[0])));
        this.settings_.setBooleanValues("gui", "sortascending", ArrayUtils.toPrimitive((Boolean[])sortColumnAscs.toArray(new Boolean[0])));
        ArrayList<Integer> visColumns = new ArrayList<Integer>();
        for (int i3 = 0; i3 < MainWindow.columnNames_.length; ++i3) {
            if (!visibleColumns[i3].getChecked()) continue;
            visColumns.add(allColumnIds.get(i3));
        }
        ArrayList orderedVisColumns = new ArrayList(visColumns);
        Collections.sort(orderedVisColumns);
        ArrayList<Integer> colOrder = new ArrayList<Integer>();
        Iterator iterator = visColumns.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            colOrder.add(orderedVisColumns.indexOf(id));
        }
        this.settings_.setValue("gui", "columnorder", StringUtils.join(colOrder, (char)' '));
    }

    private SortedMap<String, Locale> getLocales() {
        ArrayList<String> supportedLanguages = new ArrayList<String>(Constants.SUPPORTED_LANGUAGES);
        File[] files = new File("./plugins/i18n").listFiles();
        if (files != null) {
            for (File file : files) {
                String code;
                String name = file.getName();
                if (!name.startsWith("MessagesBundle_") || !name.endsWith(".properties") || (code = name.substring("MessagesBundle_".length(), name.indexOf(".properties"))).length() <= 0) continue;
                supportedLanguages.add(code);
            }
        }
        TreeMap<String, Locale> allLocales = new TreeMap<String, Locale>();
        for (Locale loc : Locale.getAvailableLocales()) {
            allLocales.put(loc.toString(), loc);
        }
        TreeMap<String, Locale> locales = new TreeMap<String, Locale>();
        for (String lang : supportedLanguages) {
            Locale loc;
            loc = (Locale)allLocales.get(lang);
            String variant = null;
            if (loc == null && StringUtils.countMatches((CharSequence)lang, (CharSequence)"_") == 2) {
                String langWithoutVariant = StringUtils.removeEnd((String)StringUtils.substringBeforeLast((String)lang, (String)"_"), (String)"_");
                variant = StringUtils.substringAfterLast((String)lang, (String)"_");
                loc = (Locale)allLocales.get(langWithoutVariant);
            }
            if (loc == null) continue;
            StringBuffer s = new StringBuffer(loc.getDisplayLanguage());
            s.append(" [").append(loc.getDisplayLanguage(loc)).append("]");
            if (loc.getCountry().length() > 0) {
                s.append(" - ").append(loc.getDisplayCountry()).append(" [").append(loc.getDisplayCountry(loc)).append("]");
            }
            if (variant != null) {
                s.append(" (").append(variant).append(')');
                loc = new Locale(loc.getLanguage(), loc.getCountry(), variant);
            }
            locales.put(s.toString(), loc);
        }
        return locales;
    }

    private List<Integer> getColumnIds() {
        int[] columnOrder;
        ArrayList<Integer> visibleColumnIds = new ArrayList<Integer>();
        for (int i = 0; i < MainWindow.columnNames_.length; ++i) {
            if (!this.settings_.getBooleanValue("gui", "column" + (i + 1) + "visible")) continue;
            visibleColumnIds.add(i);
        }
        ArrayList orderedVisibleColumnIds = new ArrayList();
        for (int element : columnOrder = this.settings_.getIntValues("gui", "columnorder")) {
            orderedVisibleColumnIds.add(visibleColumnIds.get(element));
        }
        ArrayList<Integer> remainingColumnIDs = new ArrayList<Integer>();
        for (int i = 0; i < MainWindow.columnNames_.length; ++i) {
            if (orderedVisibleColumnIds.contains(i)) continue;
            remainingColumnIDs.add(i);
        }
        ArrayList<Integer> allColumnIds = new ArrayList<Integer>(orderedVisibleColumnIds);
        allColumnIds.addAll(remainingColumnIDs);
        return allColumnIds;
    }

    private boolean isValid(Table visibleColumnsTable, TableItem[] visibleColumns, TabItem columnsTabItem) {
        GeneralPurposeDialogs.initErrorDialog();
        if (Stream.of(visibleColumns).noneMatch(x -> x.getChecked())) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.settings.required.onevisiblecolumn"), (Control)visibleColumnsTable, columnsTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell_);
    }
}

