/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import java.util.stream.Stream;
import org.dbgl.gui.abstractdialog.BaseDialog;
import org.dbgl.service.ImageService;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class Thumb
extends BaseDialog<Object> {
    private static final int DIALOG_WIDTH_EXT = 24;
    private static final int DIALOG_HEIGHT_EXT = 50;
    private String filename_;
    private Image thumbImage_;

    public Thumb(Shell parent, String filename) {
        super(parent, 67680);
        this.filename_ = filename;
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.screenshot.title", new Object[]{this.filename_});
    }

    @Override
    protected boolean prepare() {
        Image orgThumb = ImageService.getImage(this.display_, this.filename_);
        ImageData bigThumb = orgThumb.getImageData();
        int width = bigThumb.width;
        int height = bigThumb.height;
        Monitor monitor = this.getActiveMonitor();
        double factor = Math.min((double)monitor.getClientArea().width / (double)(width + 48), (double)monitor.getClientArea().height / (double)(height + 100));
        this.thumbImage_ = new Image((Device)this.display_, bigThumb.scaledTo((int)((double)width * factor), (int)((double)height * factor)));
        orgThumb.dispose();
        return true;
    }

    @Override
    protected void onShellCreated() {
        if (this.thumbImage_ != null) {
            this.shell_.setSize(this.thumbImage_.getImageData().width + 24, this.thumbImage_.getImageData().height + 50);
            this.shell_.setLayout((Layout)new FillLayout());
            Rectangle bounds = this.getActiveMonitor().getBounds();
            Rectangle rect = this.shell_.getBounds();
            this.shell_.setLocation(bounds.x + (bounds.width - rect.width) / 2, bounds.y + (bounds.height - rect.height) / 2);
            Thumb.createImageButton((Composite)this.shell_, 0x800000, this.thumbImage_, (SelectionListener)this.closeShellAdapter);
        }
    }

    @Override
    protected void onClose() {
        if (this.thumbImage_ != null && !this.thumbImage_.isDisposed()) {
            this.thumbImage_.dispose();
        }
    }

    private Monitor getActiveMonitor() {
        return Stream.of(this.display_.getMonitors()).filter(x -> x.getBounds().intersects(this.getParent().getBounds())).findFirst().orElse(this.display_.getPrimaryMonitor());
    }
}

