/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog.wizard;

import java.sql.SQLException;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.abstractdialog.JobWizardDialog;
import org.dbgl.gui.controls.BrowseButton;
import org.dbgl.gui.thread.MigrateThread;
import org.dbgl.model.FileLocation;
import org.dbgl.model.ICanonicalize;
import org.dbgl.service.FileLocationService;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MigrateDialog
extends JobWizardDialog<String> {
    private Text from_;
    private ICanonicalize canonicalizer_;

    public MigrateDialog(Shell parent) {
        super(parent, "migratedialog");
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.migration.title");
    }

    @Override
    protected void onShellCreated() {
        Group optionsGroup = MigrateDialog.createGroup((Composite)this.shell_, this.text_.get("dialog.migration.options"), 3);
        this.from_ = MigrateDialog.createLabelAndText((Composite)optionsGroup, this.text_.get("dialog.migration.from"));
        this.canonicalizer_ = new BrowseButton((Composite)optionsGroup).connect(this.shell_, this.from_, null, BrowseButton.BrowseType.DIR, BrowseButton.CanonicalType.NONE, false, null);
        MigrateDialog.createLabelAndText((Composite)optionsGroup, this.text_.get("dialog.migration.to"), 2, FileLocationService.getInstance().getDosroot().getPath()).setEditable(false);
        this.addStep(optionsGroup);
        this.addFinalStep(this.text_.get("dialog.migration.progress"), this.text_.get("dialog.migration.startmigration"));
    }

    @Override
    protected boolean onNext(int step) {
        if (step == 0) {
            if (!this.isValid()) {
                return false;
            }
        } else if (step == 1) {
            try {
                this.job_ = new MigrateThread(this.log_, this.progressBar_, this.status_, new FileLocation(this.from_.getText(), this.canonicalizer_));
            }
            catch (SQLException e) {
                GeneralPurposeDialogs.warningMessage(this.shell_, e);
                return false;
            }
        } else if (step == 2) {
            if (this.job_.isEverythingOk()) {
                GeneralPurposeDialogs.infoMessage(this.shell_, this.text_.get("dialog.migration.notice.migrationok"));
            } else {
                GeneralPurposeDialogs.warningMessage(this.shell_, this.text_.get("dialog.migration.error.problem"));
            }
            this.status_.setText(this.text_.get("dialog.migration.reviewlog"));
            this.status_.pack();
            this.result_ = this.from_.getText();
        }
        return true;
    }

    private boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (this.from_.getText().equals("")) {
            GeneralPurposeDialogs.addError(this.text_.get("dialog.migration.required.from"), (Control)this.from_);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(this.shell_);
    }
}

