/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog.wizard;

import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.abstractdialog.JobWizardDialog;
import org.dbgl.gui.controls.DaControl;
import org.dbgl.gui.controls.MetaControl;
import org.dbgl.gui.thread.SearchEngineThread;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.repository.ProfileRepository;
import org.dbgl.util.SystemUtils;
import org.dbgl.util.searchengine.WebSearchEngine;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class UpdateMultiProfileDialog
extends JobWizardDialog<Boolean> {
    private final List<Profile> orgProfs_;
    private final List<Profile> profs_;
    private final boolean dbversionChanged_;
    private final boolean templateReloaded_;
    private final List<DaControl> daControls_;
    private final List<MetaControl> autoexecControls_;
    private final List<MetaControl> metaControls_;
    private final WebSearchEngine engine_;

    public UpdateMultiProfileDialog(Shell parent, List<Profile> orgProfs, List<Profile> profs, boolean dbversionChanged, boolean templateReloaded, List<DaControl> daControls, List<MetaControl> autoexecControls, List<MetaControl> metaControls, WebSearchEngine engine) {
        super(parent, "multiprofiledialog");
        this.orgProfs_ = orgProfs;
        this.profs_ = profs;
        this.dbversionChanged_ = dbversionChanged;
        this.templateReloaded_ = templateReloaded;
        this.daControls_ = daControls.stream().filter(x -> x.hasChangedValue()).collect(Collectors.toList());
        this.autoexecControls_ = autoexecControls.stream().filter(x -> x.hasChangedValue()).collect(Collectors.toList());
        this.metaControls_ = metaControls.stream().filter(x -> x.hasChangedValue()).collect(Collectors.toList());
        this.engine_ = engine;
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.multiprofile.title.edit", new Object[]{this.profs_.size()});
    }

    @Override
    protected void onShellCreated() {
        StringBuffer info = new StringBuffer();
        if (this.dbversionChanged_) {
            long count = IntStream.range(0, this.profs_.size()).filter(x -> this.profs_.get(x).getDosboxVersion().getId() != this.orgProfs_.get(x).getDosboxVersion().getId()).count();
            info.append(this.text_.get("dialog.multiprofile.dosboxversionchanged", new Object[]{this.profs_.get(0).getDosboxVersion().getTitle(), count})).append(SystemUtils.EOLN);
        }
        if (this.templateReloaded_) {
            info.append(this.text_.get("dialog.multiprofile.templateloaded")).append(SystemUtils.EOLN);
        }
        String conflicting = this.text_.get("dialog.multiprofile.conflictingvalues");
        this.metaControls_.forEach(x -> info.append(x.getLabelText()).append(": ").append(x.getOriginalValue() == null ? conflicting : '\"' + x.getOriginalValue() + '\"').append(" -> ").append('\"' + x.getCurrentValue() + '\"').append(SystemUtils.EOLN));
        this.daControls_.forEach(x -> info.append(x.getLabelText()).append(" (").append(x.getConfLabel()).append("): ").append(x.getOriginalValue() == null ? conflicting : '\"' + x.getOriginalValue() + '\"').append(" -> ").append('\"' + x.getCurrentValue() + '\"').append(SystemUtils.EOLN));
        this.autoexecControls_.forEach(x -> info.append(x.getLabelText()).append(": ").append(x.getOriginalValue() == null ? conflicting : '\"' + x.getOriginalValue() + '\"').append(" -> ").append('\"' + x.getCurrentValue() + '\"').append(SystemUtils.EOLN));
        Group infoGroup = UpdateMultiProfileDialog.createGroup((Composite)this.shell_, this.text_.get("dialog.multiprofile.reviewchanges"), (Layout)new GridLayout());
        UpdateMultiProfileDialog.createTextarea((Composite)infoGroup, true, false, 1, 1, info.toString());
        this.addStep(infoGroup);
        this.addFinalStep(this.text_.get("dialog.dfendimport.progress"), this.text_.get("dialog.multiprofile.applychanges"));
        this.progressBar_.setMaximum(this.profs_.size());
    }

    @Override
    protected boolean onNext(int step) {
        if (step == 1) {
            for (Profile prof : this.profs_) {
                this.metaControls_.forEach(x -> x.updateProfileByControl(prof));
                this.daControls_.forEach(x -> x.updateConfigurationByControl(prof));
                this.autoexecControls_.forEach(x -> x.updateAutoexecByControl(prof.getConfiguration().getAutoexec()));
                try {
                    new ProfileRepository().update(prof);
                }
                catch (SQLException e) {
                    this.log_.append(e.toString());
                    e.printStackTrace();
                }
                this.progressBar_.setSelection(this.progressBar_.getSelection() + 1);
            }
            this.progressBar_.setSelection(0);
            this.job_ = new SearchEngineThread(this.profs_, this.engine_, this.log_, this.progressBar_, this.status_);
        } else if (step == 2) {
            if (!this.job_.isEverythingOk()) {
                GeneralPurposeDialogs.warningMessage(this.shell_, this.text_.get("dialog.multiprofile.error.problem"));
            }
            this.status_.setText(this.text_.get("dialog.multiprofile.reviewlog"));
            this.status_.pack();
            this.result_ = true;
        }
        return true;
    }
}

