/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.listeners;

import org.dbgl.model.ThumbInfo;
import org.dbgl.service.ImageService;
import org.dbgl.service.SettingsService;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class PaintListener
implements Listener {
    private static final SettingsService settings_ = SettingsService.getInstance();

    public void handleEvent(Event event) {
        if (event.widget instanceof Gallery) {
            GalleryItem galleryItem = (GalleryItem)event.item;
            ThumbInfo thumbInfo = (ThumbInfo)galleryItem.getData();
            String filename = thumbInfo.getMainThumb();
            if (thumbInfo.isUpdated()) {
                if (filename == null) {
                    galleryItem.setImage(null);
                } else {
                    Rectangle rect = galleryItem.getBounds();
                    galleryItem.setImage(ImageService.getCachedResizedImage(event.display, rect.width - 4, rect.height - 22, settings_.getBooleanValue("gui", "screenshotscolumnkeepaspectratio"), filename));
                }
                galleryItem.setData((Object)thumbInfo);
            }
        } else if (event.widget instanceof Table) {
            Table table = (Table)event.widget;
            Widget item = event.item;
            Integer sc = (Integer)table.getData();
            if (event.index == sc) {
                ThumbInfo thumbInfo = (ThumbInfo)item.getData();
                String filename = thumbInfo.getMainThumb();
                if (filename != null) {
                    int columnWidth = table.getColumn(sc.intValue()).getWidth();
                    int columnHeight = settings_.getIntValue("gui", "screenshotscolumnheight");
                    Image image = settings_.getBooleanValue("gui", "screenshotscolumnstretch") ? ImageService.getCachedResizedImage(event.display, columnWidth, columnHeight, settings_.getBooleanValue("gui", "screenshotscolumnkeepaspectratio"), filename) : ImageService.getCachedHeightLimitedImage(event.display, columnHeight, filename, null);
                    int offsetX = Math.max(0, (columnWidth - image.getBounds().width - 2) / 2);
                    int offsetY = Math.max(0, (columnHeight - image.getBounds().height - 2) / 2);
                    event.gc.drawImage(image, event.x + offsetX, event.y + offsetY);
                }
                if (thumbInfo.isUpdated()) {
                    item.setData((Object)thumbInfo);
                }
            }
        }
    }
}

