/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.thread;

import java.io.IOException;
import java.sql.SQLException;
import org.dbgl.gui.thread.UIThread;
import org.dbgl.model.FileLocation;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.repository.DosboxVersionRepository;
import org.dbgl.model.repository.ProfileRepository;
import org.dbgl.service.FileLocationService;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public class MigrateThread
extends UIThread<Profile> {
    private final FileLocation from_;

    public MigrateThread(Text log, ProgressBar progressBar, Label status, FileLocation from) throws SQLException {
        super(log, progressBar, status, false);
        this.from_ = from;
        this.setObjects(new ProfileRepository().list(" ORDER BY LOWER(GAM.TITLE)", null, new DosboxVersionRepository().listAll()));
    }

    @Override
    public String work(Profile profile) throws IOException, SQLException {
        this.displayTitle(text_.get("dialog.migration.migrating", new Object[]{this.getTitle(profile)}));
        String warnings = profile.resetAndLoadConfiguration();
        profile.migrate(this.from_, FileLocationService.getInstance().getDosrootLocation());
        new ProfileRepository().update(profile);
        return warnings;
    }

    @Override
    public String getTitle(Profile profile) {
        return profile.getTitle();
    }

    @Override
    public void preFinish() {
    }
}

