/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.model.conf.dfend;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.model.FileLocation;
import org.dbgl.model.conf.Configuration;
import org.dbgl.model.conf.Settings;
import org.dbgl.model.conf.dfend.DFendProfile;
import org.dbgl.service.ITextService;
import org.dbgl.service.TextService;
import org.dbgl.util.FilesUtils;

public class DFendConfiguration {
    private Settings datConfiguration_ = new Settings();
    private Map<String, DFendProfile> profiles_;

    public DFendConfiguration(File file) {
        this.datConfiguration_.setFileLocation(new FileLocation(file.getPath()));
        this.profiles_ = new LinkedHashMap<String, DFendProfile>();
    }

    public String loadDat() throws IOException {
        StringBuffer warningsLog = new StringBuffer();
        warningsLog.append(this.datConfiguration_.load(TextService.getInstance()));
        for (String title : this.getSectionNames()) {
            File alternative;
            String profFile = this.datConfiguration_.getValue(title, "prof");
            String confFile = this.datConfiguration_.getValue(title, "conf");
            Configuration prof = new Configuration();
            prof.setFileLocation(new FileLocation(profFile));
            Configuration conf = new Configuration();
            conf.setFileLocation(new FileLocation(confFile));
            File confsDir = new File(this.datConfiguration_.getCanonicalFile().getParent(), "Confs");
            if (!FilesUtils.isExistingFile(prof.getCanonicalFile()) && FilesUtils.isExistingFile(alternative = new File(confsDir, prof.getFile().getName()))) {
                prof.setFileLocation(new FileLocation(alternative.getPath()));
            }
            if (!FilesUtils.isExistingFile(conf.getCanonicalFile()) && FilesUtils.isExistingFile(alternative = new File(confsDir, conf.getFile().getName()))) {
                conf.setFileLocation(new FileLocation(alternative.getPath()));
            }
            this.profiles_.put(title, new DFendProfile(prof, conf));
        }
        return warningsLog.toString();
    }

    public String loadProfile(String title) throws IOException {
        ITextService text = TextService.getInstance();
        StringBuffer warningsLog = new StringBuffer();
        warningsLog.append(this.profiles_.get(title).getProf().load(text));
        warningsLog.append(this.profiles_.get(title).load(text));
        return warningsLog.toString();
    }

    public String[] getSectionNames() {
        return this.datConfiguration_.getSectionNames();
    }

    public String getValue(String sectionTitle, String sectionItem) {
        return this.datConfiguration_.getValue(sectionTitle, sectionItem);
    }

    public String getValue(String profileTitle, String sectionTitle, String sectionItem) {
        return StringUtils.defaultString((String)this.profiles_.get(profileTitle).getProf().getValue(sectionTitle, sectionItem));
    }

    public File getConfFile(String profileTitle) {
        return this.profiles_.get(profileTitle).getConf().getFile();
    }

    public File getConfCanonicalFile(String profileTitle) {
        return this.profiles_.get(profileTitle).getConf().getCanonicalFile();
    }

    public String getConf(String profileTitle) {
        return this.profiles_.get(profileTitle).getConf().toString(null);
    }
}

