/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.abstractdialog;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.dbgl.exception.DrivelettersExhaustedException;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.abstractdialog.SizeControlledTabbedDialog;
import org.dbgl.gui.controls.BrowseButton;
import org.dbgl.gui.controls.DaControl;
import org.dbgl.gui.controls.DaControlConvertorAdapter;
import org.dbgl.gui.controls.MetaControl;
import org.dbgl.gui.dialog.EditMixerDialog;
import org.dbgl.gui.dialog.EditMountDialog;
import org.dbgl.gui.dialog.EditNativeCommandDialog;
import org.dbgl.gui.interfaces.DaControlConvertor;
import org.dbgl.model.NativeCommand;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.conf.Autoexec;
import org.dbgl.model.conf.Configuration;
import org.dbgl.model.conf.GenerationAwareConfiguration;
import org.dbgl.model.entity.TemplateProfileBase;
import org.dbgl.model.helper.DriveLetterHelper;
import org.dbgl.model.repository.DosboxVersionRepository;
import org.dbgl.service.FileLocationService;
import org.eclipse.swt.events.ExpandAdapter;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;

public abstract class EditConfigurableDialog<T>
extends SizeControlledTabbedDialog<T> {
    protected final List<DaControl> daControls_ = new ArrayList<DaControl>();
    protected final List<MetaControl> metaControls_ = new ArrayList<MetaControl>();
    protected final List<MetaControl> autoexecControls_ = new ArrayList<MetaControl>();
    protected List<DosboxVersion> dbversionsList_;
    protected int dbversionIndex_;
    protected Combo dbversionCombo_;
    protected Button setButton_;
    protected ExpandItem booterExpandItem_;
    protected ExpandItem dosExpandItem_;
    protected org.eclipse.swt.widgets.List mountingpointsList_;
    private Button switchButton_;
    private Button ipx_;
    private Text ipxNet_;
    private Combo output_;
    private Combo scaler_;
    private Combo machine_;
    private Combo cpuType_;
    private Combo midiDevice_;
    private Combo sbType_;
    private Combo oplMode_;
    private org.eclipse.swt.widgets.List nativeCommandsList_;

    public EditConfigurableDialog(Shell parent, String dialogName) {
        super(parent, dialogName);
    }

    protected abstract void doPerformDosboxConfAction(DosboxConfAction var1, DosboxVersion var2);

    @Override
    protected boolean prepare() {
        try {
            this.dbversionsList_ = new DosboxVersionRepository().listAll();
            this.dbversionIndex_ = DosboxVersionRepository.indexOfDefault(this.dbversionsList_);
            return true;
        }
        catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e);
            return false;
        }
    }

    protected void updateControlsByConfigurable(TemplateProfileBase configurable, boolean multiEdit) {
        Object[] machineValues;
        GenerationAwareConfiguration overrideConf = configurable.getConfiguration();
        Autoexec overrideAuto = overrideConf.getAutoexec();
        Configuration combinedConf = configurable.getCombinedConfiguration();
        Autoexec combinedAuto = combinedConf.getAutoexec();
        DosboxVersion dosbox = configurable.getDosboxVersion();
        GenerationAwareConfiguration dosboxConf = dosbox.getConfiguration();
        this.daControls_.forEach(x -> x.enableOrDisable(dosbox));
        Object[] objectArray = machineValues = dosbox.isUsingNewMachineConfig() ? this.settings_.getValues("profile", "machine073") : this.settings_.getValues("profile", "machine");
        if (!Arrays.equals(this.machine_.getItems(), machineValues)) {
            this.machine_.setItems((String[])machineValues);
        }
        this.updateComboItems(this.output_, dosbox.likelyDirect3DSupport(), new String[]{"openglhq", "direct3d"});
        this.updateComboItems(this.scaler_, dosbox.likelyHardwareScalerSupport(), new String[]{"hardware2x", "hardware3x"});
        this.updateComboItems(this.machine_, dosbox.likelyAmstradSupport(), new String[]{"cga_mono", "svga_s3_full", "amstrad"});
        this.updateComboItems(this.cpuType_, dosbox.likelyAdditionalCPUTypesSupport(), new String[]{"486", "pentium", "pentium_mmx"});
        this.updateComboItems(this.midiDevice_, dosbox.hasMT32Support(), new String[]{"mt32", "synth", "timidity"});
        this.updateComboItems(this.sbType_, dosbox.likelySoundBlaster16VibraSupport(), new String[]{"sb16vibra"});
        this.updateComboItems(this.oplMode_, dosbox.hasHardwareOPLSupport(), new String[]{"hardware", "hardwaregb"});
        this.daControls_.forEach(x -> x.setControlByConf(dosboxConf, overrideConf, combinedConf, multiEdit));
        DaControl.setFieldIfEnabled(this.mountingpointsList_, configurable.getMountStringsForUI());
        DaControl.setFieldIfEnabled(this.dosExpandItem_, !combinedAuto.isBooter());
        DaControl.setFieldIfEnabled(this.booterExpandItem_, combinedAuto.isBooter());
        this.autoexecControls_.forEach(x -> x.setControlByAutoexec(overrideAuto, combinedAuto, multiEdit));
        this.setButton_.setEnabled(false);
        this.switchButton_.setEnabled(false);
        this.ipxNet_.setEnabled(this.ipx_.getSelection());
        this.updateNativeCommands(-1, configurable);
    }

    protected void updateConfigurableByControls(TemplateProfileBase configurable) {
        this.daControls_.forEach(x -> x.updateConfigurationByControl(configurable));
        this.autoexecControls_.forEach(x -> x.updateAutoexecByControl(configurable.getConfiguration().getAutoexec()));
        configurable.setBooter(this.booterExpandItem_.getExpanded());
    }

    protected void updateComboItems(Combo combo, boolean available, String[] items) {
        ArrayList<String> comboItems = new ArrayList<String>(Arrays.asList(combo.getItems()));
        boolean changes = false;
        if (available) {
            for (String s : items) {
                if (comboItems.contains(s)) continue;
                comboItems.add(s);
                changes = true;
            }
        } else {
            for (String s : items) {
                if (!comboItems.contains(s)) continue;
                comboItems.remove(s);
                changes = true;
            }
        }
        if (changes) {
            combo.setItems(comboItems.toArray(new String[comboItems.size()]));
        }
    }

    protected Group createGeneralTab(String capturesText, String configFileText) {
        Composite composite = this.createTabWithComposite(this.text_.get("dialog.template.tab.general"), (Layout)new GridLayout());
        Group associationGroup = EditConfigurableDialog.createGroup(composite, this.text_.get("dialog.template.association"), 5);
        associationGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dbversionCombo_ = EditConfigurableDialog.createLabelAndWideCombo((Composite)associationGroup, this.text_.get("dialog.template.dosboxversion"));
        this.dbversionCombo_.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dbversionsList_.forEach(x -> this.dbversionCombo_.add(x.getTitle()));
        this.dbversionCombo_.select(this.dbversionIndex_);
        this.setButton_ = EditConfigurableDialog.createButton((Composite)associationGroup, null, this.text_.get("dialog.template.set"), this.text_.get("dialog.template.set.tooltip"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.doPerformDosboxConfAction(DosboxConfAction.SET, EditConfigurableDialog.this.dbversionsList_.get(EditConfigurableDialog.this.dbversionCombo_.getSelectionIndex()));
            }
        });
        this.switchButton_ = EditConfigurableDialog.createButton((Composite)associationGroup, null, this.text_.get("dialog.template.switch"), this.text_.get("dialog.template.switch.tooltip"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.doPerformDosboxConfAction(DosboxConfAction.SWITCH, EditConfigurableDialog.this.dbversionsList_.get(EditConfigurableDialog.this.dbversionCombo_.getSelectionIndex()));
            }
        });
        EditConfigurableDialog.createButton((Composite)associationGroup, null, this.text_.get("dialog.template.reloadsettings"), this.text_.get("dialog.template.reloadsettings.tooltip"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.doPerformDosboxConfAction(DosboxConfAction.RELOAD, EditConfigurableDialog.this.dbversionsList_.get(EditConfigurableDialog.this.dbversionCombo_.getSelectionIndex()));
            }
        });
        this.dbversionCombo_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.setButton_.setEnabled(true);
                EditConfigurableDialog.this.switchButton_.setEnabled(true);
            }
        });
        Group miscGroup = EditConfigurableDialog.createGroup(composite, this.text_.get("dialog.template.miscellaneous"), 3);
        miscGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        EditConfigurableDialog.createLabel((Composite)miscGroup);
        EditConfigurableDialog.createLabel((Composite)miscGroup, this.text_.get("dialog.template.active"));
        EditConfigurableDialog.createLabel((Composite)miscGroup, this.text_.get("dialog.template.inactive"));
        Label priorityLabel = EditConfigurableDialog.createLabel((Composite)miscGroup, this.text_.get("dialog.template.priority"));
        Combo priorityActive = EditConfigurableDialog.createCombo((Composite)miscGroup, this.settings_.getValues("profile", "priority_active"), this.text_.get("dialog.template.priority.tooltip"));
        Combo priorityInactive = EditConfigurableDialog.createCombo((Composite)miscGroup, this.settings_.getValues("profile", "priority_inactive"), this.text_.get("dialog.template.priority.tooltip"));
        this.daControls_.add(new DaControl(priorityLabel, new Control[]{priorityActive, priorityInactive}, "sdl", "priority"));
        this.createLabelAndCheckButtonDaControl((Composite)miscGroup, this.text_.get("dialog.template.waitonerror"), "sdl", "waitonerror");
        EditConfigurableDialog.createLabel((Composite)miscGroup);
        this.createLabelAndCheckButtonAutoexecControl((Composite)miscGroup, this.text_.get("dialog.template.exitafterwards"), Autoexec::getExit, Autoexec::setExit);
        EditConfigurableDialog.createLabel((Composite)miscGroup);
        Text language = this.createLabelAndTooltipTextDaControl((Composite)miscGroup, this.text_.get("dialog.template.languagefile"), this.text_.get("dialog.template.languagefile.tooltip"), "dosbox", "language");
        language.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Text captures = EditConfigurableDialog.createLabelAndText((Composite)miscGroup, this.text_.get("dialog.template.captures"), 2, capturesText, this.text_.get("dialog.template.captures.tooltip"));
        captures.setEditable(false);
        Text configFile_ = EditConfigurableDialog.createLabelAndText((Composite)miscGroup, this.text_.get("dialog.profile.configfile"), 2, configFileText);
        configFile_.setEditable(false);
        return associationGroup;
    }

    protected void createDisplayTab() {
        TabFolder subTabFolder = this.createSubTabs("dialog.template.tab.display", 1, 2);
        Composite releaseComposite = (Composite)subTabFolder.getChildren()[0];
        Composite experimentalComposite = (Composite)subTabFolder.getChildren()[1];
        Group groupRelease = EditConfigurableDialog.createGroup(releaseComposite, this.text_.get("dialog.template.general"), 4);
        groupRelease.setLayoutData((Object)new GridData(1, 1, false, false));
        this.output_ = this.createLabelAndTooltipComboDaControl((Composite)groupRelease, this.text_.get("dialog.template.output"), this.settings_.getValues("profile", "output"), 10, this.text_.get("dialog.template.output.tooltip"), "sdl", "output");
        EditConfigurableDialog.createLabel((Composite)groupRelease, 2, 2);
        this.createLabelAndTooltipComboDaControl((Composite)groupRelease, this.text_.get("dialog.template.frameskip"), this.settings_.getValues("profile", "frameskip"), 15, this.text_.get("dialog.template.frameskip.tooltip"), "render", "frameskip");
        Label scalerLabel = EditConfigurableDialog.createLabel((Composite)groupRelease, this.text_.get("dialog.template.scaler"));
        this.scaler_ = EditConfigurableDialog.createCombo((Composite)groupRelease, this.settings_.getValues("profile", "scaler"), 15, this.text_.get("dialog.template.scaler.tooltip"));
        Button scaler_forced = EditConfigurableDialog.createLabelAndTooltipCheckButton((Composite)groupRelease, this.text_.get("dialog.template.scalerforced"), this.text_.get("dialog.template.scalerforced.tooltip"), false);
        this.daControls_.add(new DaControl(scalerLabel, new Control[]{this.scaler_, scaler_forced}, "render", "scaler", (DaControlConvertor)new DaControlConvertorAdapter(){

            @Override
            public String toConfValue(String[] values) {
                String result = values[0];
                if (Boolean.valueOf(values[1]).booleanValue()) {
                    result = result + " forced";
                }
                return result;
            }

            @Override
            public String[] toControlValues(String value) {
                if (value == null) {
                    return new String[0];
                }
                String[] results = new String[2];
                if (value.endsWith("forced")) {
                    results[0] = value.substring(0, value.length() - 7);
                    results[1] = "true";
                } else {
                    results[0] = value;
                    results[1] = "false";
                }
                return results;
            }
        }));
        this.createLabelAndTooltipComboDaControl((Composite)groupRelease, this.text_.get("dialog.template.fullscreenresolution"), this.settings_.getValues("profile", "fullresolution"), 10, this.text_.get("dialog.template.fullscreenresolution.tooltip"), "sdl", "fullresolution");
        EditConfigurableDialog.createLabel((Composite)groupRelease, 2, 5);
        this.createLabelAndTooltipComboDaControl((Composite)groupRelease, this.text_.get("dialog.template.windowresolution"), this.settings_.getValues("profile", "windowresolution"), 10, this.text_.get("dialog.template.windowresolution.tooltip"), "sdl", "windowresolution");
        this.createLabelAndTooltipCheckButtonDaControl((Composite)groupRelease, this.text_.get("dialog.template.fullscreen"), this.text_.get("dialog.template.fullscreen.tooltip"), "sdl", "fullscreen");
        this.createLabelAndTooltipCheckButtonDaControl((Composite)groupRelease, this.text_.get("dialog.template.doublebuffering"), this.text_.get("dialog.template.doublebuffering.tooltip"), "sdl", "fulldouble");
        this.createLabelAndTooltipCheckButtonDaControl((Composite)groupRelease, this.text_.get("dialog.template.aspectcorrection"), this.text_.get("dialog.template.aspectcorrection.tooltip"), "render", "aspect");
        Group groupExpGeneral = EditConfigurableDialog.createGroup(experimentalComposite, this.text_.get("dialog.template.general"), 2);
        groupExpGeneral.setLayoutData((Object)new GridData(1, 1, false, false, 1, 3));
        this.createLabelAndCheckButtonDaControl((Composite)groupExpGeneral, this.text_.get("dialog.template.autofit"), "render", "autofit");
        Combo pixelshader = this.createLabelAndComboDaControl((Composite)groupExpGeneral, this.text_.get("dialog.template.pixelshader"), 20, "sdl", "pixelshader");
        String[] shaders = FileLocationService.getInstance().listShaderFilenames();
        if (shaders != null && shaders.length > 0) {
            pixelshader.setItems(shaders);
            pixelshader.add("none", 0);
        } else {
            pixelshader.setItems(this.settings_.getValues("profile", "pixelshader"));
        }
        this.createLabelAndCheckButtonDaControl((Composite)groupExpGeneral, this.text_.get("dialog.template.linewise"), "render", "linewise");
        this.createLabelAndCheckButtonDaControl((Composite)groupExpGeneral, this.text_.get("dialog.template.char9"), "render", "char9");
        this.createLabelAndCheckButtonDaControl((Composite)groupExpGeneral, this.text_.get("dialog.template.multiscan"), "render", "multiscan");
        this.createLabelAndCheckButtonDaControl((Composite)groupExpGeneral, this.text_.get("dialog.template.cgasnow"), "cpu", "cgasnow");
        this.createLabelAndEditableComboDaControl((Composite)groupExpGeneral, this.text_.get("dialog.template.overscan"), this.settings_.getValues("profile", "overscan"), 10, "sdl", "overscan");
        this.createLabelAndComboDaControl((Composite)groupExpGeneral, this.text_.get("dialog.template.vsyncmode"), this.settings_.getValues("profile", "vsyncmode"), 10, "vsync", "vsyncmode");
        this.createLabelAndTextDaControl((Composite)groupExpGeneral, this.text_.get("dialog.template.vsyncrate"), "vsync", "vsyncrate");
        this.createLabelAndTextDaControl((Composite)groupExpGeneral, this.text_.get("dialog.template.forcerate"), "cpu", "forcerate");
        this.createLabelAndComboDaControl((Composite)groupExpGeneral, this.text_.get("dialog.template.videoram"), this.settings_.getValues("profile", "vmemsize"), 10, "dosbox", "vmemsize");
        this.createLabelAndTooltipCheckButtonDaControl((Composite)groupExpGeneral, this.text_.get("dialog.template.fullborderless"), this.text_.get("dialog.template.fullborderless.tooltip"), "sdl", "fullborderless");
        this.createLabelAndTooltipCheckButtonDaControl((Composite)groupExpGeneral, this.text_.get("dialog.template.glfullvsync"), this.text_.get("dialog.template.glfullvsync.tooltip"), "sdl", "glfullvsync");
        Group groupExpGlide = EditConfigurableDialog.createGroup(experimentalComposite, this.text_.get("dialog.template.glide"), 2);
        this.createLabelAndComboDaControl((Composite)groupExpGlide, this.text_.get("dialog.template.glide"), this.settings_.getValues("profile", "glide"), 10, "glide", "glide");
        this.createLabelAndTextDaControl((Composite)groupExpGlide, this.text_.get("dialog.template.glideport"), "glide", "port", "grport");
        this.createLabelAndComboDaControl((Composite)groupExpGlide, this.text_.get("dialog.template.lfbglide"), this.settings_.getValues("profile", "lfbglide"), 10, "glide", "lfb");
        this.createLabelAndCheckButtonDaControl((Composite)groupExpGlide, this.text_.get("dialog.template.splash3dfx"), "glide", "splash");
        Group groupExpVoodoo = EditConfigurableDialog.createGroup(experimentalComposite, this.text_.get("dialog.template.voodoo"), 2);
        this.createLabelAndComboDaControl((Composite)groupExpVoodoo, this.text_.get("dialog.template.voodoo"), this.settings_.getValues("profile", "voodoo"), 10, "pci", "voodoo");
        this.createLabelAndComboDaControl((Composite)groupExpVoodoo, this.text_.get("dialog.template.voodoomem"), this.settings_.getValues("profile", "voodoomem"), 10, "pci", "voodoomem");
        Group groupExpPPScaling = EditConfigurableDialog.createGroup(experimentalComposite, this.text_.get("dialog.template.pixelperfectscaling"), 2);
        this.createLabelAndSpinnerDaControl((Composite)groupExpPPScaling, this.text_.get("dialog.template.surfacenpsharpness"), 0, 100, "sdl", "surfacenp-sharpness");
    }

    protected Group createMachineTab() {
        TabFolder subTabFolder = this.createSubTabs("dialog.template.tab.machine", 1, 1);
        Composite releaseComposite = (Composite)subTabFolder.getChildren()[0];
        Composite experimentalComposite = (Composite)subTabFolder.getChildren()[1];
        Group cpuGroup = EditConfigurableDialog.createGroup(releaseComposite, this.text_.get("dialog.template.cpu"), 6);
        this.machine_ = this.createLabelAndTooltipComboDaControl((Composite)cpuGroup, this.text_.get("dialog.template.machine"), new String[0], 20, this.text_.get("dialog.template.machine.tooltip"), "dosbox", "machine");
        this.cpuType_ = this.createLabelAndTooltipComboDaControl((Composite)cpuGroup, this.text_.get("dialog.template.cputype"), this.settings_.getValues("profile", "cputype"), 10, this.text_.get("dialog.template.cputype.tooltip"), "cpu", "cputype");
        EditConfigurableDialog.createLabel((Composite)cpuGroup, 2, 1);
        this.createLabelAndTooltipComboDaControl((Composite)cpuGroup, this.text_.get("dialog.template.core"), this.settings_.getValues("profile", "core"), 10, this.text_.get("dialog.template.core.tooltip"), "cpu", "core");
        EditConfigurableDialog.createLabel((Composite)cpuGroup, 4, 1);
        this.createLabelAndEditableComboDaControl((Composite)cpuGroup, this.text_.get("dialog.template.cycles"), this.text_.get("dialog.template.cycles.tooltip"), this.settings_.getValues("profile", "cycles"), 15, "cpu", "cycles");
        this.createLabelAndEditableComboDaControl((Composite)cpuGroup, this.text_.get("dialog.template.up"), this.text_.get("dialog.template.up.tooltip"), this.settings_.getValues("profile", "cycles_up"), 10, "cpu", "cycleup");
        this.createLabelAndEditableComboDaControl((Composite)cpuGroup, this.text_.get("dialog.template.down"), this.text_.get("dialog.template.down.tooltip"), this.settings_.getValues("profile", "cycles_down"), 10, "cpu", "cycledown");
        Group memoryGroup = EditConfigurableDialog.createGroup(releaseComposite, this.text_.get("dialog.template.memory"), 4);
        this.createLabelAndTooltipComboDaControl((Composite)memoryGroup, this.text_.get("dialog.template.memorysize"), this.settings_.getValues("profile", "memsize"), 10, this.text_.get("dialog.template.memorysize.tooltip"), "dosbox", "memsize");
        EditConfigurableDialog.createLabel((Composite)memoryGroup, 2, 4);
        this.createLabelAndTooltipCheckButtonDaControl((Composite)memoryGroup, this.text_.get("dialog.template.xms"), this.text_.get("dialog.template.xms.tooltip"), "dos", "xms");
        this.createLabelAndTooltipComboDaControl((Composite)memoryGroup, this.text_.get("dialog.template.ems"), this.settings_.getValues("profile", "ems"), 10, this.text_.get("dialog.template.ems.tooltip"), "dos", "ems");
        this.createLabelAndTooltipComboDaControl((Composite)memoryGroup, this.text_.get("dialog.template.umb"), this.settings_.getValues("profile", "umb"), 10, this.text_.get("dialog.template.umb.tooltip"), "dos", "umb");
        Group expMemoryGroup = EditConfigurableDialog.createGroup(experimentalComposite, this.text_.get("dialog.template.memory"), 2);
        this.createLabelAndTextDaControl((Composite)expMemoryGroup, this.text_.get("dialog.template.memorysizekb"), "dosbox", "memsizekb");
        this.createLabelAndEditableComboDaControl((Composite)expMemoryGroup, this.text_.get("dialog.template.memalias"), this.settings_.getValues("profile", "memalias"), 10, "dosbox", "memalias");
        return memoryGroup;
    }

    protected void createAudioTab() {
        TabFolder subTabFolder = this.createSubTabs("dialog.template.tab.audio", 3, 3);
        Composite releaseComposite = (Composite)subTabFolder.getChildren()[0];
        Composite experimentalComposite = (Composite)subTabFolder.getChildren()[1];
        Group generalGroup = EditConfigurableDialog.createGroup(releaseComposite, this.text_.get("dialog.template.general"), 2);
        generalGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createLabelAndTooltipCheckButtonDaControl((Composite)generalGroup, this.text_.get("dialog.template.silentmode"), this.text_.get("dialog.template.silentmode.tooltip"), "mixer", "nosound");
        this.createLabelAndTooltipComboDaControl((Composite)generalGroup, this.text_.get("dialog.template.samplerate"), this.settings_.getValues("profile", "rate"), 10, this.text_.get("dialog.template.samplerate.tooltip"), "mixer", "rate");
        this.createLabelAndTooltipComboDaControl((Composite)generalGroup, this.text_.get("dialog.template.blocksize"), this.settings_.getValues("profile", "blocksize"), 10, this.text_.get("dialog.template.blocksize.tooltip"), "mixer", "blocksize");
        this.createLabelAndEditableComboDaControl((Composite)generalGroup, this.text_.get("dialog.template.prebuffer"), this.text_.get("dialog.template.prebuffer.tooltip"), this.settings_.getValues("profile", "prebuffer"), 10, "mixer", "prebuffer");
        Label mpu401Label = EditConfigurableDialog.createLabel((Composite)generalGroup, this.text_.get("dialog.template.mpu401"));
        Combo mpu401 = EditConfigurableDialog.createCombo((Composite)generalGroup, this.settings_.getValues("profile", "mpu401"), this.text_.get("dialog.template.mpu401.tooltip"));
        this.daControls_.add(new DaControl(mpu401Label, (Control)mpu401, "midi", "intelligent", "midi", "mpu401", new DaControlConvertorAdapter(){

            @Override
            public String toConfValue(String[] values) {
                return values[0];
            }

            @Override
            public String[] toControlValues(String value) {
                if (value == null) {
                    return new String[0];
                }
                return new String[]{value};
            }

            @Override
            public String[] toConfValues(String[] values) {
                String[] result = new String[]{String.valueOf(!values[0].equalsIgnoreCase("none")), String.valueOf(!values[0].equalsIgnoreCase("uart"))};
                return result;
            }

            @Override
            public String[] toControlValues(String[] values) {
                boolean intelligent = Boolean.valueOf(values[0]);
                boolean mpu = Boolean.valueOf(values[1]);
                String[] stringArray = new String[1];
                stringArray[0] = mpu ? (intelligent ? "intelligent" : "uart") : "none";
                return stringArray;
            }
        }));
        this.midiDevice_ = this.createLabelAndTooltipComboDaControl((Composite)generalGroup, this.text_.get("dialog.template.mididevice"), this.settings_.getValues("profile", "device"), 10, this.text_.get("dialog.template.mididevice.tooltip"), "midi", "device", "mididevice");
        this.createLabelAndTooltipTextDaControl((Composite)generalGroup, this.text_.get("dialog.template.midiconfig"), this.text_.get("dialog.template.midiconfig.tooltip"), "midi", "config", "midiconfig");
        Label mixerConfigLabel = EditConfigurableDialog.createLabel((Composite)generalGroup, this.text_.get("dialog.template.mixercommand"));
        Composite mixerSettings = EditConfigurableDialog.createInnerComposite((Composite)generalGroup, new GridData(4, 4, true, false), 2);
        final Text mixer_config = EditConfigurableDialog.createText(mixerSettings, new GridData(4, 0x1000000, true, false));
        this.autoexecControls_.add(new MetaControl(mixerConfigLabel, (Control)mixer_config).connectAutoexec(Autoexec::getMixer, Autoexec::setMixer));
        EditConfigurableDialog.createThreeDotButton(mixerSettings, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditMixerDialog dialog = new EditMixerDialog(EditConfigurableDialog.this.shell_, mixer_config.getText());
                String command = (String)dialog.open();
                if (command != null) {
                    mixer_config.setText(command);
                }
            }
        });
        Group soundblasterGroup = EditConfigurableDialog.createGroup(releaseComposite, this.text_.get("dialog.template.soundblaster"), 2);
        this.sbType_ = this.createLabelAndTooltipComboDaControl((Composite)soundblasterGroup, this.text_.get("dialog.template.sbtype"), this.settings_.getValues("profile", "sbtype"), 10, this.text_.get("dialog.template.sbtype.tooltip"), "sblaster", "type", "sbtype");
        this.createLabelAndTooltipComboDaControl((Composite)soundblasterGroup, this.text_.get("dialog.template.sboplrate"), this.settings_.getValues("profile", "oplrate"), 10, this.text_.get("dialog.template.sboplrate.tooltip"), "sblaster", "oplrate");
        this.oplMode_ = this.createLabelAndTooltipComboDaControl((Composite)soundblasterGroup, this.text_.get("dialog.template.sboplmode"), this.settings_.getValues("profile", "oplmode"), 10, this.text_.get("dialog.template.sboplmode.tooltip"), "sblaster", "oplmode");
        this.createLabelAndTooltipComboDaControl((Composite)soundblasterGroup, this.text_.get("dialog.template.sboplemu"), this.settings_.getValues("profile", "oplemu"), 10, this.text_.get("dialog.template.sboplemu.tooltip"), "sblaster", "oplemu");
        this.createLabelAndTooltipComboDaControl((Composite)soundblasterGroup, this.text_.get("dialog.template.sbaddress"), this.settings_.getValues("profile", "sbbase"), 10, this.text_.get("dialog.template.sbaddress.tooltip"), "sblaster", "base", "sbbase");
        this.createLabelAndTooltipComboDaControl((Composite)soundblasterGroup, this.text_.get("dialog.template.sbirq"), this.settings_.getValues("profile", "irq"), 10, this.text_.get("dialog.template.sbirq.tooltip"), "sblaster", "irq");
        this.createLabelAndTooltipComboDaControl((Composite)soundblasterGroup, this.text_.get("dialog.template.sbdma"), this.settings_.getValues("profile", "dma"), 10, this.text_.get("dialog.template.sbdma.tooltip"), "sblaster", "dma");
        this.createLabelAndTooltipComboDaControl((Composite)soundblasterGroup, this.text_.get("dialog.template.sbhdma"), this.settings_.getValues("profile", "hdma"), 10, this.text_.get("dialog.template.sbhdma.tooltip"), "sblaster", "hdma");
        this.createLabelAndTooltipCheckButtonDaControl((Composite)soundblasterGroup, this.text_.get("dialog.template.mixer"), this.text_.get("dialog.template.mixer.tooltip"), "sblaster", "mixer", "sbmixer");
        Group gusGroup = EditConfigurableDialog.createGroup(releaseComposite, this.text_.get("dialog.template.gravisultrasound"), 2);
        gusGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createLabelAndTooltipCheckButtonDaControl((Composite)gusGroup, this.text_.get("dialog.template.enablegus"), this.text_.get("dialog.template.enablegus.tooltip"), "gus", "gus");
        this.createLabelAndTooltipComboDaControl((Composite)gusGroup, this.text_.get("dialog.template.gusrate"), this.settings_.getValues("profile", "gusrate"), 10, this.text_.get("dialog.template.gusrate.tooltip"), "gus", "rate", "gusrate");
        this.createLabelAndTooltipComboDaControl((Composite)gusGroup, this.text_.get("dialog.template.gusaddress"), this.settings_.getValues("profile", "gusbase"), 10, this.text_.get("dialog.template.gusaddress.tooltip"), "gus", "base", "gusbase");
        this.createLabelAndTooltipComboDaControl((Composite)gusGroup, this.text_.get("dialog.template.gusirq1"), this.settings_.getValues("profile", "irq1"), 10, this.text_.get("dialog.template.gusirq1.tooltip"), "gus", "irq1", "gusirq");
        this.createLabelAndTooltipComboDaControl((Composite)gusGroup, this.text_.get("dialog.template.gusirq2"), this.settings_.getValues("profile", "irq2"), 10, this.text_.get("dialog.template.gusirq1.tooltip"), "gus", "irq2");
        this.createLabelAndTooltipComboDaControl((Composite)gusGroup, this.text_.get("dialog.template.gusdma1"), this.settings_.getValues("profile", "dma1"), 10, this.text_.get("dialog.template.gusdma1.tooltip"), "gus", "dma1", "gusdma");
        this.createLabelAndTooltipComboDaControl((Composite)gusGroup, this.text_.get("dialog.template.gusdma2"), this.settings_.getValues("profile", "dma2"), 10, this.text_.get("dialog.template.gusdma1.tooltip"), "gus", "dma2");
        this.createLabelAndTooltipTextDaControl((Composite)gusGroup, this.text_.get("dialog.template.ultradir"), this.text_.get("dialog.template.ultradir.tooltip"), "gus", "ultradir");
        Group speakerGroup = EditConfigurableDialog.createGroup(releaseComposite, this.text_.get("dialog.template.pcspeaker"), 2);
        speakerGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createLabelAndTooltipCheckButtonDaControl((Composite)speakerGroup, this.text_.get("dialog.template.enablepcspeaker"), this.text_.get("dialog.template.enablepcspeaker.tooltip"), "speaker", "pcspeaker");
        this.createLabelAndTooltipComboDaControl((Composite)speakerGroup, this.text_.get("dialog.template.pcrate"), this.settings_.getValues("profile", "pcrate"), 10, this.text_.get("dialog.template.pcrate.tooltip"), "speaker", "pcrate");
        Group tandyGroup = EditConfigurableDialog.createGroup(releaseComposite, this.text_.get("dialog.template.tandy"), 2);
        tandyGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.createLabelAndTooltipComboDaControl((Composite)tandyGroup, this.text_.get("dialog.template.enabletandy"), this.settings_.getValues("profile", "tandy"), 10, this.text_.get("dialog.template.enabletandy.tooltip"), "speaker", "tandy");
        this.createLabelAndTooltipComboDaControl((Composite)tandyGroup, this.text_.get("dialog.template.tandyrate"), this.settings_.getValues("profile", "tandyrate"), 10, this.text_.get("dialog.template.tandyrate.tooltip"), "speaker", "tandyrate");
        Group disneyGroup = EditConfigurableDialog.createGroup(releaseComposite, this.text_.get("dialog.template.miscellaneous"), 2);
        disneyGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createLabelAndTooltipCheckButtonDaControl((Composite)disneyGroup, this.text_.get("dialog.template.enablesoundsource"), this.text_.get("dialog.template.enablesoundsource.tooltip"), "speaker", "disney");
        Group generalExpGroup = EditConfigurableDialog.createGroup(experimentalComposite, this.text_.get("dialog.template.general"), 2);
        generalExpGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createLabelAndCheckButtonDaControl((Composite)generalExpGroup, this.text_.get("dialog.template.swapstereo"), "mixer", "swapstereo");
        Group soundblasterExpGroup = EditConfigurableDialog.createGroup(experimentalComposite, this.text_.get("dialog.template.soundblaster"), 2);
        soundblasterExpGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.createLabelAndComboDaControl((Composite)soundblasterExpGroup, this.text_.get("dialog.template.hardwaresbaddress"), this.settings_.getValues("profile", "hardwaresbbase"), 10, "sblaster", "hardwarebase");
        this.createLabelAndCheckButtonDaControl((Composite)soundblasterExpGroup, this.text_.get("dialog.template.goldplay"), "sblaster", "goldplay");
        this.createLabelAndSpinnerDaControl((Composite)soundblasterExpGroup, this.text_.get("dialog.template.fmstrength"), 1, 1000, "sblaster", "fmstrength");
        Group mt32ExpGroup = EditConfigurableDialog.createGroup(experimentalComposite, this.text_.get("dialog.template.mt32"), 2);
        mt32ExpGroup.setLayoutData((Object)new GridData(4, 4, false, false, 1, 3));
        this.createLabelDirSelectDaControl((Composite)mt32ExpGroup, this.text_.get("dialog.template.mt32.romdir"), "midi", "mt32.romdir");
        this.createLabelAndCheckButtonDaControl((Composite)mt32ExpGroup, this.text_.get("dialog.template.swapstereo"), "midi", "mt32.reverse.stereo", false);
        this.createLabelAndCheckButtonDaControl((Composite)mt32ExpGroup, this.text_.get("dialog.template.mt32.verboselogging"), "midi", "mt32.verbose", false);
        this.createLabelAndCheckButtonDaControl((Composite)mt32ExpGroup, this.text_.get("dialog.template.mt32.multithread"), "midi", "mt32.thread", false);
        this.createLabelAndSpinnerDaControl((Composite)mt32ExpGroup, this.text_.get("dialog.template.mt32.chunk"), 2, 100, "midi", "mt32.chunk");
        this.createLabelAndSpinnerDaControl((Composite)mt32ExpGroup, this.text_.get("dialog.template.mt32.prebuffer"), 3, 200, "midi", "mt32.prebuffer");
        this.createLabelAndSpinnerDaControl((Composite)mt32ExpGroup, this.text_.get("dialog.template.mt32.partials"), 0, 256, "midi", "mt32.partials");
        this.createLabelAndComboDaControl((Composite)mt32ExpGroup, this.text_.get("dialog.template.mt32.dac"), this.settings_.getValues("profile", "mt32dac"), 10, "midi", "mt32.dac");
        this.createLabelAndComboDaControl((Composite)mt32ExpGroup, this.text_.get("dialog.template.mt32.analog"), this.settings_.getValues("profile", "mt32analog"), 10, "midi", "mt32.analog");
        this.createLabelAndComboDaControl((Composite)mt32ExpGroup, this.text_.get("dialog.template.mt32.reverbmode"), this.settings_.getValues("profile", "mt32reverbmode"), 10, "midi", "mt32.reverb.mode");
        this.createLabelAndComboDaControl((Composite)mt32ExpGroup, this.text_.get("dialog.template.mt32.reverbtime"), this.settings_.getValues("profile", "mt32reverbtime"), 10, "midi", "mt32.reverb.time");
        this.createLabelAndComboDaControl((Composite)mt32ExpGroup, this.text_.get("dialog.template.mt32.reverblevel"), this.settings_.getValues("profile", "mt32reverblevel"), 10, "midi", "mt32.reverb.level");
        Group fluidExpGroup = EditConfigurableDialog.createGroup(experimentalComposite, this.text_.get("dialog.template.fluidsynth"), 2);
        fluidExpGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 2));
        this.createLabelAndEditableComboDaControl((Composite)fluidExpGroup, this.text_.get("dialog.template.fluidsynth.driver"), this.settings_.getValues("profile", "fluidsynthdriver"), 10, "midi", "fluid.driver");
        this.createLabelAndTextDaControl((Composite)fluidExpGroup, this.text_.get("dialog.template.fluidsynth.soundfont"), "midi", "fluid.soundfont");
        this.createLabelAndComboDaControl((Composite)fluidExpGroup, this.text_.get("dialog.template.fluidsynth.samplerate"), this.settings_.getValues("profile", "fluidsynthsamplerate"), 10, "midi", "fluid.samplerate");
        this.createLabelAndTextDaControl((Composite)fluidExpGroup, this.text_.get("dialog.template.fluidsynth.gain"), "midi", "fluid.gain");
        Group innovaExpGroup = EditConfigurableDialog.createGroup(experimentalComposite, this.text_.get("dialog.template.innova"), 2);
        innovaExpGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.createLabelAndCheckButtonDaControl((Composite)innovaExpGroup, this.text_.get("dialog.template.innovaenable"), "innova", "innova");
        this.createLabelAndComboDaControl((Composite)innovaExpGroup, this.text_.get("dialog.template.innovarate"), this.settings_.getValues("profile", "innovarate"), 10, "innova", "samplerate");
        this.createLabelAndComboDaControl((Composite)innovaExpGroup, this.text_.get("dialog.template.innovaaddress"), this.settings_.getValues("profile", "innovabase"), 10, "innova", "sidbase");
        this.createLabelAndComboDaControl((Composite)innovaExpGroup, this.text_.get("dialog.template.innovaquality"), this.settings_.getValues("profile", "innovaquality"), 10, "innova", "quality");
        Group ps1ExpGroup = EditConfigurableDialog.createGroup(experimentalComposite, this.text_.get("dialog.template.ps1"), 2);
        ps1ExpGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.createLabelAndCheckButtonDaControl((Composite)ps1ExpGroup, this.text_.get("dialog.template.ps1enable"), "speaker", "ps1audio", true);
        this.createLabelAndComboDaControl((Composite)ps1ExpGroup, this.text_.get("dialog.template.ps1rate"), this.settings_.getValues("profile", "ps1rate"), 10, "speaker", "ps1audiorate");
    }

    protected void createIOTab() {
        TabFolder subTabFolder = this.createSubTabs("dialog.template.tab.io", 3, 4);
        Composite releaseComposite = (Composite)subTabFolder.getChildren()[0];
        Composite experimentalComposite = (Composite)subTabFolder.getChildren()[1];
        Group mouseGroup = EditConfigurableDialog.createGroup(releaseComposite, this.text_.get("dialog.template.mouse"), 2);
        mouseGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.createLabelAndTooltipCheckButtonDaControl((Composite)mouseGroup, this.text_.get("dialog.template.autolock"), this.text_.get("dialog.template.autolock.tooltip"), "sdl", "autolock");
        Label sensitivityLabel = EditConfigurableDialog.createLabel((Composite)mouseGroup, this.text_.get("dialog.template.sensitivity"));
        Combo sensitivity = EditConfigurableDialog.createEditableCombo((Composite)mouseGroup, this.settings_.getValues("profile", "sensitivity"), 20, this.text_.get("dialog.template.sensitivity.tooltip"));
        this.daControls_.add(new DaControl(sensitivityLabel, (Control)sensitivity, "sdl", "sensitivity", new DaControlConvertor(){

            @Override
            public String toConfValue(String[] values) {
                return String.join((CharSequence)",", values);
            }

            @Override
            public String[] toControlValues(String value) {
                String[] stringArray;
                if (value == null) {
                    stringArray = new String[]{};
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = value;
                }
                return stringArray;
            }

            @Override
            public String[] toConfValues(String[] values) {
                return null;
            }

            @Override
            public String[] toControlValues(String[] values) {
                return null;
            }
        }));
        Group keyboardGroup = EditConfigurableDialog.createGroup(releaseComposite, this.text_.get("dialog.template.keyboard"), 2);
        keyboardGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createLabelAndTooltipCheckButtonDaControl((Composite)keyboardGroup, this.text_.get("dialog.template.usescancodes"), this.text_.get("dialog.template.usescancodes.tooltip"), "sdl", "usescancodes");
        Label mapperFileLabel = EditConfigurableDialog.createLabel((Composite)keyboardGroup, this.text_.get("dialog.template.mapperfile"));
        Composite mapperfileSettings = EditConfigurableDialog.createInnerComposite((Composite)keyboardGroup, new GridData(4, 0x1000000, true, false), 2);
        final Text mapperfile = EditConfigurableDialog.createText(mapperfileSettings, 2048, new GridData(4, 0x1000000, true, false), null, this.text_.get("dialog.template.mapperfile.tooltip"));
        this.daControls_.add(new DaControl(mapperFileLabel, (Control)mapperfile, "sdl", "mapperfile"));
        EditConfigurableDialog.createButton(mapperfileSettings, "*", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                mapperfile.setText(EditConfigurableDialog.this.settings_.getValue("profile", "uniquemapperfile"));
            }
        });
        this.createLabelAndWideEditableComboDaControl((Composite)keyboardGroup, this.text_.get("dialog.template.keyboardlayout"), this.settings_.getValues("profile", "keyboardlayout"), 15, this.text_.get("dialog.template.keyboardlayout.tooltip"), "dos", "keyboardlayout");
        this.createLabelAndTextAutoexecControl((Composite)keyboardGroup, this.text_.get("dialog.template.keybcommand"), Autoexec::getKeyb, Autoexec::setKeyb);
        Group joystickGroup = EditConfigurableDialog.createGroup(releaseComposite, this.text_.get("dialog.template.joystick"), 2);
        joystickGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createLabelAndTooltipComboDaControl((Composite)joystickGroup, this.text_.get("dialog.template.joysticktype"), this.settings_.getValues("profile", "joysticktype"), 10, this.text_.get("dialog.template.joysticktype.tooltip"), "bios", "joysticktype", "joystick", "joysticktype");
        this.createLabelAndTooltipCheckButtonDaControl((Composite)joystickGroup, this.text_.get("dialog.template.timedemulation"), this.text_.get("dialog.template.timedemulation.tooltip"), "joystick", "timed");
        this.createLabelAndTooltipCheckButtonDaControl((Composite)joystickGroup, this.text_.get("dialog.template.autofire"), this.text_.get("dialog.template.autofire.tooltip"), "joystick", "autofire");
        this.createLabelAndTooltipCheckButtonDaControl((Composite)joystickGroup, this.text_.get("dialog.template.swap34"), this.text_.get("dialog.template.swap34.tooltip"), "joystick", "swap34");
        this.createLabelAndTooltipCheckButtonDaControl((Composite)joystickGroup, this.text_.get("dialog.template.buttonwrapping"), this.text_.get("dialog.template.buttonwrapping.tooltip"), "joystick", "buttonwrap");
        Group modemGroup = EditConfigurableDialog.createGroup(releaseComposite, this.text_.get("dialog.template.modem"), 2);
        modemGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.createLabelAndTooltipTextDaControl((Composite)modemGroup, this.text_.get("dialog.template.serial1"), this.text_.get("dialog.template.serial.tooltip"), "serial", "serial1");
        this.createLabelAndTooltipTextDaControl((Composite)modemGroup, this.text_.get("dialog.template.serial2"), this.text_.get("dialog.template.serial.tooltip"), "serial", "serial2");
        this.createLabelAndTooltipTextDaControl((Composite)modemGroup, this.text_.get("dialog.template.serial3"), this.text_.get("dialog.template.serial.tooltip"), "serial", "serial3");
        this.createLabelAndTooltipTextDaControl((Composite)modemGroup, this.text_.get("dialog.template.serial4"), this.text_.get("dialog.template.serial.tooltip"), "serial", "serial4");
        Group networkGroup = EditConfigurableDialog.createGroup(releaseComposite, this.text_.get("dialog.template.network"), 2);
        networkGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.ipx_ = this.createLabelAndTooltipCheckButtonDaControl((Composite)networkGroup, this.text_.get("dialog.template.enableipx"), this.text_.get("dialog.template.enableipx.tooltip"), "ipx", "ipx");
        Label ipxnetCommandLabel = EditConfigurableDialog.createLabel((Composite)networkGroup, this.text_.get("dialog.template.ipxnetcommand"));
        ipxnetCommandLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.ipxNet_ = EditConfigurableDialog.createText((Composite)networkGroup, new GridData(4, 0x1000000, true, false, 2, 1));
        this.autoexecControls_.add(new MetaControl(ipxnetCommandLabel, (Control)this.ipxNet_).connectAutoexec(Autoexec::getIpxnet, Autoexec::setIpxnet));
        this.ipx_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.ipxNet_.setEnabled(EditConfigurableDialog.this.ipx_.getSelection());
            }
        });
        Group mouseExpGroup = EditConfigurableDialog.createGroup(experimentalComposite, this.text_.get("dialog.template.mouse"), 2);
        mouseExpGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.createLabelAndCheckButtonDaControl((Composite)mouseExpGroup, this.text_.get("dialog.template.int33"), "dos", "int33");
        this.createLabelAndCheckButtonDaControl((Composite)mouseExpGroup, this.text_.get("dialog.template.biosps2"), "dos", "biosps2");
        this.createLabelAndCheckButtonDaControl((Composite)mouseExpGroup, this.text_.get("dialog.template.aux"), "keyboard", "aux");
        this.createLabelAndComboDaControl((Composite)mouseExpGroup, this.text_.get("dialog.template.auxdevice"), this.settings_.getValues("profile", "auxdevice"), 10, "keyboard", "auxdevice");
        Group miscExpGroup = EditConfigurableDialog.createGroup(experimentalComposite, this.text_.get("dialog.template.miscellaneous"), 2);
        miscExpGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.createLabelAndSpinnerDaControl((Composite)miscExpGroup, this.text_.get("dialog.template.files"), 8, 255, "dos", "files");
        this.createLabelAndCheckButtonDaControl((Composite)miscExpGroup, this.text_.get("dialog.template.isapnpbios"), "cpu", "isapnpbios");
        this.createLabelAndCheckButtonDaControl((Composite)miscExpGroup, this.text_.get("dialog.template.ide1"), "ide, primary", "enable");
        this.createLabelAndCheckButtonDaControl((Composite)miscExpGroup, this.text_.get("dialog.template.ide2"), "ide, secondary", "enable");
        this.createLabelAndCheckButtonDaControl((Composite)miscExpGroup, this.text_.get("dialog.template.ide3"), "ide, tertiary", "enable");
        this.createLabelAndCheckButtonDaControl((Composite)miscExpGroup, this.text_.get("dialog.template.ide4"), "ide, quaternary", "enable");
        this.createLabelAndCheckButtonDaControl((Composite)miscExpGroup, this.text_.get("dialog.template.automount"), "dos", "automount");
        Group printerExpGroup = EditConfigurableDialog.createGroup(experimentalComposite, this.text_.get("dialog.template.printer"), 2);
        printerExpGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.createLabelAndCheckButtonDaControl((Composite)printerExpGroup, this.text_.get("dialog.template.printerenable"), "printer", "printer");
        this.createLabelAndSpinnerDaControl((Composite)printerExpGroup, this.text_.get("dialog.template.printerdpi"), 0, Short.MAX_VALUE, "printer", "dpi");
        this.createLabelAndSpinnerDaControl((Composite)printerExpGroup, this.text_.get("dialog.template.printerwidth"), 0, Short.MAX_VALUE, "printer", "width");
        this.createLabelAndSpinnerDaControl((Composite)printerExpGroup, this.text_.get("dialog.template.printerheight"), 0, Short.MAX_VALUE, "printer", "height");
        this.createLabelAndComboDaControl((Composite)printerExpGroup, this.text_.get("dialog.template.printeroutput"), this.settings_.getValues("profile", "printeroutput"), 10, "printer", "printoutput");
        this.createLabelAndCheckButtonDaControl((Composite)printerExpGroup, this.text_.get("dialog.template.printermultipage"), "printer", "multipage");
        this.createLabelAndTextDaControl((Composite)printerExpGroup, this.text_.get("dialog.template.printerdocpath"), "printer", "docpath");
        this.createLabelAndSpinnerDaControl((Composite)printerExpGroup, this.text_.get("dialog.template.printertimeout"), 0, Short.MAX_VALUE, "printer", "timeout");
        Group joystickExpGroup = EditConfigurableDialog.createGroup(experimentalComposite, this.text_.get("dialog.template.joystick"), 2);
        this.createLabelAndTooltipCheckButtonDaControl((Composite)joystickExpGroup, this.text_.get("dialog.template.circularinput"), this.text_.get("dialog.template.circularinput.tooltip"), "joystick", "circularinput");
        this.createLabelAndSpinnerDaControl((Composite)joystickExpGroup, this.text_.get("dialog.template.deadzone"), 1, 100, "joystick", "deadzone");
        joystickExpGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        Group parallelExpGroup = EditConfigurableDialog.createGroup(experimentalComposite, this.text_.get("dialog.template.parallel"), 2);
        parallelExpGroup.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.createLabelAndTextDaControl((Composite)parallelExpGroup, this.text_.get("dialog.template.parallel1"), "parallel", "parallel1");
        this.createLabelAndTextDaControl((Composite)parallelExpGroup, this.text_.get("dialog.template.parallel2"), "parallel", "parallel2");
        this.createLabelAndTextDaControl((Composite)parallelExpGroup, this.text_.get("dialog.template.parallel3"), "parallel", "parallel3");
        this.createLabelAndCheckButtonDaControl((Composite)parallelExpGroup, this.text_.get("dialog.template.dongle"), "parallel", "dongle");
        Group ne2000ExpGroup = EditConfigurableDialog.createGroup(experimentalComposite, this.text_.get("dialog.template.ne2000"), 2);
        ne2000ExpGroup.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.createLabelAndCheckButtonDaControl((Composite)ne2000ExpGroup, this.text_.get("dialog.template.ne2000enable"), "ne2000", "ne2000");
        this.createLabelAndTextDaControl((Composite)ne2000ExpGroup, this.text_.get("dialog.template.ne2000base"), "ne2000", "nicbase");
        this.createLabelAndTextDaControl((Composite)ne2000ExpGroup, this.text_.get("dialog.template.ne2000irq"), "ne2000", "nicirq");
        this.createLabelAndTextDaControl((Composite)ne2000ExpGroup, this.text_.get("dialog.template.ne2000macaddress"), "ne2000", "macaddr");
        this.createLabelAndTextDaControl((Composite)ne2000ExpGroup, this.text_.get("dialog.template.ne2000realnic"), "ne2000", "realnic");
    }

    protected void createCustomCommandsTab(final TemplateProfileBase configurable, boolean multiEdit) {
        TabFolder subTabFolder = this.createSubTabs("dialog.template.tab.customcommands", "dialog.template.tab.dosboxautoexec", 2, "dialog.template.tab.native", 2);
        Composite dosboxComposite = (Composite)subTabFolder.getChildren()[0];
        Composite nativeComposite = (Composite)subTabFolder.getChildren()[1];
        Text[] customCommands = new Text[Autoexec.SECTIONS];
        for (int i = 0; i < Autoexec.SECTIONS; ++i) {
            Label filterLabel = EditConfigurableDialog.createLabel(dosboxComposite, this.text_.get("dialog.template.customcommand" + (i + 1)));
            customCommands[i] = EditConfigurableDialog.createTextarea(dosboxComposite, false);
            this.autoexecControls_.add(new MetaControl(filterLabel, (Control)customCommands[i]).connectAutoexec(i, Autoexec::getCustomSection, Autoexec::setCustomSection));
        }
        this.nativeCommandsList_ = EditConfigurableDialog.createList(nativeComposite, 1, 6);
        this.nativeCommandsList_.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (EditConfigurableDialog.this.nativeCommandsList_.getSelectionIndex() == -1) {
                    EditConfigurableDialog.this.doAddNativeCommand(configurable);
                } else {
                    EditConfigurableDialog.this.doEditNativeCommand(configurable);
                }
            }
        });
        EditConfigurableDialog.createButton(nativeComposite, this.text_.get("dialog.template.mount.add"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.doAddNativeCommand(configurable);
            }
        });
        EditConfigurableDialog.createButton(nativeComposite, this.text_.get("dialog.template.mount.edit"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.doEditNativeCommand(configurable);
            }
        });
        EditConfigurableDialog.createButton(nativeComposite, this.text_.get("dialog.template.mount.remove"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.doRemoveNativeCommand(configurable);
            }
        });
        EditConfigurableDialog.createUpButton(nativeComposite, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sel = EditConfigurableDialog.this.nativeCommandsList_.getSelectionIndex();
                if (sel > 0) {
                    Collections.swap(configurable.getNativeCommands(), sel, sel - 1);
                    EditConfigurableDialog.this.updateNativeCommands(sel - 1, configurable);
                }
            }
        });
        EditConfigurableDialog.createDownButton(nativeComposite, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sel = EditConfigurableDialog.this.nativeCommandsList_.getSelectionIndex();
                if (sel >= 0 && sel < EditConfigurableDialog.this.nativeCommandsList_.getItemCount() - 1) {
                    Collections.swap(configurable.getNativeCommands(), sel, sel + 1);
                    EditConfigurableDialog.this.updateNativeCommands(sel + 1, configurable);
                }
            }
        });
        EditConfigurableDialog.createLabel(nativeComposite);
        if (multiEdit) {
            Arrays.asList(nativeComposite.getChildren()).forEach(x -> x.setEnabled(false));
        }
    }

    protected void updateNativeCommands(int sel, TemplateProfileBase configurable) {
        this.nativeCommandsList_.removeAll();
        for (NativeCommand cmd : configurable.getNativeCommands()) {
            this.nativeCommandsList_.add(cmd.toString());
        }
        this.nativeCommandsList_.select(sel);
    }

    protected void doAddNativeCommand(TemplateProfileBase configurable) {
        EditNativeCommandDialog cmdDialog = new EditNativeCommandDialog(this.shell_, null);
        NativeCommand cmd = (NativeCommand)cmdDialog.open();
        if (cmd != null) {
            int nr = this.nativeCommandsList_.getSelectionIndex() + 1;
            configurable.getNativeCommands().add(nr, cmd);
            this.updateNativeCommands(nr, configurable);
        }
    }

    protected void doEditNativeCommand(TemplateProfileBase configurable) {
        EditNativeCommandDialog cmdDialog;
        NativeCommand cmd;
        int sel = this.nativeCommandsList_.getSelectionIndex();
        if (sel != -1 && !(cmd = configurable.getNativeCommands().get(sel)).isDosboxCommand() && (cmd = (NativeCommand)(cmdDialog = new EditNativeCommandDialog(this.shell_, cmd)).open()) != null) {
            configurable.getNativeCommands().set(sel, cmd);
            this.updateNativeCommands(sel, configurable);
        }
    }

    protected void doRemoveNativeCommand(TemplateProfileBase configurable) {
        NativeCommand cmd;
        int sel = this.nativeCommandsList_.getSelectionIndex();
        if (sel != -1 && !(cmd = configurable.getNativeCommands().get(sel)).isDosboxCommand()) {
            configurable.getNativeCommands().remove(sel);
            this.updateNativeCommands(Math.min(sel, this.nativeCommandsList_.getItemCount() - 1), configurable);
        }
    }

    protected void createMountingTab(final TemplateProfileBase configurable, boolean multiEdit) {
        final Composite composite = this.createTabWithComposite(this.text_.get("dialog.template.tab.mounting"), (Layout)new GridLayout());
        Group mountGroup = EditConfigurableDialog.createGroup(composite, this.text_.get("dialog.template.mountingoverview"), 2);
        mountGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.mountingpointsList_ = EditConfigurableDialog.createList((Composite)mountGroup, 1, 3);
        Group executeGroup = EditConfigurableDialog.createGroup(composite, this.text_.get("dialog.template.execute"), (Layout)new FillLayout());
        executeGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        final ExpandBar dosBooterExpandBar = new ExpandBar((Composite)executeGroup, 512);
        Composite booterComposite = EditConfigurableDialog.createComposite((Composite)dosBooterExpandBar);
        Composite dosComposite = EditConfigurableDialog.createComposite((Composite)dosBooterExpandBar);
        this.booterExpandItem_ = EditConfigurableDialog.createExpandItem(dosBooterExpandBar, this.text_.get("dialog.template.booter"), false, booterComposite);
        this.dosExpandItem_ = EditConfigurableDialog.createExpandItem(dosBooterExpandBar, this.text_.get("dialog.template.dos"), false, dosComposite);
        dosBooterExpandBar.addExpandListener((ExpandListener)new ExpandAdapter(){

            public void itemCollapsed(ExpandEvent e) {
                dosBooterExpandBar.getItem(((ExpandItem)e.item).getText().equals(EditConfigurableDialog.this.text_.get("dialog.template.dos")) ? 0 : 1).setExpanded(true);
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        composite.layout();
                    }
                });
            }

            public void itemExpanded(ExpandEvent e) {
                dosBooterExpandBar.getItem(((ExpandItem)e.item).getText().equals(EditConfigurableDialog.this.text_.get("dialog.template.dos")) ? 0 : 1).setExpanded(false);
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        composite.layout();
                    }
                });
            }
        });
        this.mountingpointsList_.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (EditConfigurableDialog.this.mountingpointsList_.getSelectionIndex() == -1) {
                    EditConfigurableDialog.doAddMount(EditConfigurableDialog.this.shell_, EditConfigurableDialog.this.booterExpandItem_.getExpanded(), EditConfigurableDialog.this.mountingpointsList_, configurable);
                } else {
                    EditConfigurableDialog.doEditMount(EditConfigurableDialog.this.shell_, EditConfigurableDialog.this.mountingpointsList_, configurable);
                }
            }
        });
        EditConfigurableDialog.createButton((Composite)mountGroup, this.text_.get("dialog.template.mount.add"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.doAddMount(EditConfigurableDialog.this.shell_, EditConfigurableDialog.this.booterExpandItem_.getExpanded(), EditConfigurableDialog.this.mountingpointsList_, configurable);
            }
        });
        EditConfigurableDialog.createButton((Composite)mountGroup, this.text_.get("dialog.template.mount.edit"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.doEditMount(EditConfigurableDialog.this.shell_, EditConfigurableDialog.this.mountingpointsList_, configurable);
            }
        });
        EditConfigurableDialog.createButton((Composite)mountGroup, this.text_.get("dialog.template.mount.remove"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditConfigurableDialog.this.doRemoveMount(configurable);
            }
        });
        if (multiEdit) {
            Arrays.asList(mountGroup.getChildren()).forEach(x -> x.setEnabled(false));
        }
    }

    public static void doAddMount(Shell shell, boolean floppy, org.eclipse.swt.widgets.List mountingpoints, TemplateProfileBase configurable) {
        char drive;
        try {
            drive = DriveLetterHelper.getFirstAvailable(floppy, configurable.getNettoMountedDrives());
        }
        catch (DrivelettersExhaustedException e) {
            drive = 'C';
        }
        EditMountDialog addMountDialog = new EditMountDialog(shell, null, drive);
        String mount = (String)addMountDialog.open();
        if (mount != null) {
            configurable.addMount(mount);
            mountingpoints.setItems(configurable.getMountStringsForUI());
            mountingpoints.select(mountingpoints.getItemCount() - 1);
        }
    }

    public static void doEditMount(Shell shell, org.eclipse.swt.widgets.List mountingpoints, TemplateProfileBase configurable) {
        EditMountDialog editMountDialog;
        String mount;
        int mounts = mountingpoints.getItemCount();
        int sel = mountingpoints.getSelectionIndex();
        if (sel == -1 && mounts == 1) {
            sel = 0;
            mountingpoints.select(sel);
        }
        if (sel != -1 && !configurable.getMountingPointsForUI().get(sel).isUnmounted() && (mount = (String)(editMountDialog = new EditMountDialog(shell, mountingpoints.getItem(sel), 'C')).open()) != null) {
            configurable.editMountBasedOnIndexUI(sel, mount);
            mountingpoints.setItems(configurable.getMountStringsForUI());
            if (mountingpoints.getItemCount() == mounts) {
                mountingpoints.select(sel);
            } else {
                mountingpoints.select(mountingpoints.getItemCount() - 1);
            }
        }
    }

    protected void doRemoveMount(TemplateProfileBase configurable) {
        EditConfigurableDialog.doRemoveMount(this.mountingpointsList_, configurable);
    }

    public static void doRemoveMount(org.eclipse.swt.widgets.List mountingpoints, TemplateProfileBase configurable) {
        int mounts = mountingpoints.getItemCount();
        int sel = mountingpoints.getSelectionIndex();
        if (sel == -1 && mounts == 1) {
            sel = 0;
            mountingpoints.select(sel);
        }
        if (sel != -1) {
            configurable.removeMountBasedOnIndexUI(sel);
            mountingpoints.setItems(configurable.getMountStringsForUI());
            if (mountingpoints.getItemCount() == mounts) {
                mountingpoints.select(sel);
            } else if (mountingpoints.getItemCount() > 0) {
                mountingpoints.select(mountingpoints.getItemCount() - 1);
            }
        }
    }

    protected Text createLabelAndTextDaControl(Composite composite, String labelText, String section, String item) {
        Label label = EditConfigurableDialog.createLabel(composite, labelText);
        Text text = EditConfigurableDialog.createText(composite);
        this.daControls_.add(new DaControl(label, (Control)text, section, item));
        return text;
    }

    protected Text createLabelAndTextDaControl(Composite composite, String labelText, String section, String itemOld, String itemNew) {
        Label label = EditConfigurableDialog.createLabel(composite, labelText);
        Text text = EditConfigurableDialog.createText(composite);
        this.daControls_.add(new DaControl(label, (Control)text, section, itemOld, itemNew));
        return text;
    }

    protected Text createLabelAndTooltipTextDaControl(Composite composite, String labelText, String tooltip, String section, String item) {
        Label label = EditConfigurableDialog.createLabel(composite, labelText);
        Text text = EditConfigurableDialog.createText(composite, 2048, new GridData(4, 0x1000000, true, false), null, tooltip);
        this.daControls_.add(new DaControl(label, (Control)text, section, item));
        return text;
    }

    protected Text createLabelAndTooltipTextDaControl(Composite composite, String labelText, String tooltip, String section, String itemOld, String itemNew) {
        Label label = EditConfigurableDialog.createLabel(composite, labelText);
        Text text = EditConfigurableDialog.createText(composite, 2048, null, null, tooltip);
        this.daControls_.add(new DaControl(label, (Control)text, section, itemOld, itemNew));
        return text;
    }

    protected Text createLabelAndTooltipDirSelectDaControl(Composite composite, String labelText, String tooltip, String section, String item) {
        Label label = EditConfigurableDialog.createLabel(composite, labelText);
        Composite inner = EditConfigurableDialog.createInnerComposite(composite, new GridData(4, 0x1000000, true, false), 2);
        Text text = EditConfigurableDialog.createText(inner, 2048, new GridData(4, 0x1000000, true, false), null, tooltip);
        new BrowseButton(inner, true).connect(this.shell_, text, null, BrowseButton.BrowseType.DIR, BrowseButton.CanonicalType.NONE, false, null);
        this.daControls_.add(new DaControl(label, (Control)text, section, item));
        return text;
    }

    protected Text createLabelDirSelectDaControl(Composite composite, String labelText, String section, String item) {
        return this.createLabelAndTooltipDirSelectDaControl(composite, labelText, null, section, item);
    }

    protected Text createLabelAndTextAutoexecControl(Composite composite, String labelText, Function<Autoexec, String> getMethod, BiConsumer<Autoexec, String> updateMethod) {
        Label label = EditConfigurableDialog.createLabel(composite, labelText);
        Text text = EditConfigurableDialog.createText(composite);
        this.autoexecControls_.add(new MetaControl(label, (Control)text).connectAutoexec(getMethod, updateMethod));
        return text;
    }

    protected Text createLabelAndTextAutoexecControl(Composite composite, String labelText, int horizontalSpan, Function<Autoexec, String> getMethod, BiConsumer<Autoexec, String> updateMethod) {
        Label label = EditConfigurableDialog.createLabel(composite, labelText);
        Text text = EditConfigurableDialog.createText(composite, horizontalSpan);
        this.autoexecControls_.add(new MetaControl(label, (Control)text).connectAutoexec(getMethod, updateMethod));
        return text;
    }

    protected Button createLabelAndCheckButtonDaControl(Composite composite, String labeltext, String section, String item) {
        Label label = EditConfigurableDialog.createLabel(composite, labeltext);
        Button checkButton = EditConfigurableDialog.createCheckButton(composite, false);
        this.daControls_.add(new DaControl(label, (Control)checkButton, section, item));
        return checkButton;
    }

    protected Button createLabelAndCheckButtonDaControl(Composite composite, String labeltext, String section, String itemOld, String itemNew) {
        Label label = EditConfigurableDialog.createLabel(composite, labeltext);
        Button checkButton = EditConfigurableDialog.createCheckButton(composite, false);
        this.daControls_.add(new DaControl(label, (Control)checkButton, section, itemOld, itemNew));
        return checkButton;
    }

    protected Button createLabelAndCheckButtonDaControl(Composite composite, String labeltext, String section, String item, boolean isOnOff) {
        Label label = EditConfigurableDialog.createLabel(composite, labeltext);
        Button checkButton = EditConfigurableDialog.createCheckButton(composite, false);
        this.daControls_.add(new DaControl(label, (Control)checkButton, section, item, isOnOff));
        return checkButton;
    }

    protected Button createLabelAndTooltipCheckButtonDaControl(Composite composite, String labeltext, String tooltip, String section, String item) {
        Label label = EditConfigurableDialog.createLabel(composite, labeltext);
        Button checkButton = EditConfigurableDialog.createCheckButton(composite, tooltip);
        this.daControls_.add(new DaControl(label, (Control)checkButton, section, item));
        return checkButton;
    }

    protected Button createLabelAndTooltipCheckButtonDaControl(Composite composite, String labeltext, String tooltip, String section, String itemOld, String itemNew) {
        Label label = EditConfigurableDialog.createLabel(composite, labeltext);
        Button checkButton = EditConfigurableDialog.createCheckButton(composite, tooltip);
        this.daControls_.add(new DaControl(label, (Control)checkButton, section, itemOld, itemNew));
        return checkButton;
    }

    protected Button createLabelAndCheckButtonAutoexecControl(Composite composite, String labeltext, Function<Autoexec, String> getMethod, BiConsumer<Autoexec, String> updateMethod) {
        Label label = EditConfigurableDialog.createLabel(composite, labeltext);
        Button checkButton = EditConfigurableDialog.createCheckButton(composite, false);
        this.autoexecControls_.add(new MetaControl(label, (Control)checkButton).connectAutoexec(getMethod, updateMethod));
        return checkButton;
    }

    protected Combo createLabelAndComboDaControl(Composite composite, String labelText, int visibleItemCount, String section, String item) {
        Label label = EditConfigurableDialog.createLabel(composite, labelText);
        Combo combo = EditConfigurableDialog.createCombo(composite, null, visibleItemCount);
        this.daControls_.add(new DaControl(label, (Control)combo, section, item));
        return combo;
    }

    protected Combo createLabelAndComboDaControl(Composite composite, String labelText, String[] items, int visibleItemCount, String section, String item) {
        Label label = EditConfigurableDialog.createLabel(composite, labelText);
        Combo combo = EditConfigurableDialog.createCombo(composite, items, visibleItemCount);
        this.daControls_.add(new DaControl(label, (Control)combo, section, item));
        return combo;
    }

    protected Combo createLabelAndComboAutoexecControl(Composite composite, String labelText, String[] items, int visibleItemCount, Function<Autoexec, String> getMethod, BiConsumer<Autoexec, String> updateMethod) {
        Label label = EditConfigurableDialog.createLabel(composite, labelText);
        Combo combo = EditConfigurableDialog.createCombo(composite, items, visibleItemCount);
        this.autoexecControls_.add(new MetaControl(label, (Control)combo).connectAutoexec(getMethod, updateMethod));
        return combo;
    }

    protected Combo createLabelAndTooltipComboDaControl(Composite composite, String labelText, String[] items, int visibleItemCount, String tooltip, String section, String item) {
        Label label = EditConfigurableDialog.createLabel(composite, labelText);
        Combo combo = EditConfigurableDialog.createCombo(composite, items, visibleItemCount, tooltip);
        this.daControls_.add(new DaControl(label, (Control)combo, section, item));
        return combo;
    }

    protected Combo createLabelAndTooltipComboDaControl(Composite composite, String labelText, String[] items, int visibleItemCount, String tooltip, String section, String itemOld, String itemNew) {
        Label label = EditConfigurableDialog.createLabel(composite, labelText);
        Combo combo = EditConfigurableDialog.createCombo(composite, items, visibleItemCount, tooltip);
        this.daControls_.add(new DaControl(label, (Control)combo, section, itemOld, itemNew));
        return combo;
    }

    protected Combo createLabelAndTooltipComboDaControl(Composite composite, String labelText, String[] items, int visibleItemCount, String tooltip, String sectionOld, String itemOld, String sectionNew, String itemNew) {
        Label label = EditConfigurableDialog.createLabel(composite, labelText);
        Combo combo = EditConfigurableDialog.createCombo(composite, items, visibleItemCount, tooltip);
        this.daControls_.add(new DaControl(label, (Control)combo, sectionOld, itemOld, sectionNew, itemNew));
        return combo;
    }

    protected Combo createLabelAndEditableComboDaControl(Composite composite, String labelText, String[] items, int visibleItemCount, String section, String item) {
        Label label = EditConfigurableDialog.createLabel(composite, labelText);
        Combo combo = EditConfigurableDialog.createEditableCombo(composite, items, visibleItemCount);
        this.daControls_.add(new DaControl(label, (Control)combo, section, item));
        return combo;
    }

    protected Combo createLabelAndWideEditableComboDaControl(Composite composite, String labelText, String[] items, int visibleItemCount, String tooltip, String section, String item) {
        Label label = EditConfigurableDialog.createLabel(composite, labelText);
        Combo combo = EditConfigurableDialog.createWideEditableCombo(composite, items, visibleItemCount, tooltip);
        this.daControls_.add(new DaControl(label, (Control)combo, section, item));
        return combo;
    }

    protected Combo createLabelAndEditableComboDaControl(Composite composite, String labelText, String tooltip, String[] items, int visibleItemCount, String section, String item) {
        Label label = EditConfigurableDialog.createLabel(composite, labelText);
        Combo combo = EditConfigurableDialog.createEditableCombo(composite, items, visibleItemCount, tooltip);
        this.daControls_.add(new DaControl(label, (Control)combo, section, item));
        return combo;
    }

    protected Spinner createLabelAndSpinnerDaControl(Composite composite, String labelText, int min, int max, String section, String item) {
        Label label = EditConfigurableDialog.createLabel(composite, labelText);
        Spinner spinner = EditConfigurableDialog.createSpinner(composite, min, max);
        this.daControls_.add(new DaControl(label, (Control)spinner, section, item));
        return spinner;
    }

    protected TabFolder createSubTabs(String titleKey, String key1, int numColumns1, String key2, int numColumns2) {
        Composite compositeHoldingSubTabs = this.createTabWithComposite(this.text_.get(titleKey), (Layout)new FillLayout());
        TabFolder subTabFolder = new TabFolder(compositeHoldingSubTabs, 0);
        EditConfigurableDialog.createTabWithComposite(subTabFolder, this.text_.get(key1), numColumns1);
        EditConfigurableDialog.createTabWithComposite(subTabFolder, this.text_.get(key2), numColumns2);
        return subTabFolder;
    }

    protected TabFolder createSubTabs(String titleKey, int numColumns1, int numColumns2) {
        return this.createSubTabs(titleKey, "dialog.template.tab.releaseoptions", numColumns1, "dialog.template.tab.experimentaloptions", numColumns2);
    }

    protected static enum DosboxConfAction {
        SET,
        SWITCH,
        RELOAD,
        RELOAD_TEMPLATE;

    }
}

