/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.abstractdialog;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.dbgl.gui.GeneralPurposeDialogs;
import org.dbgl.gui.abstractdialog.EditConfigurableDialog;
import org.dbgl.gui.controls.AutoSelectCombo;
import org.dbgl.gui.controls.BrowseButton;
import org.dbgl.gui.controls.GrabButton;
import org.dbgl.gui.controls.MetaControl;
import org.dbgl.gui.controls.SearchEngineSelector;
import org.dbgl.model.SearchEngineImageInformation;
import org.dbgl.model.aggregate.DosboxVersion;
import org.dbgl.model.aggregate.Profile;
import org.dbgl.model.aggregate.Template;
import org.dbgl.model.conf.Autoexec;
import org.dbgl.model.entity.ITitledEntity;
import org.dbgl.model.entity.TemplateProfileBase;
import org.dbgl.model.entity.TitledEntity;
import org.dbgl.model.repository.TemplateRepository;
import org.dbgl.model.repository.TitledEntityRepository;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;

public abstract class EditProfileDialog<T>
extends EditConfigurableDialog<T> {
    protected List<ITitledEntity> developersList_;
    protected List<ITitledEntity> publishersList_;
    protected List<ITitledEntity> genresList_;
    protected List<ITitledEntity> yearsList_;
    protected List<ITitledEntity> statusList_;
    protected List<List<ITitledEntity>> customList_;
    protected List<Template> templatesList_;
    protected Text title_;
    protected Text notes_;
    protected SearchEngineSelector engineSelector_;
    protected Text[] link_;
    protected Text[] linkTitle_;
    protected BrowseButton[] linkBrowseButton_;
    protected AutoSelectCombo developer_;
    protected AutoSelectCombo publisher_;
    protected AutoSelectCombo genre_;
    protected AutoSelectCombo year_;
    protected Scale custom9_;
    protected Combo templateCombo_;
    protected Button loadfix_;
    protected Combo loadfixValue_;
    protected Text img1_;
    protected Text img2_;
    protected Text img3_;
    protected Text main_;
    protected Text setup_;
    protected Composite webImagesSpaceHolder_;
    protected SearchEngineImageInformation[] imageInformation_;
    protected Button[] imgButtons_;
    protected int templateIndex_;

    public EditProfileDialog(Shell parent) {
        super(parent, "profiledialog");
    }

    @Override
    protected boolean prepare() {
        if (!super.prepare()) {
            return false;
        }
        try {
            TemplateRepository templRepo = new TemplateRepository();
            TitledEntityRepository titledRepo = new TitledEntityRepository();
            this.templatesList_ = templRepo.listAll(this.dbversionsList_);
            this.developersList_ = titledRepo.listDevelopers();
            this.publishersList_ = titledRepo.listPublishers();
            this.genresList_ = titledRepo.listGenres();
            this.yearsList_ = titledRepo.listYears();
            this.statusList_ = titledRepo.listStatus();
            this.customList_ = new ArrayList<List<ITitledEntity>>();
            for (int i = 0; i < 4; ++i) {
                this.customList_.add(titledRepo.listCustomValues(i));
            }
            this.templateIndex_ = TemplateRepository.indexOfDefault(this.templatesList_);
            return true;
        }
        catch (Exception e) {
            GeneralPurposeDialogs.warningMessage(this.getParent(), e);
            return false;
        }
    }

    protected ToolBar createInfoTab() {
        int i;
        int i2;
        Composite composite = this.createTabWithComposite(this.text_.get("dialog.profile.tab.info"), 6);
        this.title_ = this.createLabelAndTextMetaControl(composite, this.text_.get("dialog.profile.title"), 4, TitledEntity::getTitle, TitledEntity::setTitle);
        ToolBar toolBar = new ToolBar(composite, 0x800000);
        this.engineSelector_ = new SearchEngineSelector(toolBar, false);
        this.developer_ = this.createLabelAndAutoSelectCombo(composite, this.text_.get("dialog.profile.developer"), this.developersList_, Profile::getDeveloper, Profile::setDeveloper);
        this.publisher_ = this.createLabelAndAutoSelectCombo(composite, this.text_.get("dialog.profile.publisher"), this.publishersList_, Profile::getPublisher, Profile::setPublisher);
        this.genre_ = this.createLabelAndAutoSelectCombo(composite, this.text_.get("dialog.profile.genre"), this.genresList_, Profile::getGenre, Profile::setGenre);
        this.year_ = this.createLabelAndAutoSelectCombo(composite, this.text_.get("dialog.profile.year"), this.yearsList_, Profile::getYear, Profile::setYear);
        this.link_ = new Text[8];
        this.linkBrowseButton_ = new BrowseButton[8];
        this.linkTitle_ = new Text[8];
        for (int i3 = 0; i3 < 4; ++i3) {
            this.link_[i3] = this.createLabelAndTextMetaControl(composite, this.text_.get("dialog.profile.link", new Object[]{i3 + 1}), 1, i3, Profile::getLinkDestination, Profile::setLinkDestination);
            this.linkBrowseButton_[i3] = new BrowseButton(composite);
            this.linkTitle_[i3] = this.createLabelAndTextMetaControl(composite, this.text_.get("dialog.profile.linktitle"), 2, i3, Profile::getLinkTitle, Profile::setLinkTitle);
        }
        this.createLabelAndAutoSelectCombo(composite, this.text_.get("dialog.profile.status"), this.statusList_, Profile::getStatus, Profile::setStatus);
        this.createLabelAndCheckboxMetaControl(composite, this.text_.get("dialog.profile.favorite"), Profile::getFavorite, Profile::setFavorite);
        EditProfileDialog.createLabel(composite);
        Label notesLabel = EditProfileDialog.createLabel(composite, this.text_.get("dialog.profile.notes"));
        this.notes_ = EditProfileDialog.createTextarea(composite, false, true, 5, 1, null);
        this.notes_.setFont(EditProfileDialog.stringToFont((Device)this.display_, this.settings_.getValues("gui", "notesfont"), this.notes_.getFont()));
        this.metaControls_.add(new MetaControl(notesLabel, (Control)this.notes_).connectProfile(Profile::getNotes, Profile::setNotes));
        Composite customComposite = this.createTabWithComposite(this.text_.get("dialog.profile.tab.custominfo"), 5);
        for (i2 = 0; i2 < 4; ++i2) {
            this.createLabelAndAutoSelectCombo(customComposite, this.settings_.getValue("gui", "custom" + (i2 + 1)), this.customList_.get(i2), i2, Profile::getCustomString, Profile::setCustomString);
        }
        for (i2 = 0; i2 < 4; ++i2) {
            this.createLabelAndTextMetaControl(customComposite, this.settings_.getValue("gui", "custom" + (i2 + 1 + 4)), 4, i2 + 4, Profile::getCustomString, Profile::setCustomString);
        }
        Label custom9Label = EditProfileDialog.createLabel(customComposite, this.settings_.getValue("gui", "custom9"));
        this.custom9_ = EditProfileDialog.createScale(customComposite, false, new GridData(4, 0x1000000, true, false, 2, 1));
        this.metaControls_.add(new MetaControl(custom9Label, (Control)this.custom9_).connectProfile(0, Profile::getCustomInt, Profile::setCustomInt));
        this.createLabelAndSpinnerMetaControl(customComposite, this.settings_.getValue("gui", "custom10"), Integer.MIN_VALUE, Integer.MAX_VALUE, 1, Profile::getCustomInt, Profile::setCustomInt);
        for (i = 4; i < 8; ++i) {
            this.link_[i] = this.createLabelAndTextMetaControl(customComposite, this.text_.get("dialog.profile.link", new Object[]{i + 1}), 1, i, Profile::getLinkDestination, Profile::setLinkDestination);
            this.linkBrowseButton_[i] = new BrowseButton(customComposite);
            this.linkTitle_[i] = this.createLabelAndTextMetaControl(customComposite, this.text_.get("dialog.profile.linktitle"), 1, i, Profile::getLinkTitle, Profile::setLinkTitle);
        }
        for (i = 0; i < 4; ++i) {
            int columns = i % 2 == 0 ? 2 : 1;
            this.createLabelAndTextMetaControl(customComposite, this.settings_.getValue("gui", "custom" + (i + 1 + 4 + 2 + 4)), columns, i + 4 + 4, Profile::getCustomString, Profile::setCustomString);
        }
        return toolBar;
    }

    @Override
    protected Group createGeneralTab(String capturesText, String configFileText) {
        Group associationGroup = super.createGeneralTab(capturesText, configFileText);
        this.templateCombo_ = EditProfileDialog.createLabelAndWideCombo((Composite)associationGroup, this.text_.get("dialog.profile.template"));
        this.templateCombo_.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.templatesList_.forEach(x -> this.templateCombo_.add(x.getTitle()));
        this.templateCombo_.select(this.templateIndex_);
        Button templateReload = EditProfileDialog.createButton((Composite)associationGroup, null, this.text_.get("dialog.profile.reloadsettings"), this.text_.get("dialog.profile.reloadsettings.tooltip"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (EditProfileDialog.this.templateCombo_.getSelectionIndex() != -1) {
                    if (EditProfileDialog.this.setButton_.isEnabled()) {
                        GeneralPurposeDialogs.initErrorDialog();
                        GeneralPurposeDialogs.addError(EditProfileDialog.this.text_.get("dialog.template.required.dosboxassociation"), (Control)EditProfileDialog.this.setButton_, EditProfileDialog.this.getTabItemByControl((Control)EditProfileDialog.this.setButton_));
                        GeneralPurposeDialogs.displayErrorDialog(EditProfileDialog.this.shell_);
                        return;
                    }
                    EditProfileDialog.this.doPerformDosboxConfAction(EditConfigurableDialog.DosboxConfAction.RELOAD_TEMPLATE, (DosboxVersion)EditProfileDialog.this.dbversionsList_.get(EditProfileDialog.this.dbversionCombo_.getSelectionIndex()));
                }
            }
        });
        templateReload.setEnabled(this.dbversionIndex_ != -1);
        return associationGroup;
    }

    @Override
    protected Group createMachineTab() {
        Group memoryGroup = super.createMachineTab();
        this.loadfix_ = this.createLabelAndCheckButtonAutoexecControl((Composite)memoryGroup, this.text_.get("dialog.profile.loadfix"), Autoexec::getLoadfix, Autoexec::setLoadfix);
        this.loadfix_.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditProfileDialog.this.loadfixValue_.setEnabled(EditProfileDialog.this.loadfix_.getSelection());
            }
        });
        this.loadfixValue_ = EditProfileDialog.createEditableCombo((Composite)memoryGroup, this.settings_.getValues("profile", "loadfix_value"), 10);
        Label kbLabel = EditProfileDialog.createLabel((Composite)memoryGroup, this.text_.get("dialog.profile.kb"));
        this.autoexecControls_.add(new MetaControl(kbLabel, (Control)this.loadfixValue_).connectAutoexec(Autoexec::getLoadfixValueAsString, Autoexec::setLoadfixValue));
        this.createLabelAndCheckButtonAutoexecControl((Composite)memoryGroup, this.text_.get("dialog.profile.loadhigh"), Autoexec::getLoadhigh, Autoexec::setLoadhigh);
        EditProfileDialog.createLabel((Composite)memoryGroup, 2, 1);
        return memoryGroup;
    }

    @Override
    protected void createMountingTab(TemplateProfileBase configurable, boolean multiEdit) {
        super.createMountingTab(configurable, multiEdit);
        Composite booterComposite = (Composite)this.booterExpandItem_.getControl();
        booterComposite.setLayout((Layout)new GridLayout(4, false));
        this.img1_ = this.createLabelAndTextAutoexecControl(booterComposite, this.text_.get("dialog.profile.booterimage1"), Autoexec::getImg1, Autoexec::setImg1);
        new BrowseButton(booterComposite).connect(this.shell_, this.img1_, this.main_, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.BOOTER, false, null);
        new GrabButton(booterComposite, this.img1_, this.mountingpointsList_, true);
        this.img2_ = this.createLabelAndTextAutoexecControl(booterComposite, this.text_.get("dialog.profile.booterimage2"), Autoexec::getImg2, Autoexec::setImg2);
        new BrowseButton(booterComposite).connect(this.shell_, this.img2_, this.img1_, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.BOOTER, false, null);
        new GrabButton(booterComposite, this.img2_, this.mountingpointsList_, true);
        this.img3_ = this.createLabelAndTextAutoexecControl(booterComposite, this.text_.get("dialog.profile.booterimage3"), Autoexec::getImg3, Autoexec::setImg3);
        new BrowseButton(booterComposite).connect(this.shell_, this.img3_, this.img1_, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.BOOTER, false, null);
        new GrabButton(booterComposite, this.img3_, this.mountingpointsList_, true);
        this.createLabelAndComboAutoexecControl(booterComposite, this.text_.get("dialog.profile.booterdriveletter"), new String[]{"", "A", "C", "D"}, 4, Autoexec::getImgDriveletter, Autoexec::setImgDriveletter);
        EditProfileDialog.createLabel(booterComposite, 2, 1);
        this.booterExpandItem_.setHeight(booterComposite.computeSize((int)-1, (int)-1).y);
        Composite dosComposite = (Composite)this.dosExpandItem_.getControl();
        dosComposite.setLayout((Layout)new GridLayout(6, false));
        this.main_ = this.createLabelAndTextAutoexecControl(dosComposite, this.text_.get("dialog.profile.mainexe"), 3, Autoexec::getMain, Autoexec::setMain);
        new BrowseButton(dosComposite).connect(this.shell_, this.main_, null, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, false, null);
        new GrabButton(dosComposite, this.main_, this.mountingpointsList_, false);
        EditProfileDialog.createLabel(dosComposite);
        this.createLabelAndTextAutoexecControl(dosComposite, this.text_.get("dialog.profile.mainparameters"), 2, Autoexec::getParameters, Autoexec::setParameters);
        EditProfileDialog.createLabel(dosComposite, 2, 1);
        this.setup_ = this.createLabelAndTextMetaControl(dosComposite, this.text_.get("dialog.profile.setupexe"), 3, Profile::getSetupString, Profile::setSetupFileLocation);
        new BrowseButton(dosComposite).connect(this.shell_, this.setup_, this.main_, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, false, null);
        new GrabButton(dosComposite, this.setup_, this.mountingpointsList_, false);
        EditProfileDialog.createLabel(dosComposite);
        this.createLabelAndTextMetaControl(dosComposite, this.text_.get("dialog.profile.setupparameters"), 2, Profile::getSetupParams, Profile::setSetupParams);
        Label alt1ParamsLabel = EditProfileDialog.createLabel(dosComposite);
        Label alt2ParamsLabel = EditProfileDialog.createLabel(dosComposite);
        Text alt1 = this.createLabelAndTextMetaControl(dosComposite, this.text_.get("dialog.profile.altexe", new Object[]{1}), 2, 0, Profile::getAltExeString, Profile::setAltExeFileLocation);
        Text alt1Params_ = EditProfileDialog.createText(dosComposite);
        this.metaControls_.add(new MetaControl(alt1ParamsLabel, (Control)alt1Params_).connectProfile(0, Profile::getAltExeParam, Profile::setAltExeParam));
        new BrowseButton(dosComposite).connect(this.shell_, alt1, this.main_, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, false, null);
        new GrabButton(dosComposite, alt1, this.mountingpointsList_, false);
        Text alt2 = this.createLabelAndTextMetaControl(dosComposite, this.text_.get("dialog.profile.altexe", new Object[]{2}), 2, 1, Profile::getAltExeString, Profile::setAltExeFileLocation);
        Text alt2Params_ = EditProfileDialog.createText(dosComposite);
        this.metaControls_.add(new MetaControl(alt2ParamsLabel, (Control)alt2Params_).connectProfile(1, Profile::getAltExeParam, Profile::setAltExeParam));
        new BrowseButton(dosComposite).connect(this.shell_, alt2, this.main_, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.EXE, false, null);
        new GrabButton(dosComposite, alt2, this.mountingpointsList_, false);
        this.dosExpandItem_.setHeight(dosComposite.computeSize((int)-1, (int)-1).y);
        for (int i = 0; i < 8; ++i) {
            this.linkBrowseButton_[i].connect(this.shell_, this.link_[i], this.main_, BrowseButton.BrowseType.FILE, BrowseButton.CanonicalType.DOC, false, null);
        }
        if (multiEdit) {
            Stream.of(booterComposite.getChildren()).forEach(x -> x.setEnabled(false));
            Stream.of(dosComposite.getChildren()).forEach(x -> x.setEnabled(false));
        }
    }

    protected Text createLabelAndTextMetaControl(Composite composite, String labelText, Function<Profile, String> getMethod, BiConsumer<Profile, String> updateMethod) {
        Label label = EditProfileDialog.createLabel(composite, labelText);
        Text text = EditProfileDialog.createText(composite, new GridData(4, 0x1000000, true, false));
        this.metaControls_.add(new MetaControl(label, (Control)text).connectProfile(getMethod, updateMethod));
        return text;
    }

    protected Text createLabelAndTextMetaControl(Composite composite, String labelText, int horizontalSpan, Function<Profile, String> getMethod, BiConsumer<Profile, String> updateMethod) {
        Label label = EditProfileDialog.createLabel(composite, labelText);
        Text text = EditProfileDialog.createText(composite, new GridData(4, 0x1000000, true, false, horizontalSpan, 1));
        this.metaControls_.add(new MetaControl(label, (Control)text).connectProfile(getMethod, updateMethod));
        return text;
    }

    protected Text createLabelAndTextMetaControl(Composite composite, String labelText, int horizontalSpan, int index, BiFunction<Profile, Integer, String> getMethod, MetaControl.TriConsumer<Profile, Integer, String> updateMethod) {
        Label label = EditProfileDialog.createLabel(composite, labelText);
        Text text = EditProfileDialog.createText(composite, new GridData(4, 0x1000000, true, false, horizontalSpan, 1));
        this.metaControls_.add(new MetaControl(label, (Control)text).connectProfile(index, getMethod, updateMethod));
        return text;
    }

    protected AutoSelectCombo createLabelAndAutoSelectCombo(Composite composite, String labelText, List<ITitledEntity> values, Function<Profile, String> getMethod, BiConsumer<Profile, String> updateMethod) {
        Label developerLabel = EditProfileDialog.createLabel(composite, labelText);
        AutoSelectCombo combo = new AutoSelectCombo(composite, new GridData(4, 0x1000000, true, false, 2, 1), values);
        this.metaControls_.add(new MetaControl(developerLabel, combo.getControl()).connectProfile(getMethod, updateMethod));
        return combo;
    }

    protected AutoSelectCombo createLabelAndAutoSelectCombo(Composite composite, String labelText, List<ITitledEntity> values, int index, BiFunction<Profile, Integer, String> getMethod, MetaControl.TriConsumer<Profile, Integer, String> updateMethod) {
        Label developerLabel = EditProfileDialog.createLabel(composite, labelText);
        AutoSelectCombo combo = new AutoSelectCombo(composite, new GridData(4, 0x1000000, true, false, 4, 1), values);
        this.metaControls_.add(new MetaControl(developerLabel, combo.getControl()).connectProfile(index, getMethod, updateMethod));
        return combo;
    }

    protected Button createLabelAndCheckboxMetaControl(Composite composite, String labeltext, Function<Profile, String> getMethod, BiConsumer<Profile, String> updateMethod) {
        Label label = EditProfileDialog.createLabel(composite, labeltext);
        Button checkButton = EditProfileDialog.createCheckButton(composite, new GridData(4, 0x1000000, true, false, 1, 1), false);
        this.metaControls_.add(new MetaControl(label, (Control)checkButton).connectProfile(getMethod, updateMethod));
        return checkButton;
    }

    protected Spinner createLabelAndSpinnerMetaControl(Composite composite, String labelText, int min, int max, int index, BiFunction<Profile, Integer, String> getMethod, MetaControl.TriConsumer<Profile, Integer, String> updateMethod) {
        Label label = EditProfileDialog.createLabel(composite, labelText);
        Spinner spinner = EditProfileDialog.createSpinner(composite, min, max);
        this.metaControls_.add(new MetaControl(label, (Control)spinner).connectProfile(index, getMethod, updateMethod));
        return spinner;
    }
}

