/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.dbgl.gui.abstractdialog.BaseDialog;
import org.dbgl.gui.dialog.BrowseArchiveDialog;
import org.dbgl.model.FileLocation;
import org.dbgl.model.ICanonicalize;
import org.dbgl.service.FileLocationService;
import org.dbgl.service.ITextService;
import org.dbgl.service.TextService;
import org.dbgl.util.FilesUtils;
import org.dbgl.util.StringRelatedUtils;
import org.dbgl.util.SystemUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BrowseButton {
    private final Button button_;

    public BrowseButton(Composite composite) {
        this.button_ = BaseDialog.createImageButton(composite, TextService.getInstance().get("button.browse"), "folder.png");
    }

    public BrowseButton(Composite composite, boolean small) {
        this.button_ = BaseDialog.createSmallBrowseButton(composite, TextService.getInstance().get("button.browse"));
    }

    public ICanonicalize connect(Shell shell, Text control, Text altControl, BrowseType browse, CanonicalType canon, boolean save, Combo combo) {
        BrowseSelectionAdapter browseSelectionAdapter = new BrowseSelectionAdapter(shell, control, altControl, browse, canon, save, combo);
        this.button_.addSelectionListener((SelectionListener)browseSelectionAdapter);
        return browseSelectionAdapter.canonicalizer_;
    }

    public static enum CanonicalType {
        DOSROOT,
        DFEND,
        CDIMAGE,
        ZIP,
        DBGLZIP,
        DOSBOX,
        DOSBOXEXE,
        DOSBOXCONF,
        DOC,
        BOOTER,
        EXE,
        INSTALLER,
        NATIVE_EXE,
        NONE;

    }

    public static enum BrowseType {
        DIR,
        FILE;

    }

    private class BrowseSelectionAdapter
    extends SelectionAdapter {
        private final Shell shell_;
        private final Text control_;
        private final Text altControl_;
        private final BrowseType browseType_;
        private final CanonicalType canonicalType_;
        private final boolean save_;
        private final Combo combo_;
        private final ICanonicalize canonicalizer_;

        public BrowseSelectionAdapter(Shell shell, Text control, Text altControl, BrowseType browse, CanonicalType canon, boolean save, Combo combo) {
            this.shell_ = shell;
            this.control_ = control;
            this.altControl_ = altControl;
            this.browseType_ = browse;
            this.canonicalType_ = canon;
            this.save_ = save;
            this.combo_ = combo;
            switch (this.getCanonicalType()) {
                case DOC: 
                case DBGLZIP: 
                case NATIVE_EXE: {
                    this.canonicalizer_ = FileLocationService.getInstance().dataRelative();
                    break;
                }
                case EXE: 
                case INSTALLER: 
                case ZIP: 
                case BOOTER: 
                case DOSROOT: 
                case CDIMAGE: {
                    this.canonicalizer_ = FileLocationService.getInstance().dosrootRelative();
                    break;
                }
                case DOSBOX: 
                case DOSBOXEXE: 
                case DOSBOXCONF: {
                    this.canonicalizer_ = FileLocationService.getInstance().dosboxRelative();
                    break;
                }
                default: {
                    this.canonicalizer_ = FileLocationService.standard();
                }
            }
        }

        private CanonicalType getCanonicalType() {
            return this.browseType_ == BrowseType.DIR && this.canonicalType_ == CanonicalType.NONE ? CanonicalType.DOSROOT : this.canonicalType_;
        }

        private String filterPath() {
            String path;
            String fieldValue = StringUtils.isBlank((CharSequence)this.control_.getText()) && this.altControl_ != null ? this.altControl_.getText() : this.control_.getText();
            switch (this.getCanonicalType()) {
                case EXE: {
                    File main;
                    if (StringUtils.isNotBlank((CharSequence)fieldValue) && (main = FilesUtils.determineMainFile(new File(fieldValue))) != null && main.getParentFile() != null && !main.getPath().equals(fieldValue) && !(main.getPath() + File.separator).equals(fieldValue)) {
                        path = main.getParent();
                        break;
                    }
                }
                case DOC: 
                case DBGLZIP: 
                case NATIVE_EXE: 
                case INSTALLER: 
                case ZIP: 
                case BOOTER: 
                case DOSROOT: 
                case DOSBOX: 
                case DOSBOXEXE: 
                case DOSBOXCONF: {
                    path = fieldValue;
                    break;
                }
                case CDIMAGE: {
                    String[] fPaths = StringRelatedUtils.textAreaToStringArray(fieldValue, this.control_.getLineDelimiter());
                    path = fPaths.length > 0 ? fPaths[0] : "";
                    break;
                }
                case DFEND: {
                    path = FileLocationService.DFEND_PATH_STRING;
                    break;
                }
                default: {
                    path = "";
                }
            }
            return new FileLocation(path, this.canonicalizer_).getCanonicalFile().getPath();
        }

        private String getResult(String result, File filterPath, String[] filenames) {
            if (this.canonicalType_ == CanonicalType.DOSBOX && SystemUtils.IS_OSX) {
                File f = new FileLocation(result, this.canonicalizer_).getFile();
                if (f.getName().endsWith(".app")) {
                    File exe = new File(f, FileLocationService.DB_APP_EXE);
                    if (FilesUtils.isExistingFile(exe)) {
                        return exe.getParent();
                    }
                } else if (f.getName().equals(FileLocationService.DOSBOX_EXE_STRING)) {
                    return f.getParent();
                }
            } else if (this.canonicalType_ == CanonicalType.EXE || this.canonicalType_ == CanonicalType.INSTALLER) {
                if (FilesUtils.isArchive(result) || FilesUtils.isCdImageFile(result) || FilesUtils.isFatImage(result)) {
                    BrowseArchiveDialog dialog = new BrowseArchiveDialog(this.shell_, result);
                    String choice = (String)dialog.open();
                    return choice == null ? null : new FileLocation(choice, this.canonicalizer_).getFile().getPath();
                }
            } else if (this.canonicalType_ == CanonicalType.CDIMAGE) {
                File path = new FileLocation(filterPath.getPath(), this.canonicalizer_).getFile();
                StringBuffer images = new StringBuffer();
                for (String file : filenames) {
                    images.append(FilesUtils.concat(path, file)).append(this.control_.getLineDelimiter());
                }
                return images.toString();
            }
            return new FileLocation(result, this.canonicalizer_).getFile().getPath();
        }

        public void widgetSelected(SelectionEvent event) {
            String result = null;
            File filterPath = null;
            String[] filenames = null;
            this.shell_.setEnabled(false);
            String rawFilterPath = this.filterPath();
            File fpath = new File(rawFilterPath);
            if (fpath != null && !fpath.isDirectory()) {
                fpath = fpath.getParentFile();
            }
            if (this.browseType_ == BrowseType.DIR) {
                DirectoryDialog dialog = new DirectoryDialog(this.shell_);
                if (fpath != null) {
                    dialog.setFilterPath(fpath.getPath());
                }
                result = dialog.open();
            } else if (this.browseType_ == BrowseType.FILE && (this.canonicalType_ == CanonicalType.EXE || this.canonicalType_ == CanonicalType.INSTALLER) && (FilesUtils.isArchive(rawFilterPath) || FilesUtils.isCdImageFile(rawFilterPath) || FilesUtils.isFatImage(rawFilterPath))) {
                result = rawFilterPath;
            } else if (this.browseType_ == BrowseType.FILE) {
                int style = this.save_ ? 8192 : (this.canonicalType_ == CanonicalType.CDIMAGE ? 4098 : 4096);
                FileDialog dialog = new FileDialog(this.shell_, style);
                if (fpath != null) {
                    dialog.setFilterPath(fpath.getPath());
                }
                ITextService text = TextService.getInstance();
                String[] filterNames = null;
                String[] filterExts = null;
                switch (this.canonicalType_) {
                    case DOC: {
                        filterNames = new String[]{"*"};
                        filterExts = new String[]{"*"};
                        break;
                    }
                    case EXE: 
                    case INSTALLER: 
                    case DOSBOXEXE: {
                        filterNames = new String[]{text.get("filetype.applicable"), text.get("filetype.exe"), text.get("filetype.hdimage"), text.get("filetype.cdimage"), text.get("filetype.floppyimage"), text.get("filetype.archive"), "*"};
                        filterExts = new String[]{"*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT;*.hdi;*.HDI;*.iso;*.ISO;*.cue;*.CUE;*.ima;*.IMA;", "*.com;*.COM;*.exe;*.EXE;*.bat;*.BAT", "*.hdi;*.HDI", "*.iso;*.ISO;*.cue;*.CUE", "*.ima;*.IMA;", "*.zip;*.ZIP;*.7z;*.7Z", "*"};
                        break;
                    }
                    case NATIVE_EXE: 
                    case DOSBOX: {
                        filterNames = new String[]{text.get("filetype.native_exe"), "*"};
                        filterExts = new String[]{FilesUtils.NATIVE_EXE_FILTER, "*"};
                        break;
                    }
                    case ZIP: {
                        filterNames = new String[]{text.get("filetype.archive"), "*"};
                        filterExts = new String[]{"*.zip;*.ZIP;*.7z;*.7Z", "*"};
                        break;
                    }
                    case DBGLZIP: {
                        filterNames = new String[]{text.get("filetype.gamepack"), "*"};
                        filterExts = new String[]{"*.dbgl.zip;*.DBGL.ZIP", "*"};
                        break;
                    }
                    case BOOTER: {
                        filterNames = new String[]{text.get("filetype.booterimage"), "*"};
                        filterExts = new String[]{"*.cp2;*.CP2;*.dcf;*.DCF;*.img;*.IMG;*.jrc;*.JRC;*.td0;*.TD0;*.fdd;*.FDD;*.fdi;*.FDI;*.d88;*.D88;*.hdi;*.HDI", "*"};
                        break;
                    }
                    case DFEND: {
                        filterNames = new String[]{text.get("filetype.dfendprofile")};
                        filterExts = new String[]{"Profiles.dat"};
                        break;
                    }
                    case CDIMAGE: {
                        filterNames = new String[]{text.get("filetype.applicable"), text.get("filetype.hdimage"), text.get("filetype.cdimage"), text.get("filetype.floppyimage"), "*"};
                        filterExts = new String[]{"*.hdi;*.HDI;*.iso;*.ISO;*.cue;*.CUE;*.ima;*.IMA;", "*.hdi;*.HDI", "*.iso;*.ISO;*.cue;*.CUE", "*.ima;*.IMA;", "*"};
                        break;
                    }
                    case DOSBOXCONF: {
                        filterNames = new String[]{text.get("filetype.conf"), "*"};
                        filterExts = new String[]{"*.conf;*.CONF", "*"};
                        break;
                    }
                }
                if (filterNames != null) {
                    dialog.setFilterNames(filterNames);
                }
                if (filterExts != null) {
                    dialog.setFilterExtensions(filterExts);
                }
                if (this.canonicalType_ == CanonicalType.DFEND) {
                    dialog.setFileName("Profiles.dat");
                }
                result = dialog.open();
                if (this.canonicalType_ == CanonicalType.CDIMAGE) {
                    filterPath = new File(dialog.getFilterPath());
                    filenames = dialog.getFileNames();
                }
            }
            if (result != null && (result = this.getResult(result, filterPath, filenames)) != null) {
                String dir;
                this.control_.setText(result);
                if (this.canonicalType_ == CanonicalType.DOSBOX && this.altControl_ != null) {
                    File confFile = new File(result, "dosbox.conf");
                    String confText = new FileLocation(confFile.getPath(), this.canonicalizer_).getFile().getPath();
                    this.altControl_.setText(confText);
                } else if (this.canonicalType_ == CanonicalType.CDIMAGE && this.combo_ != null) {
                    if (FilesUtils.isCdImageFile((String)filenames[0])) {
                        this.combo_.setText("iso");
                    } else if (FilesUtils.isFatImage((String)filenames[0])) {
                        this.combo_.setText("floppy");
                    }
                } else if (this.canonicalType_ == CanonicalType.NATIVE_EXE && this.altControl_ != null && (dir = new FileLocation(result, this.canonicalizer_).getFile().getParent()) != null) {
                    this.altControl_.setText(dir);
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (this.shell_.getDisplay().readAndDispatch()) {
            }
            this.shell_.setEnabled(true);
        }
    }
}

